/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.view;

import com.floreantpos.PosLog;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanExplorerGridView;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.InlineFormContainer;
import com.orocube.siiopa.cloud.client.InlineFormEditorWindow;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.action.DeleteCustomPaymentAction;
import com.orocube.siiopa.cloud.client.crud.form.inline.CustomPaymentInlineForm;
import com.orocube.siiopa.cloud.client.curd.grid.CustomPaymentGrid;
import com.vaadin.event.SelectionEvent;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.List;

public class CustomPaymentCrudView
extends BeanExplorerGridView<CustomPayment> {
    public static final String VIEW_NAME = ConsoleMessages.getString("CustomPaymentCrudView.0");
    private OutletCombobox cbOutlet;
    private Button btnSearch;

    @Override
    public VerticalLayout createTopBar() {
        ShortcutListener shortcutListener = new ShortcutListener(ConsoleMessages.getString("ShopTableCrudView.1"), 13, null){

            public void handleAction(Object sender, Object target) {
                PosLog.debug(CustomPaymentCrudView.class, (String)"button listener fired");
                if (target == CustomPaymentCrudView.this.btnSearch) {
                    CustomPaymentCrudView.this.doSearch();
                }
            }
        };
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                CustomPaymentCrudView.this.doSearch();
            }
        };
        topLayout.setVisible(this.cbOutlet.isVisible());
        this.btnSearch = CommonUIUtil.createColorButton("");
        this.btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        this.btnSearch.addShortcutListener(shortcutListener);
        this.btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.doSearch());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET") + " :", (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout(this.btnSearch, null));
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        Component searchContainer = CommonUIUtil.getSearchContainer((Component)topLayout);
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), searchContainer});
        searchContainer.setVisible(this.cbOutlet.isVisible());
        return mainTopLayout;
    }

    @Override
    public void updateView(Pagination<CustomPayment> pagination) {
        Outlet outlet = (Outlet)this.cbOutlet.getValue();
        List customPayments = CustomPaymentDAO.getInstance().findCustomPaymentByOutlet(outlet);
        this.grid.setItems(customPayments);
    }

    @Override
    protected void doCreateNewItem() {
        this.doOpenCreateItemWindow(new CustomPayment());
    }

    protected void doOpenCreateItemWindow(CustomPayment customPayment) {
        this.setInlineFromVisible(false);
        InlineFormEditorWindow window = new InlineFormEditorWindow();
        CustomPaymentInlineForm inlineForm = this.getCustomPaymentInlineForm(customPayment, window);
        window.open(inlineForm);
    }

    @Override
    protected void doEditItem(CustomPayment customPayment) {
        if (customPayment == null) {
            String info = ConsoleMessages.getString("CurrencyCrudView.3");
            CommonUIUtil.showMessageDialog(info);
            return;
        }
        InlineFormEditorWindow window = new InlineFormEditorWindow();
        CustomPaymentInlineForm inlineForm = this.getCustomPaymentInlineForm(customPayment, window);
        window.open(inlineForm);
    }

    private CustomPaymentInlineForm getCustomPaymentInlineForm(CustomPayment currency, InlineFormEditorWindow window) {
        CustomPaymentInlineForm inlineForm = new CustomPaymentInlineForm(this, currency, window);
        inlineForm.setHidePanelBorder(true);
        inlineForm.setSizeFull();
        inlineForm.enter(null);
        if (currency.getId() == null) {
            inlineForm.setHeading(ConsoleMessages.getString("CustomPaymentCrudView.2"));
        } else {
            inlineForm.setHeading(currency.getName());
        }
        return inlineForm;
    }

    @Override
    protected void doDeleteItem(CustomPayment customPayment) {
        if (customPayment == null) {
            CommonUIUtil.showMessageDialog(ConsoleMessages.getString("CustomPaymentCrudView.3"));
            return;
        }
        DeleteCustomPaymentAction paymentDeleteAction = new DeleteCustomPaymentAction(this.grid, customPayment);
        paymentDeleteAction.execute();
    }

    @Override
    protected BeanGrid<CustomPayment> createItemGrid() {
        CustomPaymentGrid paymentGrid = new CustomPaymentGrid();
        paymentGrid.addStyleName("custom-grid-cell-focus");
        paymentGrid.addSelectionListener((SelectionEvent.SelectionListener & Serializable)event -> this.doSelectItem(this.getSelectedRow()));
        return paymentGrid;
    }

    @Override
    protected void addButton(HorizontalLayout buttonLayout) {
        this.setEditDeleteVisible(false);
    }

    private void setEditDeleteVisible(boolean visible) {
        this.setEditProductVisible(visible);
        this.setDeleteProductVisible(visible);
    }

    private void doSearch() {
        this.reloadPage();
    }

    public CustomPayment getSelectedRow() {
        return (CustomPayment)this.grid.getSelectedRow();
    }

    protected void doSelectItem(CustomPayment customPayment) {
        Component layout = this.getContainer();
        if (layout == null) {
            if (customPayment != null) {
                this.setEditDeleteVisible(true);
            } else {
                this.setEditDeleteVisible(false);
            }
            return;
        }
        if (layout instanceof InlineFormContainer) {
            InlineFormContainer formContainer = (InlineFormContainer)layout;
            formContainer.setVisible(true);
            if (customPayment == null) {
                layout.setVisible(false);
                this.setEditDeleteVisible(false);
                return;
            }
            this.setEditDeleteVisible(true);
            formContainer.removeAllComponents();
            CustomPaymentDAO.getInstance().refresh((Object)customPayment);
            CustomPaymentInlineForm inlineForm = this.getCustomPaymentInlineForm(customPayment, null);
            formContainer.addComponent((Component)inlineForm);
        }
    }
}

