/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public abstract class DoneCancelWindow
extends Window {
    private static final long serialVersionUID = 1L;
    protected boolean canceled = true;
    protected Button btnDone = CommonUIUtil.createColorButton(ConsoleMessages.getString("DoneCancelWindow.0"));
    protected Button btnCancel = CommonUIUtil.createColorButton(ConsoleMessages.getString("DoneCancelWindow.1"));
    private HorizontalLayout content;

    public DoneCancelWindow() {
        this("");
    }

    public DoneCancelWindow(String title) {
        this.setClosable(false);
        this.setResizable(false);
        this.setModal(true);
        this.setSizeFull();
        this.setCaption(title);
        VerticalLayout container = new VerticalLayout();
        container.addStyleName("main-content");
        container.setMargin(false);
        container.setSizeFull();
        this.content = new HorizontalLayout();
        this.content.setMargin(false);
        this.content.addStyleName("content");
        this.content.setSizeFull();
        this.content.addStyleName("order-mgmt-overflow");
        this.initUI(this.content);
        HorizontalLayout buttonPannel = new HorizontalLayout();
        buttonPannel.addStyleName("footer");
        this.createBottomPanel(buttonPannel);
        container.addComponents(new Component[]{this.content, buttonPannel});
        container.setExpandRatio((Component)this.content, 1.0f);
        container.setComponentAlignment((Component)this.content, Alignment.MIDDLE_CENTER);
        container.setComponentAlignment((Component)buttonPannel, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)container);
        this.center();
    }

    private void createBottomPanel(HorizontalLayout buttonPannel) {
        buttonPannel.setWidth("100%");
        buttonPannel.setSpacing(true);
        buttonPannel.addStyleName("custom-button-margin");
        this.btnDone.setSizeFull();
        this.btnCancel.setSizeFull();
        buttonPannel.addComponents(new Component[]{this.btnDone, this.btnCancel});
        this.btnDone.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (!DoneCancelWindow.this.doOk()) {
                    return;
                }
                DoneCancelWindow.this.setCanceled(false);
                DoneCancelWindow.this.close();
            }
        });
        this.btnCancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                DoneCancelWindow.this.close();
            }
        });
        this.initBottomPanel(buttonPannel);
    }

    protected void initBottomPanel(HorizontalLayout buttonPannel) {
    }

    public HorizontalLayout getContentPanel() {
        return this.content;
    }

    public void setOkButtonText(String text) {
        this.btnDone.setCaption(text);
    }

    public void setOkButtonVisible(Boolean visible) {
        this.btnDone.setVisible(visible.booleanValue());
    }

    public void setCancelButtonVisible(Boolean visible) {
        this.btnCancel.setVisible(visible.booleanValue());
    }

    public void setSize(int w, int h) {
        this.setWidth(w + "px");
        this.setHeight(h + "px");
    }

    public void setSize(String w, String h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public void open() {
        int browserWindowWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
        if (browserWindowWidth < 800) {
            this.openFullScreen();
        } else {
            UI.getCurrent().addWindow((Window)this);
        }
    }

    public void openFullScreen() {
        this.setSizeFull();
        UI.getCurrent().addWindow((Window)this);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public abstract boolean doOk();

    public abstract void initUI(HorizontalLayout var1);

    public Button getDoneButton() {
        return this.btnDone;
    }
}

