/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InputPromptModel;
import com.google.gson.Gson;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.DoneCancelWindow;
import com.orocube.siiopa.cloud.client.FieldSet;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PaymentReferenceEntryDialog
extends DoneCancelWindow {
    private String paymentRef;

    public PaymentReferenceEntryDialog(String title, List<InputPromptModel> inputPromptList) {
        super(title);
        this.init(inputPromptList);
    }

    private void init(List<InputPromptModel> inputPromptList) {
        VerticalLayout mainLayout = new VerticalLayout();
        for (InputPromptModel inputPromptModel : inputPromptList) {
            FieldSet fieldSet = new FieldSet();
            Label legendHeader = new Label(inputPromptModel.getFieldName());
            fieldSet.addLegend((Component)legendHeader);
            SiiopaTextField textField = new SiiopaTextField();
            textField.setWidth("100%");
            fieldSet.addContent((Component)textField);
            mainLayout.addComponents(new Component[]{fieldSet});
        }
        HorizontalLayout contentPane = this.getContentPanel();
        contentPane.setSizeFull();
        contentPane.setMargin(true);
        contentPane.setSpacing(false);
        contentPane.addComponents(new Component[]{mainLayout});
        contentPane.setExpandRatio((Component)mainLayout, 1.0f);
    }

    @Override
    public boolean doOk() {
        try {
            HashMap<String, String> inputPromptMap = new HashMap<String, String>();
            VerticalLayout verticalLayout = (VerticalLayout)this.getContentPanel().getComponent(0);
            for (int i = 0; i < verticalLayout.getComponentCount(); ++i) {
                FieldSet fieldSet = (FieldSet)verticalLayout.getComponent(i);
                Label lbl = (Label)fieldSet.getComponent("fieldset-legend");
                SiiopaTextField textField = (SiiopaTextField)fieldSet.getComponent("fieldset-content");
                String propertyName = lbl.getValue();
                String value = textField.getValue();
                if (StringUtils.isBlank((String)value)) {
                    CloudNotification.showMessage(String.format("%s can't be empty. Please enter %s", propertyName, propertyName.toLowerCase()));
                    textField.focus();
                    return false;
                }
                inputPromptMap.put(propertyName, value);
            }
            this.setPaymentRef(new Gson().toJson(inputPromptMap));
            return true;
        }
        catch (PosException e) {
            CloudNotification.showErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e);
        }
        return false;
    }

    @Override
    public void initUI(HorizontalLayout contentPane) {
    }

    public String getPaymentRef() {
        return this.paymentRef;
    }

    public void setPaymentRef(String paymentRef) {
        this.paymentRef = paymentRef;
    }
}

