/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.model;

import com.floreantpos.util.NumberUtil;
import org.apache.commons.lang.StringUtils;

public class ByzlogicsProjectReportData {
    private String projectName;
    private String itemName;
    private String date;
    private String type;
    private String ticketId;
    private double itemQuantity;
    private double itemPrice;
    private String challanNo;
    private String description;
    private double totalAmount;
    private double paidAmount;
    private double dueAmount;
    private boolean isShipped;
    private String performerName;
    private String expenseRecipient;
    private String category;
    private String subCategory;

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public void setTicketId(String ticketId) {
        this.ticketId = ticketId;
    }

    public double getItemQuantity() {
        return this.itemQuantity;
    }

    public void setItemQuantity(double itemQuantity) {
        this.itemQuantity = itemQuantity;
    }

    public double getItemPrice() {
        return this.itemPrice;
    }

    public void setItemPrice(double itemPrice) {
        this.itemPrice = itemPrice;
    }

    public String getChallanNo() {
        return this.challanNo;
    }

    public void setChallanNo(String challanNo) {
        this.challanNo = challanNo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(double paidAmount) {
        this.paidAmount = paidAmount;
    }

    public double getDueAmount() {
        return this.dueAmount;
    }

    public void setDueAmount(double dueAmount) {
        this.dueAmount = dueAmount;
    }

    public void setPaidAmountDisplay(String paidAmountDisplay) {
    }

    public String getPaidAmountDisplay() {
        if (this.paidAmount == 0.0) {
            return NumberUtil.formatAmount((Double)this.paidAmount);
        }
        if (StringUtils.isNotBlank((String)this.type) && (this.type.equalsIgnoreCase("Refund") || this.type.equalsIgnoreCase("Purchase") || this.type.equalsIgnoreCase("Expense") || this.type.equalsIgnoreCase("Purchase due paid"))) {
            return "(" + NumberUtil.formatAmount((Double)this.paidAmount) + ")";
        }
        return NumberUtil.formatAmount((Double)this.paidAmount);
    }

    public void setDueAmountDisplay(String dueAmountDisplay) {
    }

    public String getDueAmountDisplay() {
        if (this.dueAmount > 0.0 && StringUtils.isNotBlank((String)this.type) && (this.type.equalsIgnoreCase("Refund") || this.type.equalsIgnoreCase("Purchase") || this.type.equalsIgnoreCase("Expense"))) {
            return "(" + NumberUtil.formatAmount((Double)this.dueAmount) + ")";
        }
        if (StringUtils.isNotBlank((String)this.type) && this.type.equalsIgnoreCase("Purchase") && this.dueAmount < 0.0) {
            return NumberUtil.formatAmount((Double)(this.dueAmount * -1.0));
        }
        if (StringUtils.isNotBlank((String)this.type) && this.type.equalsIgnoreCase("Sales") && this.dueAmount < 0.0) {
            double amount = this.dueAmount;
            if (amount < 0.0) {
                amount *= -1.0;
            }
            return "(" + NumberUtil.formatAmount((Double)amount) + ")";
        }
        return NumberUtil.formatAmount((Double)this.dueAmount);
    }

    public boolean isShipped() {
        return this.isShipped;
    }

    public String getPerformerName() {
        return this.performerName;
    }

    public void setPerformerName(String userName) {
        this.performerName = userName;
    }

    public String getExpenseRecipient() {
        return this.expenseRecipient;
    }

    public void setExpenseRecipient(String expenseRecipient) {
        this.expenseRecipient = expenseRecipient;
    }

    public void setShipped(boolean isShipped) {
        this.isShipped = isShipped;
    }

    public void setTotalAmountDisplay(String totalDisplayAmount) {
    }

    public String getTotalAmountDisplay() {
        if (StringUtils.isNotBlank((String)this.type) && (this.type.equalsIgnoreCase("Refund") || this.type.equalsIgnoreCase("Purchase") || this.type.equalsIgnoreCase("Expense"))) {
            return "(" + NumberUtil.formatAmount((Double)this.totalAmount) + ")";
        }
        return NumberUtil.formatAmount((Double)this.totalAmount);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }
}

