/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.action;

import com.floreantpos.POSConstants;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.dao.BankAccountDAO;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.YesNoDialog;

public class DeleteBankAccountAction
implements YesNoDialog.Callback {
    BeanGrid<BankAccount> bankAccountGrid;
    private BankAccount bankAccount;

    public DeleteBankAccountAction(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public DeleteBankAccountAction(BeanGrid<BankAccount> bankAccountGrid, BankAccount bankAccount) {
        this.bankAccountGrid = bankAccountGrid;
        this.bankAccount = bankAccount;
    }

    public void execute() {
        try {
            CloudNotification.showYesNoDialog(POSConstants.DELETE, POSConstants.CONFIRM_DELETE, this);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
        }
    }

    @Override
    public void dialogClosed(boolean isApproved) {
        if (isApproved) {
            this.onApprove();
        }
    }

    public void onApprove() {
        try {
            BankAccountDAO.getInstance().delete(this.bankAccount);
            CloudNotification.showMessage(ConsoleMessages.getString("DeletedSuccessfully"));
            if (this.bankAccountGrid != null) {
                this.bankAccountGrid.getContainerDataSource().removeItem((Object)this.bankAccount);
                this.bankAccountGrid.getSelectionModel().reset();
            }
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            return;
        }
    }
}

