/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonInlineFormContainer;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CommonUiContainer;
import com.orocube.siiopa.cloud.client.PaginationBar;
import com.orocube.siiopa.cloud.client.PaginationMenuBar;
import com.orocube.siiopa.cloud.client.crud.view.DateSelectionView;
import com.orocube.siiopa.cloud.client.page.ViewDataChangeListener;
import com.orocube.siiopa.cloud.server.security.CurrentSession;
import com.vaadin.event.ShortcutListener;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;

public abstract class BeanExplorerGridView<T>
extends CssLayout
implements View,
PaginationBar.PagingListener,
ViewDataChangeListener<T>,
DateSelectionView.DateChangeListener {
    protected BeanGrid<T> grid;
    protected Button btnNew;
    protected Button btnEdit;
    protected Button btnDelete;
    private PaginationBar paginationBar;
    private HorizontalLayout paginationPanel;
    private PaginationMenuBar paginationMenuBar;
    private boolean viewInitialized = false;
    private Pagination<T> pagination;
    private boolean showHeader = true;
    private boolean margin = true;
    private DateSelectionView dateSelectionView;
    private boolean standAlone = true;
    private Map<String, String> outletNamesMap = new WeakHashMap<String, String>();

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public void setMargin(boolean margin) {
        this.margin = margin;
    }

    public void initUI() {
        this.setSizeFull();
        this.addStyleName("crud-view");
        VerticalLayout topLayout = this.createTopBar();
        if (!this.showHeader) {
            topLayout.setVisible(false);
        }
        topLayout.addStyleName("margin-bottom-5px");
        this.grid = this.createItemGrid();
        VerticalLayout barAndGridLayout = new VerticalLayout();
        barAndGridLayout.setMargin(this.margin);
        barAndGridLayout.addStyleName("padding-bottom_5");
        barAndGridLayout.setSizeFull();
        barAndGridLayout.addComponent((Component)topLayout);
        barAndGridLayout.addComponent(this.grid);
        barAndGridLayout.setExpandRatio(this.grid, 2.0f);
        this.btnNew = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanExplorerGridView.1"));
        this.btnEdit = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanExplorerGridView.2"));
        this.btnDelete = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanExplorerGridView.3"));
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth("100%");
        horizontalLayout.setSpacing(true);
        horizontalLayout.addStyleName("margin-top-five");
        boolean productionMode = CurrentSession.isProductionMode();
        this.btnNew.setVisible(productionMode);
        this.btnEdit.setVisible(productionMode);
        this.btnDelete.setVisible(productionMode);
        horizontalLayout.addComponent((Component)this.btnNew);
        horizontalLayout.addComponent((Component)this.btnEdit);
        horizontalLayout.addComponent((Component)this.btnDelete);
        this.addButton(horizontalLayout);
        this.paginationBar = new PaginationBar(this, this.grid.getPageSize(), 0L);
        this.paginationPanel = new HorizontalLayout();
        this.paginationPanel.addComponent((Component)this.paginationBar);
        this.paginationBar.setVisible(!this.grid.hidePagination());
        this.paginationMenuBar = new PaginationMenuBar(this, 20, 0L);
        this.paginationMenuBar.setVisible(!this.grid.hidePagination());
        this.paginationBar.setFirstLastVisible(!this.grid.hideFirstLast());
        horizontalLayout.addComponent((Component)this.paginationPanel);
        horizontalLayout.setComponentAlignment((Component)this.paginationPanel, Alignment.MIDDLE_RIGHT);
        horizontalLayout.setExpandRatio((Component)this.paginationPanel, 1.0f);
        barAndGridLayout.addComponent((Component)horizontalLayout);
        this.addComponent((Component)barAndGridLayout);
        this.btnNew.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                BeanExplorerGridView.this.doCreateNewItem();
            }
        });
        this.btnEdit.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Object selectedRow = BeanExplorerGridView.this.grid.getSelectedRow();
                BeanExplorerGridView.this.setInlineFromVisible(!BeanExplorerGridView.this.standAlone);
                BeanExplorerGridView.this.doEditItem(selectedRow);
            }
        });
        this.btnDelete.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                Object selectedRow = BeanExplorerGridView.this.grid.getSelectedRow();
                try {
                    BeanExplorerGridView.this.doDeleteItem(selectedRow);
                }
                catch (Exception ex) {
                    CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("BeanExplorerGridView.0"), ex);
                }
            }
        });
        CommonUIUtil.makeVisibleIfEditableOnCloud(new AbstractComponent[]{this.btnNew, this.btnEdit, this.btnDelete});
    }

    public PaginationBar getPaginationBar() {
        return this.paginationBar;
    }

    public PaginationBar.PagingListener getPagingListener() {
        return this;
    }

    public HorizontalLayout getPaginationPanel() {
        return this.paginationPanel;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (!this.viewInitialized) {
            this.initUI();
            this.viewInitialized = true;
        }
        this.pageRequested(0);
    }

    public abstract void updateView(Pagination<T> var1);

    protected abstract void doCreateNewItem();

    protected abstract void doEditItem(T var1);

    protected abstract void doDeleteItem(T var1);

    protected abstract BeanGrid<T> createItemGrid();

    public abstract VerticalLayout createTopBar();

    protected abstract void addButton(HorizontalLayout var1);

    public void showError(String msg) {
        Notification.show((String)msg, (Notification.Type)Notification.Type.ERROR_MESSAGE);
    }

    public void showSaveNotification(String msg) {
        Notification.show((String)msg, (Notification.Type)Notification.Type.TRAY_NOTIFICATION);
    }

    public void setNewProductEnabled(boolean enabled) {
        this.btnNew.setEnabled(enabled);
    }

    public void setEditProductEnabled(boolean enabled) {
        this.btnEdit.setEnabled(enabled);
    }

    public void setEditProductVisible(boolean visible) {
        this.btnEdit.setVisible(visible);
    }

    public void setNewProductVisible(boolean visible) {
        this.btnNew.setVisible(visible);
    }

    public void setDeleteProductVisible(boolean visible) {
        this.btnDelete.setVisible(visible);
    }

    @Override
    public void clearSelection() {
        this.grid.getSelectionModel().reset();
    }

    public void selectRow(MenuItem row) {
        ((Grid.SelectionModel.Single)this.grid.getSelectionModel()).select((Object)row);
    }

    @Override
    public void refresh(T product) {
        if (product == null) {
            return;
        }
        this.grid.addOrUpdateItem(product);
        this.grid.recalculateColumnWidths();
        this.grid.clearSortOrder();
    }

    public void reloadPage() {
        this.paginationBar.setCurrentPage(0);
        this.pageRequested(0);
    }

    public void setRowCount(long numRow) {
        this.paginationBar.setRowCount(numRow);
    }

    @Override
    public void pageRequested(int page) {
        try {
            int pageSize = this.paginationBar.getPageSize();
            if (this.pagination == null) {
                this.pagination = new Pagination(page, this.grid.getPageSize());
            }
            this.pagination.setPageSize(pageSize);
            this.pagination.setCurrentRowIndex(page * pageSize);
            this.updateView(this.pagination);
            this.paginationBar.setRowCount(this.pagination.getNumRows());
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
        }
    }

    public Pagination<T> getPagination() {
        return this.pagination;
    }

    public BeanGrid<T> getGrid() {
        return this.grid;
    }

    public String getOutletNameById(String outletId) {
        if (StringUtils.isEmpty((String)outletId)) {
            return " ";
        }
        String outletName = this.outletNamesMap.get(outletId);
        if (StringUtils.isEmpty((String)outletName)) {
            Outlet outlet2 = OutletDAO.getInstance().get(outletId);
            outletName = outlet2.getName();
            this.outletNamesMap.put(outletId, outletName);
        }
        return outletName;
    }

    public Component getContainer() {
        Component inlineLayout = null;
        for (UI ui = this.getUI(); ui != null; ui = ui.getParent()) {
            Component layout;
            if (!(ui instanceof CommonUiContainer) || !((layout = ((CommonUiContainer)ui).getContent()) instanceof CommonInlineFormContainer)) continue;
            inlineLayout = ((CommonInlineFormContainer)layout).getGridFormContainer();
            if (inlineLayout != null) break;
            return null;
        }
        return inlineLayout;
    }

    public void setInlineFromVisible(boolean visible) {
        for (UI ui = this.getUI(); ui != null; ui = ui.getParent()) {
            Component layout;
            if (!(ui instanceof CommonUiContainer) || !((layout = ((CommonUiContainer)ui).getContent()) instanceof CommonInlineFormContainer)) continue;
            Component inlineLayout = ((CommonInlineFormContainer)layout).getGridFormContainer();
            if (inlineLayout == null) {
                return;
            }
            inlineLayout.setVisible(visible);
            break;
        }
    }

    public void updatePagination(int width) {
        if (width <= 600) {
            this.paginationPanel.removeAllComponents();
            this.paginationPanel.addComponent((Component)this.paginationMenuBar);
            this.paginationMenuBar.setPageSize(this.paginationBar.getPageSize());
            this.paginationMenuBar.setCurrentPage(this.paginationBar.getCurrentPage());
            this.paginationMenuBar.setRowCount(this.paginationBar.getRowCount());
        } else {
            this.paginationPanel.removeAllComponents();
            this.paginationPanel.addComponent((Component)this.paginationBar);
            this.paginationBar.setCurrentPage(this.paginationMenuBar.getCurrentPage());
            this.paginationBar.setRowCount(this.paginationMenuBar.getRowCount());
        }
    }

    public void setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
    }

    public void setDefaultPageSize(int pageSize) {
        this.paginationBar.setDefaultPageSize(pageSize);
    }

    public void addDateFilters(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView();
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addDateFilters(CssLayout topLayout, int dateRangeMonth, int dateRangeDays, boolean isAllowFutureDate) {
        this.dateSelectionView = new DateSelectionView(dateRangeMonth, dateRangeDays, isAllowFutureDate);
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addInventoryPurchaseOrderCrudViewDateFilters(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView(1, true);
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addInventoryTransactionCrudViewDateFilters(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView(1, true);
        this.dateSelectionView.setDateChangeListener(this);
        this.dateSelectionView.setDfFromDateWidth("140px");
        this.dateSelectionView.setDfToDateWidth("140px");
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    public void addAccountingDateFilters(CssLayout topLayout) {
        this.dateSelectionView = new DateSelectionView(6, true);
        this.dateSelectionView.setDateChangeListener(this);
        ShortcutListener enterKeyListener = this.createKeyPressListener();
        this.dateSelectionView.addEnterListener(enterKeyListener);
        topLayout.addComponent((Component)this.dateSelectionView);
    }

    private ShortcutListener createKeyPressListener() {
        ShortcutListener shortcutListener = new ShortcutListener("Enter key pressed", 13, null){

            public void handleAction(Object sender, Object target) {
                PosLog.debug(BeanExplorerGridView.class, (String)"date field shortcut listener fired");
                if (BeanExplorerGridView.this.dateSelectionView.isTargetMatch(target)) {
                    BeanExplorerGridView.this.updateView(BeanExplorerGridView.this.pagination);
                }
            }
        };
        return shortcutListener;
    }

    public Date getFromDate() {
        return this.dateSelectionView.getFromDate();
    }

    public Date getToDate() {
        return this.dateSelectionView.getToDate();
    }

    public void doUpdateUi(int reportType) {
        this.dateSelectionView.doUpdateUi(reportType);
    }

    public void validateDate() throws Exception {
        this.dateSelectionView.validateDate();
    }

    public void clearDateFields() {
        this.dateSelectionView.clearDateFields();
    }

    public void clearAccountDateFields() {
        this.dateSelectionView.clearDateFields();
        Date serverTimestamp = StoreDAO.getServerTimestamp();
        Calendar c = Calendar.getInstance();
        c.setTime(serverTimestamp);
        c.add(2, 6);
        this.dateSelectionView.toDateRangeEnd(DateUtil.endOfMonth((Date)c.getTime()));
    }

    public StreamResource getPreviewResource() {
        return null;
    }

    @Override
    public void updateData() {
    }
}

