/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public abstract class OkCancelWindow
extends Window {
    private static final long serialVersionUID = 1L;
    protected boolean canceled = true;
    protected Button ok = CommonUIUtil.createWhiteButton(ConsoleMessages.getString("OkCancelWindow.0"));
    protected Button cancel = CommonUIUtil.createWhiteButton(ConsoleMessages.getString("OkCancelWindow.1"));
    private HorizontalLayout content;
    private HorizontalLayout buttonPannel;

    public OkCancelWindow() {
        this.addStyleName("ok-cancel-window");
        this.setClosable(false);
        this.setResizable(false);
        this.setModal(true);
        this.setSizeFull();
        String title = this.getHeaderDisplayString();
        this.initContentUi(title);
        this.center();
    }

    public OkCancelWindow(String title) {
        this.addStyleName("ok-cancel-window");
        this.setClosable(false);
        this.setResizable(false);
        this.setModal(true);
        this.setSizeFull();
        this.initContentUi(title);
        this.center();
    }

    private void initContentUi(String title) {
        HorizontalLayout topHeader = new HorizontalLayout();
        topHeader.setStyleName("top-header");
        this.createHeaderPanel(topHeader, title);
        VerticalLayout container = new VerticalLayout();
        container.setSizeFull();
        container.addStyleName("main-content");
        container.setMargin(false);
        this.content = new HorizontalLayout();
        this.content.setMargin(false);
        this.content.setSizeFull();
        this.content.setStyleName("content");
        this.initUI(this.content);
        container.addComponents(new Component[]{topHeader, this.content});
        container.setExpandRatio((Component)this.content, 1.0f);
        this.setContent((Component)container);
    }

    private void createHeaderPanel(HorizontalLayout topHeader, String title) {
        topHeader.setSizeFull();
        Label lblTitle = new Label(title);
        lblTitle.addStyleName("small");
        lblTitle.addStyleName("colored");
        lblTitle.addStyleName("window-title");
        this.buttonPannel = new HorizontalLayout();
        this.buttonPannel.setSpacing(true);
        this.buttonPannel.addComponents(new Component[]{this.ok, this.cancel});
        topHeader.addComponents(new Component[]{lblTitle, this.buttonPannel});
        topHeader.setComponentAlignment((Component)lblTitle, Alignment.TOP_CENTER);
        topHeader.setComponentAlignment((Component)this.buttonPannel, Alignment.TOP_RIGHT);
        this.ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (!OkCancelWindow.this.doOk()) {
                    return;
                }
                OkCancelWindow.this.setCanceled(false);
                OkCancelWindow.this.close();
            }
        });
        this.cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                OkCancelWindow.this.close();
            }
        });
    }

    public HorizontalLayout getButtonPannel() {
        return this.buttonPannel;
    }

    public HorizontalLayout getContentPanel() {
        return this.content;
    }

    public void setOkButtonText(String text) {
        this.ok.setCaption(text);
    }

    public void setOkButtonVisible(Boolean visible) {
        this.ok.setVisible(visible.booleanValue());
    }

    public void setOkButtonEnabled(Boolean enabled) {
        this.ok.setEnabled(enabled.booleanValue());
    }

    public void setCancelButtonVisible(Boolean visible) {
        this.cancel.setVisible(visible.booleanValue());
    }

    public void setSize(int w, int h) {
        this.setWidth(w + "px");
        this.setHeight(h + "px");
    }

    public void setSize(String w, String h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public void open() {
        int browserWindowWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
        if (browserWindowWidth < 800) {
            this.openFullScreen();
        } else {
            UI.getCurrent().addWindow((Window)this);
        }
    }

    public void openFullScreen() {
        this.setSizeFull();
        UI.getCurrent().addWindow((Window)this);
    }

    public void openInlineScreen() {
        this.setResizable(false);
        this.center();
        this.setModal(true);
        int browserWindowWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
        int browserWindowHeight = UI.getCurrent().getPage().getBrowserWindowHeight();
        if (browserWindowWidth < 800 || browserWindowHeight < 500) {
            this.setSizeFull();
        } else {
            this.setWidth("800px");
            this.setHeight("85%");
        }
        this.addStyleName("inline_form_editor_window");
        UI.getCurrent().addWindow((Window)this);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public abstract boolean doOk();

    public abstract void initUI(HorizontalLayout var1);

    public abstract String getHeaderDisplayString();
}

