/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import java.io.Serializable;
import java.util.Collection;

public class PaginationBar
extends HorizontalLayout {
    private PagingListener listener;
    private long size;
    private int pageSize;
    private int currentPage;
    private int pages;
    private CloudButton first;
    private CloudButton last;
    private CloudButton next;
    private CloudButton previous;
    private final Label status = new Label();
    private Label lblPageSize;
    private SiiopaCombobox cbPageSize;
    private Button.ClickListener handler = new Button.ClickListener(){

        public void buttonClick(Button.ClickEvent event) {
            if (event.getButton() == PaginationBar.this.first) {
                PaginationBar.this.currentPage = 0;
            } else if (event.getButton() == PaginationBar.this.last) {
                PaginationBar.this.currentPage = PaginationBar.this.pages - 1;
            } else if (event.getButton() == PaginationBar.this.next) {
                PaginationBar.this.currentPage++;
            } else if (event.getButton() == PaginationBar.this.previous) {
                PaginationBar.this.currentPage--;
            }
            PaginationBar.this.updateState();
            PaginationBar.this.listener.pageRequested(PaginationBar.this.currentPage);
        }
    };

    public PaginationBar(PagingListener listener, int pageSize, long size) {
        this.addStyleName("pagination-bar");
        this.listener = listener;
        this.size = size;
        this.pageSize = pageSize;
        this.pages = (int)Math.ceil(((double)size + 0.0) / ((double)pageSize + 0.0));
        this.initButtons();
        this.updateState();
        this.addComponents(new Component[]{this.lblPageSize, this.cbPageSize, this.first, this.previous, this.status, this.next, this.last});
        this.setComponentAlignment((Component)this.lblPageSize, Alignment.MIDDLE_CENTER);
        this.setComponentAlignment((Component)this.cbPageSize, Alignment.MIDDLE_CENTER);
        this.setComponentAlignment((Component)this.first, Alignment.MIDDLE_CENTER);
        this.setComponentAlignment((Component)this.status, Alignment.MIDDLE_CENTER);
        this.setSizeFull();
    }

    public void setRowCount(long rowCount) {
        this.size = rowCount;
        this.pageSize = this.getPageSize();
        this.pages = (int)Math.ceil(((double)this.size + 0.0) / ((double)this.pageSize + 0.0));
        this.updateState();
    }

    public long getRowCount() {
        return this.size;
    }

    private void initButtons() {
        this.setSpacing(true);
        this.lblPageSize = new Label(ConsoleMessages.getString("PaginatedBar.0"));
        this.cbPageSize = new SiiopaCombobox();
        this.cbPageSize.setWidth("80px");
        this.cbPageSize.setNullSelectionAllowed(false);
        this.cbPageSize.setTextInputAllowed(false);
        this.addPageItem();
        this.setPageSizeComboVisible(Boolean.TRUE);
        this.first = CommonUIUtil.createColorButton("");
        this.first.setIcon((Resource)FontAwesome.FAST_BACKWARD);
        this.last = CommonUIUtil.createColorButton("");
        this.last.setIcon((Resource)FontAwesome.FAST_FORWARD);
        this.next = CommonUIUtil.createColorButton("");
        this.next.setIcon((Resource)FontAwesome.FORWARD);
        this.previous = CommonUIUtil.createColorButton("");
        this.previous.setIcon((Resource)FontAwesome.BACKWARD);
        this.setFirstLastVisible(Boolean.FALSE);
        this.cbPageSize.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.doUpdateUiState());
        this.first.addClickListener(this.handler);
        this.last.addClickListener(this.handler);
        this.next.addClickListener(this.handler);
        this.previous.addClickListener(this.handler);
    }

    private void doUpdateUiState() {
        this.pageSize = this.getPageSize();
        this.pages = (int)Math.ceil(((double)this.size + 0.0) / ((double)this.pageSize + 0.0));
        this.currentPage = 0;
        this.updateState();
        this.listener.pageRequested(this.currentPage);
    }

    public long getSize() {
        return this.size;
    }

    public int getPageSize() {
        if (this.cbPageSize == null) {
            return this.pageSize;
        }
        if (this.cbPageSize.getValue() instanceof String) {
            return 0;
        }
        return this.cbPageSize.getValue() == null ? this.pageSize : (Integer)this.cbPageSize.getValue();
    }

    private void setPageSizeComboVisible(boolean isVisiable) {
        this.lblPageSize.setVisible(isVisiable);
        this.cbPageSize.setVisible(isVisiable);
    }

    public void setFirstLastVisible(boolean isVisiable) {
        this.first.setVisible(isVisiable);
        this.last.setVisible(isVisiable);
    }

    private void addPageItem() {
        Collection itemIds = this.cbPageSize.getItemIds();
        if (itemIds.isEmpty()) {
            this.cbPageSize.addItem(20);
            this.cbPageSize.addItem(50);
            this.cbPageSize.addItem(100);
            this.cbPageSize.addItem(200);
            this.cbPageSize.addItem(500);
            this.cbPageSize.addItem(1000);
        }
        this.setDefaultPageSize(100);
    }

    public void setDefaultPageSize(int pageSize) {
        this.cbPageSize.select(pageSize);
    }

    public PagingListener getListener() {
        return this.listener;
    }

    public void setListener(PagingListener listener) {
        this.listener = listener;
    }

    private void updateState() {
        if (this.getPageSize() != 0) {
            boolean hasPrev = this.currentPage > 0;
            this.first.setButtonEnabled(hasPrev);
            this.previous.setButtonEnabled(hasPrev);
            boolean hasNext = this.currentPage < this.pages - 1;
            this.last.setButtonEnabled(hasNext);
            this.next.setButtonEnabled(hasNext);
            this.status.setValue(this.currentPage + 1 + "/" + this.pages);
        } else {
            this.first.setButtonEnabled(Boolean.FALSE);
            this.previous.setButtonEnabled(Boolean.FALSE);
            this.last.setButtonEnabled(Boolean.FALSE);
            this.next.setButtonEnabled(Boolean.FALSE);
            this.status.setValue("1/1");
        }
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public Label getStatus() {
        return this.status;
    }

    public static interface PagingListener {
        public void pageRequested(int var1);
    }
}

