/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Pagination;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonInlineFormContainer;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CommonUiContainer;
import com.orocube.siiopa.cloud.client.PaginationBar;
import com.orocube.siiopa.cloud.client.PaginationMenuBar;
import com.orocube.siiopa.cloud.client.page.ViewDataChangeListener;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;

public abstract class BeanExplorerMultiSelectGridView<T>
extends CssLayout
implements View,
PaginationBar.PagingListener,
ViewDataChangeListener<T> {
    protected BeanGrid<T> grid;
    private Button btnNew;
    private Button btnEdit;
    private Button btnDelete;
    private PaginationBar paginationBar;
    private PaginationMenuBar paginationMenuBar;
    private HorizontalLayout paginationPanel;
    private boolean viewInitialized = false;
    private Pagination<T> pagination;

    public void initUI() {
        this.setWidth("100%");
        this.setHeight("98%");
        this.addStyleName("crud-view");
        VerticalLayout topLayout = this.createTopBar();
        this.grid = this.createItemGrid();
        VerticalLayout barAndGridLayout = new VerticalLayout();
        barAndGridLayout.addStyleName("barAndGridLayout");
        barAndGridLayout.addComponent((Component)topLayout);
        barAndGridLayout.addComponent(this.grid);
        barAndGridLayout.setMargin(true);
        barAndGridLayout.setSpacing(true);
        barAndGridLayout.setSizeFull();
        barAndGridLayout.setExpandRatio(this.grid, 1.0f);
        this.btnNew = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanExplorerMultiSelectGridView.0"));
        this.btnEdit = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanExplorerMultiSelectGridView.1"));
        this.btnDelete = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanExplorerMultiSelectGridView.2"));
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth("100%");
        horizontalLayout.setSpacing(true);
        horizontalLayout.addComponent((Component)this.btnNew);
        horizontalLayout.addComponent((Component)this.btnEdit);
        horizontalLayout.addComponent((Component)this.btnDelete);
        this.addButton(horizontalLayout);
        this.paginationBar = new PaginationBar(this, this.grid.getPageSize(), 0L);
        this.paginationPanel = new HorizontalLayout();
        this.paginationPanel.addComponent((Component)this.paginationBar);
        this.paginationBar.setVisible(!this.grid.hidePagination());
        this.paginationMenuBar = new PaginationMenuBar(this, 20, 0L);
        this.paginationMenuBar.setVisible(!this.grid.hidePagination());
        horizontalLayout.addComponent((Component)this.paginationPanel);
        horizontalLayout.setComponentAlignment((Component)this.paginationPanel, Alignment.MIDDLE_RIGHT);
        horizontalLayout.setExpandRatio((Component)this.paginationPanel, 1.0f);
        barAndGridLayout.addComponent((Component)horizontalLayout);
        this.addComponent((Component)barAndGridLayout);
        this.btnNew.addClickListener((Button.ClickListener & Serializable)e -> this.doCreateNewItem());
        this.btnEdit.addClickListener((Button.ClickListener & Serializable)e -> this.doEditItem(this.grid.getSelectionModel().getSelectedRows()));
        this.btnDelete.addClickListener((Button.ClickListener & Serializable)event -> this.doDeleteSelectedItem());
    }

    private void doDeleteSelectedItem() {
        Collection selectedRows = this.grid.getSelectionModel().getSelectedRows();
        try {
            this.doDeleteItems(selectedRows);
        }
        catch (Exception ex) {
            CloudNotification.showErrorMessageDialog(ConsoleMessages.getString("BeanExplorerMultiSelectGridView.5"));
        }
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (!this.viewInitialized) {
            this.initUI();
            this.viewInitialized = true;
        }
        this.pageRequested(0);
    }

    public abstract void updateView(Pagination<T> var1);

    protected abstract void doCreateNewItem();

    protected abstract void doEditItem(Collection<Object> var1);

    protected abstract void doDeleteItems(Collection<Object> var1);

    protected abstract BeanGrid<T> createItemGrid();

    public abstract VerticalLayout createTopBar();

    protected abstract void addButton(HorizontalLayout var1);

    public void showError(String msg) {
        CloudNotification.showMessage(msg, Notification.Type.ERROR_MESSAGE);
    }

    public void showSaveNotification(String msg) {
        CloudNotification.showMessage(msg, Notification.Type.TRAY_NOTIFICATION);
    }

    public void setNewProductEnabled(boolean enabled) {
        this.btnNew.setEnabled(enabled);
    }

    public void setNewProductVisible(boolean visible) {
        this.btnNew.setVisible(visible);
    }

    public void setEditProductEnabled(boolean enabled) {
        this.btnEdit.setEnabled(enabled);
    }

    public void setEditProductVisible(boolean visible) {
        this.btnEdit.setVisible(visible);
    }

    @Override
    public void clearSelection() {
        this.grid.getSelectionModel().reset();
    }

    public void selectRow(MenuItem row) {
        ((Grid.SelectionModel.Single)this.grid.getSelectionModel()).select((Object)row);
    }

    @Override
    public void refresh(Object product) {
        if (product == null) {
            return;
        }
        this.grid.addOrUpdateItem(product);
        this.grid.recalculateColumnWidths();
        this.grid.clearSortOrder();
    }

    public void reloadPage() {
        this.paginationBar.setCurrentPage(0);
        this.pageRequested(0);
    }

    public void setRowCount(long numRow) {
        this.paginationBar.setRowCount(numRow);
    }

    @Override
    public void pageRequested(int page) {
        int pageSize = this.paginationBar.getPageSize();
        if (this.pagination == null) {
            this.pagination = new Pagination(page, this.grid.getPageSize());
        }
        this.pagination.setPageSize(pageSize);
        this.pagination.setCurrentRowIndex(page * pageSize);
        this.updateView(this.pagination);
        this.paginationBar.setRowCount(this.pagination.getNumRows());
    }

    public Pagination<T> getPagination() {
        return this.pagination;
    }

    public void updatePagination(int width) {
        if (width <= 600) {
            this.paginationPanel.removeAllComponents();
            this.paginationPanel.addComponent((Component)this.paginationMenuBar);
            this.paginationMenuBar.setPageSize(this.paginationBar.getPageSize());
            this.paginationMenuBar.setCurrentPage(this.paginationBar.getCurrentPage());
            this.paginationMenuBar.setRowCount(this.paginationBar.getRowCount());
        } else {
            this.paginationPanel.removeAllComponents();
            this.paginationPanel.addComponent((Component)this.paginationBar);
            this.paginationBar.setCurrentPage(this.paginationMenuBar.getCurrentPage());
            this.paginationBar.setRowCount(this.paginationMenuBar.getRowCount());
        }
    }

    public void setInlineFromVisible(boolean visible) {
        for (UI ui = this.getUI(); ui != null; ui = ui.getParent()) {
            Component layout;
            if (!(ui instanceof CommonUiContainer) || !((layout = ((CommonUiContainer)ui).getContent()) instanceof CommonInlineFormContainer)) continue;
            Component inlineLayout = ((CommonInlineFormContainer)layout).getGridFormContainer();
            if (inlineLayout == null) {
                return;
            }
            inlineLayout.setVisible(visible);
            break;
        }
    }

    public PaginationBar getPaginationBar() {
        return this.paginationBar;
    }
}

