/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.form;

import com.floreantpos.PosLog;
import com.floreantpos.model.util.CustomerPINGenerationUtil;
import com.floreantpos.model.util.UserPINGenerationUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.vaadin.jsclipboard.JSClipboard;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import org.apache.commons.lang.StringUtils;

public class GenerateCloudPinForm
extends CssLayout
implements View {
    private Window popUpWindow;
    private String generatedPin;
    private boolean isCancel;
    protected TextField tfGenPin;
    protected TextField tfPassLength;
    private JSClipboard clipboard;
    private boolean isForCustomer;

    public GenerateCloudPinForm(Window popUpWindow) {
        this(popUpWindow, false);
    }

    public GenerateCloudPinForm(Window popUpWindow, boolean isForCustomer) {
        this.popUpWindow = popUpWindow;
        this.isForCustomer = isForCustomer;
        this.enter(null);
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.initUI();
    }

    private void initUI() {
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setSpacing(true);
        mainLayout.addStyleName("padding-left-5");
        VerticalLayout contentLayout = new VerticalLayout();
        contentLayout.setSpacing(true);
        contentLayout.setMargin(true);
        FormLayout formLayout = new FormLayout();
        formLayout.setSpacing(true);
        this.clipboard = new JSClipboard();
        CssLayout wrapButton = new CssLayout();
        wrapButton.setCaption(this.getPinLenght());
        this.tfPassLength = new TextField();
        this.tfPassLength.setMaxLength(1);
        this.tfPassLength.setValue(ConsoleMessages.getString("GenerateCloudPinForm.1"));
        CloudButton btnGeneratePin = CommonUIUtil.createColorButton(ConsoleMessages.getString("GenerateCloudPinForm.2"));
        wrapButton.addComponent((Component)CustomLayoutComponent.createLayout("", (Component)this.tfPassLength));
        wrapButton.addComponent((Component)CustomLayoutComponent.createSpacing());
        wrapButton.addComponent((Component)CustomLayoutComponent.createLayout("", (Component)btnGeneratePin));
        wrapButton.addComponent((Component)CustomLayoutComponent.createSpacing());
        formLayout.addComponent((Component)wrapButton);
        this.tfGenPin = new TextField(this.getGeneratePin());
        this.tfGenPin.setReadOnly(true);
        this.tfGenPin.setId("tfGenPin");
        formLayout.addComponent((Component)this.tfGenPin);
        HorizontalLayout buttomButtonLayout = new HorizontalLayout();
        buttomButtonLayout.setSpacing(true);
        CloudButton btnCopy = CommonUIUtil.createColorButton(ConsoleMessages.getString("GenerateCloudPinForm.4"));
        CloudButton btnUseThisPass = CommonUIUtil.createColorButton(this.getUseThisPin());
        CloudButton btnCencal = CommonUIUtil.createColorButton(ConsoleMessages.getString("GenerateCloudPinForm.6"));
        btnGeneratePin.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                GenerateCloudPinForm.this.doSetGeneratedPass();
            }
        });
        this.clipboard.apply((Button)btnCopy, (Component)this.tfGenPin);
        this.clipboard.addSuccessListener(new JSClipboard.SuccessListener(){

            public void onSuccess() {
                if (((String)GenerateCloudPinForm.this.tfGenPin.getValue()).length() == 0) {
                    CloudNotification.showWarningMessageDialog(ConsoleMessages.getString("GenerateCloudPinForm.7"));
                    return;
                }
                CloudNotification.showMessage(ConsoleMessages.getString("GenerateCloudPinForm.8"));
            }
        });
        this.clipboard.addErrorListener(new JSClipboard.ErrorListener(){

            public void onError() {
                CloudNotification.showWarningMessageDialog(ConsoleMessages.getString("GenerateCloudPinForm.9"));
            }
        });
        btnUseThisPass.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                GenerateCloudPinForm.this.doUseThisPass();
            }
        });
        btnCencal.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                GenerateCloudPinForm.this.isCancel = true;
                GenerateCloudPinForm.this.doCloseWindow();
            }
        });
        buttomButtonLayout.addComponents(new Component[]{btnCopy, btnUseThisPass, btnCencal});
        formLayout.addComponents(new Component[]{buttomButtonLayout});
        contentLayout.addComponents(new Component[]{formLayout});
        contentLayout.setExpandRatio((Component)formLayout, 1.0f);
        mainLayout.addComponent((Component)contentLayout);
        mainLayout.setComponentAlignment((Component)contentLayout, Alignment.MIDDLE_LEFT);
        this.popUpWindow.setContent((Component)mainLayout);
    }

    public String getUseThisPin() {
        return "Use this PIN";
    }

    public String getGeneratePin() {
        return "Generated PIN";
    }

    public String getPinLenght() {
        return "PIN length";
    }

    protected void doSetGeneratedPass() {
        try {
            if (((String)this.tfPassLength.getValue()).equals("0") || ((String)this.tfPassLength.getValue()).equals("1") || ((String)this.tfPassLength.getValue()).equals("2") || ((String)this.tfPassLength.getValue()).equals("3")) {
                CloudNotification.showWarningMessageDialog(ConsoleMessages.getString("GenerateCloudPinForm.12"));
            } else {
                String value = (String)this.tfPassLength.getValue();
                if (!StringUtils.isNumeric((String)value)) {
                    CloudNotification.showWarningMessageDialog(ConsoleMessages.getString("GenerateCloudPinForm.12"));
                    return;
                }
                this.tfGenPin.setReadOnly(false);
                this.tfGenPin.setValue(this.createPIN(value));
                this.tfGenPin.selectAll();
                this.tfGenPin.setReadOnly(true);
            }
        }
        catch (Exception e) {
            PosLog.error(GenerateCloudPinForm.class, (String)e.getMessage(), (Exception)e);
        }
    }

    public String createPIN(String value) throws Exception {
        if (this.isForCustomer) {
            CustomerPINGenerationUtil passwordService = new CustomerPINGenerationUtil();
            return passwordService.createPIN(value);
        }
        UserPINGenerationUtil passwordService = new UserPINGenerationUtil();
        return passwordService.createPIN(value);
    }

    protected void doCloseWindow() {
        this.popUpWindow.close();
    }

    public void openFullScreen() {
        this.popUpWindow.setSizeFull();
        UI.getCurrent().addWindow(this.popUpWindow);
    }

    public void openInlineScreen() {
        this.popUpWindow.setResizable(false);
        this.popUpWindow.center();
        this.popUpWindow.setModal(true);
        int browserWindowWidth = UI.getCurrent().getPage().getBrowserWindowWidth();
        if (browserWindowWidth > 800) {
            this.popUpWindow.setWidth("400px");
            this.popUpWindow.setHeight("200px");
        } else {
            this.popUpWindow.setSizeFull();
        }
        this.addStyleName("inline_form_editor_window");
        UI.getCurrent().addWindow(this.popUpWindow);
    }

    private void doUseThisPass() {
        try {
            if (((String)this.tfGenPin.getValue()).length() == 0) {
                CloudNotification.showWarningMessageDialog(ConsoleMessages.getString("GenerateCloudPinForm.7"));
                return;
            }
            this.generatedPin = (String)this.tfGenPin.getValue();
            this.doCloseWindow();
        }
        catch (Exception e) {
            PosLog.error(GenerateCloudPinForm.class, (String)e.getMessage(), (Exception)e);
        }
    }

    public String getGeneratedPin() {
        return this.generatedPin;
    }

    public boolean isCancelWindow() {
        return this.isCancel;
    }
}

