/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.common.classes;

import com.floreantpos.PosLog;
import com.floreantpos.extension.AuthorizeNetGatewayPlugin;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.xeoh.plugins.base.Plugin;
import net.xeoh.plugins.base.PluginManager;
import net.xeoh.plugins.base.impl.PluginManagerFactory;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.util.PluginManagerUtil;
import org.apache.commons.lang.StringUtils;

public class SiiopaExtensionManager {
    private List<FloreantPlugin> plugins;
    private static SiiopaExtensionManager instance;

    private synchronized void initializePlugins() {
        PluginManager pluginManager = PluginManagerFactory.createPluginManager();
        URI uri = null;
        try {
            uri = Application.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            PosLog.info(this.getClass(), (String)e.getMessage());
        }
        pluginManager.addPluginsFrom(uri, new AddPluginsFromOption[0]);
        PluginManagerUtil pmUtil = new PluginManagerUtil(pluginManager);
        List allPlugins = (List)pmUtil.getPlugins();
        Collections.sort(allPlugins, new Comparator<Plugin>(){

            @Override
            public int compare(Plugin o1, Plugin o2) {
                return o1.getClass().getName().compareToIgnoreCase(o2.getClass().getName());
            }
        });
        ArrayList<PaymentGatewayPlugin> floreantPlugins = new ArrayList<PaymentGatewayPlugin>();
        for (Plugin plugin : allPlugins) {
            if (!(plugin instanceof PaymentGatewayPlugin)) continue;
            floreantPlugins.add((PaymentGatewayPlugin)plugin);
        }
        this.plugins = Collections.unmodifiableList(floreantPlugins);
    }

    public static PaymentGatewayPlugin getPaymentGateway(Store store) {
        if (store == null) {
            return new AuthorizeNetGatewayPlugin();
        }
        String gatewayId = store.getProperty("online_order.payment.card.gateway");
        if (StringUtils.isBlank((String)gatewayId)) {
            return new AuthorizeNetGatewayPlugin();
        }
        List<FloreantPlugin> plugins = SiiopaExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin plugin : plugins) {
            if (gatewayId == null || !gatewayId.equals(plugin.getId())) continue;
            return (PaymentGatewayPlugin)plugin;
        }
        return new AuthorizeNetGatewayPlugin();
    }

    public static PaymentGatewayPlugin getPaymentGateway(Outlet outlet) {
        if (outlet == null) {
            return new AuthorizeNetGatewayPlugin();
        }
        String gatewayId = outlet.getProperty("online_order.payment.card.gateway");
        if (StringUtils.isBlank((String)gatewayId)) {
            return new AuthorizeNetGatewayPlugin();
        }
        List<FloreantPlugin> plugins = SiiopaExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin plugin : plugins) {
            if (gatewayId == null || !gatewayId.equals(plugin.getId())) continue;
            return (PaymentGatewayPlugin)plugin;
        }
        return new AuthorizeNetGatewayPlugin();
    }

    public static List<FloreantPlugin> getPlugins(Class pluginClass) {
        ArrayList<FloreantPlugin> list = new ArrayList<FloreantPlugin>();
        for (FloreantPlugin floreantPlugin : SiiopaExtensionManager.getInstance().plugins) {
            if (!pluginClass.isAssignableFrom(floreantPlugin.getClass())) continue;
            list.add(floreantPlugin);
        }
        return list;
    }

    public static List<FloreantPlugin> initPlugins() {
        return SiiopaExtensionManager.getInstance().plugins;
    }

    private static synchronized SiiopaExtensionManager getInstance() {
        if (instance == null) {
            instance = new SiiopaExtensionManager();
            instance.initializePlugins();
        }
        return instance;
    }
}

