/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.PurchaseOrder;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class PurchaseSummaryReportGrid
extends FooterSupportedBeanGrid<PurchaseOrder> {
    private Grid.FooterCell costCell;
    private Grid.FooterCell paidCell;
    private Grid.FooterCell dueCell;

    public PurchaseSummaryReportGrid() {
        this.addColumn("PO. No", PurchaseOrder.PROP_ORDER_ID, String.class);
        this.addColumn("Order date", "createdDateAsString", String.class);
        this.addColumn("Received date", "receivedDateAsString", String.class);
        this.addColumn("Pay to", "vendorDisplay", String.class);
        this.addColumn("Location", "locationDisplay", String.class);
        this.addColumn("Total cost", PurchaseOrder.PROP_TOTAL_AMOUNT, Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.addColumn("Paid amount", PurchaseOrder.PROP_PAID_AMOUNT, Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.addColumn("Due amount", PurchaseOrder.PROP_DUE_AMOUNT, Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
        this.mergeAndshowTotal(PurchaseOrder.PROP_ORDER_ID, "createdDateAsString", "receivedDateAsString", "vendorDisplay", "locationDisplay");
        this.costCell = this.createSummaryCell(PurchaseOrder.PROP_TOTAL_AMOUNT);
        this.paidCell = this.createSummaryCell(PurchaseOrder.PROP_PAID_AMOUNT);
        this.dueCell = this.createSummaryCell(PurchaseOrder.PROP_DUE_AMOUNT);
    }

    @Override
    public void setItems(Collection<PurchaseOrder> items) {
        super.setItems(items);
        Double totalCost = 0.0;
        Double totalPaid = 0.0;
        Double totalDue = 0.0;
        if (items != null) {
            for (PurchaseOrder purchaseOrder : items) {
                totalCost = totalCost + purchaseOrder.getTotalAmount();
                totalPaid = totalPaid + purchaseOrder.getPaidAmount();
                totalDue = totalDue + purchaseOrder.getDueAmount();
            }
        }
        this.updateCellValue(this.costCell, totalCost);
        this.updateCellValue(this.paidCell, totalPaid);
        this.updateCellValue(this.dueCell, totalDue);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PurchaseOrder.class;
    }

    @Override
    public void clearFooterCell() {
        this.updateCellValue(this.costCell, 0.0);
        this.updateCellValue(this.paidCell, 0.0);
        this.updateCellValue(this.dueCell, 0.0);
    }
}

