/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Address;
import com.floreantpos.model.Appointment;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.Doctor;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SalesSummaryDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.AttendanceReportModel;
import com.floreantpos.report.CardReportModel;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.DeletedItem;
import com.floreantpos.report.HourlySalesReportModel;
import com.floreantpos.report.ItemwiseRfReportData;
import com.floreantpos.report.JournalReportModel;
import com.floreantpos.report.LabDoctorFeeReportData;
import com.floreantpos.report.LabItemChargesDataModel;
import com.floreantpos.report.MenuUsageReport;
import com.floreantpos.report.PayrollReportModel;
import com.floreantpos.report.PurchaseOrderItemReportModel;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReferralCommissionReportData;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesDetailedReport;
import com.floreantpos.report.SalesExceptionReport;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.report.ServerProductivityReport;
import com.floreantpos.report.SessionSummaryReportModel;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.report.StoreSessionReportModel;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketReportModel;
import com.floreantpos.report.TransactionReportModel;
import com.floreantpos.report.UserWiseCollectionReportData;
import com.floreantpos.report.VoidItemReportModel;
import com.floreantpos.report.WeeklyPayrollReportModel;
import com.floreantpos.report.model.AccountPayableReportDataModel;
import com.floreantpos.report.model.BankAccountTransactionReportDataModel;
import com.floreantpos.report.model.CustomerPaymentReportModel;
import com.floreantpos.report.model.DoctorAppointmentReportModel;
import com.floreantpos.report.model.ExpenseReportDataModel;
import com.floreantpos.report.model.GiftCardSummaryReportModel;
import com.floreantpos.report.model.InvTransactionsReportModel;
import com.floreantpos.report.model.InventoryAverageCostUnitReportModel;
import com.floreantpos.report.model.InventoryStockTransfersReportModel;
import com.floreantpos.report.model.InventoryTransactionReportModel;
import com.floreantpos.report.model.ItemWiseRFReportModel;
import com.floreantpos.report.model.LabDoctorFeeReportModel;
import com.floreantpos.report.model.LabDoctorPaymentsReportModel;
import com.floreantpos.report.model.PaymentReceivedReportData;
import com.floreantpos.report.model.PaymentReceivedReportModel2;
import com.floreantpos.report.model.PayoutReportDataModel;
import com.floreantpos.report.model.ProjectReportDataModel;
import com.floreantpos.report.model.ReferralCommissionReportModel;
import com.floreantpos.report.model.ReferralDetailsReportModel;
import com.floreantpos.report.model.UserWiseCollectionReportDataModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.crud.inventory.view.InventoryTransfer;
import com.vaadin.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.calendar.DateUtils;

public class CommonCloudReportService {
    private static final String CLOUD_DAILY_SUMMARY_SUBREPORT = "cloud_daily_summary_subreport";
    private static final String CLOUD_DAILY_SUMMARY_REPORT = "cloud_daily_summary_report";
    private static final String CLOUD_ORDER_INFO_REPORT = "cloud_order_info_report";
    private static SimpleDateFormat orderDateFormat;
    private static Ticket selectedTicket;

    public static StreamResource getReportStream(String reportOutputFilename, JasperPrint jasperPrint) {
        reportOutputFilename = reportOutputFilename + "_" + CommonCloudReportService.getDateAsString() + ".pdf";
        StreamResource resource = CommonCloudReportService.createPdfResourceStream(reportOutputFilename, jasperPrint);
        resource.setMIMEType("application/pdf");
        resource.getStream().setParameter("Content-Disposition", "attachment; filename=" + reportOutputFilename);
        return resource;
    }

    private static StreamResource createPdfResourceStream(String reportFileName, final JasperPrint jasperPrint) {
        return new StreamResource(new StreamResource.StreamSource(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public InputStream getStream() {
                try (ByteArrayOutputStream pdfBuffer = new ByteArrayOutputStream();){
                    ByteArrayInputStream inputStream;
                    CommonCloudReportService.exportReportToPdf(jasperPrint, pdfBuffer);
                    ByteArrayInputStream byteArrayInputStream = inputStream = new ByteArrayInputStream(pdfBuffer.toByteArray());
                    return byteArrayInputStream;
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), (Exception)e);
                    return null;
                }
            }
        }, reportFileName);
    }

    private static void exportReportToPdf(JasperPrint jasperPrint, OutputStream outputStream) throws JRException {
        JRPdfExporter exporter = new JRPdfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)outputStream);
        exporter.exportReport();
    }

    public static String getDateAsString() {
        return String.valueOf(Calendar.getInstance().get(1)) + String.valueOf(Calendar.getInstance().get(2) + 1) + String.valueOf(Calendar.getInstance().get(5)) + String.valueOf(Calendar.getInstance().get(11)) + String.valueOf(Calendar.getInstance().get(12)) + String.valueOf(Calendar.getInstance().get(13));
    }

    public static void populateCloudStoreSessionSummaryReportParameters(CashDrawer cashDrawer, StoreSession storeSession, OutputStream outputStream) throws JRException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine0", store.getName());
        parameters.put("reportTitle", "End of day sales report");
        parameters.put("IS_IGNORE_PAGINATION", true);
        parameters.put("startTime", ConsoleMessages.getString("CloudReportService.8") + CommonCloudReportService.format(storeSession.getOpenTime()));
        parameters.put("user", ConsoleMessages.getString("CloudReportService.10") + storeSession.getOpenedByUserId());
        if (storeSession.getCloseTime() != null) {
            parameters.put("date", ConsoleMessages.getString("CloudReportService.11") + CommonCloudReportService.format(storeSession.getCloseTime()));
            parameters.put("reportUser", ConsoleMessages.getString("CloudReportService.12") + storeSession.getClosedByUserId());
        }
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport((String)"drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport((String)"drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport((String)"store-session-summary-report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
        jasperPrint.setName("StoreSessionSummaryReport");
        CommonCloudReportService.exportReportToPdf(jasperPrint, outputStream);
    }

    public static JasperPrint populateCloudTerminalStatusReport(CashDrawer cashDrawer, StoreSession storeSession) throws Exception {
        boolean staffBankReport = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Store store = StoreDAO.getRestaurant();
        parameters.put("headerLine0", store.getName());
        parameters.put("reportTitle", staffBankReport ? "Staff bank report" : ConsoleMessages.getString("CloudReportService.13"));
        JasperPrint jasperPrint = CommonCloudReportService.populateTerminalStatusReport(cashDrawer, staffBankReport, parameters);
        return jasperPrint;
    }

    public static JasperPrint populateTerminalStatusReport(CashDrawer cashDrawer, boolean staffBankReport, HashMap parameters) throws JRException {
        parameters.put("IS_IGNORE_PAGINATION", true);
        CommonCloudReportService.populateTerminalStatusReportParams(parameters);
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression((Map)parameters, (Store)store);
        User assignedUser = cashDrawer.getAssignedUser();
        if (assignedUser != null) {
            String userInfo = assignedUser.getFullName();
            parameters.put("user", (staffBankReport ? Messages.getString((String)"PosPrintService.21") : Messages.getString((String)"PosPrintService.4") + " ") + userInfo);
        }
        if (cashDrawer.getStartTime() != null) {
            parameters.put("startTime", Messages.getString((String)"PosPrintService.24") + CommonCloudReportService.format(cashDrawer.getStartTime()));
        }
        parameters.put("date", Messages.getString((String)"PosPrintService.25") + CommonCloudReportService.format(new Date()));
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport((String)"drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport((String)"drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport((String)"terminal_status_report_72");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, (Map)parameters, (JRDataSource)dataSource);
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        jasperPrint.setName("TerminalStatusReport" + cashDrawer.getTerminalId());
        return jasperPrint;
    }

    private static void populateTerminalStatusReportParams(HashMap map) {
        map.put("salesBalance", Messages.getString((String)"SALES_BALANCE"));
        map.put("rowGrossReceipts", Messages.getString((String)"grossReceipts"));
        map.put("rowCReceipts", "-" + Messages.getString((String)"cashReceipts"));
        map.put("rowCCards", "-" + Messages.getString((String)"creditCards"));
        map.put("rowDCards", "-" + Messages.getString((String)"debitCards"));
        map.put("rowMPayments", "-" + Messages.getString((String)"memberPayments"));
        map.put("rowCPayments", "-" + Messages.getString((String)"customPayments"));
        map.put("rowGReturns", "-" + Messages.getString((String)"giftReurns"));
        map.put("rowGCChange", "-" + Messages.getString((String)"giftCertChange"));
        map.put("rowRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("rowReceiptDiff", "=" + Messages.getString((String)"receiptDifferential"));
        map.put("rowCashTips", "+" + Messages.getString((String)"TipsCashoutReportTableModel.9"));
        map.put("rowChargedTips", "+" + Messages.getString((String)"chargedTips"));
        map.put("rowTipsPaid", "-" + Messages.getString((String)"TipsCashoutReportTableModel.5"));
        map.put("rowTipsDiff", "=" + Messages.getString((String)"tipsDiff"));
        map.put("cashBalance", Messages.getString((String)"CASH_BALANCE"));
        map.put("rowCash", POSConstants.CASH);
        map.put("rowTipsPaid", "-" + Messages.getString((String)"TipsCashoutReportTableModel.5"));
        map.put("rowPayOut", "-" + Messages.getString((String)"UserPermission.13"));
        map.put("rowRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("rowBeginCash", "+" + Messages.getString((String)"beginCash"));
        map.put("rowDBleed", "-" + Messages.getString((String)"CashDropDialog.2"));
        map.put("rowDAcc", "=" + Messages.getString((String)"drawerAccountable"));
        map.put("rowDTips", ">" + Messages.getString((String)"declaredTips"));
        map.put("rowCToDipo", ">" + Messages.getString((String)"cashToDeposit"));
        map.put("rowCBreakD", Messages.getString((String)"CBreakDown"));
        map.put("rowCSRAmount", POSConstants.AMOUNT);
        map.put("rowVRExceptions", Messages.getString((String)"VRExceptions"));
        map.put("rowVRTax", Messages.getString((String)"VRTax"));
        map.put("rowVRAmount", POSConstants.AMOUNT);
        map.put("rowVRTotal", POSConstants.TOTAL);
    }

    public static String format(Date date) {
        return DateUtil.formatDateWithBrowserTimeOffset((Date)date);
    }

    protected static String makeBoldString(String string) {
        return "<b>" + string + "</b> ";
    }

    public static JasperPrint getTransactionSummaryDetailReportPrint(CashDrawer cashDrawer) throws JRException {
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        List transactions = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(cashDrawer.getId(), false);
        reportModel.setItems(transactions);
        HashMap<String, String> map = new HashMap<String, String>();
        boolean staffBankReport = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(map, (Store)store);
        map.put("headerLine1", store.getName());
        map.put("receiptType", staffBankReport ? "Staff bank sales details" : ConsoleMessages.getString("CloudReportService.19"));
        Date storeCloseTime = cashDrawer != null ? cashDrawer.getReportTime() : new Date();
        map.put("status", transactions == null || transactions.isEmpty() ? ConsoleMessages.getString("CloudReportService.20") : null);
        String strDate = CommonCloudReportService.makeBoldString(ConsoleMessages.getString("From")) + DateUtil.formatDateWithBrowserTimeOffset((Date)cashDrawer.getStartTime()) + " " + CommonCloudReportService.makeBoldString(ConsoleMessages.getString(ConsoleMessages.getString("CloudReportService.16"))) + DateUtil.formatDateWithBrowserTimeOffset((Date)(storeCloseTime != null ? storeCloseTime : new Date()));
        map.put("startDate", strDate);
        map.put("status", transactions == null || transactions.isEmpty() ? ConsoleMessages.getString("CloudReportService.23") : null);
        JasperReport masterReport = ReportUtil.getReport((String)"server_details_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return jasperPrint;
    }

    public static JasperPrint getCloudStoreSessionSummaryReportPrint(CashDrawer cashDrawer, StoreSession storeSession) throws JRException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Outlet outlet = storeSession.getOutlet();
        List stores = StoreDAO.getInstance().findAll();
        if (stores != null) {
            for (int i = 0; i < stores.size(); ++i) {
                Store store = (Store)stores.get(0);
                parameters.put("headerLine0", store.getName());
            }
        }
        if (outlet != null) {
            parameters.put("headerLine1", outlet.getName());
        }
        parameters.put("reportTitle", "End of day sales report");
        parameters.put("IS_IGNORE_PAGINATION", true);
        parameters.put("startTime", ConsoleMessages.getString("CloudReportService.24") + CommonCloudReportService.format(storeSession.getOpenTime()));
        parameters.put("user", ConsoleMessages.getString("CloudReportService.26") + storeSession.getOpenedByUserId());
        if (storeSession.getCloseTime() != null) {
            parameters.put("date", ConsoleMessages.getString("CloudReportService.27") + CommonCloudReportService.format(storeSession.getCloseTime()));
            parameters.put("reportUser", ConsoleMessages.getString("CloudReportService.28") + storeSession.getClosedByUserId());
        }
        parameters.put("totalVoid", cashDrawer.getTotalVoid());
        parameters.put("declaredTips", cashDrawer.getDeclaredTips());
        JasperReport subReportCurrencyBalance = ReportUtil.getReport((String)"drawer-currency-balance");
        JasperReport subReport = ReportUtil.getReport((String)"drawer-pull-void-veport");
        parameters.put("currencyBalanceReport", subReportCurrencyBalance);
        parameters.put("subreportParameter", subReport);
        JasperReport mainReport = ReportUtil.getReport((String)"store-session-summary-report");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(Arrays.asList(cashDrawer));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)mainReport, parameters, (JRDataSource)dataSource);
        jasperPrint.setName("StoreSessionSummaryReport");
        return jasperPrint;
    }

    public static JasperPrint getStoreSessionReportPrint(Outlet outlet, Date from, Date to) throws JRException {
        List sessions = StoreSessionDAO.getInstance().findSessions(outlet, from, to);
        return CommonCloudReportService.getStoreSessionReportPrint(outlet, from, to, sessions);
    }

    public static JasperPrint getStoreSessionReportPrint(Outlet outlet, Date from, Date to, List<StoreSession> sessions) throws JRException {
        StoreSessionReportModel reportModel = new StoreSessionReportModel();
        reportModel.setItems(sessions);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("receiptType", ConsoleMessages.getString("CloudReportService.31"));
        map.put("outletName", ConsoleMessages.getString("CloudReportService.32") + (outlet == null ? ConsoleMessages.getString("CloudReportService.33") : outlet));
        map.put("reportDate", ConsoleMessages.getString("CloudReportService.34") + DateUtil.formatDateWithBrowserTimeOffset((Date)from) + ConsoleMessages.getString("CloudReportService.35") + DateUtil.formatDateWithBrowserTimeOffset((Date)to));
        map.put("status", sessions == null || sessions.isEmpty() ? ConsoleMessages.getString("CloudReportService.36") : null);
        JasperReport masterReport = ReportUtil.getReport((String)"store_session_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return jasperPrint;
    }

    public static JasperPrint getTransactionReport(Outlet outlet, Date from, Date to, List<PosTransaction> transactions) throws JRException {
        TransactionReportModel reportModel = new TransactionReportModel();
        reportModel.setItems(transactions);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportHeader(map, null, (Date)from, (Date)to, null);
        Store store = StoreDAO.getRestaurant();
        ReportUtil.populatePatternExpression(map, (Store)store);
        CommonCloudReportService.populateTransactionReportParams(map, outlet);
        map.put("receiptType", ConsoleMessages.getString("TransactionReportView.3"));
        map.put("serverName", ConsoleMessages.getString("CloudReportService.38") + (outlet == null ? ConsoleMessages.getString("CloudReportService.39") : outlet));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateUtil.getStoreDateFormat() + " hh:mm a");
        map.put("reportTime", POSConstants.REPORT_TIME + DateUtil.formatDateWithBrowserTimeOffset((Date)new Date(), (SimpleDateFormat)simpleDateFormat));
        map.put("startDate", ConsoleMessages.getString("CloudReportService.40") + DateUtil.formatReportDate((Date)from));
        map.put("toDate", POSConstants.TO + ": " + DateUtil.formatReportDate((Date)to));
        map.put("status", transactions == null || transactions.isEmpty() ? ConsoleMessages.getString("CloudReportService.42") : null);
        JasperReport masterReport = ReportUtil.getReport((String)"transaction_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return jasperPrint;
    }

    private static void populateTransactionReportParams(HashMap<String, Object> map, Outlet outlet) {
        map.put("colDate", POSConstants.TIME);
        map.put("colTrans", ConsoleMessages.getString("CloudReportService.43") + "#");
        map.put("colOwner", ConsoleMessages.getString("CloudReportService.46"));
        map.put("colPaymentType", ConsoleMessages.getString("CloudReportService.49"));
        if (outlet != null) {
            Currency mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            map.put("colTotal", ConsoleMessages.getString("CloudReportService.51") + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
        } else {
            map.put("colTotal", ConsoleMessages.getString("CloudReportService.54"));
        }
        map.put("lblGrandTotal", Messages.getString((String)"GRAND_TOTAL"));
    }

    public static SalesReportModel prepareItemSalesReportModel(List<TicketItem> ticketItems) {
        SalesReportModel itemReportModel = new SalesReportModel();
        if (ticketItems != null && ticketItems.size() > 0) {
            LinkedHashMap<String, ReportItem> itemMap = new LinkedHashMap<String, ReportItem>();
            String key = null;
            for (TicketItem ticketItem : ticketItems) {
                String menuItemId = ticketItem.getMenuItemId();
                key = (menuItemId == null ? ticketItem.getName() : menuItemId) + "-" + ticketItem.getUnitPrice() + "-" + ticketItem.getUnitName();
                ReportItem reportItem = (ReportItem)((HashMap)itemMap).get(key);
                if (reportItem == null) {
                    reportItem = new ReportItem();
                    reportItem.setId(key);
                    reportItem.setPrice(ticketItem.getUnitPrice().doubleValue());
                    String unitId = ticketItem.getUnitName();
                    InventoryUnit inventoryUnit = DataProvider.get().getInventoryUnitById(unitId);
                    if (inventoryUnit != null) {
                        reportItem.setUnit(inventoryUnit.getName());
                    } else {
                        reportItem.setUnit("");
                    }
                    reportItem.setCost(ticketItem.getUnitCost().doubleValue());
                    reportItem.setName(ticketItem.getName());
                    reportItem.setTaxRate(ticketItem.getTotalTaxRate());
                    reportItem.setGroupName(ticketItem.getGroupName());
                    reportItem.setBarcode(menuItemId);
                    reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice().doubleValue());
                    Ticket ticket = ticketItem.getTicket();
                    if (ticket != null) {
                        reportItem.setOutletId(ticket.getOutletId());
                    }
                    itemMap.put(key, reportItem);
                }
                reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
                reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedTotalWithoutModifiers());
                reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscountWithoutModifiers());
                reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTaxWithoutModifiers());
                reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
                double adjustedAmount = ticketItem.isTaxIncluded() != false ? ticketItem.getAdjustedTotalWithoutModifiers() - ticketItem.getAdjustedTaxWithoutModifiers() : ticketItem.getAdjustedSubtotalWithoutModifiers();
                reportItem.setNetTotal(reportItem.getNetTotal() + adjustedAmount);
            }
            itemReportModel.setItems(new ArrayList(((HashMap)itemMap).values()));
        }
        return itemReportModel;
    }

    public static SalesReportModel prepareItemModifierSalesReportModel(List<TicketItemModifier> ticketItemModifiers) {
        SalesReportModel modifierReportModel = new SalesReportModel();
        if (ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
            LinkedHashMap<String, ReportItem> modifierMap = new LinkedHashMap<String, ReportItem>();
            String key = null;
            for (TicketItemModifier modifier : ticketItemModifiers) {
                String itemId = modifier.getItemId();
                key = (itemId == null ? modifier.getName() : itemId) + "-" + modifier.getModifierType() + "-" + modifier.getUnitPrice();
                ReportItem modifierReportItem = (ReportItem)((HashMap)modifierMap).get(key);
                if (modifierReportItem == null) {
                    modifierReportItem = new ReportItem();
                    modifierReportItem.setId(itemId);
                    modifierReportItem.setPrice(modifier.getUnitPrice().doubleValue());
                    modifierReportItem.setName(modifier.getName());
                    modifierReportItem.setTaxRate(modifier.getTotalTaxRate());
                    modifierReportItem.setAdjustedPrice(modifier.getAdjustedUnitPrice().doubleValue());
                    modifierReportItem.setServiceCharge(modifier.getServiceCharge().doubleValue());
                    Ticket ticket = modifier.getTicketItem().getTicket();
                    if (ticket != null) {
                        modifierReportItem.setOutletId(ticket.getOutletId());
                    }
                    modifierMap.put(key, modifierReportItem);
                }
                modifierReportItem.setQuantity(modifierReportItem.getQuantity() + modifier.getItemQuantity() * modifier.getTicketItemQuantity());
                modifierReportItem.setDiscount(modifierReportItem.getDiscount() + modifier.getAdjustedDiscount());
                modifierReportItem.setServiceCharge(modifierReportItem.getServiceCharge() + modifier.getServiceCharge());
                modifierReportItem.setGrossTotal(modifierReportItem.getGrossTotal() + modifier.getAdjustedTotal());
                modifierReportItem.setTaxTotal(modifierReportItem.getTaxTotal() + modifier.getAdjustedTax());
                double adjustedAmount = modifier.isTaxIncluded() != false ? modifier.getAdjustedSubtotal() - modifier.getAdjustedTax() : modifier.getAdjustedSubtotal();
                modifierReportItem.setNetTotal(modifierReportItem.getNetTotal() + adjustedAmount);
            }
            modifierReportModel.setItems(new ArrayList(((HashMap)modifierMap).values()));
        }
        return modifierReportModel;
    }

    public static JasperPrint getItemwisePurchaseReportPrint(Date startDate, Date endDate, Boolean isInventory, Boolean isGroupEnable, PurchaseOrderItemReportModel itemReportModel, PurchaseOrderItemReportModel modifierReportModel, Boolean isShowModifier, Outlet outlet, boolean isShowOnlineTicket) throws JRException {
        String reportTitle;
        JasperReport itemReport = ReportUtil.getReport((String)"byzlogics_itemwise_purchase_sub_report");
        JasperReport modifierReport = ReportUtil.getReport((String)"byzlogics_itemwise_purchase_sub_report");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportHeader(map, (Outlet)outlet, (Date)startDate, (Date)endDate, null, (boolean)false, (boolean)true);
        if (outlet != null) {
            Currency mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            map.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + " (" + mainCurrency.getSymbol() + ")");
        }
        String string = reportTitle = isShowOnlineTicket ? "Online itemwise purchase report" : "Itemwise purchase report";
        if (isInventory != null) {
            reportTitle = isInventory != false ? reportTitle + Messages.getString((String)"ItemwiseSalesReportService.0") : reportTitle + Messages.getString((String)"ItemwiseSalesReportService.1");
        }
        map.put("reportTitle", reportTitle);
        map.put("itemDataSource", new JRTableModelDataSource((TableModel)itemReportModel));
        map.put("modifierDataSource", new JRTableModelDataSource((TableModel)modifierReportModel));
        map.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("itemReport", itemReport);
        map.put("isShowGroup", isGroupEnable);
        map.put("isShowModifier", isShowModifier);
        map.put("modifierReport", modifierReport);
        map.put("colId", ReportUtil.reportLabelWithBoldTag((String)POSConstants.ID));
        map.put("colDate", ReportUtil.reportLabelWithBoldTag((String)POSConstants.DATE));
        map.put("colName", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NAME));
        map.put("colQty", ReportUtil.reportLabelWithBoldTag((String)POSConstants.QTY));
        map.put("colUnit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT));
        map.put("colSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT_PRICE));
        map.put("colDiscount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.DISCOUNT));
        map.put("colCost", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST));
        map.put("colCostPer", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST_PERCENTAGE));
        map.put("colNetTotal", ReportUtil.reportLabelWithBoldTag((String)"Total cost"));
        map.put("colTax", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TAX));
        map.put("colSC", ReportUtil.reportLabelWithBoldTag((String)POSConstants.S_C));
        map.put("colGrossT", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TOTAL));
        map.put("groupTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROUP_TOTAL));
        map.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.MODIFIER_TOTAL + ": ")));
        map.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_SALES));
        map.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"SalesReportService.0")));
        map.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.RETURN));
        map.put("lblProfit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_PROFIT));
        map.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.PROFIT + " %")));
        map.put("colRFCommission", ReportUtil.reportLabelWithBoldTag((String)"Commission"));
        map.put("colLabDoctorFee", ReportUtil.reportLabelWithBoldTag((String)"Lab dr fee"));
        map.put("itemSection", POSConstants.ITEMS);
        if (modifierReportModel != null && modifierReportModel.getItems().size() > 0) {
            map.put("modifierSection", Messages.getString((String)"SalesReportService.5"));
        }
        CommonCloudReportService.populateGrandTotal(map, itemReportModel, modifierReportModel);
        JasperReport masterReport = ReportUtil.getReport((String)"itemwise_purchase_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private static void populateGrandTotal(HashMap<String, Object> map, PurchaseOrderItemReportModel itemReportModel, PurchaseOrderItemReportModel modifierReportModel) {
    }

    public static JasperPrint getShiftwiseSalesReportPrint(Date fromDate, Date toDate, UserType userType, Outlet outlet) throws JRException {
        SalesSummaryDAO dao = new SalesSummaryDAO();
        List datas = dao.findSalesAnalysis(fromDate, toDate, userType, outlet);
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        properties.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        properties.put("reportTime", DateUtil.formatFullDateAndTimeAsString((Date)new Date()));
        properties.put("fromDate", DateUtil.formatFullDateAsString((Date)fromDate));
        properties.put("toDate", DateUtil.formatFullDateAsString((Date)toDate));
        if (userType == null) {
            properties.put("reportType", POSConstants.SYSTEM_TOTAL);
        } else {
            properties.put("reportType", userType.getName());
        }
        properties.put("terminal", outlet == null ? POSConstants.ALL : outlet.getName());
        JasperReport report = ReportUtil.getReport((String)"shiftwise_sales_summary_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)new ShiftwiseSalesSummaryReportModel(datas)));
        return print;
    }

    public static JasperPrint getSalesExceptionReportPrint(Date fromDate, Date toDate, Outlet outlet) throws Exception {
        fromDate = DateUtil.startOfDay((Date)fromDate);
        toDate = DateUtil.endOfDay((Date)toDate);
        ReportService reportService = new ReportService();
        SalesExceptionReport report = reportService.getSalesExceptionReport(fromDate, toDate);
        JasperReport voidReport = ReportUtil.getReport((String)"sales_summary_exception_voids");
        JasperReport refundReport = ReportUtil.getReport((String)"sales_summary_exception_refund_trns");
        JasperReport discountReport = ReportUtil.getReport((String)"sales_summary_exception_discounts");
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        map.put("fromDate", DateUtil.formatDateWithBrowserTimeOffsetWithoutSec((Date)fromDate));
        map.put("toDate", DateUtil.formatDateWithBrowserTimeOffsetWithoutSec((Date)toDate));
        map.put("reportTime", DateUtil.formatDateWithBrowserTimeOffset((Date)new Date()));
        map.put("voidReport", (String)voidReport);
        map.put("voidReportDataSource", (String)new JRTableModelDataSource((TableModel)report.getVoidTableModel()));
        map.put("refundReport", (String)refundReport);
        map.put("refundReportDataSource", (String)new JRTableModelDataSource((TableModel)report.getRefundTableModel()));
        map.put("discountReport", (String)discountReport);
        map.put("discountReportDataSource", (String)new JRTableModelDataSource((TableModel)report.getDiscountTableModel()));
        JasperReport jasperReport = ReportUtil.getReport((String)"sales_exception_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    public static JasperPrint getMenuUsageReportprint(Date fromDate, Date toDate, Outlet outlet) throws Exception {
        fromDate = DateUtil.startOfDay((Date)fromDate);
        toDate = DateUtil.endOfDay((Date)toDate);
        ReportService reportService = new ReportService();
        MenuUsageReport report = reportService.getMenuUsageReport(fromDate, toDate);
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        map.put("reportTitle", "MENU USAGE REPORT");
        map.put("fromDate", ReportService.formatShortDate((Date)fromDate));
        map.put("toDate", ReportService.formatShortDate((Date)toDate));
        map.put("reportTime", ReportService.formatFullDate((Date)new Date()));
        JasperReport jasperReport = ReportUtil.getReport((String)"menu_usage_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)report.getTableModel()));
        return jasperPrint;
    }

    public static JasperPrint getJournalReportPrint(Date fromDate, Date toDate, Outlet outlet) throws Exception {
        fromDate = DateUtil.startOfDay((Date)fromDate);
        toDate = DateUtil.endOfDay((Date)toDate);
        ReportService reportService = new ReportService();
        JournalReportModel report = reportService.getJournalReport(fromDate, toDate);
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        map.put("reportTitle", ConsoleMessages.getString("JournalReportView.0"));
        map.put("fromDate", ReportService.formatShortDate((Date)fromDate));
        map.put("toDate", ReportService.formatShortDate((Date)toDate));
        map.put("reportTime", ReportService.formatFullDate((Date)new Date()));
        JasperReport jasperReport = ReportUtil.getReport((String)"journal_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)report.getTableModel()));
        return jasperPrint;
    }

    public static synchronized JasperPrint getVoidReportPrint(VoidItemReportModel voidItemReportModel, Date fromDate, Date toDate, Outlet outlet) throws Exception {
        JasperReport itemReport = ReportUtil.getReport((String)"deleteItem_sub_report");
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        ReportUtil.populateReportHeader(map, (Outlet)outlet, (Date)fromDate, (Date)toDate, null, (boolean)false, (boolean)true);
        ReportUtil.populateReportFooter(map);
        CommonCloudReportService.populateReportParams(map);
        map.put("reportTitle", "Return report");
        map.put("itemDataSource", (String)new JRTableModelDataSource((TableModel)voidItemReportModel));
        map.put("itemSection", "Return items");
        map.put("itemReport", (String)itemReport);
        JasperReport masterReport = ReportUtil.getReport((String)"void_item_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private static void populateOpenTicketSummaryReportParams(HashMap map) {
        map.put("colId", POSConstants.ID);
        map.put("colCreated", POSConstants.CREATED);
        map.put("colOrderT", POSConstants.ORDER_TYPE);
        map.put("colOwner", Messages.getString((String)"GiftCardSummaryReportView.3"));
        map.put("colTotal", POSConstants.TOTAL);
        map.put("colDue", POSConstants.DUE);
        map.put("colGTotal", POSConstants.GRAND_TOTAL);
    }

    private static void populateReportParams(HashMap map) {
        map.put("VSRDate", "Return date");
        map.put("VSRTicketId", "Invoice id");
        map.put("VSRItem", POSConstants.ITEM);
        map.put("VSRQty", POSConstants.QTY);
        map.put("VSRReason", Messages.getString((String)"VSRReason"));
        map.put("VSRWasted", Messages.getString((String)"VSRWasted"));
        map.put("VSRDeletedBy", "Returned by");
        map.put("VSRAmount", POSConstants.AMOUNT);
        map.put("VSRGrandT", POSConstants.GRAND_TOTAL);
    }

    private static void populateHourlySalesReportParams(HashMap<String, Object> properties) {
        properties.put("SWRTitle", "");
        properties.put("SRGTotal", POSConstants.GRAND_TOTAL);
        properties.put("SRPeriod", Messages.getString((String)"PERIOD"));
        properties.put("SRChecks", Messages.getString((String)"CHECKS"));
        properties.put("SRGuests", Messages.getString((String)"GUESTS"));
        properties.put("SRSales", POSConstants.SALES);
        properties.put("SRMHour", Messages.getString((String)"ManHour"));
        properties.put("SRSMH", Messages.getString((String)"SManHour"));
        properties.put("SRGMH", Messages.getString((String)"GManHour"));
        properties.put("SRCMH", Messages.getString((String)"CManHour"));
        properties.put("SRLCost", Messages.getString((String)"LaborCost"));
        properties.put("SRLCostP", Messages.getString((String)"LaborCostP"));
    }

    public static synchronized VoidItemReportModel createVoidTicketReportModel(Date fromDate, Date toDate, Outlet outlet) {
        Date date1 = DateUtils.startOfDay((Date)fromDate);
        Date date2 = DateUtils.endOfDay((Date)toDate);
        List voidTickets = TicketDAO.getInstance().findVoidTicketByDate(date1, date2, outlet);
        ArrayList<DeletedItem> deletedTickets = new ArrayList<DeletedItem>();
        for (Ticket voidTicket : voidTickets) {
            DeletedItem deletedItem = new DeletedItem();
            deletedItem.setId(voidTicket.getId());
            deletedItem.setVoidDate(voidTicket.getClosingDate());
            deletedItem.setTicketId(voidTicket.getId());
            List voidItemList = VoidItemDAO.getInstance().getVoidItems(voidTicket.getId());
            double amount = 0.0;
            double quantity = 0.0;
            if (voidItemList != null) {
                for (VoidItem item : voidItemList) {
                    amount += item.getTotalPrice().doubleValue();
                    quantity += item.getQuantity().doubleValue();
                }
                deletedItem.setQuantity(quantity);
                deletedItem.setTotal(amount);
            }
            deletedItem.setVoidReason(voidTicket.getVoidReason());
            deletedItem.setOwner(voidTicket.getOwner());
            deletedItem.setVoidUserName(voidTicket.getVoidedBy().getFullName());
            deletedTickets.add(deletedItem);
        }
        VoidItemReportModel voidTicketReportModel = new VoidItemReportModel();
        voidTicketReportModel.setItems(deletedTickets);
        return voidTicketReportModel;
    }

    public static JasperPrint getCreditCardReportPrint(Outlet outlet, Date fromDate, Date toDate, CardReportModel ticketReportModel, boolean isShowOnlineTicket) throws Exception {
        int saleCount = 0;
        double totalSales = 0.0;
        double totalTips = 0.0;
        if (ticketReportModel.getRows() != null) {
            for (PosTransaction transaction : ticketReportModel.getRows()) {
                ++saleCount;
                totalSales = transaction instanceof RefundTransaction ? (totalSales += -1.0 * transaction.getAmount()) : (totalSales += transaction.getAmount().doubleValue());
                totalTips += transaction.getTipsAmount().doubleValue();
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        ReportUtil.populateReportTime(map, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(map);
        Currency mainCurrency = null;
        if (outlet != null) {
            mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            map.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
            map.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
        }
        CommonCloudReportService.populateCreditCardReportReportParams(map, mainCurrency);
        map.put("reportTitle", isShowOnlineTicket ? ConsoleMessages.getString("CloudReportService.58") : "Card and custom payment received report");
        map.put("saleCount", String.valueOf(saleCount));
        map.put("totalSales", NumberUtil.formatNumber((Double)(totalSales - totalTips)));
        map.put("totalTips", NumberUtil.formatNumber((Double)totalTips));
        map.put("total", NumberUtil.formatNumber((Double)totalSales));
        map.put("totalCount", ReportUtil.reportLabelWithBoldTag((String)ConsoleMessages.getString("CreditCardReportView.10")) + saleCount);
        JasperReport jasperReport = ReportUtil.getReport((String)"credit-card-report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)ticketReportModel));
        return jasperPrint;
    }

    private static void populateCreditCardReportReportParams(HashMap map, Currency currency) {
        map.put("colTicketNo", ConsoleMessages.getString("CloudReportService.77"));
        map.put("colPaymentType", Messages.getString((String)"SettleTicketDialog.9"));
        map.put("colCardType", Messages.getString((String)"TransactionListView.3"));
        map.put("colMember", Messages.getString((String)"CUSTOMER"));
        map.put("colMemberId", Messages.getString((String)"CUSTOMER") + " ID");
        map.put("colDate", POSConstants.DATE);
        map.put("colServer", POSConstants.SERVER);
        map.put("colAuthC", Messages.getString((String)"AuthCode"));
        if (currency != null) {
            map.put("tips", ConsoleMessages.getString("CreditCardReportView.2") + CommonUIUtil.getTextWithBracket(currency.getSymbol()));
            map.put("totalHeader", ConsoleMessages.getString("CreditCardReportView.6") + CommonUIUtil.getTextWithBracket(currency.getSymbol()));
        } else {
            map.put("tips", ConsoleMessages.getString("CreditCardReportView.2"));
            map.put("totalHeader", ConsoleMessages.getString("CreditCardReportView.6"));
        }
        map.put("rowTSCount", Messages.getString((String)"TSCount"));
        map.put("rowTSales", Messages.getString((String)"TotalSales"));
        map.put("rowTTips", Messages.getString((String)"TotalTips"));
        map.put("rowTotal", "Grand total:");
    }

    public static JasperPrint getOpenTicketSummaryReportPrint(UserType userType, TicketReportModel reportModel, Date startTime, Date endTime, Outlet outlet, boolean isShowOnlineTicket) throws JRException {
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        String name = userType == null ? POSConstants.ALL : userType.getName();
        ReportUtil.populateReportHeader(map, (Outlet)outlet, (Date)startTime, (Date)endTime, (String)name);
        ReportUtil.populateReportFooter(map);
        CommonCloudReportService.populateOpenTicketSummaryReportParams(map);
        if (outlet != null) {
            Currency mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            map.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + " (" + mainCurrency.getSymbol() + ")");
        }
        map.put("orderType", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.ORDER_TYPE + ":")) + " " + POSConstants.ALL);
        map.put("reportTitle", isShowOnlineTicket ? ConsoleMessages.getString("CloudReportService.59") : ConsoleMessages.getString("OpenTicketSummaryReport.0"));
        map.put("grandTotal", reportModel.getGrandTotalAsString());
        map.put("totalDue", reportModel.getTotalDueAsString());
        JasperReport masterReport = ReportUtil.getReport((String)"open_ticket_summary_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    public static JasperPrint getPayrollSummaryReportPrint(Date fromDate, Date toDate, User user, Outlet outlet) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
        List findPayroll = dao.findPayroll(fromDate, toDate, user, outlet);
        JasperReport report = ReportUtil.getReport((String)"PayrollReport");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        properties.put("fromDate", DateUtil.formatFullDateAsString((Date)fromDate));
        properties.put("toDate", DateUtil.formatFullDateAsString((Date)toDate));
        properties.put("reportDate", DateUtil.formatFullDateAsString((Date)new Date()));
        properties.put("rate", ConsoleMessages.getString("CloudReportService.1") + CurrencyUtil.getCurrencySymbol() + ")");
        properties.put("payment", ConsoleMessages.getString("CloudReportService.3") + CurrencyUtil.getCurrencySymbolWithBracket());
        PayrollReportModel reportModel = new PayrollReportModel();
        reportModel.setRows(findPayroll);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    public static JasperPrint getWeeklyPayrollSummaryReportPrint(DayOfWeek firstDay, Date fromDate, Date toDate, User user, Outlet outlet) throws Exception {
        int firstDayOfWeek = firstDay.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
        List findPayroll = dao.findWeeklyPayroll(fromDate, toDate, user, outlet, firstDayOfWeek);
        JasperReport report = ReportUtil.getReport((String)"WeeklyPayrollReport");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        properties.put("fromDate", DateUtil.formatFullDateAsString((Date)fromDate));
        properties.put("toDate", DateUtil.formatFullDateAsString((Date)toDate));
        properties.put("reportDate", DateUtil.formatDateAsLocale((Date)new Date()));
        WeeklyPayrollReportModel reportModel = new WeeklyPayrollReportModel();
        reportModel.setRows(findPayroll);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    public static JasperPrint getServerProductivityReportPrint(Date fromDate, Date toDate, Outlet outlet) throws Exception {
        fromDate = DateUtil.startOfDay((Date)fromDate);
        toDate = DateUtil.endOfDay((Date)toDate);
        ReportService reportService = new ReportService();
        ServerProductivityReport report = reportService.getServerProductivityReport(fromDate, toDate, null);
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, (Outlet)outlet);
        map.put("reportTitle", ConsoleMessages.getString("ServerProductivityReportView.0"));
        map.put("fromDate", ReportService.formatShortDate((Date)fromDate));
        map.put("toDate", ReportService.formatShortDate((Date)toDate));
        map.put("reportTime", POSConstants.REPORT_TIME + ReportService.formatFullDate((Date)new Date()));
        JasperReport jasperReport = ReportUtil.getReport((String)"server_productivity_report");
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)report.getTableModel()));
        return jasperPrint;
    }

    public static JasperPrint getEmployeeAttendanceReportPrint(Date fromDate, Date toDate, User user, Outlet outlet) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
        List attendanceList = dao.findAttendance(fromDate, toDate, user);
        JasperReport report = ReportUtil.getReport((String)"EmployeeAttendanceReport");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        properties.put("fromDate", DateUtil.formatFullDateAsString((Date)fromDate));
        properties.put("toDate", DateUtil.formatFullDateAsString((Date)toDate));
        properties.put("reportDate", DateUtil.formatFullDateAndTimeAsString((Date)new Date()));
        AttendanceReportModel reportModel = new AttendanceReportModel();
        reportModel.setRows(attendanceList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    public static JasperPrint getPaymentReceivedReportPrint(Date fromDate, Date toDate, User user, Outlet outlet, List<PaymentReceivedReportData> transactionList, boolean isShowDueCollection) throws Exception {
        JasperReport report = ReportUtil.getReport((String)(isShowDueCollection ? "due_payment_receive_report" : "payment_receive_report"));
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        Currency mainCurrency = null;
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
            mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            if (mainCurrency != null) {
                properties.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
                properties.put("totalAmount", ConsoleMessages.getString("CloudReportService.111") + "(" + mainCurrency.getSymbol() + ")");
            }
        }
        CommonCloudReportService.populateReportParamsForPaymentReceivedReport(properties, mainCurrency);
        properties.put("reportTitle", isShowDueCollection ? "Due collection report" : "Payment received detail report");
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        properties.put("totalMsg", ConsoleMessages.getString("CloudReportService.109"));
        PaymentReceivedReportModel2 reportModel = new PaymentReceivedReportModel2();
        reportModel.setRows(transactionList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    public static JasperPrint getPaymentDetailedReportPrint(Date fromDate, Date toDate, Outlet outlet, SalesDetailedReport salesDetailedReport, boolean isShowOnlineTicket) throws Exception {
        JasperReport creditCardReport = ReportUtil.getReport((String)"sales_summary_balance_detailed_2");
        JasperReport customPaymentReport = ReportUtil.getReport((String)"sales_summary_balance_detailed_3");
        JasperReport returnPaymentReport = ReportUtil.getReport((String)"sales_summary_balance_detailed_4");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        Currency mainCurrency = null;
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
            mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            if (mainCurrency != null) {
                properties.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
            }
        }
        CommonCloudReportService.populateReportParamsForPaymentDetailedReport(properties, mainCurrency);
        properties.put("reportTitle", isShowOnlineTicket ? ConsoleMessages.getString("CloudReportService.61") : "Payment received detail report");
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        properties.put("totalMsg", ConsoleMessages.getString("CloudReportService.109"));
        properties.put("totalAmount", ConsoleMessages.getString("CloudReportService.111") + "(" + CurrencyUtil.getCurrencySymbol() + ")");
        properties.put("creditCardReport", creditCardReport);
        SalesDetailedReport.CreditCardDataTableModel creditCardDataTableModel = salesDetailedReport.getCreditCardDataTableModel();
        properties.put("creditCardReportDatasource", new JRTableModelDataSource((TableModel)creditCardDataTableModel));
        properties.put("customPaymentReport", customPaymentReport);
        SalesDetailedReport.OtherPaymentDataTableModel otherPaymentDataTableModel = salesDetailedReport.getOtherPaymentDataTableModel();
        properties.put("customPaymentReportDatasource", new JRTableModelDataSource((TableModel)otherPaymentDataTableModel));
        properties.put("returnPaymentReport", returnPaymentReport);
        SalesDetailedReport.RefundPaymentDataTableModel refundPaymentDataTableModel = salesDetailedReport.getRefundPaymentDataTableModel();
        properties.put("returnPaymentReportDatasource", new JRTableModelDataSource((TableModel)refundPaymentDataTableModel));
        double totalSalesAmount = creditCardDataTableModel.getGrandTotal() + otherPaymentDataTableModel.getGrandTotal();
        properties.put("colTotalAmount", ConsoleMessages.getString("CreditCardReportView.11"));
        properties.put("totalSales", totalSalesAmount);
        properties.put("totalCount", creditCardDataTableModel.getTotalCount() + otherPaymentDataTableModel.getTotalCount() + refundPaymentDataTableModel.getTotalCount());
        properties.put("grandTotal", totalSalesAmount - refundPaymentDataTableModel.getGrandTotal());
        JasperReport jasperReport = ReportUtil.getReport((String)"sales_detail_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, properties, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private static void populateReportParamsForPaymentReceivedReport(HashMap properties, Currency currency) {
        properties.put("colRefType", ConsoleMessages.getString("CloudReportService.142"));
        properties.put("colReferrer", ConsoleMessages.getString("CloudReportService.143"));
        properties.put("colReferrerId", "Referral ID");
        properties.put("totalMsg", Messages.getString((String)"PaymentReceivedReportView.13"));
        if (currency != null) {
            properties.put("totalAmount", Messages.getString((String)"PaymentReceivedReportView.15") + CommonUIUtil.getTextWithBracket(currency.getSymbol()));
        } else {
            properties.put("totalAmount", Messages.getString((String)"PaymentReceivedReportView.15"));
        }
        properties.put("colUser", "Received by");
        properties.put("colOrderDate", ConsoleMessages.getString("CloudReportService.68"));
        properties.put("colTime", ConsoleMessages.getString("CloudReportService.69"));
        properties.put("colTrans", ConsoleMessages.getString("CloudReportService.1111"));
        properties.put("colPType", Messages.getString((String)"SettleTicketDialog.9"));
        properties.put("colTicket", ConsoleMessages.getString("CloudReportService.71"));
        properties.put("colGrandTotal", Messages.getString((String)"GRAND_TOTAL"));
    }

    private static void populateReportParamsForPaymentDetailedReport(HashMap map, Currency currency) {
        map.put("SDRTitle", "Payment received summary report");
        map.put("MRGCR", Messages.getString((String)"MRGCR"));
        map.put("MRGCC", Messages.getString((String)"MRGCC"));
        map.put("MRTCT", Messages.getString((String)"MRTCT"));
        map.put("MRTP", Messages.getString((String)"DrawerPullReportExplorer.26"));
        map.put("MRCount", Messages.getString((String)"MRCount"));
        map.put("MRAmount", Messages.getString((String)"MRAmount"));
        map.put("SRDPRTitle", Messages.getString((String)"SRDPRTitle"));
        map.put("SRDPRCount", POSConstants.COUNT);
        map.put("SRDPRIdeal", Messages.getString((String)"SRDPRIdeal"));
        map.put("SRDPRActual", Messages.getString((String)"SRDPRActual"));
        map.put("SRDPRVariant", Messages.getString((String)"SalesDetailReportView.2"));
        map.put("SRDPRTDP", Messages.getString((String)"SRDPRTDP"));
        map.put("SRCCardTitle", Messages.getString((String)"SalesDetailReportView.4"));
        map.put("SRCCard", Messages.getString((String)"SalesDetailReportView.6"));
        map.put("SRSCount", ConsoleMessages.getString("SalesCount"));
        map.put("SRSAmount", ConsoleMessages.getString("SalesAmount"));
        map.put("SRRCount", Messages.getString((String)"SRRefundCount"));
        map.put("SRRAmount", Messages.getString((String)"SRRefundAmount"));
        map.put("SRNAmount", Messages.getString((String)"SRNAmount"));
        if (currency != null) {
            map.put("SRNTips", Messages.getString((String)"TipsConfigurationView.14") + CommonUIUtil.getTextWithBracket(currency.getSymbol()));
        } else {
            map.put("SRNTips", Messages.getString((String)"TipsConfigurationView.14"));
        }
        map.put("SRCPaymentTitle", Messages.getString((String)"SalesDetailReportView.8"));
        map.put("SRCPaymentTitle", Messages.getString((String)"SalesDetailReportView.8"));
        map.put("SRCPayment", Messages.getString((String)"SalesDetailReportView.1"));
        map.put("SRTotal", POSConstants.TOTAL);
        map.put("SRCRefundPaymentTitle", Messages.getString((String)"SalesDetailReportView.0"));
        map.put("SRDPRTermenalName", Messages.getString((String)"SalesDetailReportView.3"));
        map.put("SRDPROpenTime", Messages.getString((String)"SalesDetailReportView.5"));
        map.put("SRTotalAmount", POSConstants.TOTAL);
    }

    public static JasperPrint getCustomerPaymentReceivedReportPrint(Date fromDate, Date toDate, Customer customer, Outlet outlet) throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        List transactionList = PosTransactionDAO.getInstance().findCustomerAccountTransactions(fromDate, toDate, customer.getId());
        JasperReport report = ReportUtil.getReport((String)"customer-payment-report");
        Terminal terminal = Application.getInstance().getTerminal();
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.115"));
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        properties.put("terminalName", terminal == null ? POSConstants.ALL : terminal.getName());
        properties.put("startDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("From")) + DateUtil.formatFullDateAsString((Date)fromDate));
        properties.put("endDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("To")) + DateUtil.formatFullDateAsString((Date)toDate));
        properties.put("tips", ConsoleMessages.getString("CloudReportService.120") + "(" + CurrencyUtil.getCurrencySymbol() + ")");
        properties.put("totalAmount", ConsoleMessages.getString("CloudReportService.124") + "(" + CurrencyUtil.getCurrencySymbol() + ")");
        CustomerPaymentReportModel reportModel = new CustomerPaymentReportModel();
        reportModel.setRows(transactionList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    public static JasperPrint getGiftCardSummaryReportPrint(Date fromDate, Date toDate, boolean isExpired, String sortOption, Outlet outlet) throws Exception {
        List giftCardList = GiftCardDAO.getInstance().findGiftCards(fromDate, toDate, isExpired, sortOption);
        JasperReport report = ReportUtil.getReport((String)"gift_card_summary_report");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.135"));
        properties.put("reportTime", ReportService.formatFullDate((Date)new Date()));
        GiftCardSummaryReportModel giftCardSummaryModel = new GiftCardSummaryReportModel(giftCardList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)giftCardSummaryModel));
        return print;
    }

    public static JasperPrint getDailyReportPrint(SessionSummaryReportModel dailySamurryReportModel, Date fromDate, Date toDate, User userType, Outlet outlet) throws Exception {
        JasperReport dailySummaryReport = ReportUtil.getReport((String)CLOUD_DAILY_SUMMARY_SUBREPORT);
        JasperReport report = ReportUtil.getReport((String)CLOUD_DAILY_SUMMARY_REPORT);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        CommonCloudReportService.populateSessionSummaryReportParams(properties);
        properties.put("reportTitle", POSConstants.SESSION_SUMMARY_REPORT);
        properties.put("reportTime", ConsoleMessages.getString("CloudReportService.4") + DateUtil.formatDateWithBrowserTimeOffset((Date)new Date()));
        properties.put("fromDay", ConsoleMessages.getString("From") + " " + ReportService.formatFullDate((Date)fromDate));
        properties.put("toDay", ConsoleMessages.getString("To") + " " + ReportService.formatFullDate((Date)toDate));
        String userTypeName = userType == null ? POSConstants.ALL : userType.getFullName();
        String termenalName = outlet == null ? POSConstants.ALL : outlet.getName();
        properties.put("type", POSConstants.EMPLOYEE + ": " + userTypeName);
        properties.put("cntr", POSConstants.TERMINAL + termenalName);
        properties.put("currency", CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("dailySummaryReport", dailySummaryReport);
        properties.put("dailySummaryReportDatasource", new JRTableModelDataSource((TableModel)dailySamurryReportModel));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private static void populateSessionSummaryReportParams(HashMap<String, Object> map) {
        map.put("colDate", POSConstants.DATE);
        map.put("colCash", POSConstants.CASH + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colOtherPayment", ConsoleMessages.getString("CloudReportService.9") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colRefund", POSConstants.REFUND_BUTTON_TEXT + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colVoids", ConsoleMessages.getString("CloudReportService.17") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colTotalSales", ConsoleMessages.getString("CloudReportService.84") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("lblGrandTotal", Messages.getString((String)"GRAND_TOTAL"));
    }

    public static JasperPrint createPrint(Ticket ticket) throws Exception {
        StringBuilder transactionsBreakdown;
        Currency currency;
        JasperReport report = ReportUtil.getReport((String)CLOUD_ORDER_INFO_REPORT);
        HashMap<String, String> properties = new HashMap<String, String>();
        String currencySymbol = "";
        if (StringUtils.isNotBlank((String)ticket.getOutletId()) && (currency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(ticket.getOutletId())) != null) {
            currencySymbol = currency.getSymbol();
        }
        Store store = StoreDAO.getRestaurant();
        double totalAmount = ticket.getTotalAmountWithTips();
        double tipAmount = 0.0;
        String TAX_STRING = POSConstants.RECEIPT_REPORT_TAX_LABEL;
        orderDateFormat = new SimpleDateFormat("dd MMM yy hh:mm a");
        String reportTime = DateUtil.formatDateWithBrowserTimeOffset((Date)new Date(), (SimpleDateFormat)orderDateFormat);
        ReportUtil.populateRestaurantProperties(properties, (Outlet)ticket.getOutlet());
        selectedTicket = TicketDAO.getInstance().loadFullTicket(ticket.getId(), ticket.getOutletId());
        if (selectedTicket.isVoided().booleanValue()) {
            properties.put("voidText", "***" + ConsoleMessages.getString("CloudReportService.123") + "***");
        }
        properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.2"));
        properties.put("reportTime", ConsoleMessages.getString("CloudReportService.4") + reportTime);
        properties.put("itemText", ticket.getTicketItems().size() > 1 ? ConsoleMessages.getString("CloudReportService.30") : ConsoleMessages.getString("CloudReportService.91"));
        properties.put("itemAmountText", ConsoleMessages.getString("CloudReportService.93"));
        properties.put("ticketId", ConsoleMessages.getString("CloudReportService.6") + ticket.getId());
        OrderType orderType = ticket.getOrderType();
        double serviceChargeRate = 0.0;
        if (orderType != null) {
            String orderTypeName = StringUtils.isEmpty((String)orderType.getName()) ? "" : "* " + orderType.getName() + " *";
            properties.put("orderType", orderTypeName);
            serviceChargeRate = ticket.getServiceCharge();
            if (serviceChargeRate != 0.0) {
                properties.put("serviceChargeText", POSConstants.SERVICE_CHARGE);
                properties.put("serviceChargeRate", currencySymbol + NumberUtil.formatNumber((Double)serviceChargeRate, (boolean)true));
            }
        }
        properties.put(ReceiptParam.CUSTOMER_NAME.getParamName(), "Customer name: " + ticket.getCustomerName());
        properties.put("customerEmail", ConsoleMessages.getString("CloudReportService.21") + ticket.getCustomerEmail());
        properties.put("customerMobileNo", ConsoleMessages.getString("CloudReportService.22") + ticket.getCustomerMobileNo());
        if (!StringUtils.isEmpty((String)ticket.getDeliveryAddress())) {
            String customerAddress = ticket.getDeliveryAddress().trim() + (!StringUtils.isEmpty((String)ticket.getDeliveryFlatNo()) ? ConsoleMessages.getString("CloudReportService.45") + ticket.getDeliveryFlatNo() : "") + (!StringUtils.isEmpty((String)ticket.getDeliveryZipCode()) ? ConsoleMessages.getString("CloudReportService.47") + ticket.getDeliveryZipCode() : "");
            properties.put("customerAddress", ConsoleMessages.getString("CloudReportService.25") + customerAddress);
        }
        if (StringUtils.isNotBlank((String)ticket.getExtraDeliveryInfo())) {
            properties.put("extraInstructions", ConsoleMessages.getString("CloudReportService.50") + ticket.getExtraDeliveryInfo());
        }
        if (StringUtils.isNotBlank((String)ticket.getVoidReason())) {
            properties.put("failOrCancelReason", ConsoleMessages.getString("CloudReportService.53") + ticket.getVoidReason());
        }
        if (StringUtils.isNotBlank((String)ticket.getProperty("delivery_failed_reason"))) {
            properties.put("failOrCancelReason", ConsoleMessages.getString("CloudReportService.56") + ticket.getProperty("delivery_failed_reason"));
        }
        if (ticket.getDeliveryDate() != null) {
            String deliveryDate = DateUtil.formatDateWithBrowserTimeOffset((Date)ticket.getDeliveryDate(), (SimpleDateFormat)orderDateFormat);
            properties.put("deliveryDate", ConsoleMessages.getString("CloudReportService.95") + deliveryDate);
        }
        if (ticket.getAssignedDriver() != null) {
            User driver = ticket.getAssignedDriver();
            properties.put(ReceiptParam.DRIVER_NAME.getParamName(), ConsoleMessages.getString("CloudReportService.29") + driver.getFullName());
            properties.put(ReceiptParam.DRIVER_ID.getParamName(), driver.getId());
        }
        if (ticket.getDeliveryCharge() > 0.0) {
            properties.put("deliveryChargeText", POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL);
            properties.put("deliveryCharge", selectedTicket.isVoided() != false ? currencySymbol + "0.00" : currencySymbol + NumberUtil.formatNumberAcceptNegative((Double)ticket.getDeliveryCharge()));
        }
        Double subtotalAmount = ticket.getSubtotalAmount();
        if (store.isShowSubtotalWithoutTax()) {
            subtotalAmount = ticket.getSubtotalWithoutIncludedTax();
        }
        properties.put("subTotalText", POSConstants.SUBTOTAL);
        properties.put("grandSubtotal", currencySymbol + NumberUtil.formatNumber((Double)subtotalAmount, (boolean)true));
        properties.put("totalText", POSConstants.TOTAL);
        if (ticket.getDiscountAmount() != 0.0) {
            properties.put("discountText", POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL);
            properties.put("discountAmount", selectedTicket.isVoided() != false ? currencySymbol + "0.00" : currencySymbol + NumberUtil.formatNumber((Double)ticket.getDiscountAmount(), (boolean)true));
        }
        String taxAmount = NumberUtil.formatNumber((Double)ticket.getTaxAmount(), (boolean)true);
        if (ticket.isTaxIncluded().booleanValue()) {
            TAX_STRING = TAX_STRING + "";
            if (!store.isShowSubtotalWithoutTax()) {
                taxAmount = " (" + taxAmount + ")";
            }
        }
        if (ticket.getTaxAmount() != 0.0) {
            properties.put("taxText", TAX_STRING);
            properties.put("taxAmount", selectedTicket.isVoided() != false ? currencySymbol + "0.00" : currencySymbol + taxAmount);
        }
        properties.put("netAmountText", POSConstants.RECEIPT_REPORT_TOTAL_LABEL);
        properties.put("netAmount", selectedTicket.isVoided() != false ? currencySymbol + "0.00" : currencySymbol + NumberUtil.formatNumber((Double)totalAmount, (boolean)true));
        if (ticket.getPaidAmount() > 0.0 && (transactionsBreakdown = ReceiptPrintService.getTransactionsBreakdown((Ticket)ticket, (String)currencySymbol)) != null) {
            properties.put("paidAmountText", transactionsBreakdown.toString());
        }
        properties.put("dueAmountText", POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL);
        String dueAmount = selectedTicket.isVoided() != false ? currencySymbol + "0.00" : (ticket.getDueAmount() < 0.0 ? "-" + currencySymbol + NumberUtil.formatNumber((Double)Math.abs(ticket.getDueAmount())) : currencySymbol + NumberUtil.formatNumber((Double)ticket.getDueAmount(), (boolean)true));
        properties.put("dueAmount", dueAmount);
        String storeName = DataProvider.get().getStore().getName();
        if (storeName != null) {
            properties.put("storeName", storeName);
        }
        Outlet outlet = ticket.getOutlet();
        properties.put("outletAddress1", outlet.getAddressLine1());
        if (outlet.getAddressLine2() != null) {
            properties.put("outletAddress2", outlet.getAddressLine2());
        }
        if (outlet.getAddressLine3() != null) {
            properties.put("outletAddress3", outlet.getAddressLine3());
        }
        properties.put("outletPhone", outlet.getTelephone());
        TicketDataSource dataSource = new TicketDataSource(ticket, false);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
        return print;
    }

    public static JasperPrint getSalesReportPrint(Date startDate, Date toDate, int reportType, Outlet outlet, SalesReportModel dailySalesReportModel, boolean isShowOnlineTicket) throws JRException {
        return CommonCloudReportService.getSalesReportPrint(startDate, toDate, reportType, outlet, dailySalesReportModel, isShowOnlineTicket, false);
    }

    public static JasperPrint getSalesReportPrint(Date startDate, Date toDate, int reportType, Outlet outlet, SalesReportModel dailySalesReportModel, boolean isShowOnlineTicket, boolean isByzlogicsReport) throws JRException {
        JasperReport dailySalesReport = ReportUtil.getReport((String)(isByzlogicsReport ? "byz_sales_sub_report" : "sales_sub_report"));
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportHeader(map, (Outlet)outlet, (Date)startDate, (Date)toDate, null, (reportType == 1 ? 1 : 0) != 0, (boolean)true);
        CommonCloudReportService.populateSalesReportParameter(map, reportType, isShowOnlineTicket);
        if (outlet != null) {
            Currency mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            map.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + " (" + mainCurrency.getSymbol() + ")");
        }
        map.put("dailySalesDataSource", new JRTableModelDataSource((TableModel)dailySalesReportModel));
        map.put("dailySalesReport", dailySalesReport);
        JasperReport masterReport = ReportUtil.getReport((String)"sales_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private static void populateSalesReportParameter(HashMap<String, Object> map, int reportType, boolean isShowOnlineTicket) {
        String reportTitle = isShowOnlineTicket ? ConsoleMessages.getString("CloudReportService.62") : "Sales summary report";
        String colName = POSConstants.DATE;
        if (reportType == 0) {
            colName = POSConstants.DATE;
        } else {
            reportTitle = isShowOnlineTicket ? ConsoleMessages.getString("CloudReportService.63") : "Monthly sales summary report";
            colName = POSConstants.MONTH;
        }
        map.put("reportTitle", reportTitle);
        map.put("colName", ReportUtil.reportLabelWithBoldTag((String)colName));
        map.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colId", ReportUtil.reportLabelWithBoldTag((String)POSConstants.ID));
        map.put("colQty", ReportUtil.reportLabelWithBoldTag((String)POSConstants.QTY));
        map.put("colUnit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT));
        map.put("colSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT_PRICE));
        map.put("colDiscount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.DISCOUNT));
        map.put("colCost", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST));
        map.put("colCostPer", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST_PERCENTAGE));
        map.put("colNetTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NET_SALES));
        map.put("colTax", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TAX));
        map.put("colSC", ReportUtil.reportLabelWithBoldTag((String)POSConstants.S_C));
        map.put("colGrossT", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TOTAL));
        map.put("groupTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROUP_TOTAL));
        map.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.MODIFIER_TOTAL + ": ")));
        map.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_SALES));
        map.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"SalesReportService.0")));
        map.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.RETURN));
        map.put("lblProfit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_PROFIT));
        map.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.PROFIT + " %")));
        map.put("colRfOnNetSales", "RF on net sales");
        map.put("colLabDrFee", "Doctor fee");
        map.put("colRfCommission", "RF on report");
    }

    public static JasperPrint getSalesByEmployeeReportPrint(SalesReportModel salesByemployeeReportModel, Date startTime, Date endTime, Outlet outlet) throws Exception {
        JasperReport itemReport = ReportUtil.getReport((String)"sales_by_employee_sub_report");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportHeader(map, (Outlet)outlet, (Date)startTime, (Date)endTime, null);
        map.put("reportTitle", POSConstants.SALES_BY_EMPLOYEE_REPORT);
        map.put("itemDataSource", new JRTableModelDataSource((TableModel)salesByemployeeReportModel));
        map.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("itemReport", itemReport);
        map.put("isShowGroup", Boolean.TRUE);
        CommonCloudReportService.populateSalesByEmployeeReportParam(map);
        JasperReport masterReport = ReportUtil.getReport((String)"sales_by_employee_report");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private static void populateSalesByEmployeeReportParam(HashMap<String, Object> map) {
        map.put("colId", ReportUtil.reportLabelWithBoldTag((String)POSConstants.ID));
        map.put("colName", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NAME));
        map.put("colQty", ReportUtil.reportLabelWithBoldTag((String)POSConstants.QTY));
        map.put("colUnit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT));
        map.put("colSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.UNIT_PRICE));
        map.put("colDiscount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.DISCOUNT));
        map.put("colCost", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST));
        map.put("colCostPer", ReportUtil.reportLabelWithBoldTag((String)POSConstants.COST_PERCENTAGE));
        map.put("colNetTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.NET_SALES));
        map.put("colTax", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TAX));
        map.put("colSC", ReportUtil.reportLabelWithBoldTag((String)POSConstants.S_C));
        map.put("colGrossT", ReportUtil.reportLabelWithBoldTag((String)POSConstants.TOTAL));
        map.put("groupTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.TOTAL + ": ")));
        map.put("lblItemTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblModifierTotal", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.MODIFIER_TOTAL + ": ")));
        map.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GRAND_TOTAL));
        map.put("lblGrossSales", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_SALES));
        map.put("lblServiceCharge", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"SalesReportService.0")));
        map.put("lblReturnAmount", ReportUtil.reportLabelWithBoldTag((String)POSConstants.RETURN));
        map.put("lblProfit", ReportUtil.reportLabelWithBoldTag((String)POSConstants.GROSS_PROFIT));
        map.put("lblProfitPer", ReportUtil.reportLabelWithBoldTag((String)(POSConstants.PROFIT + " %")));
    }

    public static JasperPrint getHourlySalesReportPrint2(HourlySalesReportModel hourlySalesReportModel, Date startTime, Date endTime, Outlet outlet, String reportTypeEnum) throws Exception {
        JasperReport hourlyReport = ReportUtil.getReport((String)"hourly_labor_subreport");
        JasperReport report = ReportUtil.getReport((String)"hourly_labor_report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)startTime, (Date)endTime);
        ReportUtil.populateReportFooter(properties);
        CommonCloudReportService.populateHourlySalesReportParams(properties);
        properties.put("reportTitle", Messages.getString((String)"HourlySalesReportView.5"));
        properties.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("salesType", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"salesType")) + reportTypeEnum);
        properties.put("incr", ReportUtil.reportLabelWithBoldTag((String)Messages.getString((String)"incr")) + Messages.getString((String)"HourlyLaborReportView.0"));
        properties.put("hourlyReport", hourlyReport);
        properties.put("hourlyReportDatasource", new JRTableModelDataSource((TableModel)hourlySalesReportModel));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    public static JasperPrint getInventoryStockTransfersReportPrint(Date startTime, Date endTime, Outlet outlet, List<InventoryTransfer> inventoryTransfers) throws JRException {
        JasperReport reportheader = ReportUtil.getReport((String)"medlogics_report_header");
        JasperReport header = ReportUtil.getReport((String)"byzlogicsbo_chalan_header_order_info");
        JasperReport chalanReport = ReportUtil.getReport((String)"byzlogicsbo-Chalan-report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("head", header);
        properties.put("reportHeader", reportheader);
        CommonCloudReportService.addStoreInfo(properties, DataProvider.get().getOutlet());
        CommonCloudReportService.populateChalanReportParams(properties, inventoryTransfers);
        InventoryStockTransfersReportModel model = new InventoryStockTransfersReportModel();
        model.setRows(inventoryTransfers);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)chalanReport, properties, (JRDataSource)new JRTableModelDataSource((TableModel)((Object)model)));
        return print;
    }

    public static void addStoreInfo(HashMap<String, Object> map, Outlet outlet) {
        Store store = StoreDAO.getRestaurant();
        if (store != null) {
            map.put("labName", store.getName());
            if (outlet != null && outlet.getAddressLine2() != null) {
                String websiteAddress;
                String telephone;
                map.put("addressLine1", outlet.getAddressLine1() + ", " + outlet.getAddressLine2());
                if (outlet.getAddressLine2() != null) {
                    map.put("addressLine2", "");
                }
                StringBuilder hotlineOrWebAddressBuilder = new StringBuilder();
                Address address = outlet.getAddress();
                if (address != null && StringUtils.isNotBlank((String)(telephone = address.getTelephone()))) {
                    hotlineOrWebAddressBuilder.append("Hotline: " + telephone + " ");
                }
                if (StringUtils.isNotBlank((String)(websiteAddress = outlet.getWebsiteAddress()))) {
                    hotlineOrWebAddressBuilder.append("Web: <a style='color: black' href='" + websiteAddress + "'>" + websiteAddress + "</a>");
                }
                map.put("hotline", hotlineOrWebAddressBuilder.toString());
            }
        }
    }

    private static void populateChalanReportParams(HashMap properties, List<InventoryTransfer> inventoryTransfers) {
        String outletId = inventoryTransfers.get(0).getInventoryTranscation().getToOultetId();
        if (StringUtils.isNotBlank((String)outletId)) {
            Outlet outlet2 = OutletDAO.getInstance().get(outletId);
            properties.put("ptName", outlet2.getName() + " branch");
            properties.put("customerAddress", outlet2.getAddress().toString());
            properties.put("date", inventoryTransfers.get(0).getInventoryTranscation().getTransactionDateAsString());
            properties.put("billNo", inventoryTransfers.get(0).getInventoryTranscation().getReferenceNo());
            properties.put("phone", outlet2.getTelephone());
        }
        properties.put("bill", "Challan");
        properties.put("colName", "Name");
        properties.put("colQty", "Quantity");
        properties.put("colUnit", "Unit");
        properties.put("colBillBy", "Printed: " + DateUtil.simplifyDateAndTime((Date)DateUtil.convertServerTimeToBrowserTime((Date)StoreDAO.getServerTimestamp()), (String)"dd MMM yy hh:mm a"));
    }

    public static JasperPrint getReferralCommissionReportPrint(Date fromDate, Date toDate, Outlet outlet, boolean isShowDetailReport, List<ReferralCommissionReportData> commissionReportDatas) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"referral-commission-report");
        if (isShowDetailReport) {
            report = ReportUtil.getReport((String)"referral_detail_report");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        Currency mainCurrency = null;
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
            if (!isShowDetailReport && (mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId())) != null) {
                properties.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
                properties.put("totalAmount", ConsoleMessages.getString("CloudReportService.111") + "(" + mainCurrency.getSymbol() + ")");
            }
        }
        CommonCloudReportService.populateReportParamsForReferralCommissionReport(properties, mainCurrency, isShowDetailReport);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        Object reportModel = null;
        reportModel = isShowDetailReport ? new ReferralDetailsReportModel() : new ReferralCommissionReportModel();
        reportModel.setRows(commissionReportDatas);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForReferralCommissionReport(HashMap properties, Currency currency, boolean isShowDetailReport) {
        properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.94"));
        if (isShowDetailReport) {
            properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.97"));
        }
        properties.put("totalMsg", ConsoleMessages.getString("CloudReportService.109"));
        if (!isShowDetailReport) {
            if (currency != null) {
                properties.put("totalAmount", Messages.getString((String)"PaymentReceivedReportView.15") + CommonUIUtil.getTextWithBracket(currency.getSymbol()));
            } else {
                properties.put("totalAmount", Messages.getString((String)"PaymentReceivedReportView.15"));
            }
        }
        properties.put("colReferralType", ConsoleMessages.getString("CloudReportService.98"));
        properties.put("colReferralBy", "Referrer");
        properties.put("colReferralId", "Referrer ID");
        properties.put("colReceivable", ConsoleMessages.getString("CloudReportService.100"));
        properties.put("colDue", ConsoleMessages.getString("CloudReportService.101"));
        properties.put("colReceived", ConsoleMessages.getString("CloudReportService.102"));
        properties.put("colReportDoctor", ConsoleMessages.getString("CloudReportService.103"));
        properties.put("colAgentFee", ConsoleMessages.getString("CloudReportService.105"));
        properties.put("colInvoiceID", ConsoleMessages.getString("CloudReportService.106"));
        properties.put("colLabDoctorFee", ConsoleMessages.getString("CloudReportService.107"));
        properties.put("colRFOnReport", ConsoleMessages.getString("CloudReportService.108"));
        properties.put("colOfcNet", ConsoleMessages.getString("CloudReportService.110"));
        properties.put("colRFOnNetSales", ConsoleMessages.getString("CloudReportService.112"));
        properties.put("colRFpayable", ConsoleMessages.getString("CloudReportService.113"));
        properties.put("colRFpaid", ConsoleMessages.getString("CloudReportService.114"));
        properties.put("colRFdue", "RF due");
        properties.put("colOfcTotal", ConsoleMessages.getString("CloudReportService.116"));
        properties.put("colReferrer", "Referrer");
        properties.put("colGroupTotal", "Group total:");
        properties.put("colTotal", "Total:");
        properties.put("colGrandTotal", Messages.getString((String)"GRAND_TOTAL"));
        properties.put("colTotalRf", "Total RF");
        properties.put("colDueCollection", "Due Coll.");
        if (isShowDetailReport) {
            properties.put("colPatientName", "Patient name");
            properties.put("colPatientId", "Patient ID");
        }
    }

    public static JasperPrint getItemwiseRFReportPrint(Date fromDate, Date toDate, Outlet outlet, List<ItemwiseRfReportData> itemwiseRfReportDatas) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"itemwise_rf_report");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForItemwiseRFReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        ItemWiseRFReportModel reportModel = new ItemWiseRFReportModel();
        reportModel.setRows(itemwiseRfReportDatas);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForItemwiseRFReport(HashMap properties) {
        properties.put("reportTitle", "Itemwise RF report");
        properties.put("colOrderId", "Invoice ID");
        properties.put("colItemName", "Test name");
        properties.put("colSubTotal", "Subtotal");
        properties.put("colDiscount", "Discount");
        properties.put("colTax", "Tax");
        properties.put("colRFrate", "RF rate");
        properties.put("colRFamount", "RF amount");
        properties.put("colNonRF", "Non RF");
        properties.put("colLabDoctorFee", "Doctor fee");
        properties.put("colNetSales", "Net sales");
        properties.put("colNetRFrate", "Net RF rate");
        properties.put("colNetRFamount", "Net RF amount");
        properties.put("colOfficeTotal", "Office total");
        properties.put("colRfOnNetSales", "RF On Net Sales");
    }

    public static JasperPrint getLabDoctorFeeReportPrint(Date fromDate, Date toDate, Outlet outlet, List<LabDoctorFeeReportData> labDoctorFeeReportDatas, boolean isShowDetailReport) throws Exception {
        JasperReport report = isShowDetailReport ? ReportUtil.getReport((String)"lab_doctor_fee_report") : ReportUtil.getReport((String)"lab_doctor_fee_summary_report");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (!isShowDetailReport ? 1 : 0) != 0, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForLabDoctorFeeReport(properties, isShowDetailReport);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        LabDoctorFeeReportModel reportModel = new LabDoctorFeeReportModel();
        reportModel.setIsShowDetail(isShowDetailReport);
        reportModel.setRows(labDoctorFeeReportDatas);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForLabDoctorFeeReport(HashMap properties, boolean isShowDetailReport) {
        properties.put("reportTitle", isShowDetailReport ? "Dr. fee detail report" : "Dr. fee summary report");
        properties.put("colLabDoctorName", "Doctor");
        properties.put("colLabDoctorId", "Doctor ID");
        properties.put("colOrderId", ConsoleMessages.getString("CloudReportService.136"));
        properties.put("colOrderDate", ConsoleMessages.getString("CloudReportService.137"));
        properties.put("colPatientName", ConsoleMessages.getString("CloudReportService.138"));
        properties.put("colPatientId", "Patient ID");
        properties.put("colTestName", ConsoleMessages.getString("CloudReportService.139"));
        properties.put("colLabDoctorFee", "Doctor fee");
        properties.put("colLabDoctorPaid", ConsoleMessages.getString("FeePaid"));
        properties.put("colLabDoctorDue", ConsoleMessages.getString("FeeDue"));
        properties.put("ColTotalAmount", ConsoleMessages.getString("Total"));
    }

    public static JasperPrint getMedlogicsLabItemChargesPrint(Outlet outlet, LabItemChargesDataModel labTestForCharges) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"lab-item-charges-report");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportFooter(properties);
        Currency mainCurrency = null;
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
            mainCurrency = CurrencyDAO.getInstance().getMainCurrencyByOutletId(outlet.getId());
            if (mainCurrency != null) {
                properties.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
            }
        }
        CommonCloudReportService.populateReportParamsForLabItemChargesReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)labTestForCharges));
        return print;
    }

    private static void populateReportParamsForLabItemChargesReport(HashMap properties) {
        properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.160"));
        properties.put("colCategoryName", ConsoleMessages.getString("CloudReportService.161"));
        properties.put("colName", ConsoleMessages.getString("CloudReportService.162"));
        properties.put("colName", ConsoleMessages.getString("CloudReportService.163"));
        properties.put("colActive", ConsoleMessages.getString("CloudReportService.164"));
        properties.put("colNormalRate", ConsoleMessages.getString("CloudReportService.165"));
        properties.put("colUrgentRate", ConsoleMessages.getString("CloudReportService.166"));
    }

    public static JasperPrint getLabDoctorPaymentsReportPrint(Date fromDate, Date toDate, boolean showReferralPayment, Outlet outlet, List<PosTransaction> posTransactions) throws Exception {
        return CommonCloudReportService.getLabDoctorPaymentsReportPrint(fromDate, toDate, showReferralPayment, outlet, posTransactions, false);
    }

    public static JasperPrint getLabDoctorPaymentsReportPrint(Date fromDate, Date toDate, boolean showReferralPayment, Outlet outlet, List<PosTransaction> posTransactions, boolean isShowDuePayment) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"lab_doctor_payments_report");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForLabDoctorPaymentsReport(properties, showReferralPayment, isShowDuePayment);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        LabDoctorPaymentsReportModel reportModel = new LabDoctorPaymentsReportModel();
        reportModel.setRows(posTransactions);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForLabDoctorPaymentsReport(HashMap properties, boolean showReferralPayment, boolean isShowDuePayment) {
        if (showReferralPayment) {
            if (isShowDuePayment) {
                properties.put("reportTitle", "Due RF payments report");
            } else {
                properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.168"));
            }
            properties.put("colCustomerName", ConsoleMessages.getString("CloudReportService.169"));
            properties.put("colCustomerId", ConsoleMessages.getString("CloudReportService.169") + " ID");
        } else {
            if (isShowDuePayment) {
                properties.put("reportTitle", "Due LDF payments report");
            } else {
                properties.put("reportTitle", ConsoleMessages.getString("CloudReportService.170"));
            }
            properties.put("colCustomerName", ConsoleMessages.getString("CloudReportService.171"));
            properties.put("colCustomerId", ConsoleMessages.getString("CloudReportService.171") + " ID");
            properties.put("colDepartment", ConsoleMessages.getString("CloudReportService.172"));
        }
        properties.put("colOrderDate", "Order date");
        properties.put("colDate", "Payment date");
        properties.put("colPaymentType", ConsoleMessages.getString("CloudReportService.174"));
        properties.put("colAmount", ConsoleMessages.getString("CloudReportService.175"));
        properties.put("ColTotalAmount", "Total");
        properties.put("colOrderId", ConsoleMessages.getString("CloudReportService.77"));
    }

    public static JasperPrint getPayoutReportReportPrint(Date fromDate, Date toDate, Outlet outlet, List<PayOutTransaction> payoutrOutTransactions) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"payout-report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForPayoutPaymentsReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        PayoutReportDataModel reportModel = new PayoutReportDataModel();
        reportModel.setRows(payoutrOutTransactions);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForPayoutPaymentsReport(HashMap<String, Object> map) {
        map.put("reportTitle", Messages.getString((String)"PayoutReportView.0"));
        map.put("colDate", POSConstants.DATE);
        map.put("colUser", Messages.getString((String)"PayoutReportView.1"));
        map.put("colRecipient", Messages.getString((String)"PayoutReportView.2"));
        map.put("colReason", Messages.getString((String)"PayoutReportView.3"));
        map.put("colNote", Messages.getString((String)"PayoutReportView.4"));
        map.put("colAmount", Messages.getString((String)"PayoutReportView.6"));
        map.put("totalAmount", Messages.getString((String)"PayoutReportView.7"));
        map.put("colBatchNo", "Batch No");
        map.put("colPayoutID", "Payout ID");
        map.put("colPaidBy", "Paid by");
    }

    public static JasperPrint getDoctorAppointmentReportPrint(Date fromDate, Date toDate, Doctor doctor, List<Appointment> appointments) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"doctor_appointment_report");
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate);
        ReportUtil.populateReportFooter(properties);
        Currency mainCurrency = DataProvider.get().getMainCurrency();
        if (mainCurrency != null) {
            properties.put("currency", ReportUtil.reportLabelWithBoldTag((String)POSConstants.CURRENCY) + " " + mainCurrency.getName() + CommonUIUtil.getTextWithBracket(mainCurrency.getSymbol()));
            properties.put("totalAmount", ConsoleMessages.getString("CloudReportService.111") + "(" + mainCurrency.getSymbol() + ")");
        }
        CommonCloudReportService.populateReportParamsForAppointmentReport(properties, mainCurrency);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        properties.put("totalMsg", ConsoleMessages.getString("CloudReportService.109"));
        DoctorAppointmentReportModel reportModel = new DoctorAppointmentReportModel();
        reportModel.setRows(appointments);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForAppointmentReport(HashMap properties, Currency currency) {
        properties.put("reportTitle", "Doctor's visit report");
        properties.put("totalMsg", Messages.getString((String)"PaymentReceivedReportView.13"));
        if (currency != null) {
            properties.put("totalAmount", Messages.getString((String)"PaymentReceivedReportView.15") + CommonUIUtil.getTextWithBracket(currency.getSymbol()));
        } else {
            properties.put("totalAmount", Messages.getString((String)"PaymentReceivedReportView.15"));
        }
        properties.put("colPatientName", "Patient");
        properties.put("colAppointmentDate", "Date");
        properties.put("colAppointmentTime", "Time");
        properties.put("colAppointmentId", "Appointment Id");
        properties.put("colGrandTotal", "Fees");
    }

    public static JasperPrint getExpenseReportReportPrint(Date fromDate, Date toDate, Outlet outlet, List<PosTransaction> balanceUpdateTransactions, boolean isByzlogicsExpense, boolean isShowStoreAmount, String storeAmount, boolean isShowAMAmount, String accountManagerAmount, double totalExpenseAmount) throws Exception {
        JasperReport report = isByzlogicsExpense ? ReportUtil.getReport((String)"byz-expense-report") : ReportUtil.getReport((String)"expense-report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        properties.put("isShowStoreAmount", isShowStoreAmount);
        properties.put("storeAmount", storeAmount);
        properties.put("isShowAMAmount", isShowAMAmount);
        properties.put("accountManagerAmount", accountManagerAmount);
        properties.put("totalAmountValue", NumberUtil.formatAmount((Double)totalExpenseAmount));
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForExpensePaymentsReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        ExpenseReportDataModel reportModel = new ExpenseReportDataModel();
        reportModel.setRows(balanceUpdateTransactions);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForExpensePaymentsReport(HashMap<String, Object> map) {
        map.put("reportTitle", "Expense report");
        map.put("colDate", "Time");
        map.put("colEventDate", "Event date");
        map.put("colAccountManager", "Store / Acct. Manager");
        map.put("colRecipient", "Expenses Recepient");
        map.put("colAmount", "Amount");
        map.put("totalAmount", Messages.getString((String)"PayoutReportView.7"));
        map.put("colChartOfAccountsName", "Account type");
        map.put("colNote", "Note");
        map.put("colReason", "Expense reason");
        map.put("colCategory", "Category");
        map.put("colSubCategory", "Sub category");
        map.put("colProject", "Project Name");
        map.put("colPaymentType", "Payment type");
        map.put("colPerformBy", "Expense by");
    }

    public static JasperPrint getUserWiseCollectionSalesReportPrint(Date fromDate, Outlet outlet, String userName, List<UserWiseCollectionReportData> balanceUpdateTransactions) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"user-wise-collection-sales-report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)new Date(), (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        properties.put("colUser", userName);
        CommonCloudReportService.populateReportParamsForCollectionSalesReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        UserWiseCollectionReportDataModel reportModel = new UserWiseCollectionReportDataModel();
        reportModel.setRows(balanceUpdateTransactions);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForCollectionSalesReport(HashMap<String, Object> map) {
        map.put("reportTitle", "User wise collection sales report");
        map.put("colSerial", "SL");
        map.put("colEmployee", "Employee");
        map.put("colBillNo", "Order ID");
        map.put("colBillDate", "Order Date");
        map.put("colPatient", "Patient");
        map.put("colSubTotal", "Subtotal");
        map.put("colVat", "VAT");
        map.put("colDiscount", "Discount");
        map.put("colTotal", "Total");
        map.put("colAdvanced", "Received");
        map.put("colDue", "Due collection");
        map.put("colTotalReceived", "Total received");
    }

    public static JasperPrint getByzProjectReportPrint(Date fromDate, Date toDate, Outlet outlet, List<PosTransaction> transactions, HashMap properties) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"byz-project-report");
        ReportUtil.populateRestaurantProperties((Map)properties, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportTime((HashMap)properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter((HashMap)properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForByzProjectReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        ProjectReportDataModel reportModel = new ProjectReportDataModel();
        reportModel.setRows(transactions);
        double calculateTotalAmount = 0.0;
        properties.put("totalAmount", NumberUtil.formatToAccountingAmount((double)calculateTotalAmount));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, (Map)properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForByzProjectReport(HashMap<String, Object> map) {
        map.put("reportTitle", "Project report");
        map.put("colDate", "Time");
        map.put("colType", "Type");
        map.put("colProjectName", "Project Name");
        map.put("colDescription", "Description");
        map.put("colAmount", "Amount");
        map.put("rowTotalAmount", "Total");
    }

    public static JasperPrint getInventoryTransactionReportPrint(Date fromDate, Date toDate, Outlet outlet, List<InventoryTransaction> transactions, MenuCategory category, MenuGroup group, Map<String, Double> previousInventoryTransactionsMap, InventoryTransactionType selectedTransactionType, Boolean isShowGroup) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"inventoryTransactionReport");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportPropertiesForInventoryTransaction(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        String strCategory = "All";
        String strGroup = "All";
        String transactionType = "All";
        if (category != null) {
            strCategory = category.getName();
        }
        if (group != null) {
            strGroup = group.getName();
        }
        if (selectedTransactionType != null) {
            transactionType = selectedTransactionType.getName();
        }
        properties.put("sGroup", ReportUtil.reportLabelWithBoldTag((String)"Group:") + " " + strGroup);
        properties.put("sCategory", ReportUtil.reportLabelWithBoldTag((String)"Category:") + " " + strCategory);
        properties.put("sTransactionType", ReportUtil.reportLabelWithBoldTag((String)"Transaction type:") + " " + transactionType);
        properties.put("isGroup", isShowGroup);
        InventoryTransactionReportModel reportModel = new InventoryTransactionReportModel();
        reportModel.setItems(transactions, previousInventoryTransactionsMap);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportPropertiesForInventoryTransaction(HashMap<String, Object> properties) {
        properties.put("reportTitle", "Inventory transaction report");
        properties.put("colGroupOrItem", "Group/Item");
        properties.put("colSku", "SKU #");
        properties.put("colVendorOrTicket", "Vendor/Ticket");
        properties.put("colLocation", "Location");
        properties.put("colTime", "Time");
        properties.put("colTType", "T.Type");
        properties.put("colReason", "Reason");
        properties.put("colQty", "Qty");
        properties.put("colUnit", "Unit");
        properties.put("colOnHand", "On hand");
        properties.put("colCost", "Cost");
        properties.put("colTotal", "Total");
        properties.put("reportGroupHeader", "Opening balance");
        properties.put("colItemTotal", "Item total:");
        properties.put("colGroupTotal", "Group total:");
        properties.put("totalMsg", "Grand total");
    }

    public static JasperPrint getInvTransactionsReportPrint(Date fromDate, Date toDate, Outlet outlet, List<InventoryTransaction> transactions, InventoryTransactionType selectedTransactionType) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"invTransactionsReport");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportPropertiesForInvTransactions(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        String transactionType = "All";
        if (selectedTransactionType != null) {
            transactionType = selectedTransactionType.getName();
        }
        properties.put("sTransactionType", ReportUtil.reportLabelWithBoldTag((String)"Transaction type:") + " " + transactionType);
        InvTransactionsReportModel reportModel = new InvTransactionsReportModel();
        reportModel.setItems(transactions);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportPropertiesForInvTransactions(HashMap<String, Object> properties) {
        properties.put("reportTitle", "Inventory transactions");
        properties.put("colName", "Name");
        properties.put("colType", "Type");
        properties.put("colFromLocation", "From Location");
        properties.put("colToLocation", "To Location");
        properties.put("colTransTime", "Time");
        properties.put("colUnitPrice", "Unit price");
        properties.put("colUnitCost", "Unit cost");
        properties.put("colQty", "Quantity");
        properties.put("colUnit", "Unit");
        properties.put("colBatch", "Batch");
        properties.put("colTotal", "Total");
        properties.put("colInventoryType", "Inv. type");
        properties.put("totalText", "Total");
    }

    public static JasperPrint getInventoryAverageUnitCostReportPrint(Date fromDate, Date toDate, Outlet outlet, List<InventoryTransaction> inventList, MenuCategory category, MenuGroup group) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"inventoryAverageUnitCost");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)false, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportPropertiesForInventoryAverageUnitCostReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        String strCategory = category == null ? "All" : category.getName();
        String strGroup = group == null ? "All" : group.getName();
        String[] searchKey = new String[]{strCategory, strGroup};
        properties.put("sGroup", ReportUtil.reportLabelWithBoldTag((String)"Group:") + " " + searchKey[1]);
        properties.put("sCategory", ReportUtil.reportLabelWithBoldTag((String)"Category:") + " " + searchKey[0]);
        InventoryAverageCostUnitReportModel reportModel = new InventoryAverageCostUnitReportModel();
        if (inventList != null && inventList.size() > 0) {
            reportModel.setItems(inventList, false);
        }
        properties.put("totalExpenses", String.valueOf(reportModel.getTotalAmount()));
        properties.put("totalQuantity", String.valueOf(reportModel.getTotalQuantity()));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportPropertiesForInventoryAverageUnitCostReport(HashMap<String, Object> properties) {
        properties.put("reportTitle", "Average Cost Report");
        properties.put("colGroupOrItem", "Group/Item");
        properties.put("colSku", "SKU #");
        properties.put("colVendor", "Vendor");
        properties.put("colTime", "Date");
        properties.put("colLocation", "Location");
        properties.put("colReason", "Reason");
        properties.put("colQty", "Qty");
        properties.put("colUnit", "Unit");
        properties.put("colCost", "Cost");
        properties.put("colTotal", "Total");
        properties.put("totalMsg", "Total");
        properties.put("reportGroupHeader", "Opening balance");
    }

    public static JasperPrint getBankAccountTransactionReportPrint(Date fromDate, Date toDate, Outlet outlet, List<BalanceUpdateTransaction> transactions, Object bank) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"bank-account-transaction-report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForBankAccountTransactionReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        if (bank instanceof BankAccount) {
            BankAccount bankAccount = (BankAccount)bank;
            bankAccount = (BankAccount)DataProvider.get().getObjectOf(BankAccount.class, (Serializable)((Object)bankAccount.getId()));
            double bankAccountBalance = bankAccount.getBalance() == 0.0 ? 0.0 : bankAccount.getBalance();
            properties.put("endBalance", bankAccountBalance);
            properties.put("bankName", "Bank Name: " + bankAccount.getBankName());
            properties.put("bankAccount", "Bank A/C Name: " + bankAccount.getAccountName());
            properties.put("bankAccountNo", "A/C No: " + bankAccount.getAccountNo());
        }
        BankAccountTransactionReportDataModel reportModel = new BankAccountTransactionReportDataModel();
        reportModel.setRows(transactions);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForBankAccountTransactionReport(HashMap<String, Object> map) {
        map.put("reportTitle", "Bank account transaction report");
        map.put("colDate", "Date");
        map.put("colBeforeBalance", "Before balance");
        map.put("colTransaction", "Transaction");
        map.put("colOrderOrEmployeeId", "Order/Employee ID");
        map.put("colNote", "Note");
        map.put("colAmount", "Amount");
        map.put("rowEndBalance", "Current balance:");
        map.put("totalAmount", "Total amount:");
    }

    public static JasperPrint getAccountPayableDueReportPrint(Date fromDate, Date toDate, Outlet outlet, List<PurchaseOrder> purchaseOrder) throws Exception {
        JasperReport report = ReportUtil.getReport((String)"account-payable-report");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, (boolean)true, (Outlet)outlet);
        ReportUtil.populateReportTime(properties, (Date)fromDate, (Date)toDate, (boolean)true);
        ReportUtil.populateReportFooter(properties);
        if (outlet != null) {
            properties.put("outletName", ReportUtil.reportLabelWithBoldTag((String)"Outlet: ") + " " + outlet.getName());
        }
        CommonCloudReportService.populateReportParamsForAccountPayableDueReport(properties);
        properties.put("reportDate", CommonCloudReportService.makeBoldString(ConsoleMessages.getString("ReportOn")) + ReportService.formatFullDate((Date)new Date()));
        AccountPayableReportDataModel reportModel = new AccountPayableReportDataModel();
        reportModel.setRows(purchaseOrder);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        return print;
    }

    private static void populateReportParamsForAccountPayableDueReport(HashMap<String, Object> map) {
        map.put("reportTitle", "Accounts payable report");
        map.put("colDate", "Date");
        map.put("colPO", "P.O No");
        map.put("colVendor", "Vendor");
        map.put("colProject", "Project");
        map.put("colTotal", "Total");
        map.put("colPaid", "Paid");
        map.put("colDue", "Due");
        map.put("totalAmount", "Total amount:");
    }
}

