/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosLog;
import com.floreantpos.model.Project;
import com.floreantpos.model.dao.ProjectDAO;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProjectCombobox
extends SiiopaCombobox {
    private final Map<String, Project> projectMap = new HashMap<String, Project>();

    public ProjectCombobox() {
        this.setNewItemHandler(new NewProjectHandler());
        this.loadProjects();
    }

    private void loadProjects() {
        for (Project project : ProjectDAO.getInstance().findAll()) {
            String name = StringUtils.defaultIfBlank((String)project.getName(), (String)project.getId());
            this.projectMap.put(name, project);
            this.addItem(project);
        }
    }

    @Override
    public void enterKeyPressed(Component source) {
        PosLog.debug(ProjectCombobox.class, (String)"Enter key pressed on ProjectComboBox");
    }

    private class NewProjectHandler
    implements AbstractSelect.NewItemHandler {
        private NewProjectHandler() {
        }

        public void addNewItem(String newProject) {
            try {
                String projectName = StringUtils.trimToEmpty((String)newProject);
                Project existing = this.findExistingProject(projectName);
                if (existing != null) {
                    ProjectCombobox.this.select(existing);
                } else {
                    int length = projectName.length();
                    if (length > 255) {
                        CloudNotification.showErrorMessage("Project name cannot be greater than 255");
                        return;
                    }
                    Project project = new Project();
                    project.setName(projectName);
                    ProjectCombobox.this.addItem(project);
                    ProjectCombobox.this.setValue(project);
                    ProjectCombobox.this.projectMap.put(projectName, project);
                }
            }
            catch (Exception e) {
                CloudNotification.showErrorMessage(e.getMessage());
            }
        }

        private Project findExistingProject(String projectName) {
            Project mapProject = (Project)ProjectCombobox.this.projectMap.get(projectName);
            if (mapProject != null) {
                return mapProject;
            }
            Collection items = ProjectCombobox.this.getItemIds();
            for (Object obj : items) {
                Project p;
                if (!(obj instanceof Project) || !projectName.equalsIgnoreCase((p = (Project)obj).getName())) continue;
                return p;
            }
            return null;
        }
    }
}

