/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.PosTransaction;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class ExpenseReportGrid
extends FooterSupportedBeanGrid<PosTransaction> {
    public ExpenseReportGrid(boolean isByzlogicsExpense, boolean isServiceOrder) {
        super.setUseNormalFont(true);
        this.addColumn("Store / Acct. Manager", "accountManagerName", String.class);
        if (isByzlogicsExpense || isServiceOrder) {
            this.addColumn("Project Name", "projectNameDisplay", String.class);
        }
        if (!isServiceOrder) {
            this.addColumn("Expense Recepient", "recepientDisplay", String.class);
        }
        this.addColumn("Expense by", "userName", String.class);
        this.addColumn("Category", "reasonDisplay", String.class);
        this.addColumn("Sub category", "subReason", String.class);
        if (isByzlogicsExpense) {
            this.addColumn("Account type", "chartOfAccountsName", String.class);
        }
        this.addColumn("Time", "dateDisplayString", String.class);
        this.addColumn("Event date", "eventTimeDisplay", String.class);
        this.addColumn("Note", "note", String.class);
        this.addColumn("Payment type", "paymentTypeDisplayString", String.class);
        this.addColumn("Amount", "expenseAmount", Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        if (isByzlogicsExpense) {
            this.showCSummaryRow("expenseAmount", "Total expense :", "accountManagerName", "dateDisplayString", "eventTimeDisplay", "projectNameDisplay", "recepientDisplay", "reasonDisplay", "subReason", "note", "paymentTypeDisplayString", "userName", "chartOfAccountsName");
        } else if (isServiceOrder) {
            this.showCSummaryRow("expenseAmount", "Total expense :", "accountManagerName", "dateDisplayString", "eventTimeDisplay", "projectNameDisplay", "reasonDisplay", "subReason", "note", "paymentTypeDisplayString", "userName");
        } else {
            this.showCSummaryRow("expenseAmount", "Total expense :", "accountManagerName", "dateDisplayString", "eventTimeDisplay", "recepientDisplay", "reasonDisplay", "subReason", "note", "paymentTypeDisplayString", "userName");
        }
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
        this.getColumn("expenseAmount").setMinimumWidth(180.0);
        this.getColumn("dateDisplayString").setMaximumWidth(165.0);
    }

    public void setItems(Collection<PosTransaction> items, double totalAmount) {
        super.setItems(items);
        super.updateView(totalAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PosTransaction.class;
    }
}

