/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.POSConstants;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PurchaseTransaction;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;

public class PurchasePaymentReportGrid
extends FooterSupportedBeanGrid<PosTransaction> {
    private Grid.FooterCell totalCell;

    public PurchasePaymentReportGrid() {
        this.addColumn("PO. No", PosTransaction.PROP_ENTITY_NO, String.class);
        this.addColumn(ConsoleMessages.getString("TransactionReportGrid.0"), String.class);
        String payToColumnName = "Pay to";
        this.addColumn(payToColumnName, String.class);
        String paymentTypeColumnName = ConsoleMessages.getString("TransactionReportGrid.2");
        this.addColumn(paymentTypeColumnName, String.class).setHeaderCaption(paymentTypeColumnName);
        this.addColumn(POSConstants.TOTAL, String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
        this.mergeAndshowTotal(PosTransaction.PROP_ENTITY_NO, "Time", payToColumnName, paymentTypeColumnName);
        this.totalCell = this.createSummaryCell(POSConstants.TOTAL);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PurchaseTransaction.class;
    }

    public void updateTotal(double totalAmount) {
        this.updateCellValue(this.totalCell, totalAmount);
    }

    @Override
    public void clearFooterCell() {
        this.updateCellValue(this.totalCell, 0.0);
    }
}

