/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.server;

import com.floreantpos.Database;
import com.floreantpos.PosLog;
import com.floreantpos.db.update.UpdateDBTo256;
import com.floreantpos.jdbc.SchemaResolver;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.HibernateSearchUtil;
import com.floreantpos.util.DatabaseUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.siiopa.cloud.server.CloudResourceCache;
import com.orocube.siiopa.cloud.server.security.CurrentSession;
import com.orocube.siiopa.common.classes.SiiopaExtensionManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

public class CloudContext
implements ServletContextListener {
    public static String MQTT_DEVICE_ID = "";
    public static String APP_VERSION = "";
    public static String APP_BUILD_TIMESTAMP = "";

    public void contextDestroyed(ServletContextEvent arg0) {
        _RootDAO.releaseConnection();
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            String hostmailaddress;
            PosLog.info(this.getClass(), (String)("java version: " + System.getProperty("java.version")));
            PosLog.info(this.getClass(), (String)("java vendor: " + System.getProperty("java.vendor")));
            PosLog.info(this.getClass(), (String)("home directory: " + System.getProperty("user.home")));
            PosLog.info(this.getClass(), (String)("current directory: " + new File(".").getAbsolutePath()));
            ServletContext servletContext = servletContextEvent.getServletContext();
            try (InputStream resourceAsStream2 = this.getClass().getResourceAsStream("/about.properties");){
                Properties properties = new Properties();
                properties.load(resourceAsStream2);
                APP_VERSION = properties.getProperty("version");
                APP_BUILD_TIMESTAMP = properties.getProperty("build_timestamp");
            }
            catch (IOException resourceAsStream2) {
                // empty catch block
            }
            CloudResourceCache.get().init(servletContext);
            String dbProvider = servletContext.getInitParameter("jdbc.databaseProvider");
            String dbHost = servletContext.getInitParameter("jdbc.database_host");
            String dbPort = servletContext.getInitParameter("jdbc.database_port");
            String path = String.format("jdbc:postgresql://%s:%s/", dbHost, dbPort);
            String dbName = servletContext.getInitParameter("jdbc.database_name");
            String username = servletContext.getInitParameter("jdbc.database_user");
            String password = servletContext.getInitParameter("jdbc.database_password");
            String luceneEnableStr = servletContext.getInitParameter("lucene.enable");
            boolean luceneEnable = true;
            if (StringUtils.isNotBlank((String)luceneEnableStr)) {
                luceneEnable = Boolean.parseBoolean(luceneEnableStr);
            }
            if (StringUtils.isNotBlank((String)(hostmailaddress = servletContext.getInitParameter("email.from_address.host")))) {
                MailService.setSenderEmail((String)("noreply@" + hostmailaddress));
            }
            Database database = Database.getByProviderName((String)dbProvider);
            String visibleActionButtons = servletContext.getInitParameter("system.visibleActionButtons");
            CurrentSession.setVisibleActionButtons(Boolean.valueOf(visibleActionButtons));
            String connectString = path + dbName + "?prepareThreshold=0";
            PosLog.info(this.getClass(), (String)("connectString: " + connectString));
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("hibernate.dialect", database.getHibernateDialect());
            properties.put("hibernate.connection.driver_class", database.getHibernateConnectionDriverClass());
            properties.put("hibernate.connection.url", connectString);
            properties.put("hibernate.connection.username", username);
            properties.put("hibernate.connection.password", password);
            properties.put("hibernate.show_sql", "true");
            properties.put("hibernate.multiTenancy", MultiTenancyStrategy.SCHEMA.name());
            properties.put("hibernate.multi_tenant_connection_provider", "com.floreantpos.jdbc.OroMultitenantConnectionProvider");
            properties.put("hibernate.tenant_identifier_resolver", "com.floreantpos.jdbc.SchemaResolver");
            properties.put("hibernate.search.default.locking_strategy", "none");
            properties.put("hibernate.search.default.directory_provider", "filesystem");
            if (luceneEnable) {
                if (CloudResourceCache.get().isSiiopa()) {
                    properties.put("hibernate.search.default.indexBase", "/opt/siiopa_lucene_index");
                    properties.put("hibernate.search.autoregister_listeners", "false");
                    properties.put("hibernate.search.indexing_strategy", "manual");
                } else {
                    properties.put("hibernate.search.default.indexBase", "/opt/menugreat_lucene_index");
                }
            } else {
                properties.put("hibernate.search.autoregister_listeners", "false");
                properties.put("hibernate.search.indexing_strategy", "manual");
            }
            DatabaseUtil.initialize(properties);
            PosLog.info(this.getClass(), (String)"initialize db properties");
            SchemaResolver.setPublicTenant();
            PosLog.info(this.getClass(), (String)"public sehema selected");
            SiiopaExtensionManager.initPlugins();
            this.initializeMqtt();
            PosLog.info(this.getClass(), (String)" System initialized.");
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
        }
    }

    private void initializeMqtt() throws Exception, MqttException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OroMqttClient instance = OroMqttClient.getInstance();
                    String mqttClientId = "siiopa-console";
                    if (CloudResourceCache.get().isMenugreat()) {
                        mqttClientId = "menugreat-console";
                    }
                    MQTT_DEVICE_ID = mqttClientId + "-" + UUID.randomUUID();
                    PosLog.debug(this.getClass(), (String)("Mqtt client id: " + MQTT_DEVICE_ID));
                    instance.initMqttClient(MQTT_DEVICE_ID);
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), (Exception)e);
                }
            }
        }).start();
    }

    private void updateDbVersion() {
        PosLog.info(this.getClass(), (String)"updateing db version");
        Store store = StoreDAO.getRestaurant();
        store.setDatabaseVersion(468);
        StoreDAO.getInstance().update(store);
        PosLog.info(this.getClass(), (String)"db version updated");
    }

    private boolean updateDbIfNeeded(String connectString, Database database, String username, String password) throws Exception {
        ArrayList<String> schemaList = new ArrayList<String>();
        try (Connection connection = DriverManager.getConnection(connectString, username, password);){
            Statement statement = connection.createStatement();
            Object object = null;
            try (ResultSet rs2 = statement.executeQuery("select store_id from siiopa_customer");){
                while (rs2.next()) {
                    String schemaName = rs2.getString(1);
                    if (!StringUtils.isNotEmpty((String)schemaName)) continue;
                    schemaList.add(schemaName);
                }
            }
            catch (Throwable rs2) {
                object = rs2;
                throw rs2;
            }
            finally {
                if (statement != null) {
                    if (object != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable rs2) {
                            ((Throwable)object).addSuppressed(rs2);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
        }
        try {
            for (String schemaName : schemaList) {
                try {
                    SchemaResolver.setTenant(schemaName);
                    List tickets = TicketDAO.getInstance().findAll();
                    PosLog.debug(this.getClass(), (String)("Total tickets for " + schemaName + ": " + tickets.size()));
                    for (Ticket ticket : tickets) {
                        TicketDAO.getInstance().loadFullTicket(ticket);
                        ticket.calculatePrice();
                        TicketDAO.getInstance().update(ticket);
                    }
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), (Exception)e);
                }
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), (Exception)e);
        }
        PosLog.info(this.getClass(), (String)"Db updated");
        return true;
    }

    private void updateSchema(Database database, String connectionString, String schema, String user, String password) throws Exception {
        PosLog.info(this.getClass(), (String)("updating schema: " + schema));
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().configure("cloudpos.hibernate.cfg.xml");
        registryBuilder.applySetting("hibernate.dialect", (Object)database.getHibernateDialect());
        registryBuilder.applySetting("hibernate.connection.driver_class", (Object)database.getHibernateConnectionDriverClass());
        registryBuilder.applySetting("hibernate.connection.url", (Object)connectionString);
        registryBuilder.applySetting("hibernate.connection.username", (Object)user);
        registryBuilder.applySetting("hibernate.connection.password", (Object)password);
        registryBuilder.applySetting("hibernate.max_fetch_depth", (Object)"3");
        registryBuilder.applySetting("hibernate.connection.isolation", (Object)String.valueOf(1));
        registryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
        registryBuilder.applySetting("hibernate.default_schema", (Object)schema);
        registryBuilder.applySetting("hibernate.search.default.indexBase", (Object)"/opt/menugreat_lucene_index");
        registryBuilder.applySetting("hibernate.search.autoregister_listeners", (Object)"false");
        registryBuilder.applySetting("hibernate.search.indexing_strategy", (Object)"manual");
        StandardServiceRegistry standardRegistry = registryBuilder.build();
        Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
        SchemaUpdate schemaUpdate = new SchemaUpdate();
        EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
        schemaUpdate.execute(enumSet, metaData);
        SessionFactory sessionFactory = metaData.buildSessionFactory();
        _RootDAO.setSessionFactory((SessionFactory)sessionFactory);
        Store store = StoreDAO.getRestaurant();
        if (store != null) {
            Integer databaseVersion;
            Integer n = databaseVersion = store == null ? null : store.getDatabaseVersion();
            if (databaseVersion == null || databaseVersion < 256) {
                PosLog.debug(DatabaseUtil.class, (String)"updating db to 256");
                UpdateDBTo256 dataConvertionUtil = new UpdateDBTo256(connectionString, user, password);
                dataConvertionUtil.update();
            }
            store.setDatabaseVersion(468);
            StoreDAO.getInstance().update(store);
        }
        sessionFactory.close();
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
        PosLog.info(this.getClass(), (String)(schema + " schema update complete."));
    }

    private void createLuceneIndex() throws InterruptedException {
        SchemaResolver.setPublicTenant();
        List schemaList = null;
        try (Session session = StoreDAO.getInstance().createNewSession();){
            SQLQuery sqlQuery = session.createSQLQuery("SELECT schema_name FROM information_schema.schemata");
            schemaList = sqlQuery.list();
        }
        schemaList.removeAll(Arrays.asList("pg_toast", "pg_temp_1", "pg_toast_temp_1", "pg_catalog", "information_schema"));
        for (String schema : schemaList) {
            SchemaResolver.setTenant(schema);
            HibernateSearchUtil.setCurrentStoreId((String)schema);
            FullTextSession fullTextSession = Search.getFullTextSession((Session)StoreDAO.getInstance().createNewSession());
            Throwable throwable = null;
            try {
                fullTextSession.createIndexer(new Class[0]).startAndWait();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fullTextSession == null) continue;
                if (throwable != null) {
                    try {
                        fullTextSession.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fullTextSession.close();
            }
        }
        HibernateSearchUtil.setCurrentStoreId(null);
    }
}

