/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosLog;
import com.kbdunn.vaadin.addons.fontawesome.FontAwesome;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.DoneCancelWindow;
import com.vaadin.addons.AutocompleteOffExtension;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.PasswordField;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class EditPasswordWindow
extends DoneCancelWindow {
    private PasswordField tfPassword;
    private PasswordField tfReTypePassword;

    public EditPasswordWindow() {
        this("Change Password");
    }

    public EditPasswordWindow(String title) {
        super(title);
        this.init();
    }

    private void init() {
        FormLayout formLayout = new FormLayout();
        formLayout.addStyleName("custom-width-formlayout");
        formLayout.setSizeFull();
        HorizontalLayout passwordLayout = new HorizontalLayout();
        passwordLayout.setCaption("New password");
        passwordLayout.setSpacing(true);
        passwordLayout.setMargin(false);
        this.tfPassword = new PasswordField();
        this.tfPassword.setId("tf-password");
        this.tfPassword.focus();
        this.tfPassword.setTabIndex(1);
        HorizontalLayout reTypePasswordLayout = new HorizontalLayout();
        reTypePasswordLayout.setCaption("Re type new password");
        reTypePasswordLayout.setSpacing(true);
        reTypePasswordLayout.setMargin(false);
        this.tfReTypePassword = new PasswordField();
        this.tfReTypePassword.setId("retype-password");
        this.tfReTypePassword.setTabIndex(2);
        this.btnDone.setTabIndex(3);
        this.btnCancel.setTabIndex(4);
        CloudButton btnShowPassword = CommonUIUtil.createColorButton("");
        btnShowPassword.setIcon((Resource)FontAwesome.EYE);
        btnShowPassword.addClickListener((Button.ClickListener & Serializable)event -> this.showOrHidePass(event));
        CloudButton btnShowReTypePassword = CommonUIUtil.createColorButton("");
        btnShowReTypePassword.setIcon((Resource)FontAwesome.EYE);
        btnShowReTypePassword.addClickListener((Button.ClickListener & Serializable)event -> this.showOrHidePin(event));
        HorizontalLayout contentPane = this.getContentPanel();
        contentPane.setSizeFull();
        contentPane.setMargin(true);
        contentPane.setSpacing(false);
        AutocompleteOffExtension.setAutocompleteOff((AbstractField)this.tfPassword);
        AutocompleteOffExtension.setAutocompleteOff((AbstractField)this.tfReTypePassword);
        passwordLayout.addComponents(new Component[]{this.tfPassword, btnShowPassword});
        reTypePasswordLayout.addComponents(new Component[]{this.tfReTypePassword, btnShowReTypePassword});
        formLayout.addComponents(new Component[]{passwordLayout, reTypePasswordLayout});
        contentPane.addComponents(new Component[]{formLayout});
        contentPane.setExpandRatio((Component)formLayout, 1.0f);
    }

    @Override
    public boolean doOk() {
        try {
            String password = (String)this.tfPassword.getValue();
            String reTypePassword = (String)this.tfReTypePassword.getValue();
            if (StringUtils.isBlank((String)password)) {
                CloudNotification.showMessageDialog("Please enter password");
                return false;
            }
            if (StringUtils.isBlank((String)reTypePassword)) {
                CloudNotification.showMessageDialog("Please enter Re type new password");
                return false;
            }
            if (!password.equals(reTypePassword)) {
                CloudNotification.showMessageDialog("Passwords did not match");
                return false;
            }
        }
        catch (Exception e) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e);
        }
        return true;
    }

    @Override
    public void initUI(HorizontalLayout contentPane) {
    }

    public String getTfPassword() {
        return (String)this.tfPassword.getValue();
    }

    private void showOrHidePin(Button.ClickEvent event) {
        JavaScript.getCurrent().execute("var pinField = document.getElementById(\"retype-password\");var inputType = pinField.getAttribute(\"type\");if(inputType==\"password\"){pinField.setAttribute(\"type\", \"text\");}if(inputType==\"text\"){pinField.setAttribute(\"type\", \"password\");}");
        Button button = event.getButton();
        if (button.getIcon().equals(FontAwesome.EYE)) {
            button.setIcon((Resource)FontAwesome.EYE_SLASH);
            return;
        }
        if (button.getIcon().equals(FontAwesome.EYE_SLASH)) {
            button.setIcon((Resource)FontAwesome.EYE);
            return;
        }
    }

    private void showOrHidePass(Button.ClickEvent event) {
        JavaScript.getCurrent().execute("var passField = document.getElementById(\"tf-password\");var passInputType = passField.getAttribute(\"type\");if(passInputType==\"password\"){passField.setAttribute(\"type\", \"text\");}if(passInputType==\"text\"){passField.setAttribute(\"type\", \"password\");}");
        Button button = event.getButton();
        if (button.getIcon().equals(FontAwesome.EYE)) {
            button.setIcon((Resource)FontAwesome.EYE_SLASH);
            return;
        }
        if (button.getIcon().equals(FontAwesome.EYE_SLASH)) {
            button.setIcon((Resource)FontAwesome.EYE);
            return;
        }
    }
}

