/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.ChartOfAccounts;
import com.floreantpos.model.DateTypeOption;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PayoutSubReason;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Project;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;
import com.floreantpos.model.dao.ChartOfAccountsDAO;
import com.floreantpos.model.dao.PayoutSubReasonDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaPayoutReasonCombobox;
import com.orocube.siiopa.cloud.client.SiiopaRecipientCombobox;
import com.orocube.siiopa.cloud.client.SiiopaUserCombobox;
import com.orocube.siiopa.cloud.client.curd.grid.ExpenseReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;

public class ExpenseReportView
extends ReportView {
    public static final String VIEW_NAME = "Expense report";
    public static final String SERVICE_VIEW_NAME = "Service order report";
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private List<PosTransaction> transactions;
    private ExpenseReportGrid grid;
    private SiiopaCombobox cbStoreOrAccountsManager;
    private SiiopaRecipientCombobox cbRecipient;
    private SiiopaPayoutReasonCombobox cbCategory;
    private SiiopaUserCombobox cbUser;
    private SiiopaCombobox cbProject;
    private SiiopaCombobox cbSubCategory;
    private boolean isByzlogicsExpense;
    private double balanceAfterExpense;
    private Double totalAmount = 0.0;
    private HorizontalLayout footerLayout;
    private VerticalLayout formLayout;
    private SiiopaCombobox cbAccountType;
    private boolean isServiceOrder;

    public ExpenseReportView() {
        this(false);
    }

    public ExpenseReportView(boolean isByzlogicsExpense) {
        this(isByzlogicsExpense, false);
    }

    public ExpenseReportView(boolean isByzlogicsExpense, boolean isServiceOrder) {
        super(UserPermission.EXPENSE_REPORT);
        this.isByzlogicsExpense = isByzlogicsExpense;
        this.isServiceOrder = isServiceOrder;
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                ExpenseReportView.this.updateAccountManagersCombo();
                ExpenseReportView.this.updateView();
            }
        };
        this.cbStoreOrAccountsManager = new SiiopaCombobox();
        this.updateAccountManagersCombo();
        this.cbStoreOrAccountsManager.setWidth("400px");
        this.cbStoreOrAccountsManager.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        List accounts = ChartOfAccountsDAO.getInstance().findAll();
        this.cbAccountType = new SiiopaCombobox();
        this.cbAccountType.setInputPrompt("Account type");
        this.cbAccountType.setWidth("1200px");
        this.cbAccountType.addItems(accounts);
        this.cbAccountType.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbRecipient = new SiiopaRecipientCombobox();
        this.cbRecipient.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbCategory = new SiiopaPayoutReasonCombobox();
        this.cbCategory.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbProject = new SiiopaCombobox();
        List project = ProjectDAO.getInstance().findAll();
        this.cbProject.addItems(project);
        this.cbProject.setWidth("400px");
        this.cbProject.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbSubCategory = new SiiopaCombobox();
        List subCatogry = PayoutSubReasonDAO.getInstance().findAll();
        this.cbSubCategory.addItems(subCatogry);
        this.cbSubCategory.setWidth("400px");
        this.cbSubCategory.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbUser = new SiiopaUserCombobox();
        this.cbUser.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        this.addDateFilters(topLayout);
        if (this.isByzlogicsExpense || this.isServiceOrder) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Project", (Component)this.cbProject));
        }
        if (!this.isServiceOrder) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Recipient", (Component)this.cbRecipient));
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Category", (Component)this.cbCategory));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sub category", (Component)this.cbSubCategory));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Expense by", (Component)this.cbUser));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Accounts manager", (Component)this.cbStoreOrAccountsManager));
        if (!this.isServiceOrder) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
            topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Account type", (Component)this.cbAccountType));
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.formLayout = new VerticalLayout();
        this.formLayout.addStyleName("bold");
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 3.0f);
        this.footerLayout = new HorizontalLayout();
        this.footerLayout.setWidth("100%");
        Label space = new Label();
        this.btnExportPdf.setWidthUndefined();
        space.setWidth("100%");
        this.formLayout.setWidthUndefined();
        this.footerLayout.addComponents(new Component[]{this.btnExportPdf, space, this.formLayout});
        this.footerLayout.setComponentAlignment((Component)this.formLayout, Alignment.MIDDLE_RIGHT);
        this.gridLayout.addComponent((Component)this.footerLayout);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(this.isServiceOrder ? SERVICE_VIEW_NAME : VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    public void updateAccountManagersCombo() {
        ArrayList<String> filterList = new ArrayList<String>();
        String outletId = null;
        Object value = this.cbOutlet.getValue();
        outletId = value instanceof Outlet ? ((Outlet)value).getId() : DataProvider.get().getOutletId();
        if (!this.isByzlogicsExpense) {
            filterList.add("Store");
            filterList.addAll(UserDAO.getInstance().findAccountsManager(outletId));
        } else {
            filterList.addAll(UserDAO.getInstance().getExpenseUsers(DataProvider.get().getCurrentUser(), true));
        }
        this.cbStoreOrAccountsManager.addItems(filterList);
    }

    protected void doClear() {
        this.cbOutlet.setValue(POSConstants.ALL);
        this.cbStoreOrAccountsManager.clear();
        this.clearDateFields();
        this.cbRecipient.clear();
        this.cbCategory.clear();
        this.cbSubCategory.clear();
        this.cbProject.clear();
        this.cbUser.clear();
        this.cbAccountType.clear();
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        String accountNo = "";
        Object storeOrAMValue = this.cbStoreOrAccountsManager.getValue();
        if (storeOrAMValue != null) {
            if (storeOrAMValue instanceof String) {
                accountNo = "1";
            } else if (storeOrAMValue instanceof User) {
                User user = (User)storeOrAMValue;
                accountNo = user.getId();
            }
        }
        String recipientId = null;
        Object selectedRecipient = this.cbRecipient.getValue();
        if (selectedRecipient != null && selectedRecipient instanceof PayoutRecepient) {
            PayoutRecepient payoutRecepient = (PayoutRecepient)selectedRecipient;
            recipientId = payoutRecepient.getId();
        }
        String categoryId = null;
        Object selectedReason = this.cbCategory.getValue();
        if (selectedReason != null && selectedReason instanceof PayoutReason) {
            PayoutReason payoutReason = (PayoutReason)selectedReason;
            categoryId = payoutReason.getId();
        }
        String projectId = null;
        Object selectedProject = this.cbProject.getValue();
        if (selectedProject != null && selectedProject instanceof Project) {
            Project project = (Project)selectedProject;
            projectId = project.getId();
        }
        String subCategoryId = null;
        Object selectedSubCategory = this.cbSubCategory.getValue();
        if (selectedSubCategory != null && selectedSubCategory instanceof PayoutSubReason) {
            PayoutSubReason subPayoutReason = (PayoutSubReason)selectedSubCategory;
            subCategoryId = subPayoutReason.getId();
        }
        String performByUserId = null;
        Object selectedUser = this.cbUser.getValue();
        if (selectedUser != null && selectedUser instanceof User) {
            User user = (User)selectedUser;
            performByUserId = user.getId();
        }
        String coaCode = null;
        Object selectedAccountType = this.cbAccountType.getValue();
        if (selectedAccountType != null && selectedAccountType instanceof ChartOfAccounts) {
            ChartOfAccounts selectedCOA = (ChartOfAccounts)selectedAccountType;
            coaCode = selectedCOA.getAccountCode();
        }
        this.transactions = PosTransactionDAO.getInstance().loadAllExpenseAndPurchaseTransaction(DateTypeOption.CREATE_DATE, startTime, endTime, recipientId, categoryId, projectId, subCategoryId, this.cbOutlet.getSelectedOrDefaultOutlet(), accountNo, performByUserId, coaCode, this.isServiceOrder, true);
        if (this.transactions != null && this.transactions.size() > 0) {
            for (PosTransaction posTransaction : this.transactions) {
                this.totalAmount = this.totalAmount + posTransaction.getExpenseAmount();
            }
        }
    }

    private double getBalanceAfterExpense(List<BalanceUpdateTransaction> transactions) {
        if (transactions == null || transactions.isEmpty()) {
            return 0.0;
        }
        transactions.sort(Comparator.comparing(BaseBalanceUpdateTransaction::getTransactionTime));
        BalanceUpdateTransaction lastTransaction = transactions.get(transactions.size() - 1);
        return lastTransaction.getBalanceBefore() + lastTransaction.getAmount();
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        StreamResource streamResource = null;
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getExpenseReportReportPrint(startTime, endTime, outlet, this.transactions, this.isByzlogicsExpense, false, "", false, "", this.totalAmount, this.isServiceOrder);
            streamResource = CommonCloudReportService.getReportStream(this.isServiceOrder ? "service-order-report" : "expense-report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.grid = new ExpenseReportGrid(this.isByzlogicsExpense, this.isServiceOrder);
        return this.grid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.totalAmount = 0.0;
            this.doSearch();
            this.grid.clearFooterCell();
            this.grid.setItems(this.transactions, this.totalAmount);
            this.gridLayout.setVisible(true);
            this.updateFooter();
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }

    private void updateFooter() {
        this.formLayout.setVisible(true);
        this.footerLayout.setHeight("80px");
    }
}

