/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.jdbc;

import com.orocube.siiopa.cloud.server.security.CurrentSession;
import org.apache.commons.lang.StringUtils;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;

public class SchemaResolver
implements CurrentTenantIdentifierResolver {
    public static final String TENANT_PUBLIC = "public";
    private static final ThreadLocal<String> tenant = new ThreadLocal();

    public static void setTenant(String tenantName) {
        if (StringUtils.isBlank((String)tenantName)) {
            SchemaResolver.setPublicTenant();
        } else {
            tenant.set(tenantName);
            CurrentSession.setCurrentSchema(tenantName);
        }
    }

    public String resolveCurrentTenantIdentifier() {
        String currentTenant = SchemaResolver.getCurrentTenant();
        return currentTenant;
    }

    public boolean validateExistingCurrentSessions() {
        return false;
    }

    public static void initTenant(String tenant) {
        SchemaResolver.setTenant(tenant);
    }

    public static void setPublicTenant() {
        tenant.set(TENANT_PUBLIC);
        CurrentSession.setCurrentSchema(TENANT_PUBLIC);
    }

    public static String getCurrentTenant() {
        String currentTenant = CurrentSession.getCurrentSchema();
        if (StringUtils.isEmpty((String)currentTenant)) {
            currentTenant = tenant.get();
        }
        return currentTenant;
    }

    public static void setTenantWithoutSettingToSession(String storeId) {
        tenant.set(storeId);
    }
}

