/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.PosException;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.crud.util.CloudNumberUtil;
import com.orocube.siiopa.cloud.client.curd.grid.convater.DoubleFormatConverter;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.DoubleRangeValidator;
import com.vaadin.ui.AbstractTextField;
import com.vaadin.ui.TextField;
import org.apache.commons.lang.StringUtils;

public class SiiopaDoubleTextField
extends TextField {
    public SiiopaDoubleTextField() {
        this.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        this.setMaxLength(11);
        this.addCustomConvator(8, 6);
    }

    public SiiopaDoubleTextField(boolean enableInlineValidation) {
        this.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        this.setMaxLength(11);
        this.addCustomConvator(8, 6, enableInlineValidation);
    }

    public SiiopaDoubleTextField(String caption) {
        this(caption, 8, 6);
    }

    public SiiopaDoubleTextField(String caption, int beforeDecimal, int afterDecimal) {
        super(caption);
        this.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        this.setMaxLength(beforeDecimal + afterDecimal + 1);
        this.addCustomConvator(beforeDecimal, afterDecimal);
    }

    public SiiopaDoubleTextField(Property<?> dataSource) {
        this(dataSource, 8, 6);
    }

    public SiiopaDoubleTextField(Property<?> dataSource, int beforeDecimal, int afterDecimal) {
        super(dataSource);
        this.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        this.setMaxLength(beforeDecimal + afterDecimal + 1);
        this.addCustomConvator(beforeDecimal, afterDecimal);
    }

    public SiiopaDoubleTextField(String caption, Property<?> dataSource) {
        this(caption, dataSource, 8, 6);
    }

    public SiiopaDoubleTextField(String caption, Property<?> dataSource, int beforeDecimal, int afterDecimal) {
        super(caption, dataSource);
        this.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        this.setMaxLength(beforeDecimal + afterDecimal + 1);
        this.addCustomConvator(beforeDecimal, afterDecimal);
    }

    public SiiopaDoubleTextField(String caption, String value) {
        this(caption, value, 8, 6);
    }

    public SiiopaDoubleTextField(String caption, String value, int beforeDecimal, int afterDecimal) {
        super(caption, value);
        this.setTextChangeEventMode(AbstractTextField.TextChangeEventMode.EAGER);
        this.setMaxLength(beforeDecimal + afterDecimal + 1);
        this.addCustomConvator(beforeDecimal, afterDecimal);
    }

    private void addCustomConvator(int beforeDecimal, int afterDecimal) {
        this.addCustomConvator(beforeDecimal, afterDecimal, true);
    }

    private void addCustomConvator(int beforeDecimal, int afterDecimal, boolean enableInlineValidation) {
        if (enableInlineValidation) {
            this.setConverter(new DoubleFormatConverter(beforeDecimal, afterDecimal));
            String doCreateMaxValue = CloudNumberUtil.doCreateMaxValue(beforeDecimal, afterDecimal);
            this.addValidator((Validator)new DoubleRangeValidator(ConsoleMessages.getString("INPUT_IS_OUT_OF_RANGE"), Double.valueOf(0.0), Double.valueOf(doCreateMaxValue)));
        }
    }

    public double getDouble() {
        String text = (String)this.getValue();
        if (StringUtils.isBlank((String)text)) {
            return Double.NaN;
        }
        return NumberUtil.parseOrGetZero((String)text).doubleValue();
    }

    public double getDoubleOrZero() {
        return NumberUtil.parseOrGetZero((String)((String)this.getValue())).doubleValue();
    }

    public void verifyVaildDoubleInput() throws PosException {
        this.getValidDoubleValue();
    }

    public double getValidDoubleValue() throws PosException {
        double doubleValue;
        String value = (String)this.getValue();
        try {
            if (!NumberUtil.isValidDouble((String)value)) {
                this.selectAll();
                this.focus();
                throw new PosException(ConsoleMessages.getString("InputIsNotValid"));
            }
            doubleValue = NumberUtil.parseDouble((String)value);
            if (doubleValue < 0.0) {
                this.selectAll();
                this.focus();
                throw new PosException(ConsoleMessages.getString("NegativeValueNotAllowed"));
            }
        }
        catch (NumberFormatException e) {
            this.selectAll();
            this.focus();
            throw new PosException(ConsoleMessages.getString("InputIsNotValid"));
        }
        return doubleValue;
    }

    public void setFieldRightAligment() {
        this.addStyleName("align-right");
    }
}

