/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.dao.GlobalConfigDAO;
import com.floreantpos.model.util.SyncUtil;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.util.POSUtil;
import com.kbdunn.vaadin.addons.fontawesome.FontAwesome;
import com.orocube.rest.service.mqtt.OroMqttClient;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.InlineFormContainer;
import com.orocube.siiopa.cloud.client.YesNoDialog;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Resource;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class BeanInlineEditorView<T>
extends VerticalLayout
implements View,
RefreshableView {
    protected boolean canceled = true;
    protected Button btnSave = CommonUIUtil.createColorButton(ConsoleMessages.getString("BeanEditorView.0"));
    protected Button btnCancel = CommonUIUtil.createColorButton(POSConstants.CLOSE);
    protected boolean hasModelChanges = false;
    protected BeanFieldGroup<T> binder;
    private T bean;
    private boolean viewInitialized = false;
    private boolean hidePanelBorder;
    private Label heading;
    private Panel container;

    public void setCancelButtonVisible(boolean visible) {
        this.btnCancel.setVisible(visible);
    }

    public void setHidePanelBorder(boolean hidePanelBorder) {
        this.hidePanelBorder = hidePanelBorder;
    }

    public void setHeading(String caption) {
        this.heading.setValue(caption);
        this.heading.addStyleName("padding-right-20px");
    }

    public BeanInlineEditorView() {
    }

    public BeanInlineEditorView(boolean hidePanelBorder) {
        this.hidePanelBorder = hidePanelBorder;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.bean = this.getBean();
        if (this.bean == null) {
            return;
        }
        if (!this.viewInitialized) {
            this.initUI();
            this.viewInitialized = true;
        }
    }

    public boolean isViewInitialized() {
        return this.viewInitialized;
    }

    private void initUI() {
        try {
            this.setSizeFull();
            this.addStyleName("inline_editor");
            this.binder = new BeanFieldGroup(this.bean.getClass());
            this.binder.setItemDataSource(this.bean);
            AbstractOrderedLayout formLayout = this.createForm(this.binder);
            this.updateForm(this.bean);
            this.hasModelChanges = false;
            this.btnSave.setStyleName("save");
            this.btnSave.addClickListener((Button.ClickListener & Serializable)e -> this.saveButtonClicked());
            this.btnCancel.addClickListener((Button.ClickListener & Serializable)event -> this.doClose());
            HorizontalLayout buttonLayout = new HorizontalLayout();
            buttonLayout.addStyleName("margin-top-five lumo-button-layout margin-bottom-five margin-right-five");
            buttonLayout.setSpacing(true);
            buttonLayout.addComponent((Component)this.btnSave);
            buttonLayout.addComponent((Component)this.btnCancel);
            this.btnSave.setVisible(!POSUtil.getBoolean((String)GlobalConfigDAO.getInstance().getProperty("edit_items.pos_only")));
            this.addButton(buttonLayout);
            buttonLayout.setComponentAlignment((Component)this.btnSave, Alignment.MIDDLE_CENTER);
            buttonLayout.setComponentAlignment((Component)this.btnCancel, Alignment.MIDDLE_CENTER);
            HorizontalLayout contentLayout = new HorizontalLayout();
            contentLayout.setMargin(false);
            formLayout.addComponent((Component)contentLayout);
            this.initComponents(contentLayout);
            this.container = new Panel();
            if (this.hidePanelBorder) {
                this.container.addStyleName("borderless");
            }
            this.container.setSizeFull();
            this.container.setContent((Component)formLayout);
            HorizontalLayout headerLayout = new HorizontalLayout();
            headerLayout.addStyleName("inline_header_layout");
            headerLayout.setHeight("40px");
            headerLayout.setWidth("100%");
            headerLayout.setSpacing(true);
            CloudButton btnClose = CommonUIUtil.createColorButton("");
            btnClose.setIcon((Resource)FontAwesome.CLOSE);
            btnClose.addStyleName("btn-close");
            this.heading = new Label();
            this.heading.addStyleName("margin-left-five bold-style ellipsis-form-header");
            btnClose.addClickListener((Button.ClickListener & Serializable)event -> this.doClose());
            headerLayout.addComponents(new Component[]{this.heading, btnClose});
            headerLayout.setComponentAlignment((Component)btnClose, Alignment.MIDDLE_CENTER);
            headerLayout.setComponentAlignment((Component)this.heading, Alignment.MIDDLE_LEFT);
            headerLayout.setExpandRatio((Component)this.heading, 1.0f);
            this.addComponents(new Component[]{headerLayout, this.container, buttonLayout});
            this.setComponentAlignment((Component)buttonLayout, Alignment.MIDDLE_RIGHT);
            this.setExpandRatio((Component)this.container, 1.0f);
        }
        catch (Exception e2) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e2);
        }
    }

    protected void doClose() {
        InlineFormContainer formContainer = BeanInlineEditorView.getParentContainer((Component)this);
        if (formContainer != null) {
            formContainer.setVisible(false);
        }
    }

    public static InlineFormContainer getParentContainer(Component child) {
        if (child == null) {
            return null;
        }
        if (child instanceof InlineFormContainer) {
            return (InlineFormContainer)child;
        }
        return BeanInlineEditorView.getParentContainer((Component)child.getParent());
    }

    protected boolean doCheckValidation() {
        return false;
    }

    protected abstract boolean save();

    public abstract AbstractOrderedLayout createForm(BeanFieldGroup<T> var1);

    protected void updateForm(T bean) {
    }

    public abstract void initComponents(HorizontalLayout var1);

    protected void addButton(HorizontalLayout buttonLayout) {
    }

    public T getBean() {
        return this.bean;
    }

    public void setBean(T bean) {
        this.bean = bean;
    }

    public T getProduct() {
        return (T)this.binder.getItemDataSource().getBean();
    }

    private void doPublish() {
        String name;
        Class<?> class1 = this.getProduct().getClass();
        if (class1 != null && StringUtils.isNotBlank((String)(name = class1.getName()))) {
            String modelName = name.substring(name.lastIndexOf(46) + 1);
            List outletRelatedModelClasses = SyncUtil.getOutletRelatedModelClasses();
            if (outletRelatedModelClasses.contains(modelName)) {
                try {
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor("outletId", class1);
                    Object outletId = propertyDescriptor.getReadMethod().invoke(this.getProduct(), (Object[])null);
                    if (outletId != null) {
                        OroMqttClient.getInstance().publishToOutlet("MQTT-COMMAND", "4", outletId.toString());
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            OroMqttClient.getInstance().publishData("MQTT-COMMAND", "4");
        }
    }

    public void refresh() {
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    private void handleDuplicteDataError(DuplicateDataException e) {
        String message = e.getMessage() + ConsoleMessages.getString("MenuItemForm.51");
        String title = ConsoleMessages.getString("MenuModifierForm.7");
        CloudNotification.showCustomYesNoDialog(title, message, new YesNoDialog.Callback(){

            @Override
            public void dialogClosed(boolean isApproved) {
                if (isApproved) {
                    try {
                        BeanInlineEditorView.this.binder.commit();
                        if (!BeanInlineEditorView.this.save()) {
                            return;
                        }
                        if (BeanInlineEditorView.this.showSuccessfullyMessage()) {
                            CloudNotification.showMessage(ConsoleMessages.getString("BeanEditorView.3"));
                        }
                        BeanInlineEditorView.this.doPublish();
                        BeanInlineEditorView.this.doClose();
                    }
                    catch (PosException e) {
                        CloudNotification.showErrorMessage(e.getMessage());
                    }
                    catch (FieldGroup.CommitException e) {
                        Notification n = new Notification(ConsoleMessages.getString("BeanEditorView.5"), Notification.Type.ERROR_MESSAGE);
                        n.setDelayMsec(500);
                        n.show(BeanInlineEditorView.this.getUI().getPage());
                    }
                    catch (Exception e) {
                        PosLog.error(this.getClass(), (Exception)e);
                        Notification n = new Notification(ConsoleMessages.getString("BeanEditorView.6") + e.getMessage(), Notification.Type.ERROR_MESSAGE);
                        n.setDelayMsec(500);
                        n.show(BeanInlineEditorView.this.getUI().getPage());
                    }
                }
            }
        }, ConsoleMessages.getString("Yes"), ConsoleMessages.getString("No"));
    }

    private void saveButtonClicked() {
        try {
            if (this.doCheckValidation()) {
                return;
            }
            this.binder.commit();
            if (!this.save()) {
                return;
            }
            if (this.showSuccessfullyMessage()) {
                CloudNotification.showMessage(ConsoleMessages.getString("BeanEditorView.3"));
            }
            this.setCanceled(false);
            this.doPublish();
            this.doClose();
        }
        catch (Validator.InvalidValueException e) {
            CloudNotification.showErrorMessage(e.getMessage());
        }
        catch (DuplicateDataException e) {
            this.handleDuplicteDataError(e);
        }
        catch (PosException e) {
            CloudNotification.showErrorMessage(e.getMessage());
        }
        catch (FieldGroup.CommitException e) {
            CloudNotification.showErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e);
            CloudNotification.showErrorMessage(e.getMessage());
        }
    }

    protected boolean showSuccessfullyMessage() {
        return true;
    }

    protected void addContainerStyle(String styleName) {
        if (this.container != null) {
            this.container.addStyleName(styleName);
        }
    }

    public void setContainerEnabled(boolean enabled) {
        this.container.setEnabled(enabled);
        this.btnSave.setEnabled(enabled);
    }
}

