/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public class YesNoDialog
extends Window
implements Button.ClickListener {
    private Callback callback;
    private Button yes = CommonUIUtil.createColorButtonListner(ConsoleMessages.getString("YesNoDialog.0"), this);
    private Button no = CommonUIUtil.createColorButtonListner(ConsoleMessages.getString("YesNoDialog.1"), this);
    private boolean noOptionCallback;

    public void setYesButtonCaption(String caption) {
        this.yes.setCaption(caption);
    }

    public void setYesButtonCaption(String caption, String style) {
        this.setYesButtonCaption(caption);
        if (style != null) {
            this.yes.setStyleName(style);
        }
    }

    public void setNoButtonCaption(String caption) {
        this.no.setCaption(caption);
    }

    public YesNoDialog(String caption, String question, Callback callback) {
        this(caption, question, callback, true);
    }

    public YesNoDialog(String caption, String question, Callback callback, boolean noOptionCallback) {
        super(caption);
        this.callback = callback;
        this.noOptionCallback = noOptionCallback;
        this.setModal(true);
        this.setResizable(false);
        this.center();
        this.setClosable(false);
        this.setWidth("400px");
        this.setHeight("200px");
        VerticalLayout mainContent = new VerticalLayout();
        mainContent.setSizeFull();
        Panel mainPanel = new Panel();
        mainPanel.addStyleName("borderless");
        mainPanel.setHeight("100%");
        if (question != null) {
            Label lblQuestion = new Label(question);
            lblQuestion.setWidth("80%");
            lblQuestion.addStyleName("custom-heading");
            mainPanel.setContent((Component)lblQuestion);
        }
        HorizontalLayout buttonPanel = new HorizontalLayout();
        buttonPanel.setWidth("100%");
        buttonPanel.setSpacing(true);
        buttonPanel.addStyleName("custom-button-margin");
        this.yes.setSizeFull();
        this.no.setSizeFull();
        buttonPanel.addComponents(new Component[]{this.yes, this.no});
        mainContent.addComponents(new Component[]{mainPanel, buttonPanel});
        mainContent.setExpandRatio((Component)mainPanel, 1.0f);
        mainContent.setComponentAlignment((Component)buttonPanel, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)mainContent);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getSource() == this.yes) {
            if (this.callback != null) {
                this.callback.dialogClosed(true);
            }
        } else if (event.getSource() == this.no && this.noOptionCallback) {
            this.callback.dialogClosed(false);
        }
        this.close();
    }

    public static interface Callback {
        public void dialogClosed(boolean var1);
    }
}

