/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.crud.view;

import com.floreantpos.PosLog;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.dao.BankAccountDAO;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.AddBalanceToBankAccountWindow;
import com.orocube.siiopa.cloud.client.BeanExplorerGridView;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.InlineFormContainer;
import com.orocube.siiopa.cloud.client.InlineFormEditorWindow;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.SiiopaBankNameCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.action.DeleteBankAccountAction;
import com.orocube.siiopa.cloud.client.crud.form.inline.BankAccountInlineForm;
import com.orocube.siiopa.cloud.client.crud.view.BankTransactionHistoryView;
import com.orocube.siiopa.cloud.client.curd.grid.BankAccountGrid;
import com.vaadin.data.Property;
import com.vaadin.event.SelectionEvent;
import com.vaadin.event.ShortcutListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.List;

public class BankAccountCrudView
extends BeanExplorerGridView<BankAccount> {
    public static final String VIEW_NAME = "Bank Accounts";
    private OutletCombobox cbOutlet;
    private SiiopaBankNameCombobox cbBankName;
    private SiiopaTextField tfAccountName;
    private SiiopaTextField tfAccountNumber;
    private Button btnSearch;

    @Override
    public VerticalLayout createTopBar() {
        ShortcutListener shortcutListener = new ShortcutListener(ConsoleMessages.getString("ShopTableCrudView.1"), 13, null){

            public void handleAction(Object sender, Object target) {
                PosLog.debug(BankAccountCrudView.class, (String)"button listener fired");
                if (target == BankAccountCrudView.this.btnSearch) {
                    BankAccountCrudView.this.doSearch();
                }
            }
        };
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                BankAccountCrudView.this.doSearch();
            }
        };
        this.cbBankName = new SiiopaBankNameCombobox();
        this.cbBankName.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.doSearch());
        this.tfAccountName = new SiiopaTextField();
        this.tfAccountName.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.doSearch());
        this.tfAccountNumber = new SiiopaTextField();
        this.btnSearch = CommonUIUtil.createColorButton("");
        this.btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        this.btnSearch.addShortcutListener(shortcutListener);
        this.btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.doSearch());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.doSearch();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        if (this.cbOutlet.isVisible()) {
            topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        }
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Bank Name", (Component)this.cbBankName));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Account Name", (Component)this.tfAccountName));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Account No", (Component)this.tfAccountNumber));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout(this.btnSearch, (Object)btnClear));
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        Component searchContainer = CommonUIUtil.getSearchContainer((Component)topLayout);
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), searchContainer});
        return mainTopLayout;
    }

    private void doClear() {
        this.cbBankName.setValue(null);
        this.tfAccountName.setValue("");
        this.tfAccountNumber.setValue("");
    }

    @Override
    public void updateView(Pagination<BankAccount> pagination) {
        String bankName = (String)this.cbBankName.getValue();
        String accountName = this.tfAccountName.getValue();
        String accountNo = this.tfAccountNumber.getValue();
        Outlet outlet = (Outlet)this.cbOutlet.getValue();
        List bankAccounts = BankAccountDAO.getInstance().findBankAccount(bankName, accountName, accountNo, outlet);
        this.grid.setItems(bankAccounts);
    }

    @Override
    protected void doCreateNewItem() {
        this.doOpenCreateItemWindow(new BankAccount());
    }

    protected void doOpenCreateItemWindow(BankAccount bankAccount) {
        this.setInlineFromVisible(false);
        InlineFormEditorWindow window = new InlineFormEditorWindow();
        BankAccountInlineForm inlineForm = this.getBankAccountInlineForm(bankAccount, window);
        window.open(inlineForm);
    }

    @Override
    protected void doEditItem(BankAccount bankAccount) {
        if (bankAccount == null) {
            String info = ConsoleMessages.getString("CurrencyCrudView.3");
            CommonUIUtil.showMessageDialog(info);
            return;
        }
        InlineFormEditorWindow window = new InlineFormEditorWindow();
        BankAccountInlineForm inlineForm = this.getBankAccountInlineForm(bankAccount, window);
        window.open(inlineForm);
    }

    private BankAccountInlineForm getBankAccountInlineForm(BankAccount bankAccount, InlineFormEditorWindow window) {
        BankAccountInlineForm inlineForm = new BankAccountInlineForm(this, bankAccount, window);
        inlineForm.setHidePanelBorder(true);
        inlineForm.setSizeFull();
        inlineForm.enter(null);
        if (bankAccount.getId() == null) {
            inlineForm.setHeading("New bank account");
        } else {
            inlineForm.setHeading(bankAccount.getBankName());
        }
        return inlineForm;
    }

    @Override
    protected void doDeleteItem(BankAccount bankAccount) {
        if (bankAccount == null) {
            CommonUIUtil.showMessageDialog("Please select bank account.");
            return;
        }
        DeleteBankAccountAction deleteAction = new DeleteBankAccountAction(this.grid, bankAccount);
        deleteAction.execute();
    }

    @Override
    protected BeanGrid<BankAccount> createItemGrid() {
        BankAccountGrid paymentGrid = new BankAccountGrid();
        paymentGrid.addStyleName("custom-grid-cell-focus");
        paymentGrid.addSelectionListener((SelectionEvent.SelectionListener & Serializable)event -> this.doSelectItem(this.getSelectedRow()));
        return paymentGrid;
    }

    @Override
    protected void addButton(HorizontalLayout buttonLayout) {
        this.setEditDeleteVisible(false);
        CloudButton btnAddBalance = CommonUIUtil.createColorButton("Add balance");
        btnAddBalance.addClickListener((Button.ClickListener & Serializable)event -> this.doAddBalance());
        buttonLayout.addComponent((Component)btnAddBalance);
        CloudButton btnTransHistory = CommonUIUtil.createColorButton("History");
        btnTransHistory.addClickListener((Button.ClickListener & Serializable)event -> this.doOpenTransHistoryDialog());
        buttonLayout.addComponent((Component)btnTransHistory);
    }

    private void doOpenTransHistoryDialog() {
        BankAccount selectedRow = this.getSelectedRow();
        if (selectedRow == null) {
            CloudNotification.showMessage("Please select a bank account");
            return;
        }
        this.setInlineFromVisible(false);
        new BankTransactionHistoryView("Bank transaction history", selectedRow).openFullScreen();
    }

    private void doAddBalance() {
        BankAccount selectedRow = this.getSelectedRow();
        if (selectedRow == null) {
            CloudNotification.showMessage("Please select bank account");
            return;
        }
        this.setInlineFromVisible(false);
        AddBalanceToBankAccountWindow balanceDialog = new AddBalanceToBankAccountWindow("Add Balance", selectedRow);
        balanceDialog.setWidth("400");
        balanceDialog.setHeight("320");
        balanceDialog.open();
        balanceDialog.addCloseListener((Window.CloseListener & Serializable)e -> this.doCloseAddBalanceDialog(balanceDialog, selectedRow));
    }

    private void doCloseAddBalanceDialog(AddBalanceToBankAccountWindow d, BankAccount selectedRow) {
        if (d.isCanceled()) {
            return;
        }
        this.grid.refreshRows(new Object[]{selectedRow});
    }

    private void setEditDeleteVisible(boolean visible) {
        this.setEditProductVisible(visible);
        this.setDeleteProductVisible(visible);
    }

    private void doSearch() {
        this.reloadPage();
    }

    public BankAccount getSelectedRow() {
        return (BankAccount)this.grid.getSelectedRow();
    }

    protected void doSelectItem(BankAccount bankAccount) {
        Component layout = this.getContainer();
        if (layout == null) {
            if (bankAccount != null) {
                this.setEditDeleteVisible(true);
            } else {
                this.setEditDeleteVisible(false);
            }
            return;
        }
        if (layout instanceof InlineFormContainer) {
            InlineFormContainer formContainer = (InlineFormContainer)layout;
            formContainer.setVisible(true);
            if (bankAccount == null) {
                layout.setVisible(false);
                this.setEditDeleteVisible(false);
                return;
            }
            this.setEditDeleteVisible(true);
            formContainer.removeAllComponents();
            BankAccountDAO.getInstance().refresh((Object)bankAccount);
            BankAccountInlineForm inlineForm = this.getBankAccountInlineForm(bankAccount, null);
            formContainer.addComponent((Component)inlineForm);
        }
    }
}

