/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.util.NumberUtil;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.data.util.MethodProperty;
import com.vaadin.ui.Grid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.NumberRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class BeanGrid<T>
extends Grid {
    private int pageSize = 20;
    private int currentPage = 0;
    private List<CellDataStyle> cellDataRenderers = new ArrayList<CellDataStyle>();
    private NumberFormat doubleZeroFormat = new DecimalFormat("0.00");
    private NumberFormat numberFormatWithSixDigit = new DecimalFormat("0.######");

    public BeanGrid() {
        this(false);
    }

    public BeanGrid(boolean editable) {
        if (editable) {
            this.setStyleName("editable-grid");
        }
        this.setSizeFull();
        this.setSelectionMode(Grid.SelectionMode.SINGLE);
        this.setCellStyleGenerator(this.buildCellStyleGenerator(null));
    }

    public void addColumn(String displayString, String fieldName) {
        this.addColumn(fieldName).setHeaderCaption(displayString);
    }

    public void addColumn(String displayString, String fieldName, Class type) {
        this.addColumn(fieldName, type).setHeaderCaption(displayString);
    }

    public void removeHeaderSort() {
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
    }

    public void addColumn(String displayString, Class type, DATA_ALIGN dataAlign, boolean isFormatNumber) {
        this.addColumn(displayString, type).setHeaderCaption(displayString);
        this.cellDataRenderers.add(new CellDataStyle(displayString, dataAlign, isFormatNumber));
        this.rightAlignedColumnHeader(displayString, dataAlign);
    }

    public void addColumn(String displayString, String fieldName, Class type, DATA_ALIGN dataAlign, boolean isFormatNumber) {
        this.addColumn(fieldName, type).setHeaderCaption(displayString);
        this.cellDataRenderers.add(new CellDataStyle(fieldName, dataAlign, isFormatNumber));
        this.rightAlignedColumnHeader(fieldName, dataAlign);
    }

    public void addColumn(String displayString, String fieldName, Class type, DATA_ALIGN dataAlign, BeanTableModel.DataType dataType) {
        this.addColumn(fieldName, type).setHeaderCaption(displayString);
        this.cellDataRenderers.add(new CellDataStyle(fieldName, dataAlign, dataType, true));
        this.rightAlignedColumnHeader(fieldName, dataAlign);
    }

    private void rightAlignedColumnHeader(String fieldName, DATA_ALIGN dataAlign) {
        Grid.HeaderRow headerRow = this.getDefaultHeaderRow();
        if (headerRow != null && DATA_ALIGN.RIGHT_ALIGN == dataAlign) {
            Grid.HeaderCell headerCell = (Grid.HeaderCell)headerRow.getCell((Object)fieldName);
            headerCell.setStyleName("header-text-align");
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public abstract boolean hidePagination();

    public boolean hidePageSizeCombo() {
        return Boolean.FALSE;
    }

    public boolean hideAllFromPageSizeCombo() {
        return Boolean.TRUE;
    }

    public boolean hideFirstLast() {
        return Boolean.TRUE;
    }

    public T getSelectedRow() throws IllegalStateException {
        return (T)super.getSelectedRow();
    }

    public void setItems(Collection<T> items) {
        BeanItemContainer container = new BeanItemContainer(this.getReferenceClass());
        if (items != null) {
            container.addAll(items);
        }
        this.setContainerDataSource((Container.Indexed)container);
    }

    public void addOrUpdateItem(Object product) {
        this.addOrUpdateItem(product, 0);
    }

    public void addOrUpdateItem(Object product, int index) {
        Item item = this.getContainerDataSource().getItem(product);
        if (item != null) {
            MethodProperty p = (MethodProperty)item.getItemProperty((Object)"id");
            if (p == null) {
                p = (MethodProperty)item.getItemProperty((Object)"autoId");
            }
            p.fireValueChange();
        } else if (index < 0) {
            this.getContainerDataSource().addItem(product);
        } else {
            this.getContainerDataSource().addItemAt(index, product);
        }
    }

    public void addItemAfter(Object previousProduct, Object newProduct) {
        this.getContainerDataSource().addItemAfter(previousProduct, newProduct);
    }

    public void remove(T product) {
        this.getContainer().removeItem(product);
    }

    public int getRowCount() {
        Container.Indexed source = this.getContainerDataSource();
        if (source != null) {
            return source.size();
        }
        return 0;
    }

    public void removeAll() {
        Container.Indexed source = this.getContainerDataSource();
        if (source != null) {
            source.removeAllItems();
        }
    }

    public void setFilter(String filterString) {
    }

    public BeanItemContainer<T> getContainer() {
        return (BeanItemContainer)super.getContainerDataSource();
    }

    public abstract Class getReferenceClass();

    public Grid.CellStyleGenerator buildCellStyleGenerator(final Map<String, String> customColumnStyleMap) {
        return new Grid.CellStyleGenerator(){

            public String getStyle(Grid.CellReference cellReference) {
                Set keySet;
                ArrayList<String> styles = new ArrayList<String>();
                if (!BeanGrid.this.cellDataRenderers.isEmpty()) {
                    for (CellDataStyle rowDataStyleRenderer : BeanGrid.this.cellDataRenderers) {
                        String fieldName = rowDataStyleRenderer.fieldName;
                        if (fieldName == null) continue;
                        if (rowDataStyleRenderer.isFormatNumber && BeanGrid.this.getColumn(fieldName) != null) {
                            NumberRenderer renderer;
                            BeanTableModel.DataType dataType = rowDataStyleRenderer.dataType;
                            switch (dataType) {
                                case MONEY: {
                                    renderer = new NumberRenderer(NumberUtil.getNumberFormat());
                                    break;
                                }
                                case NUMBER: {
                                    renderer = new NumberRenderer(BeanGrid.this.numberFormatWithSixDigit);
                                    break;
                                }
                                default: {
                                    renderer = new NumberRenderer(BeanGrid.this.doubleZeroFormat);
                                }
                            }
                            BeanGrid.this.getColumn(fieldName).setRenderer((Renderer)renderer);
                        }
                        if (!fieldName.equals(cellReference.getPropertyId())) continue;
                        styles.add(rowDataStyleRenderer.dataAlign.getValue());
                    }
                } else {
                    styles.add(DATA_ALIGN.LEFT_ALIGN.getValue());
                }
                if (customColumnStyleMap != null && (keySet = customColumnStyleMap.keySet()) != null) {
                    for (String columnKey : keySet) {
                        String styleName;
                        if (StringUtils.isBlank((String)columnKey) || StringUtils.isBlank((String)(styleName = (String)customColumnStyleMap.get(columnKey))) || !columnKey.equals(cellReference.getPropertyId())) continue;
                        String expiryDate = (String)cellReference.getValue();
                        try {
                            Date colExpiryDate = DateUtil.parseBySortDate((String)expiryDate);
                            if (colExpiryDate == null || !colExpiryDate.before(StoreDAO.getServerTimestamp())) continue;
                            styles.add(styleName);
                        }
                        catch (Exception exception) {}
                    }
                }
                return String.join((CharSequence)" ", styles);
            }
        };
    }

    public void renderGridUi() {
    }

    public static enum DATA_ALIGN {
        LEFT_ALIGN("leftAligned"),
        RIGHT_ALIGN("rightAligned"),
        CENTER_ALIGN("centerAligned");

        private String align;

        private DATA_ALIGN(String align) {
            this.align = align;
        }

        public String getValue() {
            return this.align;
        }

        public static DATA_ALIGN get(int value) {
            switch (value) {
                case 0: {
                    return LEFT_ALIGN;
                }
                case 1: {
                    return RIGHT_ALIGN;
                }
                case 2: {
                    return CENTER_ALIGN;
                }
            }
            return LEFT_ALIGN;
        }

        public String toString() {
            return this.name();
        }
    }

    private class CellDataStyle
    implements Serializable {
        protected String fieldName;
        protected DATA_ALIGN dataAlign;
        protected boolean isFormatNumber;
        protected BeanTableModel.DataType dataType;

        public CellDataStyle(String fieldName, DATA_ALIGN dataAlign, boolean isFormatNumber) {
            this.fieldName = fieldName;
            this.dataAlign = dataAlign;
            this.isFormatNumber = isFormatNumber;
            this.dataType = BeanTableModel.DataType.MONEY;
        }

        public CellDataStyle(String fieldName, DATA_ALIGN dataAlign, BeanTableModel.DataType dataType, boolean isFormatNumber) {
            this.fieldName = fieldName;
            this.dataAlign = dataAlign;
            this.isFormatNumber = isFormatNumber;
            this.dataType = dataType;
        }
    }
}

