/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.page;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.DoneCancelWindow;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.vaadin.data.Validator;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import org.apache.commons.lang.StringUtils;

public class CloudInputDialog
extends DoneCancelWindow {
    private SiiopaTextField tfTextField;
    private String infoMessage;
    private Validator validator;

    public CloudInputDialog() {
    }

    public CloudInputDialog(String textFieldCaption) {
        this(textFieldCaption, "");
    }

    public CloudInputDialog(String textFieldCaption, String infoMessage) {
        super(ConsoleMessages.getString("CloudInputDialog.0"));
        this.infoMessage = infoMessage;
        this.setOkButtonText(POSConstants.CONFIRM);
        this.setModal(true);
        this.tfTextField.setCaption(textFieldCaption);
    }

    @Override
    public boolean doOk() {
        try {
            String descriptionValue = this.tfTextField.getValue();
            if (StringUtils.isBlank((String)descriptionValue)) {
                if (StringUtils.isBlank((String)this.infoMessage)) {
                    this.infoMessage = ConsoleMessages.getString("CloudTextInputDialog.0");
                }
                CloudNotification.showMessageDialog(this.infoMessage);
                return false;
            }
            if (this.validator != null) {
                this.tfTextField.validate();
            }
            return true;
        }
        catch (Validator.InvalidValueException e) {
            CloudNotification.showErrorMessageDialog(e.getMessage());
            return false;
        }
        catch (Exception e) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e);
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void initUI(HorizontalLayout contentPane) {
        FormLayout formLayout = new FormLayout();
        formLayout.setMargin(true);
        formLayout.setSpacing(true);
        formLayout.addStyleName("margin-top-20px");
        this.tfTextField = new SiiopaTextField();
        this.tfTextField.setWidth("100%");
        this.setFieldLength(120);
        formLayout.addComponent((Component)this.tfTextField);
        contentPane.addComponent((Component)formLayout);
    }

    public void setTfvalue(String textValue) {
        this.tfTextField.setValue(textValue);
    }

    public String getTfvalue() {
        return this.tfTextField.getValue();
    }

    public void addValidator(Validator validator) {
        this.validator = validator;
        this.tfTextField.addValidator(validator);
        this.tfTextField.setRequired(true);
    }

    public void setFieldLength(int maxLength) {
        this.tfTextField.setMaxLength(maxLength);
    }
}

