/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.PurchaseOrder;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import java.util.Collection;

public class AccountsPayableReportGrid
extends FooterSupportedBeanGrid<PurchaseOrder> {
    public AccountsPayableReportGrid() {
        this.addColumn("P.O No", PurchaseOrder.PROP_ORDER_ID, String.class);
        this.addColumn("Order date", "createdDateAsString", String.class);
        this.addColumn("Vendor", "vendorDisplay", String.class);
        this.addColumn("Project", "projectNameDisplay", String.class);
        this.addColumn("Total", PurchaseOrder.PROP_TOTAL_AMOUNT, String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.addColumn("Paid", "paidAmount", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.addColumn("Due", "dueAmount", String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.showSummaryRow("dueAmount", PurchaseOrder.PROP_ORDER_ID, "vendorDisplay", "createdDateAsString", PurchaseOrder.PROP_TOTAL_AMOUNT, "paidAmount", "projectNameDisplay");
    }

    @Override
    public void setItems(Collection<PurchaseOrder> items) {
        super.setItems(items);
        double totalDueAmount = 0.0;
        if (items != null && items.size() > 0) {
            for (PurchaseOrder posTransaction : items) {
                totalDueAmount += posTransaction.getDueAmount().doubleValue();
            }
        }
        super.updateView(totalDueAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PurchaseOrder.class;
    }
}

