/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.PosTransaction;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.Grid;
import java.util.Collection;

public class DoctorPaymentReportGrid
extends FooterSupportedBeanGrid<PosTransaction> {
    public DoctorPaymentReportGrid(boolean showAgentPayment) {
        this.addColumn(showAgentPayment ? ConsoleMessages.getString("DoctorPaymentReportGrid.0") : ConsoleMessages.getString("DoctorPaymentReportGrid.1"), "recepientName", String.class);
        this.addColumn(showAgentPayment ? "Referrer ID" : "Doctor ID", "recepientId", String.class);
        this.addColumn(ConsoleMessages.getString("CloudReportService.77"), "transTicketIdsDisplay", String.class);
        this.addColumn("Order date", "orderDateDisplayString", String.class);
        this.addColumn("Payment date", "dateDisplayString", String.class);
        this.addColumn(ConsoleMessages.getString("DoctorPaymentReportGrid.3"), "paymentTypeDisplayString", String.class);
        this.addColumn(ConsoleMessages.getString("DoctorPaymentReportGrid.4"), PosTransaction.PROP_AMOUNT, String.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, true);
        this.showSummaryRow(PosTransaction.PROP_AMOUNT, "recepientName", "recepientId", "transTicketIdsDisplay", "orderDateDisplayString", "dateDisplayString", "paymentTypeDisplayString");
        Grid.Column column = this.getColumn("transTicketIdsDisplay");
        column.setWidth(260.0);
    }

    @Override
    public void setItems(Collection<PosTransaction> items) {
        super.setItems(items);
        double totalAmount = 0.0;
        if (items != null && items.size() > 0) {
            for (PosTransaction posTransaction : items) {
                totalAmount += posTransaction.getAmount().doubleValue();
            }
        }
        super.updateView(totalAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return PosTransaction.class;
    }
}

