/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid;

import com.floreantpos.model.InventoryTransaction;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.FooterSupportedBeanGrid;
import com.vaadin.ui.renderers.HtmlRenderer;
import com.vaadin.ui.renderers.Renderer;
import java.util.Collection;

public class InventoryTransactionReportGrid
extends FooterSupportedBeanGrid<InventoryTransaction> {
    public InventoryTransactionReportGrid() {
        this.addColumn("Group", "menuGroupName", String.class);
        this.addColumn("Item", "itemName", String.class);
        this.addColumn("SKU", "sku", String.class);
        this.addColumn("Vendor/Ticket", "vendorOrTicket", String.class);
        this.addColumn("Location", "inventoryLocation", String.class);
        this.addColumn("Time", "transactionDateAsString", String.class);
        this.addColumn("Transaction Type", "transactionType", String.class);
        this.addColumn("Reason", InventoryTransaction.PROP_REASON, String.class);
        this.addColumn("Qty", InventoryTransaction.PROP_QUANTITY, String.class);
        this.addColumn("Unit", "unitName", String.class);
        this.addColumn("On hand", "afterOnHandQtyDisplay", String.class);
        this.addColumn("Cost", InventoryTransaction.PROP_UNIT_COST, Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.addColumn("Total", InventoryTransaction.PROP_TOTAL, Double.class, BeanGrid.DATA_ALIGN.RIGHT_ALIGN, false);
        this.showSummaryRow(InventoryTransaction.PROP_TOTAL, "menuGroupName", "itemName", "sku", "vendorOrTicket", "inventoryLocation", "transactionDateAsString", "transactionType", InventoryTransaction.PROP_REASON, InventoryTransaction.PROP_QUANTITY, "unitName", "afterOnHandQtyDisplay", InventoryTransaction.PROP_UNIT_COST);
        this.getColumns().forEach(column -> column.setExpandRatio(1).setSortable(false).setRenderer((Renderer)new HtmlRenderer()));
    }

    @Override
    public void setItems(Collection<InventoryTransaction> items) {
        super.setItems(items);
        double totalAmount = 0.0;
        if (items != null && items.size() > 0) {
            for (InventoryTransaction posTransaction : items) {
                totalAmount += posTransaction.getTotal().doubleValue();
            }
        }
        super.updateView(totalAmount);
    }

    @Override
    public boolean hidePagination() {
        return false;
    }

    @Override
    public Class getReferenceClass() {
        return InventoryTransaction.class;
    }
}

