/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Project;
import com.floreantpos.model.base.BaseInventoryTransaction;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.InventoryStockData;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.InventoryTransactionReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.vaadin.data.Property;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.hibernate.type.DoubleType;
import org.hibernate.type.Type;

public class InventoryTransactionReportView
extends ReportView {
    public static final String VIEW_NAME = "Inventory transaction report";
    private VerticalLayout gridLayout;
    private List<InventoryTransaction> transactions;
    private InventoryTransactionReportGrid grid;
    private SiiopaTextField tfNameAndSku;
    private SiiopaCombobox cbTransactionType;
    private SiiopaCombobox cbGroup;
    private SiiopaCombobox cbCategory;
    private SiiopaCombobox cbProject;
    private CheckBox chkShowInGroups;
    private Map<String, Double> previousInventoryTransactionsMap;

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        super.enter(event);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.tfNameAndSku = new SiiopaTextField();
        this.cbTransactionType = new SiiopaCombobox();
        this.cbTransactionType.setWidth("200px");
        this.cbTransactionType.addItems(InventoryTransactionType.values());
        this.cbTransactionType.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbCategory = new SiiopaCombobox();
        this.cbCategory.setWidth("200px");
        this.cbCategory.addItems(MenuCategoryDAO.getInstance().loadGoodsAndServiceCategory());
        this.cbCategory.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.categoryChanged());
        this.cbGroup = new SiiopaCombobox();
        this.cbGroup.setWidth("200px");
        this.cbGroup.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.cbProject = new SiiopaCombobox();
        this.cbProject.setWidth("200px");
        this.cbProject.addItems(ProjectDAO.getInstance().findAll());
        this.cbProject.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        this.chkShowInGroups = new CheckBox();
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Name/SKY", (Component)this.tfNameAndSku));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Transaction type", (Component)this.cbTransactionType));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Category", (Component)this.cbCategory));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Group", (Component)this.cbGroup));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
    }

    private void categoryChanged() {
        List groups = new ArrayList();
        MenuCategory menuCategory = (MenuCategory)this.cbCategory.getValue();
        if (menuCategory != null) {
            groups = MenuGroupDAO.getInstance().findByCategoryId(menuCategory.getId());
        }
        this.cbGroup.removeAllItems();
        this.cbGroup.addItems(groups);
        this.updateView();
    }

    protected void doClear() {
        this.clearDateFields();
        this.tfNameAndSku.setValue("");
        this.cbTransactionType.setValue(null);
        this.cbCategory.setValue(null);
        this.cbGroup.setValue(null);
    }

    protected void doSearch() throws Exception {
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Object selectedCategory = this.cbCategory.getValue();
        MenuCategory category = null;
        if (selectedCategory instanceof MenuCategory) {
            category = (MenuCategory)selectedCategory;
        }
        Object selectedGroup = this.cbGroup.getValue();
        MenuGroup group = null;
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        Object selectedProject = this.cbProject.getValue();
        Project project = null;
        if (selectedProject instanceof Project) {
            project = (Project)selectedProject;
        }
        InventoryTransactionType selectedTransactionType = (InventoryTransactionType)this.cbTransactionType.getValue();
        this.transactions = InventoryTransactionDAO.getInstance().findTransactionsByType(this.tfNameAndSku.getValue(), selectedTransactionType == null ? null : Arrays.asList(selectedTransactionType.getType()), group, category, startTime, endTime);
        Comparator<InventoryTransaction> comparator = Comparator.comparing(BaseInventoryTransaction::getTransactionDate, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(InventoryTransaction::getItemName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)).thenComparing(BaseInventoryTransaction::getUnit, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
        this.transactions.sort(comparator);
        for (InventoryTransaction inventoryTransaction : this.transactions) {
            String unit = inventoryTransaction.getUnit();
            if (!StringUtils.isBlank((String)unit)) continue;
            inventoryTransaction.setUnit("ea");
        }
        this.previousInventoryTransactionsMap = this.populatePreviousInventoryTransactionsMap(this.tfNameAndSku.getValue(), selectedTransactionType == null ? null : Arrays.asList(selectedTransactionType.getType()), group, category, startTime);
    }

    public Map<String, Double> populatePreviousInventoryTransactionsMap(String menuItemNameOrSku, List<Integer> transactionTypes, MenuGroup menuGroup, MenuCategory menuCategory, Date fromDate) {
        HashMap<String, Double> previousInventoryTransactionMap = new HashMap<String, Double>();
        InventoryTransactionDAO instance = InventoryTransactionDAO.getInstance();
        try (Session session = instance.createNewSession();){
            Criteria criteria = instance.buildCriteriaForTransactionReport(session, menuItemNameOrSku, transactionTypes, menuGroup, menuCategory);
            criteria.add((Criterion)Restrictions.lt((String)InventoryTransaction.PROP_TRANSACTION_DATE, (Object)fromDate));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add(Projections.sqlProjection((String)("sum(quantity*tran_type) AS " + InventoryStockData.PROP_QUANTITY_IN_HAND), (String[])new String[]{InventoryStockData.PROP_QUANTITY_IN_HAND}, (Type[])new Type[]{new DoubleType()}));
            projectionList.add((Projection)Projections.groupProperty((String)("menuItem." + MenuItem.PROP_ID)), InventoryStockData.PROP_MENU_ITEM_ID);
            projectionList.add((Projection)Projections.groupProperty((String)InventoryTransaction.PROP_UNIT), InventoryStockData.PROP_UNIT);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(InventoryStockData.class));
            List stockDatas = criteria.list();
            if (stockDatas != null) {
                for (InventoryStockData inventoryStockData : stockDatas) {
                    String key = inventoryStockData.getMenuItemId() + "_" + inventoryStockData.getUnit();
                    Double qtyValue = (Double)previousInventoryTransactionMap.get(key);
                    if (qtyValue != null) continue;
                    previousInventoryTransactionMap.put(key, inventoryStockData.getQuantityInHand());
                }
            }
        }
        return previousInventoryTransactionMap;
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        if (startTime != null && endTime != null && startTime.after(endTime)) {
            throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
        }
        Object selectedCategory = this.cbCategory.getValue();
        MenuCategory category = null;
        if (selectedCategory instanceof MenuCategory) {
            category = (MenuCategory)selectedCategory;
        }
        Object selectedGroup = this.cbGroup.getValue();
        MenuGroup group = null;
        if (selectedGroup instanceof MenuGroup) {
            group = (MenuGroup)selectedGroup;
        }
        StreamResource streamResource = null;
        InventoryTransactionType selectedTransactionType = (InventoryTransactionType)this.cbTransactionType.getValue();
        try {
            JasperPrint jasperPrint = CommonCloudReportService.getInventoryTransactionReportPrint(startTime, endTime, DataProvider.get().getOutlet(), this.transactions, category, group, this.previousInventoryTransactionsMap, selectedTransactionType, (Boolean)this.chkShowInGroups.getValue());
            streamResource = CommonCloudReportService.getReportStream("Inventory-transaction-report", jasperPrint);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.grid = new InventoryTransactionReportGrid();
        return this.grid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            this.grid.clearFooterCell();
            if (this.transactions == null || this.transactions.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage("No data found!");
                return;
            }
            this.grid.setItems((Collection<InventoryTransaction>)this.transactions);
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }
}

