/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.report.view;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.Challan;
import com.floreantpos.model.ChallanItemDto;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.ExpenseTransaction;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Project;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.PurchaseTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ShipmentStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ChallanDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.ProjectDAO;
import com.floreantpos.model.dao.PurchaseOrderDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.SalesReportUtil;
import com.floreantpos.report.model.ByzlogicsProjectReportData;
import com.floreantpos.util.NumberUtil;
import com.itextpdf.html2pdf.HtmlConverter;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.BeanGrid;
import com.orocube.siiopa.cloud.client.CloudButton;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.orocube.siiopa.cloud.client.CustomLayoutComponent;
import com.orocube.siiopa.cloud.client.OutletCombobox;
import com.orocube.siiopa.cloud.client.ReportView;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.curd.grid.ProjectReportGrid;
import com.orocube.siiopa.cloud.client.report.CommonCloudReportService;
import com.orocube.siiopa.cloud.util.VelocityUtil;
import com.vaadin.data.Property;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.hibernate.Session;

public class ProjectReportView
extends ReportView {
    public static final String VIEW_NAME = "Project report";
    public static final String SALES = "Sales";
    public static final String PURCHASE = "Purchase";
    public static final String SALES_DUE_COL = "Sales due col.";
    public static final String PURCHASE_DUE_PAID = "Purchase due paid";
    private OutletCombobox cbOutlet;
    private VerticalLayout gridLayout;
    private List<PosTransaction> transactions;
    private List<ByzlogicsProjectReportData> reportGridDataList = new ArrayList<ByzlogicsProjectReportData>();
    private ProjectReportGrid grid;
    private SiiopaCombobox cbProject;
    private SiiopaTextField tfTotalItemSales;
    private SiiopaTextField tfSalesDueCollection;
    private SiiopaTextField tfPurchaseDueCollection;
    private SiiopaTextField tfTotalItemSalesPaid;
    private SiiopaTextField tfTotalItemSalesDue;
    private SiiopaTextField tfTotalPurchaseSales;
    private SiiopaTextField tfTotalPurchasePaid;
    private SiiopaTextField tfTotalPurchaseDue;
    private SiiopaTextField tfTotalExpense;
    private Map<String, Double> salesMap = new HashMap<String, Double>();
    private Map<String, Double> purchaseMap = new HashMap<String, Double>();
    private Map<String, Double> expenseMap = new HashMap<String, Double>();
    private List<ByzlogicsProjectReportData> salesDataList = new ArrayList<ByzlogicsProjectReportData>();
    private List<ByzlogicsProjectReportData> purchaseDataList = new ArrayList<ByzlogicsProjectReportData>();
    private List<ByzlogicsProjectReportData> expenseDataList = new ArrayList<ByzlogicsProjectReportData>();
    private double totalSalesAmount;
    private double grandTotalPurchaseSales;
    private double grandTotalExpense;
    private double totalProjectPaidAmount;
    private double totalSalesPaidAmount;
    private double totalPurchaseOrderPaidAmount;
    private List<Ticket> ticketList;

    public ProjectReportView() {
        super(UserPermission.PROJECT_REPORT);
    }

    @Override
    public void initComponents(HorizontalLayout contentLayout) {
        VerticalLayout mainContainer = new VerticalLayout();
        mainContainer.setSpacing(false);
        mainContainer.setMargin(true);
        mainContainer.setSizeFull();
        mainContainer.addStyleName("padding-bottom_5");
        VerticalLayout reportContainer = new VerticalLayout();
        reportContainer.setSpacing(false);
        reportContainer.setMargin(false);
        reportContainer.setSizeFull();
        CssLayout topLayout = new CssLayout();
        this.cbOutlet = new OutletCombobox(){

            @Override
            protected void outletSelected() {
                ProjectReportView.this.updateView();
            }
        };
        this.cbProject = new SiiopaCombobox();
        List project = ProjectDAO.getInstance().findAll();
        this.cbProject.addItems(project);
        this.cbProject.setWidth("400px");
        this.cbProject.setNullSelectionAllowed(false);
        this.cbProject.selectFirstComponent();
        this.cbProject.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.updateView());
        CloudButton btnSearch = CommonUIUtil.createColorButton("");
        btnSearch.setIcon((Resource)FontAwesome.SEARCH);
        btnSearch.addClickListener((Button.ClickListener & Serializable)event -> this.updateView());
        CloudButton btnClear = CommonUIUtil.createColorButton(ConsoleMessages.getString("TransactionReportView.4"));
        btnClear.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doClear();
            this.updateView();
        });
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout(ConsoleMessages.getString("OUTLET"), (Component)this.cbOutlet));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createLayout("Project", (Component)this.cbProject));
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        this.addDateFilters(topLayout);
        topLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        topLayout.addComponent((Component)CustomLayoutComponent.createButtonLayout((Object)btnSearch, (Object)btnClear));
        this.gridLayout = new VerticalLayout();
        this.gridLayout.addComponent((Component)this.grid);
        this.gridLayout.setMargin(false);
        this.gridLayout.setSpacing(false);
        this.gridLayout.setSizeFull();
        this.gridLayout.setExpandRatio((Component)this.grid, 2.0f);
        this.gridLayout.addComponent((Component)this.btnExportPdf);
        this.gridLayout.setExpandRatio((Component)this.btnExportPdf, 0.0f);
        reportContainer.addComponents(new Component[]{this.gridLayout});
        reportContainer.setExpandRatio((Component)this.gridLayout, 1.0f);
        this.gridLayout.setVisible(false);
        VerticalLayout mainTopLayout = new VerticalLayout();
        mainTopLayout.setWidth("100%");
        mainTopLayout.addStyleName("margin-bottom-5px");
        mainTopLayout.addComponents(new Component[]{CommonUIUtil.createViewNameSection(VIEW_NAME), CommonUIUtil.getSearchContainer((Component)topLayout)});
        mainContainer.addComponents(new Component[]{mainTopLayout, this.addProjectSummaryLayout(), reportContainer});
        mainContainer.setExpandRatio((Component)reportContainer, 1.0f);
        contentLayout.addComponent((Component)mainContainer);
        this.cbOutlet.setValue(DataProvider.get().getOutlet());
    }

    private Component addProjectSummaryLayout() {
        CssLayout summaryLayout = new CssLayout();
        summaryLayout.addStyleName("margin-bottom-5px");
        this.tfTotalItemSales = this.createTextField();
        this.tfSalesDueCollection = this.createTextField();
        this.tfTotalItemSalesPaid = this.createTextField();
        this.tfTotalItemSalesDue = this.createTextField();
        this.tfTotalPurchaseSales = this.createTextField();
        this.tfTotalPurchasePaid = this.createTextField();
        this.tfTotalPurchaseDue = this.createTextField();
        this.tfPurchaseDueCollection = this.createTextField();
        this.tfTotalExpense = this.createTextField();
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales: ", (Component)this.tfTotalItemSales));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales Paid: ", (Component)this.tfTotalItemSalesPaid));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales Due: ", (Component)this.tfTotalItemSalesDue));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Sales Due Collection: ", (Component)this.tfSalesDueCollection));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Purchase Cost: ", (Component)this.tfTotalPurchaseSales));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Purchase Paid: ", (Component)this.tfTotalPurchasePaid));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Purchase Due: ", (Component)this.tfTotalPurchaseDue));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Purchase Due Collection: ", (Component)this.tfPurchaseDueCollection));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        summaryLayout.addComponent((Component)CustomLayoutComponent.createLayout("Expense: ", (Component)this.tfTotalExpense));
        summaryLayout.addComponent((Component)CustomLayoutComponent.createSpacing());
        return summaryLayout;
    }

    private SiiopaTextField createTextField() {
        SiiopaTextField textField = new SiiopaTextField();
        textField.setFieldRightAligment();
        textField.setEnabled(false);
        textField.addStyleName("remove-opacity");
        textField.addStyleName("quick-menuitem-txtfield-cost");
        return textField;
    }

    protected void doClear() {
        this.cbOutlet.setValue(POSConstants.ALL);
        this.cbProject.selectFirstComponent();
        this.clearDateFields();
    }

    protected void doSearch() throws Exception {
        List dueColTicketList;
        Map<String, ByzlogicsProjectReportData> dueTicketDataList;
        List duePurchaseOrderList;
        Map<String, ByzlogicsProjectReportData> duePurchaseDataList;
        this.salesMap.clear();
        this.purchaseMap.clear();
        this.expenseMap.clear();
        this.salesDataList.clear();
        this.purchaseDataList.clear();
        this.expenseDataList.clear();
        this.reportGridDataList.clear();
        this.totalSalesAmount = 0.0;
        this.grandTotalPurchaseSales = 0.0;
        this.grandTotalExpense = 0.0;
        this.totalProjectPaidAmount = 0.0;
        this.totalSalesPaidAmount = 0.0;
        this.totalPurchaseOrderPaidAmount = 0.0;
        this.validateDate();
        Date startTime = this.getFromDate();
        Date endTime = this.getToDate();
        Project project = null;
        Object selectedProject = this.cbProject.getValue();
        if (selectedProject != null && selectedProject instanceof Project) {
            project = (Project)selectedProject;
        }
        Outlet outlet = null;
        if (this.cbOutlet.getValue() instanceof Outlet) {
            outlet = (Outlet)this.cbOutlet.getValue();
        }
        this.transactions = PosTransactionDAO.getInstance().findProjectTransaction(outlet, startTime, endTime, project);
        this.ticketList = TicketDAO.getInstance().findTicketsByProject(outlet, startTime, endTime, project);
        Map<String, ByzlogicsProjectReportData> ticketDataMap = this.getSalesDataList(this.ticketList, true);
        this.salesDataList.addAll(ticketDataMap.values());
        if (!this.salesDataList.isEmpty()) {
            this.reportGridDataList.addAll(this.salesDataList);
        }
        List purchaseOrderList = PurchaseOrderDAO.getInstance().findPurchaseOrderListByProject(outlet, startTime, endTime, project);
        Map<String, ByzlogicsProjectReportData> purchaseDataMap = this.getPurchaseDataList(purchaseOrderList, true);
        this.purchaseDataList.addAll(purchaseDataMap.values());
        if (!this.purchaseDataList.isEmpty()) {
            this.reportGridDataList.addAll(this.purchaseDataList);
        }
        this.expenseDataList = this.getExpenseDataList(this.transactions);
        if (!this.expenseDataList.isEmpty()) {
            this.reportGridDataList.addAll(this.expenseDataList);
        }
        double expense = 0.0;
        ArrayList<ByzlogicsProjectReportData> dueColTransList = new ArrayList<ByzlogicsProjectReportData>();
        ArrayList<String> duePurchaseOrderIdList = new ArrayList<String>();
        ArrayList<String> dueSalesIdList = new ArrayList<String>();
        double salesDueCollectionAmount = 0.0;
        double purchaseDueCollectionAmount = 0.0;
        for (PosTransaction posTransaction : this.transactions) {
            ByzlogicsProjectReportData byzProjectReportData;
            Double totalAmount;
            String key;
            if (posTransaction instanceof PurchaseTransaction) {
                key = posTransaction.getPaymentTypeDisplayString();
                totalAmount = this.purchaseMap.get(key);
                totalAmount = totalAmount == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount + posTransaction.getAmountWithoutRoundingAmount());
                this.purchaseMap.put(key, totalAmount);
                String entityId = posTransaction.getEntityId();
                byzProjectReportData = purchaseDataMap.get(entityId);
                if (byzProjectReportData == null) {
                    purchaseDueCollectionAmount += posTransaction.getAmount().doubleValue();
                    this.geDueColDataFromTransaction(posTransaction, dueColTransList, PURCHASE_DUE_PAID);
                    duePurchaseOrderIdList.add(entityId);
                }
            }
            if (posTransaction instanceof ExpenseTransaction) {
                expense += posTransaction.getAmountWithoutRoundingAmount();
                key = posTransaction.getPaymentTypeDisplayString();
                totalAmount = this.expenseMap.get(key);
                totalAmount = totalAmount == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount + posTransaction.getAmountWithoutRoundingAmount());
                this.expenseMap.put(key, totalAmount);
            }
            if (posTransaction instanceof CashTransaction || posTransaction instanceof CreditCardTransaction || posTransaction instanceof DebitCardTransaction || posTransaction instanceof CustomPaymentTransaction) {
                key = posTransaction.getPaymentTypeDisplayString();
                totalAmount = this.salesMap.get(key);
                totalAmount = totalAmount == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(totalAmount + posTransaction.getAmountWithoutRoundingAmount());
                this.salesMap.put(key, totalAmount);
                String ticketId = posTransaction.getTicketId();
                byzProjectReportData = ticketDataMap.get(ticketId);
                if (byzProjectReportData == null) {
                    salesDueCollectionAmount += posTransaction.getAmount().doubleValue();
                    this.geDueColDataFromTransaction(posTransaction, dueColTransList, SALES_DUE_COL);
                    dueSalesIdList.add(ticketId);
                }
            }
            if (!(posTransaction instanceof RefundTransaction)) continue;
            key = posTransaction.getPaymentTypeDisplayString();
            String refundKey = key + " refund";
            Double totalAmount2 = this.salesMap.get(refundKey);
            totalAmount2 = totalAmount2 == null ? Double.valueOf(posTransaction.getAmountWithoutRoundingAmount()) : Double.valueOf(Math.abs(totalAmount2) + Math.abs(posTransaction.getAmountWithoutRoundingAmount()));
            this.salesMap.put(refundKey, totalAmount2 * -1.0);
        }
        if (!dueColTransList.isEmpty()) {
            this.reportGridDataList.addAll(dueColTransList);
        }
        if (!duePurchaseOrderIdList.isEmpty() && !(duePurchaseDataList = this.getPurchaseDataList(duePurchaseOrderList = PurchaseOrderDAO.getInstance().getPurchaseOrderListByIds(duePurchaseOrderIdList), false)).isEmpty()) {
            this.purchaseDataList.addAll(duePurchaseDataList.values());
        }
        if (!dueSalesIdList.isEmpty() && !(dueTicketDataList = this.getSalesDataList(dueColTicketList = TicketDAO.getInstance().getTicketListByIds(dueSalesIdList), false)).isEmpty()) {
            this.salesDataList.addAll(dueTicketDataList.values());
        }
        try (Session session = GenericDAO.getInstance().createNewSession();){
            session.setDefaultReadOnly(true);
            SalesReportUtil salesReportUtil = new SalesReportUtil(startTime, endTime);
            salesReportUtil.setOutlet(outlet);
            salesReportUtil.setProjectId(project == null ? null : project.getId());
            double ticketItemSales = this.totalSalesAmount;
            this.tfTotalItemSales.setValue(NumberUtil.formatAmount((Double)ticketItemSales));
            this.tfTotalItemSalesPaid.setValue(NumberUtil.formatAmount((Double)this.totalSalesPaidAmount));
            this.tfTotalItemSalesDue.setValue(NumberUtil.formatAmount((Double)(ticketItemSales - this.totalSalesPaidAmount)));
            this.tfTotalPurchaseSales.setValue(NumberUtil.formatAmount((Double)this.grandTotalPurchaseSales));
            this.tfTotalPurchasePaid.setValue(NumberUtil.formatAmount((Double)this.totalPurchaseOrderPaidAmount));
            this.tfTotalPurchaseDue.setValue(NumberUtil.formatAmount((Double)(this.grandTotalPurchaseSales - this.totalPurchaseOrderPaidAmount)));
            this.tfTotalExpense.setValue(NumberUtil.formatAmount((Double)expense));
        }
        this.tfSalesDueCollection.setValue(NumberUtil.formatAmount((Double)salesDueCollectionAmount));
        this.tfPurchaseDueCollection.setValue(NumberUtil.formatAmount((Double)purchaseDueCollectionAmount));
    }

    @Override
    protected StreamResource executeExportButtonAction() {
        return this.getStreamResource();
    }

    private StreamResource getStreamResource() {
        StreamResource streamResource = null;
        try {
            Date startTime = this.getFromDate();
            Date endTime = this.getToDate();
            if (startTime != null && endTime != null && startTime.after(endTime)) {
                throw new PosException(POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            }
            Outlet outlet = null;
            if (this.cbOutlet.getValue() instanceof Outlet) {
                outlet = (Outlet)this.cbOutlet.getValue();
            }
            Project project = null;
            Object selectedProject = this.cbProject.getValue();
            if (selectedProject != null && selectedProject instanceof Project) {
                project = (Project)selectedProject;
            }
            Comparator<ReceiptPrintService.TransactionDataRow> comparator = Comparator.comparing(ReceiptPrintService.TransactionDataRow::getPaymentType, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            ArrayList<Object> salesTransRows = new ArrayList<Object>();
            ArrayList<ReceiptPrintService.TransactionDataRow> salesRefundTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
            Set<String> salesKeySet = this.salesMap.keySet();
            for (String salesKey : salesKeySet) {
                Double amount = this.salesMap.get(salesKey);
                ReceiptPrintService.TransactionDataRow transactionDataRow = new ReceiptPrintService.TransactionDataRow(salesKey, amount);
                if (amount < 0.0) {
                    salesRefundTransRows.add(transactionDataRow);
                    continue;
                }
                salesTransRows.add(transactionDataRow);
            }
            salesTransRows.sort(comparator);
            salesRefundTransRows.sort(comparator);
            salesTransRows.addAll(salesRefundTransRows);
            ArrayList<ReceiptPrintService.TransactionDataRow> purchaseTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
            Set<String> keySet = this.purchaseMap.keySet();
            for (String key : keySet) {
                Double amount = this.purchaseMap.get(key);
                purchaseTransRows.add(new ReceiptPrintService.TransactionDataRow(key, amount));
            }
            purchaseTransRows.sort(comparator);
            ArrayList<ReceiptPrintService.TransactionDataRow> expenseTransRows = new ArrayList<ReceiptPrintService.TransactionDataRow>();
            Set<String> expenseKeySet = this.expenseMap.keySet();
            for (String key : expenseKeySet) {
                Double amount = this.expenseMap.get(key);
                expenseTransRows.add(new ReceiptPrintService.TransactionDataRow(key, amount));
            }
            expenseTransRows.sort(comparator);
            Comparator<ByzlogicsProjectReportData> idComparator = Comparator.comparing(ByzlogicsProjectReportData::getTicketId, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER)).thenComparing(ByzlogicsProjectReportData::getItemName, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
            this.salesDataList.sort(idComparator);
            this.purchaseDataList.sort(idComparator);
            List<ByzlogicsProjectReportData> challanReportDataList = this.getChallanDataList();
            double purchaseColvalue = Double.valueOf(this.tfPurchaseDueCollection.getValue());
            double salesColvalue = Double.valueOf(this.tfSalesDueCollection.getValue());
            double calculateTotalPaidAmount = this.totalProjectPaidAmount;
            double totalAmount = this.totalSalesAmount - (this.grandTotalPurchaseSales + this.grandTotalExpense);
            String totalProjectAmount = "0.00";
            totalProjectAmount = totalAmount < 0.0 ? "(" + NumberUtil.formatAmount((Double)(totalAmount * -1.0)) + ")" : NumberUtil.formatAmount((Double)totalAmount);
            double totalDueAmount = totalAmount - calculateTotalPaidAmount;
            String totalProjectDueAmount = "0.00";
            totalProjectDueAmount = totalDueAmount < 0.0 ? "(" + NumberUtil.formatAmount((Double)(totalDueAmount * -1.0)) + ")" : NumberUtil.formatAmount((Double)totalDueAmount);
            calculateTotalPaidAmount += salesColvalue - purchaseColvalue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("StringUtils", StringUtils.class);
            data.put("NumberUtil", NumberUtil.class);
            data.put("DateUtil", DateUtil.class);
            Store store = DataProvider.get().getStore();
            data.put("restaurantName", store.getName());
            if (outlet != null) {
                data.put("addressLine1", outlet.getAddressLine1());
                if (StringUtils.isNotBlank((String)outlet.getAddressLine2())) {
                    data.put("addressLine2", outlet.getAddressLine2());
                }
                if (StringUtils.isNotBlank((String)outlet.getAddressLine3())) {
                    data.put("addressLine3", outlet.getAddressLine3());
                }
                if (StringUtils.isNotBlank((String)outlet.getTelephone())) {
                    data.put("phone", outlet.getTelephone());
                }
            }
            data.put("reportName", project != null ? "Project: " + project.getNameDisplay() : null);
            data.put("reportDate", new Date());
            data.put("fromDate", startTime);
            data.put("toDate", endTime);
            data.put("projectName", this.cbProject.getValue());
            data.put("salesTransList", salesTransRows);
            data.put("purchaseTransList", purchaseTransRows);
            data.put("expenseTransList", expenseTransRows);
            data.put("projectData", this.reportGridDataList);
            data.put("salesDetails", this.salesDataList);
            data.put("purchaseDetails", this.purchaseDataList);
            data.put("expenseDetails", this.expenseDataList);
            data.put("challanReportDataList", challanReportDataList);
            data.put("totalItemSales", this.tfTotalItemSales.getValue());
            data.put("salesPaid", this.tfTotalItemSalesPaid.getValue());
            data.put("salesDue", this.tfTotalItemSalesDue.getValue());
            data.put("purchaseSales", this.tfTotalPurchaseSales.getValue());
            data.put("purchasePaid", this.tfTotalPurchasePaid.getValue());
            data.put("purchaseDue", this.tfTotalPurchaseDue.getValue());
            data.put("totalExpense", this.tfTotalExpense.getValue());
            data.put("totalProjectAmount", totalProjectAmount);
            data.put("totalProjectDueAmount", totalProjectDueAmount);
            data.put("totalAmount", NumberUtil.formatToAccountingAmount((double)calculateTotalPaidAmount));
            final StringWriter writer = new StringWriter();
            VelocityEngine engine = VelocityUtil.getVelocityEngine();
            String templateFile = "templates/project_report.vm";
            Template template = engine.getTemplate(templateFile);
            VelocityContext context = new VelocityContext(data);
            template.merge((Context)context, (Writer)writer);
            String reportOutputFilename = "Project_report_" + CommonCloudReportService.getDateAsString() + ".pdf";
            streamResource = new StreamResource(new StreamResource.StreamSource(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public InputStream getStream() {
                    try (ByteArrayOutputStream pdfBuffer = new ByteArrayOutputStream();){
                        ByteArrayInputStream inputStream;
                        HtmlConverter.convertToPdf((String)writer.toString(), (OutputStream)pdfBuffer);
                        ByteArrayInputStream byteArrayInputStream = inputStream = new ByteArrayInputStream(pdfBuffer.toByteArray());
                        return byteArrayInputStream;
                    }
                    catch (Exception e) {
                        PosLog.error(this.getClass(), (Exception)e);
                        return null;
                    }
                }
            }, reportOutputFilename);
            streamResource.setMIMEType("application/pdf");
        }
        catch (Exception e0) {
            PosLog.error(this.getClass(), (Exception)e0);
        }
        return streamResource;
    }

    private String getPurchaseOrderPerformerName(PurchaseOrder purchaseOrder) {
        User user;
        String userId = purchaseOrder.getCreatedByUserId();
        if (StringUtils.isNotBlank((String)userId) && (user = DataProvider.get().getUserById(userId, purchaseOrder.getOutletId())) != null) {
            return user.getFullName();
        }
        return "";
    }

    private Map<String, ByzlogicsProjectReportData> getSalesDataList(List<Ticket> ticketList, boolean isCalculateAmount) {
        HashMap<String, ByzlogicsProjectReportData> salesDataMap = new HashMap<String, ByzlogicsProjectReportData>();
        for (Ticket ticket : ticketList) {
            ticket = TicketDAO.getInstance().get(ticket);
            if (ticket == null) continue;
            String key = ticket.getId();
            ByzlogicsProjectReportData byzProjectReportData = (ByzlogicsProjectReportData)salesDataMap.get(key);
            double totalItemAmount = 0.0;
            if (byzProjectReportData != null) continue;
            byzProjectReportData = new ByzlogicsProjectReportData();
            byzProjectReportData.setDate(DateUtil.formatReportDateWithBrowserTimeOffset((Date)ticket.getCreateDate()));
            byzProjectReportData.setTicketId(key);
            byzProjectReportData.setPerformerName(this.getSalesPerformerName(ticket));
            byzProjectReportData.setType(SALES);
            byzProjectReportData.setDescription(ticket.getId());
            byzProjectReportData.setProjectName(ticket.getProjectNameDisplay());
            Double paidAmount = ticket.getPaidAmount();
            Double refundAmount = ticket.getRefundAmount();
            double paidAmountWithoutRefund = paidAmount - refundAmount;
            byzProjectReportData.setPaidAmount(paidAmountWithoutRefund);
            byzProjectReportData.setDueAmount(ticket.getDueAmount());
            if (isCalculateAmount) {
                this.totalProjectPaidAmount += paidAmountWithoutRefund;
                this.totalSalesPaidAmount += paidAmountWithoutRefund;
                this.totalSalesAmount -= refundAmount.doubleValue();
                Double dueAmount = ticket.getDueAmount();
                if (dueAmount < 0.0) {
                    this.totalSalesAmount += ticket.getDueAmount().doubleValue();
                }
            }
            String itemName = "";
            double itemPrice = 0.0;
            List ticketItems = ticket.getTicketItems();
            int returnAmount = 0;
            for (TicketItem ticketItem : ticketItems) {
                if (ticketItem.isReturned() || ticketItem.isVoided().booleanValue()) {
                    returnAmount = (int)((double)returnAmount + Math.abs(ticketItem.getSubtotalAmount()));
                    continue;
                }
                totalItemAmount += ticketItem.getSubtotalAmount().doubleValue();
                if (isCalculateAmount) {
                    this.totalSalesAmount += ticketItem.getSubtotalAmount().doubleValue();
                }
                if (StringUtils.isNotBlank((String)itemName)) {
                    itemName = itemName + ", ";
                }
                itemName = itemName + ticketItem.getName();
                itemPrice += ticketItem.getSubtotalAmount().doubleValue();
            }
            byzProjectReportData.setTotalAmount(totalItemAmount - (double)returnAmount);
            itemName = ProjectReportView.getFormattedNameDisplay(itemName, 50);
            byzProjectReportData.setItemName(itemName);
            byzProjectReportData.setItemPrice(itemPrice - (double)returnAmount);
            salesDataMap.put(key, byzProjectReportData);
        }
        return salesDataMap;
    }

    private Map<String, ByzlogicsProjectReportData> getPurchaseDataList(List<PurchaseOrder> purchseOrderList, boolean isCalculateAmount) {
        HashMap<String, ByzlogicsProjectReportData> reportDataMap = new HashMap<String, ByzlogicsProjectReportData>();
        for (PurchaseOrder purchaseOrder : purchseOrderList) {
            String entityId = purchaseOrder.getEntityId();
            ByzlogicsProjectReportData byzProjectReportData = (ByzlogicsProjectReportData)reportDataMap.get(entityId);
            if (byzProjectReportData != null) continue;
            byzProjectReportData = new ByzlogicsProjectReportData();
            byzProjectReportData.setDate(DateUtil.formatReportDateWithBrowserTimeOffset((Date)purchaseOrder.getCreatedDate()));
            byzProjectReportData.setTicketId(purchaseOrder.getOrderId());
            byzProjectReportData.setPerformerName(this.getPurchaseOrderPerformerName(purchaseOrder));
            byzProjectReportData.setPaidAmount(purchaseOrder.getPaidAmount());
            byzProjectReportData.setDueAmount(purchaseOrder.getDueAmount());
            byzProjectReportData.setTotalAmount(purchaseOrder.getSubtotalAmount());
            byzProjectReportData.setType(PURCHASE);
            byzProjectReportData.setDescription(purchaseOrder.getOrderId());
            byzProjectReportData.setProjectName(purchaseOrder.getProjectNameDisplay());
            if (isCalculateAmount) {
                this.grandTotalPurchaseSales += purchaseOrder.getSubtotalAmount().doubleValue();
                this.totalProjectPaidAmount -= purchaseOrder.getPaidAmount().doubleValue();
                this.totalPurchaseOrderPaidAmount += purchaseOrder.getPaidAmount().doubleValue();
            }
            String itemName = "";
            double itemPrice = 0.0;
            List purchaseOrderItems = purchaseOrder.getOrderItems();
            Iterator iterator = purchaseOrderItems.iterator();
            while (iterator.hasNext()) {
                PurchaseOrderItem orderItem = (PurchaseOrderItem)iterator.next();
                itemPrice += orderItem.getSubtotalAmount().doubleValue();
                itemName = itemName + orderItem.getName();
                if (iterator.hasNext()) {
                    itemName = itemName + ", ";
                }
                itemName = ProjectReportView.getFormattedNameDisplay(itemName, 40);
                byzProjectReportData.setItemName(itemName);
                byzProjectReportData.setItemPrice(itemPrice);
            }
            reportDataMap.put(entityId, byzProjectReportData);
        }
        return reportDataMap;
    }

    private void geDueColDataFromTransaction(PosTransaction posTransaction, List<ByzlogicsProjectReportData> salesTransList, String type) {
        ByzlogicsProjectReportData byzProjectData = new ByzlogicsProjectReportData();
        byzProjectData.setDate(posTransaction.getDateDisplayString());
        byzProjectData.setPerformerName(posTransaction.getServerName());
        byzProjectData.setType(posTransaction.getClassTypeDislay());
        byzProjectData.setProjectName(posTransaction.getProjectNameDisplay());
        byzProjectData.setDescription(posTransaction.getEntityNoDisplay());
        byzProjectData.setPaidAmount(posTransaction.getAmount());
        byzProjectData.setType(type);
        byzProjectData.setDueAmount(0.0);
        byzProjectData.setTotalAmount(0.0);
        salesTransList.add(byzProjectData);
    }

    private List<ByzlogicsProjectReportData> getExpenseDataList(List<PosTransaction> transactions) {
        ArrayList<ByzlogicsProjectReportData> balanceTransList = new ArrayList<ByzlogicsProjectReportData>();
        for (PosTransaction posTransaction : transactions) {
            if (!(posTransaction instanceof ExpenseTransaction)) continue;
            ByzlogicsProjectReportData byzProjectReportData = new ByzlogicsProjectReportData();
            byzProjectReportData.setDate(posTransaction.getDateDisplayString());
            byzProjectReportData.setPerformerName(posTransaction.getServerName());
            byzProjectReportData.setType(posTransaction.getClassTypeDislay());
            byzProjectReportData.setProjectName(posTransaction.getProjectNameDisplay());
            byzProjectReportData.setDescription(posTransaction.getNote());
            byzProjectReportData.setPaidAmount(posTransaction.getAmount());
            byzProjectReportData.setExpenseRecipient(posTransaction.getRecepientDisplay());
            byzProjectReportData.setCategory(posTransaction.getReasonDisplay());
            byzProjectReportData.setSubCategory(posTransaction.getSubReason());
            byzProjectReportData.setDueAmount(0.0);
            byzProjectReportData.setTotalAmount(posTransaction.getAmount());
            balanceTransList.add(byzProjectReportData);
            this.grandTotalExpense += posTransaction.getAmount().doubleValue();
            this.totalProjectPaidAmount -= posTransaction.getAmount().doubleValue();
        }
        return balanceTransList;
    }

    private List<ByzlogicsProjectReportData> getChallanDataList() {
        HashMap<String, ByzlogicsProjectReportData> challanDataMap = new HashMap<String, ByzlogicsProjectReportData>();
        for (Ticket ticket : this.ticketList) {
            List challanList;
            ShipmentStatus shipmentStatus;
            if (ticket == null || (shipmentStatus = ShipmentStatus.fromName((String)ticket.getShipmentStatus())) == null || (challanList = ChallanDAO.getInstance().getChallansByTicketId(ticket.getId())) == null) continue;
            for (Challan challan : challanList) {
                User user;
                String chalanId = challan.getId();
                ByzlogicsProjectReportData challanData = (ByzlogicsProjectReportData)challanDataMap.get(chalanId);
                if (challanData != null) continue;
                challanData = new ByzlogicsProjectReportData();
                challanData.setDate(DateUtil.formatReportDateWithBrowserTimeOffset((Date)challan.getCreateDate()));
                challanData.setTicketId(challan.getTicketId());
                challanData.setChallanNo(challan.getChallanNo());
                challanData.setShipped(challan.isShipped());
                String userId = challan.getCreatedUserId();
                if (StringUtils.isNotBlank((String)userId) && (user = DataProvider.get().getUserById(userId, challan.getOutletId())) != null) {
                    challanData.setPerformerName(user.getFullName());
                }
                String itemName = "";
                double itemPrice = 0.0;
                List challanItems = challan.getItems();
                Iterator iterator = challanItems.iterator();
                while (iterator.hasNext()) {
                    ChallanItemDto challanItem = (ChallanItemDto)iterator.next();
                    itemPrice += challanItem.getUnitPrice() * challanItem.getItemQuantity();
                    itemName = itemName + challanItem.getTicketItemName();
                    if (iterator.hasNext()) {
                        itemName = itemName + ", ";
                    }
                    itemName = ProjectReportView.getFormattedNameDisplay(itemName, 40);
                    challanData.setItemName(itemName);
                    challanData.setItemPrice(itemPrice);
                }
                challanDataMap.put(chalanId, challanData);
            }
        }
        return new ArrayList<ByzlogicsProjectReportData>(challanDataMap.values());
    }

    @Override
    protected BeanGrid createItemGrid() {
        this.grid = new ProjectReportGrid();
        return this.grid;
    }

    @Override
    public void updateView() {
        try {
            this.grid.removeAll();
            this.doSearch();
            this.grid.clearFooterCell();
            if (this.reportGridDataList == null || this.reportGridDataList.size() == 0) {
                this.gridLayout.setVisible(false);
                CloudNotification.showMessage("No data found!");
                return;
            }
            this.grid.setItems((Collection<ByzlogicsProjectReportData>)this.reportGridDataList);
            this.gridLayout.setVisible(true);
        }
        catch (Exception e) {
            CloudNotification.showErrorMessageDialog(e.getMessage(), e);
            this.gridLayout.setVisible(false);
        }
    }

    private String getSalesPerformerName(Ticket ticket) {
        User user;
        String userId = ticket.getCreatedByUserId();
        if (StringUtils.isNotBlank((String)userId) && (user = DataProvider.get().getUserById(userId, ticket.getOutletId())) != null) {
            return user.getFullName();
        }
        return "";
    }

    private static String getFormattedNameDisplay(String label, int maxLength) {
        if (label.length() <= maxLength) {
            return label;
        }
        return label.substring(0, maxLength - 3) + "...";
    }
}

