/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.BankAccount;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.client.CloudNotification;
import com.orocube.siiopa.cloud.client.DoneCancelWindow;
import com.orocube.siiopa.cloud.client.PaymentReferenceEntryDialog;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.client.SiiopaDoubleTextField;
import com.orocube.siiopa.cloud.client.SiiopaTextField;
import com.orocube.siiopa.cloud.client.SiiopaTypeableSearchCombobox;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

public class AddBalanceToBankAccountWindow
extends DoneCancelWindow {
    private SiiopaTypeableSearchCombobox cbBankName;
    private SiiopaCombobox cbPaymentMethod;
    private SiiopaTextField tfAccountName;
    private SiiopaTextField tfAccountNumber;
    private SiiopaTextField tfNote;
    private SiiopaDoubleTextField tfAddBalance;
    private BankAccount bankAccount;

    public AddBalanceToBankAccountWindow(String title, BankAccount bankAccount) {
        super(title);
        this.bankAccount = bankAccount;
        this.init();
    }

    private void init() {
        FormLayout formLayout = new FormLayout();
        formLayout.addStyleName("custom-width-formlayout");
        formLayout.setSizeFull();
        this.cbPaymentMethod = new SiiopaCombobox();
        List customPayments = CustomPaymentDAO.getInstance().findAllActive(DataProvider.get().getOutletId());
        this.cbPaymentMethod.addItem(POSConstants.CASH);
        this.cbPaymentMethod.addItems(customPayments);
        this.cbPaymentMethod.setWidth("100%");
        this.cbPaymentMethod.setNullSelectionAllowed(false);
        this.cbBankName = new SiiopaTypeableSearchCombobox();
        this.cbBankName.setNullSelectionAllowed(false);
        this.cbBankName.setWidth("100%");
        this.tfAccountName = new SiiopaTextField();
        this.tfAccountNumber = new SiiopaTextField();
        this.tfAddBalance = new SiiopaDoubleTextField();
        this.tfNote = new SiiopaTextField();
        if (this.bankAccount != null) {
            this.cbBankName.addItem(this.bankAccount.getBankName());
            this.cbBankName.setValue(this.bankAccount.getBankName());
            this.tfAccountNumber.setValue(this.bankAccount.getAccountNo());
            this.tfAccountName.setValue(this.bankAccount.getAccountName());
            this.cbBankName.setReadOnly(true);
            this.tfAccountName.setReadOnly(true);
            this.tfAccountNumber.setReadOnly(true);
        }
        HorizontalLayout bankAccountNameLayout = new HorizontalLayout();
        bankAccountNameLayout.setCaption("Bank name");
        bankAccountNameLayout.setSpacing(true);
        bankAccountNameLayout.setMargin(false);
        bankAccountNameLayout.setWidth("100%");
        HorizontalLayout accountNameLayout = new HorizontalLayout();
        accountNameLayout.setCaption("A/C Name");
        accountNameLayout.setSpacing(true);
        accountNameLayout.setMargin(false);
        accountNameLayout.setWidth("100%");
        HorizontalLayout accountNumberLayout = new HorizontalLayout();
        accountNumberLayout.setCaption("A/C No");
        accountNumberLayout.setSpacing(true);
        accountNumberLayout.setMargin(false);
        accountNumberLayout.setWidth("100%");
        HorizontalLayout balanceLayout = new HorizontalLayout();
        balanceLayout.setCaption("Balance");
        balanceLayout.setSpacing(true);
        balanceLayout.setMargin(false);
        balanceLayout.setWidth("100%");
        HorizontalLayout noteLayout = new HorizontalLayout();
        noteLayout.setCaption("Note");
        noteLayout.setSpacing(true);
        noteLayout.setMargin(false);
        noteLayout.setWidth("100%");
        HorizontalLayout paymentMethodLayout = new HorizontalLayout();
        paymentMethodLayout.setCaption("Add payment type");
        paymentMethodLayout.setSpacing(true);
        paymentMethodLayout.setMargin(false);
        paymentMethodLayout.setWidth("100%");
        this.btnDone.setTabIndex(3);
        this.btnCancel.setTabIndex(4);
        HorizontalLayout contentPane = this.getContentPanel();
        contentPane.setSizeFull();
        contentPane.setMargin(true);
        contentPane.setSpacing(false);
        bankAccountNameLayout.addComponents(new Component[]{this.cbBankName});
        accountNameLayout.addComponents(new Component[]{this.tfAccountName});
        accountNumberLayout.addComponents(new Component[]{this.tfAccountNumber});
        balanceLayout.addComponents(new Component[]{this.tfAddBalance});
        noteLayout.addComponents(new Component[]{this.tfNote});
        paymentMethodLayout.addComponents(new Component[]{this.cbPaymentMethod});
        formLayout.addComponents(new Component[]{paymentMethodLayout, bankAccountNameLayout, accountNameLayout, accountNumberLayout, balanceLayout, noteLayout});
        contentPane.addComponents(new Component[]{formLayout});
        contentPane.setExpandRatio((Component)formLayout, 1.0f);
    }

    @Override
    public boolean doOk() {
        try {
            if (this.cbPaymentMethod.getValue() == null) {
                CloudNotification.showMessage("Must be select payment type");
                return false;
            }
            if (NumberUtil.isZero((Double)this.tfAddBalance.getValidDoubleValue())) {
                CloudNotification.showMessage("Must be input balance");
                return false;
            }
            this.tfAddBalance.getValidDoubleValue();
            this.doSave();
            return true;
        }
        catch (PosException e) {
            CloudNotification.showErrorMessage(e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(((Object)((Object)this)).getClass(), (Exception)e);
        }
        return false;
    }

    private void doSave() {
        Object paymentMethod = this.cbPaymentMethod.getValue();
        PaymentType paymentType = null;
        if (paymentMethod instanceof CustomPayment) {
            CustomPayment customPayment = (CustomPayment)paymentMethod;
            List inputPromptList = customPayment.getInputPromptList();
            if (inputPromptList != null && !inputPromptList.isEmpty()) {
                PaymentReferenceEntryDialog paymentReferenceEntryDialog = new PaymentReferenceEntryDialog("Pay by " + customPayment.getName(), inputPromptList);
                paymentReferenceEntryDialog.open();
                paymentReferenceEntryDialog.setSize(330, 400);
                paymentReferenceEntryDialog.addCloseListener((Window.CloseListener & Serializable)e -> {
                    if (paymentReferenceEntryDialog.isCanceled()) {
                        return;
                    }
                    String paymentRefJson = paymentReferenceEntryDialog.getPaymentRef();
                    this.doPayByCustomPaymentMethod(customPayment, paymentRefJson);
                });
            } else {
                this.doPayByCustomPaymentMethod(customPayment, "");
            }
        } else {
            paymentType = PaymentType.CASH;
            BalanceUpdateTransactionDAO.getInstance().saveBankAccountAddBalanceTransaction(this.bankAccount, paymentType, Double.valueOf(this.tfAddBalance.getDoubleOrZero()), this.tfNote.getValue(), "");
        }
    }

    private void doPayByCustomPaymentMethod(CustomPayment customPayment, String paymentRefJson) {
        JSONObject payment = new JSONObject();
        payment.put("type", (Object)customPayment.getName());
        payment.put("id", (Object)customPayment.getId());
        payment.put("amount", this.tfAddBalance.getValidDoubleValue());
        if (StringUtils.isNotBlank((String)paymentRefJson)) {
            payment.put("ref", (Object)paymentRefJson);
        }
        String json = payment.toString();
        BalanceUpdateTransactionDAO.getInstance().saveBankAccountAddBalanceTransaction(this.bankAccount, PaymentType.CUSTOM_PAYMENT, Double.valueOf(this.tfAddBalance.getDoubleOrZero()), this.tfNote.getValue(), json);
    }

    @Override
    public void initUI(HorizontalLayout contentPane) {
    }
}

