/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.SiiopaCombobox;
import com.orocube.siiopa.cloud.server.CloudResourceCache;
import com.orocube.siiopa.cloud.server.security.CurrentSession;
import com.vaadin.data.Property;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class OutletCombobox
extends SiiopaCombobox {
    private boolean showAll;

    public OutletCombobox() {
        this(false);
    }

    public OutletCombobox(boolean showAll) {
        this.showAll = showAll;
        this.setTextInputAllowed(false);
        this.setInputPrompt(ConsoleMessages.getString("OUTLET"));
        if (CurrentSession.getUser().hasPermission(UserPermission.VIEW_ANY_OUTLET)) {
            List outlets = OutletDAO.getInstance().findAll(false);
            if (showAll && outlets != null && outlets.size() > 1) {
                this.addItem("All");
            }
            for (Outlet outlet : outlets) {
                this.addItem(outlet);
            }
            this.setNullSelectionAllowed(false);
        } else {
            this.addItem(DataProvider.get().getOutlet());
        }
        this.setValue(DataProvider.get().getOutlet());
        this.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.valueChanged());
    }

    protected void valueChanged() {
        Object value = this.getValue();
        if (!this.showAll && value != null && value instanceof Outlet) {
            Outlet outlet = (Outlet)value;
            CurrentSession.setSelectedOutletId(outlet.getId());
            NumberUtil.initializeNumberFormats((Outlet)outlet);
        }
        this.outletSelected();
    }

    @Override
    public void selectFirstComponent() {
        Collection outlets;
        if (this.showAll) {
            super.selectFirstComponent();
            return;
        }
        Outlet selectedOutlet = CurrentSession.getSelectedOutlet();
        if (selectedOutlet != null && (outlets = this.getItemIds()) != null && outlets.size() > 0) {
            for (Object object : outlets) {
                if (!(object instanceof Outlet)) continue;
                Outlet outlet = (Outlet)object;
                if (!object.equals(selectedOutlet)) continue;
                this.setValue(outlet);
                return;
            }
        }
        super.selectFirstComponent();
    }

    protected abstract void outletSelected();

    public boolean isVisible() {
        if (CloudResourceCache.get().isSiiopa() || this.size() <= 1) {
            return false;
        }
        if (!CurrentSession.hasMultioutletSubscription()) {
            return false;
        }
        return super.isVisible();
    }

    public List<User> getUserBySelectedOutlet() {
        return UserDAO.getInstance().findAllActive(this.getSelectedOrDefaultOutlet().getId());
    }

    public Outlet getSelectedOrDefaultOutlet() {
        Object outletObject = super.getValue();
        if (outletObject instanceof String) {
            return null;
        }
        if (outletObject instanceof Outlet) {
            return (Outlet)outletObject;
        }
        Store store = DataProvider.get().getStore();
        String defaultOutletId = store.getDefaultOutletId();
        if (StringUtils.isNotBlank((String)defaultOutletId)) {
            return OutletDAO.getInstance().get(defaultOutletId);
        }
        return null;
    }
}

