/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client;

import com.orocube.siiopa.cloud.ConsoleMessages;
import com.orocube.siiopa.cloud.client.CommonUIUtil;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;

public class YesNoCancelDialog
extends Window
implements Button.ClickListener {
    private YesNoCancelListener listener;
    private Button yes = CommonUIUtil.createColorButtonListner(ConsoleMessages.getString("YesNoDialog.0"), this);
    private Button no = CommonUIUtil.createColorButtonListner(ConsoleMessages.getString("YesNoDialog.1"), this);
    private Button cancel = CommonUIUtil.createColorButtonListner(ConsoleMessages.getString("OkCancelWindow.1"), this);

    public void setYesButtonCaption(String caption) {
        this.yes.setCaption(caption);
    }

    public void setYesButtonCaption(String caption, String style) {
        this.setYesButtonCaption(caption);
        if (style != null) {
            this.yes.setStyleName(style);
        }
    }

    public void setNoButtonCaption(String caption) {
        this.no.setCaption(caption);
    }

    public void setCancelButtonCaption(String caption) {
        this.cancel.setCaption(caption);
    }

    public YesNoCancelDialog(String caption, String question, YesNoCancelListener listener) {
        super(caption);
        this.listener = listener;
        this.setModal(true);
        this.setResizable(false);
        this.center();
        this.setClosable(false);
        this.setWidth("400px");
        this.setHeight("200px");
        VerticalLayout mainContent = new VerticalLayout();
        mainContent.setSizeFull();
        Panel mainPanel = new Panel();
        mainPanel.addStyleName("borderless");
        mainPanel.setHeight("100%");
        if (question != null) {
            Label lblQuestion = new Label(question);
            lblQuestion.setWidth("80%");
            lblQuestion.addStyleName("custom-heading");
            mainPanel.setContent((Component)lblQuestion);
        }
        HorizontalLayout buttonPanel = new HorizontalLayout();
        buttonPanel.setWidth("100%");
        buttonPanel.setSpacing(true);
        buttonPanel.addStyleName("custom-button-margin");
        this.yes.setSizeFull();
        this.no.setSizeFull();
        this.cancel.setSizeFull();
        buttonPanel.addComponents(new Component[]{this.yes, this.no, this.cancel});
        mainContent.addComponents(new Component[]{mainPanel, buttonPanel});
        mainContent.setExpandRatio((Component)mainPanel, 1.0f);
        mainContent.setComponentAlignment((Component)buttonPanel, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)mainContent);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getSource().equals(this.yes)) {
            this.listener.closed(true);
        } else if (event.getSource().equals(this.no)) {
            this.listener.closed(false);
        } else {
            this.listener.canceled();
        }
        this.close();
    }

    public static interface YesNoCancelListener {
        public void closed(boolean var1);

        public void canceled();
    }
}

