/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.siiopa.cloud.client.curd.grid.convater;

import com.floreantpos.util.NumberUtil;
import com.vaadin.data.util.converter.Converter;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class DoubleFormatConverter
implements Converter<String, Double> {
    private int beforeDecimal;
    private int afterDecimal;

    public DoubleFormatConverter() {
        this(8, 2);
    }

    public DoubleFormatConverter(int beforeDecimal, int afterDecimal) {
        this.beforeDecimal = beforeDecimal;
        this.afterDecimal = afterDecimal;
    }

    public Double convertToModel(String value, Class<? extends Double> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return 0.0;
        }
        value = value.trim();
        ParsePosition parsePosition = new ParsePosition(0);
        Number parsedValue = this.getFormat(locale).parse(value, parsePosition);
        if (parsedValue == null) {
            return 0.0;
        }
        double doubleValue = parsedValue.doubleValue();
        return doubleValue;
    }

    public String convertToPresentation(Double value, Class<? extends String> targetType, Locale locale) throws Converter.ConversionException {
        if (value == null) {
            return "0.00";
        }
        return NumberUtil.format((Number)value);
    }

    public Class<Double> getModelType() {
        return Double.class;
    }

    public Class<String> getPresentationType() {
        return String.class;
    }

    protected NumberFormat getFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        format.setGroupingUsed(true);
        format.setMaximumFractionDigits(this.afterDecimal);
        format.setParseIntegerOnly(false);
        return format;
    }
}

