/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.extension;

import java.awt.Component;
import java.io.File;

import org.apache.commons.logging.LogFactory;

import com.orocube.common.util.ProductInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.LicenseSelectionListener;

public abstract class AbstractFloreantPlugin implements FloreantPlugin, LicenseSelectionListener, ProductInfo {

	private OroLicense license;

	public abstract String getId();

	public abstract String getProductName();

	public abstract String getProductVersion();

	public abstract Integer getProductNumericVersion();

	public abstract Component getParent();

	public abstract String getUpdateServerURL();

	@Override
	public void licenseFileSelected(File pluginFile) throws Exception {
		try {
			OroLicense newLicense = LicenseUtil.loadAndValidate(pluginFile, getProductName(), getProductVersion(), TerminalUtil.getSystemUID());
			LicenseUtil.copyLicenseFile(pluginFile, getProductName());
			setLicense(newLicense);
		} catch (Exception e) {
			LogFactory.getLog(getClass()).error(e);
			throw e;
		}
	}

	@Override
	public boolean hasValidLicense() {
		if (license != null) {
			if (license.isDemoLicense()) {
				return license.isValid() && license.isPinVarified();
			}
			return license.isValid();
		}
		return false;
	}

	public OroLicense getLicense() {
		return license;
	}

	public void setLicense(OroLicense license) {
		this.license = license;
	}

	public boolean isActivated() {
		return getLicense() != null && getLicense().getLicenseMode() != LicenseMode.UNINILIZED;
	}

}
