package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseBalanceUpdateTransaction;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "paymentType", "balanceType" })
@XmlRootElement
public class BalanceUpdateTransaction extends BaseBalanceUpdateTransaction implements TimedModel {
	private static final long serialVersionUID = 1L;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public BalanceUpdateTransaction () {
    }

	/**
	 * Constructor for primary key
	 */
	public BalanceUpdateTransaction (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public BalanceUpdateTransaction (
		java.lang.String id,
		java.lang.String balanceTypeString,
		java.lang.String paymentTypeString,
		java.lang.String transactionType,
		java.lang.String transactionSubType) {

		super (
			id,
			balanceTypeString,
			paymentTypeString,
			transactionType,
			transactionSubType);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setPaymentType(PaymentType paymentType) {
		setPaymentTypeString(paymentType != null ? paymentType.name() : null);
	}

	@XmlTransient
	public PaymentType getPaymentType() {
		String paymentTypeString = super.getPaymentTypeString();
		if (paymentTypeString == null) {
			return null;
		}
		return PaymentType.valueOf(paymentTypeString);
	}

	public void setBalanceType(BalanceType balanceType) {
		setBalanceTypeString(balanceType != null ? balanceType.name() : null);
	}

	@XmlTransient
	public BalanceType getBalanceType() {
		String balanceTypeString = super.getBalanceTypeString();
		if (balanceTypeString == null) {
			return null;
		}
		return BalanceType.valueOf(balanceTypeString);
	}
}