/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BasePackagingUnit;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "conversionRate" })
@XmlRootElement
public class PackagingUnit extends BasePackagingUnit implements IUnit, TimedModel {
	private static final long serialVersionUID = 1L;
	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public PackagingUnit () {
    }

	/**
	 * Constructor for primary key
	 */
	public PackagingUnit (java.lang.String id) {
		super(id);
	}

	/**
	 * Constructor for required fields
	 */
	public PackagingUnit (
		java.lang.String id,
		java.lang.String code) {

		super (
			id,
			code);
	}

	/*[CONSTRUCTOR MARKER END]*/

	public void setPackagingDimension(PackagingDimension dimension) {
		if (dimension != null) {
			setDimension(dimension.name());
		}
	}

	public PackagingDimension getPackagingDimension() {
		String dimension2 = getDimension();

		if (StringUtils.isEmpty(dimension2)) {
			return null;
		}

		return PackagingDimension.valueOf(dimension2);
	}

	@Override
	public String toString() {
		return getName();
	}

	@Override
	public String getUniqueCode() {
		return super.getCode();
	}

	@Override
	public Double getConversionRate() {
		return getFactor();
	}
}