package com.floreantpos.model;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.Messages;

@SuppressWarnings("nls")
public enum TransactionSubType {
	//@formatter:off
	BALANCE_ADDED(Messages.getString("BALANCE_ADDED")),
	VOIDED_SALES( Messages.getString("PosGiftCardPlugin.0")),
	SALES(Messages.getString("PosGiftCardProcessor.9")),
	REFUNDED(Messages.getString("PosTransactionService.4")),
	VOIDED_BALANCE(Messages.getString("TicketDAO.0"));
	//@formatter:on

	private final String displayString;

	private TransactionSubType(String displayString) {
		this.displayString = displayString;
	}

	public String getDisplayString() {
		return displayString;
	}

	public static TransactionSubType fromString(String value) {
		if (StringUtils.isEmpty(value)) {
			return null;
		}

		for (TransactionSubType subType : TransactionSubType.values()) {
			if (subType.getDisplayString().equals(value)) {
				return subType;
			}
		}
		return null;
	}

	public static TransactionSubType getSubType(String propertyValue) {
		TransactionSubType subType;
		try {
			subType = TransactionSubType.valueOf(propertyValue);
		} catch (Exception e) {
			subType = TransactionSubType.fromString(propertyValue);
		}
		return subType;
	}

	@Override
	public String toString() {
		return displayString;
	}
}
