package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the OUTLET table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="OUTLET"
 */

public abstract class BaseOutlet  implements Comparable, Serializable {

	public static String REF = "Outlet"; //$NON-NLS-1$
	public static String PROP_NAME = "name"; //$NON-NLS-1$
	public static String PROP_DELETED = "deleted"; //$NON-NLS-1$
	public static String PROP_ADDRESS_ID = "addressId"; //$NON-NLS-1$
	public static String PROP_DEFAULT_GRATUITY_PERCENTAGE = "defaultGratuityPercentage"; //$NON-NLS-1$
	public static String PROP_DESCRIPTION = "description"; //$NON-NLS-1$
	public static String PROP_TAX_GROUP_ID = "taxGroupId"; //$NON-NLS-1$
	public static String PROP_CURRENCY_ID = "currencyId"; //$NON-NLS-1$
	public static String PROP_ID = "id"; //$NON-NLS-1$
	public static String PROP_SERVICE_CHARGE_PERCENTAGE = "serviceChargePercentage"; //$NON-NLS-1$
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime"; //$NON-NLS-1$
	public static String PROP_EXTRA_PROPERTIES = "extraProperties"; //$NON-NLS-1$
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime"; //$NON-NLS-1$
	public static String PROP_USE_DETAILED_RECONCILIATION = "useDetailedReconciliation"; //$NON-NLS-1$
	public static String PROP_ITEM_PRICE_INCLUDES_TAX = "itemPriceIncludesTax"; //$NON-NLS-1$
	public static String PROP_ENABLE_ONLINE_ORDERING = "enableOnlineOrdering"; //$NON-NLS-1$


	// constructors
	public BaseOutlet () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseOutlet (java.lang.String id) {
		this.setId(id);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key
	private java.lang.String id;

	private long version;

	// fields
			private java.util.Date lastUpdateTime;
				private java.util.Date lastSyncTime;
				private java.lang.String name;
				private java.lang.String description;
				private java.lang.Double serviceChargePercentage;
				private java.lang.Double defaultGratuityPercentage;
				private java.lang.String addressId;
				private java.lang.String taxGroupId;
				private java.lang.String currencyId;
				private java.lang.String extraProperties;
				private java.lang.Boolean deleted;
				private java.lang.Boolean itemPriceIncludesTax;
				private java.lang.Boolean useDetailedReconciliation;
				private java.lang.Boolean enableOnlineOrdering;
	
	// collections
	private java.util.List<com.floreantpos.model.Department> departments;
	private java.util.Map<String, String> properties;



	/**
	 * Return the unique identifier of this class
     * @hibernate.id
     *  generator-class="com.floreantpos.util.NameBaseIdGenerator"
     *  column="ID"
     */
	public java.lang.String getId () {
		return id;
	}

	/**
	 * Set the unique identifier of this class
	 * @param id the new ID
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */

	public long getVersion () {
			return version;
	}



	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
			public void setVersion (long version) {
			this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */

	public java.util.Date getLastUpdateTime () {
			return lastUpdateTime;
	}



	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
			public void setLastUpdateTime (java.util.Date lastUpdateTime) {
			this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */

	public java.util.Date getLastSyncTime () {
			return lastSyncTime;
	}



	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
			public void setLastSyncTime (java.util.Date lastSyncTime) {
			this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: NAME
	 */

	public java.lang.String getName () {
			return name;
	}



	/**
	 * Set the value related to the column: NAME
	 * @param name the NAME value
	 */
			public void setName (java.lang.String name) {
			this.name = name;
	}



	/**
	 * Return the value associated with the column: DESCRIPTION
	 */

	public java.lang.String getDescription () {
			return description;
	}



	/**
	 * Set the value related to the column: DESCRIPTION
	 * @param description the DESCRIPTION value
	 */
			public void setDescription (java.lang.String description) {
			this.description = description;
	}



	/**
	 * Return the value associated with the column: SC_PERCENTAGE
	 */

	public java.lang.Double getServiceChargePercentage () {
						return serviceChargePercentage == null ? Double.valueOf(0) : serviceChargePercentage;
		}



	/**
	 * Set the value related to the column: SC_PERCENTAGE
	 * @param serviceChargePercentage the SC_PERCENTAGE value
	 */
			public void setServiceChargePercentage (java.lang.Double serviceChargePercentage) {
			this.serviceChargePercentage = serviceChargePercentage;
	}



	/**
	 * Return the value associated with the column: GRATUITY_PERCENTAGE
	 */

	public java.lang.Double getDefaultGratuityPercentage () {
						return defaultGratuityPercentage == null ? Double.valueOf(0) : defaultGratuityPercentage;
		}



	/**
	 * Set the value related to the column: GRATUITY_PERCENTAGE
	 * @param defaultGratuityPercentage the GRATUITY_PERCENTAGE value
	 */
			public void setDefaultGratuityPercentage (java.lang.Double defaultGratuityPercentage) {
			this.defaultGratuityPercentage = defaultGratuityPercentage;
	}



	/**
	 * Return the value associated with the column: ADDRESS_ID
	 */

	public java.lang.String getAddressId () {
			return addressId;
	}



	/**
	 * Set the value related to the column: ADDRESS_ID
	 * @param addressId the ADDRESS_ID value
	 */
			public void setAddressId (java.lang.String addressId) {
			this.addressId = addressId;
	}



	/**
	 * Return the value associated with the column: TAX_GROUP_ID
	 */

	public java.lang.String getTaxGroupId () {
			return taxGroupId;
	}



	/**
	 * Set the value related to the column: TAX_GROUP_ID
	 * @param taxGroupId the TAX_GROUP_ID value
	 */
			public void setTaxGroupId (java.lang.String taxGroupId) {
			this.taxGroupId = taxGroupId;
	}



	/**
	 * Return the value associated with the column: CURRENCY
	 */

	public java.lang.String getCurrencyId () {
			return currencyId;
	}



	/**
	 * Set the value related to the column: CURRENCY
	 * @param currencyId the CURRENCY value
	 */
			public void setCurrencyId (java.lang.String currencyId) {
			this.currencyId = currencyId;
	}



	/**
	 * Return the value associated with the column: EXTRA_PROPERTIES
	 */

	public java.lang.String getExtraProperties () {
			return extraProperties;
	}



	/**
	 * Set the value related to the column: EXTRA_PROPERTIES
	 * @param extraProperties the EXTRA_PROPERTIES value
	 */
			public void setExtraProperties (java.lang.String extraProperties) {
			this.extraProperties = extraProperties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */

	public java.lang.Boolean isDeleted () {
						return deleted == null ? Boolean.valueOf(false) : deleted;
			}

	public java.lang.Boolean getDeleted () {
					return deleted == null ? Boolean.valueOf(false) : deleted;
			}


	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
			public void setDeleted (java.lang.Boolean deleted) {
			this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}
	
	/**
	 * Return the value associated with the column: PRICE_INCLUDES_TAX
	 */

	public java.lang.Boolean isItemPriceIncludesTax () {
					return itemPriceIncludesTax == null ? Boolean.FALSE : itemPriceIncludesTax;
		}

	public java.lang.Boolean getItemPriceIncludesTax () {
				return itemPriceIncludesTax == null ? Boolean.FALSE : itemPriceIncludesTax;
			}


	/**
	 * Set the value related to the column: PRICE_INCLUDES_TAX
	 * @param itemPriceIncludesTax the PRICE_INCLUDES_TAX value
	 */
			public void setItemPriceIncludesTax (java.lang.Boolean itemPriceIncludesTax) {
			this.itemPriceIncludesTax = itemPriceIncludesTax;
	}



	/**
	 * Return the value associated with the column: USE_DETAILED_RECONCILIATION
	 */

	public java.lang.Boolean isUseDetailedReconciliation () {
					return useDetailedReconciliation == null ? Boolean.FALSE : useDetailedReconciliation;
		}

	public java.lang.Boolean getUseDetailedReconciliation () {
				return useDetailedReconciliation == null ? Boolean.FALSE : useDetailedReconciliation;
			}


	/**
	 * Set the value related to the column: USE_DETAILED_RECONCILIATION
	 * @param useDetailedReconciliation the USE_DETAILED_RECONCILIATION value
	 */
			public void setUseDetailedReconciliation (java.lang.Boolean useDetailedReconciliation) {
			this.useDetailedReconciliation = useDetailedReconciliation;
	}



	/**
	 * Return the value associated with the column: ENABLE_ONLINE_ORDERING
	 */

	public java.lang.Boolean isEnableOnlineOrdering () {
					return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
		}

	public java.lang.Boolean getEnableOnlineOrdering () {
				return enableOnlineOrdering == null ? Boolean.FALSE : enableOnlineOrdering;
			}


	/**
	 * Set the value related to the column: ENABLE_ONLINE_ORDERING
	 * @param enableOnlineOrdering the ENABLE_ONLINE_ORDERING value
	 */
			public void setEnableOnlineOrdering (java.lang.Boolean enableOnlineOrdering) {
			this.enableOnlineOrdering = enableOnlineOrdering;
	}


	/**
	 * Return the value associated with the column: departments
	 */

	public java.util.List<com.floreantpos.model.Department> getDepartments () {
			return departments;
	}



	/**
	 * Set the value related to the column: departments
	 * @param departments the departments value
	 */
			public void setDepartments (java.util.List<com.floreantpos.model.Department> departments) {
			this.departments = departments;
	}

	public void addTodepartments (com.floreantpos.model.Department department) {
		if (null == getDepartments()) setDepartments(new java.util.ArrayList<com.floreantpos.model.Department>());
		getDepartments().add(department);
	}



	/**
	 * Return the value associated with the column: properties
	 */
				public java.util.Map<String, String> getProperties () {
			return properties;
	}



	/**
	 * Set the value related to the column: properties
	 * @param properties the properties value
	 */
			public void setProperties (java.util.Map<String, String> properties) {
			this.properties = properties;
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.Outlet)) return false;
		else {
			com.floreantpos.model.Outlet outlet = (com.floreantpos.model.Outlet) obj;
			if (null == this.getId() || null == outlet.getId()) return this == obj;
			else return (this.getId().equals(outlet.getId()));
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			if (null == this.getId()) return super.hashCode();
			else {
				String hashStr = this.getClass().getName() + ":" + this.getId().hashCode();
				this.hashCode = hashStr.hashCode();
			}
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}