package com.floreantpos.model.base;

import java.lang.Comparable;
import java.io.Serializable;


/**
 * This is an object that contains data related to the USERS table.
 * Do not modify this class because it will be overwritten if the configuration file
 * related to this class is modified.
 *
 * @hibernate.class
 *  table="USERS"
 */

public abstract class BaseUser  implements Comparable, Serializable {

	public static String REF = "User";
	public static String PROP_EMAIL = "email";
	public static String PROP_DRIVER = "driver";
	public static String PROP_ALLOW_RECEIVE_TIPS = "allowReceiveTips";
	public static String PROP_HAS_SYNC_ERROR = "hasSyncError";
	public static String PROP_LAST_CLOCK_IN_TIME = "lastClockInTime";
	public static String PROP_PROPERTIES = "properties";
	public static String PROP_OVERTIME_RATE_PER_HOUR = "overtimeRatePerHour";
	public static String PROP_LAST_UPDATE_TIME = "lastUpdateTime";
	public static String PROP_PHONE_NO = "phoneNo";
	public static String PROP_LAST_SYNC_TIME = "lastSyncTime";
	public static String PROP_IMAGE_ID = "imageId";
	public static String PROP_COST_PER_HOUR = "costPerHour";
	public static String PROP_CURRENT_CASH_DRAWER_ID = "currentCashDrawerId";
	public static String PROP_DELETED = "deleted";
	public static String PROP_PASSWORD = "password";
	public static String PROP_STAFF_BANK = "staffBank";
	public static String PROP_ROOT = "root";
	public static String PROP_FIRST_NAME = "firstName";
	public static String PROP_CLOCKED_IN = "clockedIn";
	public static String PROP_SSN = "ssn";
	public static String PROP_CAN_LOGIN_IN_CLOUD = "canLoginInCloud";
	public static String PROP_ACTIVE = "active";
	public static String PROP_USER_TYPE_ID = "userTypeId";
	public static String PROP_PARENT_USER_ID = "parentUserId";
	public static String PROP_STAFF_BANK_STARTED = "staffBankStarted";
	public static String PROP_CLOUD_SYNCED = "cloudSynced";
	public static String PROP_LONG_PASSWORD = "longPassword";
	public static String PROP_LAST_CLOCK_OUT_TIME = "lastClockOutTime";
	public static String PROP_AUTO_START_STAFF_BANK = "autoStartStaffBank";
	public static String PROP_AVAILABLE_FOR_DELIVERY = "availableForDelivery";
	public static String PROP_LAST_NAME = "lastName";
	public static String PROP_CURRENT_SHIFT_ID = "currentShiftId";
	public static String PROP_BLIND_ACCOUNTABLE_AMOUNT = "blindAccountableAmount";


	// constructors
	public BaseUser () {
		initialize();
	}

	/**
	 * Constructor for primary key
	 */
	public BaseUser (
		java.lang.String id,
		java.lang.String outletId) {

		this.setId(id);
		this.setOutletId(outletId);
		initialize();
	}

	protected void initialize () {}



	private int hashCode = Integer.MIN_VALUE;

	// primary key

	private java.lang.String id;

	private java.lang.String outletId;

	 long version;

	// fields
	private java.util.Date lastUpdateTime;
	private java.util.Date lastSyncTime;
	private java.lang.String password;
	private java.lang.String longPassword;
	private java.lang.String firstName;
	private java.lang.String lastName;
	private java.lang.String email;
	private java.lang.String ssn;
	private java.lang.Double costPerHour;
	private java.lang.Boolean clockedIn;
	private java.lang.Boolean canLoginInCloud;
	private java.util.Date lastClockInTime;
	private java.util.Date lastClockOutTime;
	private java.lang.String phoneNo;
	private java.lang.Boolean driver;
	private java.lang.Boolean allowReceiveTips;
	private java.lang.Boolean staffBank;
	private java.lang.Boolean autoStartStaffBank;
	private java.lang.Boolean staffBankStarted;
	private java.lang.Boolean blindAccountableAmount;
	private java.lang.Boolean availableForDelivery;
	private java.lang.Boolean active;
	private java.lang.String imageId;
	private java.lang.Boolean root;
	private java.lang.String currentCashDrawerId;
	private java.lang.Double overtimeRatePerHour;
	private java.lang.String currentShiftId;
	private java.lang.String userTypeId;
	private java.lang.String parentUserId;
	private java.lang.Boolean cloudSynced;
	private java.lang.Boolean hasSyncError;
	private java.lang.String properties;
	private java.lang.Boolean deleted;

	// collections
	private java.util.List<com.floreantpos.model.User> linkedUser;



	/**
     * @hibernate.property
     *  column=ID
	 * not-null=true
	 */
	public java.lang.String getId () {
		return this.id;
	}

	/**
	 * Set the value related to the column: ID
	 * @param id the ID value
	 */
	public void setId (java.lang.String id) {
		this.id = id;
		this.hashCode = Integer.MIN_VALUE;
	}

	/**
     * @hibernate.property
     *  column=OUTLET_ID
	 * not-null=true
	 */
	public java.lang.String getOutletId () {
		return this.outletId;
	}

	/**
	 * Set the value related to the column: OUTLET_ID
	 * @param outletId the OUTLET_ID value
	 */
	public void setOutletId (java.lang.String outletId) {
		this.outletId = outletId;
		this.hashCode = Integer.MIN_VALUE;
	}



	/**
	 * Return the value associated with the column: VERSION_NO
	 */
	public long getVersion () {
		return version;
	}

	/**
	 * Set the value related to the column: VERSION_NO
	 * @param version the VERSION_NO value
	 */
	public void setVersion (long version) {
		this.version = version;
	}




	/**
	 * Return the value associated with the column: LAST_UPDATE_TIME
	 */
	public java.util.Date getLastUpdateTime () {
		return lastUpdateTime;
	}

	/**
	 * Set the value related to the column: LAST_UPDATE_TIME
	 * @param lastUpdateTime the LAST_UPDATE_TIME value
	 */
	public void setLastUpdateTime (java.util.Date lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}



	/**
	 * Return the value associated with the column: LAST_SYNC_TIME
	 */
	public java.util.Date getLastSyncTime () {
		return lastSyncTime;
	}

	/**
	 * Set the value related to the column: LAST_SYNC_TIME
	 * @param lastSyncTime the LAST_SYNC_TIME value
	 */
	public void setLastSyncTime (java.util.Date lastSyncTime) {
		this.lastSyncTime = lastSyncTime;
	}



	/**
	 * Return the value associated with the column: USER_PASS
	 */
	public java.lang.String getPassword () {
		return password;
	}

	/**
	 * Set the value related to the column: USER_PASS
	 * @param password the USER_PASS value
	 */
	public void setPassword (java.lang.String password) {
		this.password = password;
	}



	/**
	 * Return the value associated with the column: LONG_PASS
	 */
	public java.lang.String getLongPassword () {
		return longPassword;
	}

	/**
	 * Set the value related to the column: LONG_PASS
	 * @param longPassword the LONG_PASS value
	 */
	public void setLongPassword (java.lang.String longPassword) {
		this.longPassword = longPassword;
	}



	/**
	 * Return the value associated with the column: FIRST_NAME
	 */
	public java.lang.String getFirstName () {
		return firstName;
	}

	/**
	 * Set the value related to the column: FIRST_NAME
	 * @param firstName the FIRST_NAME value
	 */
	public void setFirstName (java.lang.String firstName) {
		this.firstName = firstName;
	}



	/**
	 * Return the value associated with the column: LAST_NAME
	 */
	public java.lang.String getLastName () {
		return lastName;
	}

	/**
	 * Set the value related to the column: LAST_NAME
	 * @param lastName the LAST_NAME value
	 */
	public void setLastName (java.lang.String lastName) {
		this.lastName = lastName;
	}



	/**
	 * Return the value associated with the column: EMAIL
	 */
	public java.lang.String getEmail () {
		return email;
	}

	/**
	 * Set the value related to the column: EMAIL
	 * @param email the EMAIL value
	 */
	public void setEmail (java.lang.String email) {
		this.email = email;
	}



	/**
	 * Return the value associated with the column: SSN
	 */
	public java.lang.String getSsn () {
		return ssn;
	}

	/**
	 * Set the value related to the column: SSN
	 * @param ssn the SSN value
	 */
	public void setSsn (java.lang.String ssn) {
		this.ssn = ssn;
	}



	/**
	 * Return the value associated with the column: COST_PER_HOUR
	 */
	public java.lang.Double getCostPerHour () {
		return costPerHour;
	}

	/**
	 * Set the value related to the column: COST_PER_HOUR
	 * @param costPerHour the COST_PER_HOUR value
	 */
	public void setCostPerHour (java.lang.Double costPerHour) {
		this.costPerHour = costPerHour;
	}



	/**
	 * Return the value associated with the column: CLOCKED_IN
	 */
	public java.lang.Boolean isClockedIn () {
		return clockedIn;
	}

	/**
	 * Set the value related to the column: CLOCKED_IN
	 * @param clockedIn the CLOCKED_IN value
	 */
	public void setClockedIn (java.lang.Boolean clockedIn) {
		this.clockedIn = clockedIn;
	}



	/**
	 * Return the value associated with the column: CLOUD_LOGIN_ENABLED
	 */
	public java.lang.Boolean isCanLoginInCloud () {
		return canLoginInCloud;
	}

	/**
	 * Set the value related to the column: CLOUD_LOGIN_ENABLED
	 * @param canLoginInCloud the CLOUD_LOGIN_ENABLED value
	 */
	public void setCanLoginInCloud (java.lang.Boolean canLoginInCloud) {
		this.canLoginInCloud = canLoginInCloud;
	}



	/**
	 * Return the value associated with the column: LAST_CLOCK_IN_TIME
	 */
	public java.util.Date getLastClockInTime () {
		return lastClockInTime;
	}

	/**
	 * Set the value related to the column: LAST_CLOCK_IN_TIME
	 * @param lastClockInTime the LAST_CLOCK_IN_TIME value
	 */
	public void setLastClockInTime (java.util.Date lastClockInTime) {
		this.lastClockInTime = lastClockInTime;
	}



	/**
	 * Return the value associated with the column: LAST_CLOCK_OUT_TIME
	 */
	public java.util.Date getLastClockOutTime () {
		return lastClockOutTime;
	}

	/**
	 * Set the value related to the column: LAST_CLOCK_OUT_TIME
	 * @param lastClockOutTime the LAST_CLOCK_OUT_TIME value
	 */
	public void setLastClockOutTime (java.util.Date lastClockOutTime) {
		this.lastClockOutTime = lastClockOutTime;
	}



	/**
	 * Return the value associated with the column: PHONE_NO
	 */
	public java.lang.String getPhoneNo () {
		return phoneNo;
	}

	/**
	 * Set the value related to the column: PHONE_NO
	 * @param phoneNo the PHONE_NO value
	 */
	public void setPhoneNo (java.lang.String phoneNo) {
		this.phoneNo = phoneNo;
	}



	/**
	 * Return the value associated with the column: IS_DRIVER
	 */
	public java.lang.Boolean isDriver () {
		return driver;
	}

	/**
	 * Set the value related to the column: IS_DRIVER
	 * @param driver the IS_DRIVER value
	 */
	public void setDriver (java.lang.Boolean driver) {
		this.driver = driver;
	}



	/**
	 * Return the value associated with the column: ALLOW_RECEIVE_TIPS
	 */
	public java.lang.Boolean isAllowReceiveTips () {
		return allowReceiveTips;
	}

	/**
	 * Set the value related to the column: ALLOW_RECEIVE_TIPS
	 * @param allowReceiveTips the ALLOW_RECEIVE_TIPS value
	 */
	public void setAllowReceiveTips (java.lang.Boolean allowReceiveTips) {
		this.allowReceiveTips = allowReceiveTips;
	}



	/**
	 * Return the value associated with the column: STAFF_BANK
	 */
	public java.lang.Boolean isStaffBank () {
		return staffBank;
	}

	/**
	 * Set the value related to the column: STAFF_BANK
	 * @param staffBank the STAFF_BANK value
	 */
	public void setStaffBank (java.lang.Boolean staffBank) {
		this.staffBank = staffBank;
	}



	/**
	 * Return the value associated with the column: AUTO_START_STAFF_BANK
	 */
	public java.lang.Boolean isAutoStartStaffBank () {
		return autoStartStaffBank;
	}

	/**
	 * Set the value related to the column: AUTO_START_STAFF_BANK
	 * @param autoStartStaffBank the AUTO_START_STAFF_BANK value
	 */
	public void setAutoStartStaffBank (java.lang.Boolean autoStartStaffBank) {
		this.autoStartStaffBank = autoStartStaffBank;
	}



	/**
	 * Return the value associated with the column: STAFF_BANK_STARTED
	 */
	public java.lang.Boolean isStaffBankStarted () {
		return staffBankStarted;
	}

	/**
	 * Set the value related to the column: STAFF_BANK_STARTED
	 * @param staffBankStarted the STAFF_BANK_STARTED value
	 */
	public void setStaffBankStarted (java.lang.Boolean staffBankStarted) {
		this.staffBankStarted = staffBankStarted;
	}



	/**
	 * Return the value associated with the column: BLIND_ACCOUNTABLE_AMOUNT
	 */
	public java.lang.Boolean isBlindAccountableAmount () {
		return blindAccountableAmount;
	}

	/**
	 * Set the value related to the column: BLIND_ACCOUNTABLE_AMOUNT
	 * @param blindAccountableAmount the BLIND_ACCOUNTABLE_AMOUNT value
	 */
	public void setBlindAccountableAmount (java.lang.Boolean blindAccountableAmount) {
		this.blindAccountableAmount = blindAccountableAmount;
	}



	/**
	 * Return the value associated with the column: AVAILABLE_FOR_DELIVERY
	 */
	public java.lang.Boolean isAvailableForDelivery () {
		return availableForDelivery;
	}

	/**
	 * Set the value related to the column: AVAILABLE_FOR_DELIVERY
	 * @param availableForDelivery the AVAILABLE_FOR_DELIVERY value
	 */
	public void setAvailableForDelivery (java.lang.Boolean availableForDelivery) {
		this.availableForDelivery = availableForDelivery;
	}



	/**
	 * Return the value associated with the column: ACTIVE
	 */
	public java.lang.Boolean isActive () {
		return active;
	}

	/**
	 * Set the value related to the column: ACTIVE
	 * @param active the ACTIVE value
	 */
	public void setActive (java.lang.Boolean active) {
		this.active = active;
	}



	/**
	 * Return the value associated with the column: IMAGE_ID
	 */
	public java.lang.String getImageId () {
		return imageId;
	}

	/**
	 * Set the value related to the column: IMAGE_ID
	 * @param imageId the IMAGE_ID value
	 */
	public void setImageId (java.lang.String imageId) {
		this.imageId = imageId;
	}



	/**
	 * Return the value associated with the column: ROOT
	 */
	public java.lang.Boolean isRoot () {
		return root;
	}

	/**
	 * Set the value related to the column: ROOT
	 * @param root the ROOT value
	 */
	public void setRoot (java.lang.Boolean root) {
		this.root = root;
	}



	/**
	 * Return the value associated with the column: CURRENT_CASH_DRAWER_ID
	 */
	public java.lang.String getCurrentCashDrawerId () {
		return currentCashDrawerId;
	}

	/**
	 * Set the value related to the column: CURRENT_CASH_DRAWER_ID
	 * @param currentCashDrawerId the CURRENT_CASH_DRAWER_ID value
	 */
	public void setCurrentCashDrawerId (java.lang.String currentCashDrawerId) {
		this.currentCashDrawerId = currentCashDrawerId;
	}



	/**
	 * Return the value associated with the column: OVERTIME_RATE_PER_HOUR
	 */
	public java.lang.Double getOvertimeRatePerHour () {
		return overtimeRatePerHour;
	}

	/**
	 * Set the value related to the column: OVERTIME_RATE_PER_HOUR
	 * @param overtimeRatePerHour the OVERTIME_RATE_PER_HOUR value
	 */
	public void setOvertimeRatePerHour (java.lang.Double overtimeRatePerHour) {
		this.overtimeRatePerHour = overtimeRatePerHour;
	}



	/**
	 * Return the value associated with the column: SHIFT_ID
	 */
	public java.lang.String getCurrentShiftId () {
		return currentShiftId;
	}

	/**
	 * Set the value related to the column: SHIFT_ID
	 * @param currentShiftId the SHIFT_ID value
	 */
	public void setCurrentShiftId (java.lang.String currentShiftId) {
		this.currentShiftId = currentShiftId;
	}



	/**
	 * Return the value associated with the column: N_USER_TYPE
	 */
	public java.lang.String getUserTypeId () {
		return userTypeId;
	}

	/**
	 * Set the value related to the column: N_USER_TYPE
	 * @param userTypeId the N_USER_TYPE value
	 */
	public void setUserTypeId (java.lang.String userTypeId) {
		this.userTypeId = userTypeId;
	}



	/**
	 * Return the value associated with the column: PARENT_USER_ID
	 */
	public java.lang.String getParentUserId () {
		return parentUserId;
	}

	/**
	 * Set the value related to the column: PARENT_USER_ID
	 * @param parentUserId the PARENT_USER_ID value
	 */
	public void setParentUserId (java.lang.String parentUserId) {
		this.parentUserId = parentUserId;
	}



	/**
	 * Return the value associated with the column: CLOUD_SYNCED
	 */
	public java.lang.Boolean isCloudSynced () {
		return cloudSynced;
	}

	/**
	 * Set the value related to the column: CLOUD_SYNCED
	 * @param cloudSynced the CLOUD_SYNCED value
	 */
	public void setCloudSynced (java.lang.Boolean cloudSynced) {
		this.cloudSynced = cloudSynced;
	}



	/**
	 * Return the value associated with the column: HAS_SYNC_ERROR
	 */
	public java.lang.Boolean isHasSyncError () {
		return hasSyncError;
	}

	/**
	 * Set the value related to the column: HAS_SYNC_ERROR
	 * @param hasSyncError the HAS_SYNC_ERROR value
	 */
	public void setHasSyncError (java.lang.Boolean hasSyncError) {
		this.hasSyncError = hasSyncError;
	}



	/**
	 * Return the value associated with the column: PROPERTIES
	 */
	public java.lang.String getProperties () {
		return properties;
	}

	/**
	 * Set the value related to the column: PROPERTIES
	 * @param properties the PROPERTIES value
	 */
	public void setProperties (java.lang.String properties) {
		this.properties = properties;
	}



	/**
	 * Return the value associated with the column: DELETED
	 */
	public java.lang.Boolean isDeleted () {
		return deleted;
	}

	/**
	 * Set the value related to the column: DELETED
	 * @param deleted the DELETED value
	 */
	public void setDeleted (java.lang.Boolean deleted) {
		this.deleted = deleted;
	}


	/**
	 * Custom property
	 */
	public static String getDeletedDefaultValue () {
		return "false";
	}


	/**
	 * Return the value associated with the column: linkedUser
	 */
	public java.util.List<com.floreantpos.model.User> getLinkedUser () {
		return linkedUser;
	}

	/**
	 * Set the value related to the column: linkedUser
	 * @param linkedUser the linkedUser value
	 */
	public void setLinkedUser (java.util.List<com.floreantpos.model.User> linkedUser) {
		this.linkedUser = linkedUser;
	}

	public void addTolinkedUser (com.floreantpos.model.User user) {
		if (null == getLinkedUser()) setLinkedUser(new java.util.ArrayList<com.floreantpos.model.User>());
		getLinkedUser().add(user);
	}





	public boolean equals (Object obj) {
		if (null == obj) return false;
		if (!(obj instanceof com.floreantpos.model.User)) return false;
		else {
			com.floreantpos.model.User user = (com.floreantpos.model.User) obj;
			if (null != this.getId() && null != user.getId()) {
				if (!this.getId().equals(user.getId())) {
					return false;
				}
			}
			else {
				return false;
			}
			if (null != this.getOutletId() && null != user.getOutletId()) {
				if (!this.getOutletId().equals(user.getOutletId())) {
					return false;
				}
			}
			else {
				return false;
			}
			return true;
		}
	}

	public int hashCode () {
		if (Integer.MIN_VALUE == this.hashCode) {
			StringBuilder sb = new StringBuilder();
			if (null != this.getId()) {
				sb.append(this.getId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			if (null != this.getOutletId()) {
				sb.append(this.getOutletId().hashCode());
				sb.append(":");
			}
			else {
				return super.hashCode();
			}
			this.hashCode = sb.toString().hashCode();
		}
		return this.hashCode;
	}

	public int compareTo (Object obj) {
		if (obj.hashCode() > hashCode()) return 1;
		else if (obj.hashCode() < hashCode()) return -1;
		else return 0;
	}

	public String toString () {
		return super.toString();
	}


}