package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.swing.PaginatedListModel;
import com.orocube.rest.service.server.BaseDataServiceDao;

public class MenuItemModifierPageDAO extends BaseMenuItemModifierPageDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public MenuItemModifierPageDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime(obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime(obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime(obj);
		super.saveOrUpdate(obj, s);
	}

	public void saveOrUpdatePages(List<MenuItemModifierPage> menuPages) {
		Session session = null;
		Transaction tx = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();
			for (Iterator iterator = menuPages.iterator(); iterator.hasNext();) {
				MenuItemModifierPage menuPage = (MenuItemModifierPage) iterator.next();
				session.saveOrUpdate(menuPage);
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			PosLog.error(getClass(), e);
		} finally {
			session.close();
		}
	}

	public int getRowCount(String specId) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());

			if (StringUtils.isNotEmpty(specId)) {
				criteria.add(Restrictions.eq(MenuItemModifierPage.PROP_MODIFIER_SPEC_ID, specId));
			}
			criteria.add(Restrictions.eq(MenuItemModifierPage.PROP_VISIBLE, Boolean.TRUE));
			criteria.setProjection(Projections.rowCount());

			Number rowCount = (Number) criteria.uniqueResult();
			if (rowCount != null) {
				return rowCount.intValue();

			}
		} finally {
			closeSession(session);
		}
		return 0;
	}

	public void loadItems(MenuItemModifierSpec spec, PaginatedListModel listModel) {
		Session session = null;
		Criteria criteria = null;
		try {
			session = createNewSession();
			criteria = session.createCriteria(getReferenceClass());
			criteria.addOrder(Order.asc(MenuItemModifierPage.PROP_SORT_ORDER));
			if (spec != null) {
				criteria.add(Restrictions.eq(MenuItemModifierPage.PROP_MODIFIER_SPEC_ID, spec.getId()));
			}
			criteria.add(Restrictions.eq(MenuItemModifierPage.PROP_VISIBLE, Boolean.TRUE));
			criteria.setFirstResult(listModel.getCurrentRowIndex());
			criteria.setMaxResults(1);
			listModel.setData(criteria.list());
		} finally {
			closeSession(session);
		}
	}

	public void saveOrUpdateMenuItemModifierPageList(List<MenuItemModifierPage> dataList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		if (dataList == null)
			return;

		Transaction tx = null;
		Session session = null;
		try {
			session = createNewSession();
			tx = session.beginTransaction();

			for (Iterator<MenuItemModifierPage> iterator = dataList.iterator(); iterator.hasNext();) {
				MenuItemModifierPage item = (MenuItemModifierPage) iterator.next();
				String modifierSpecId = item.getModifierSpecId();
				
				BaseDataServiceDao.get().saveOrSetVersionMenuItemModiPage(session, item); 
				item.setModifierSpecId(modifierSpecId);
				//Need to used as parameter
				item.setUpdateLastUpdateTime(updateLastUpdateTime);
				item.setUpdateSyncTime(updateSyncTime);
				saveOrUpdate(item, session);
				
//				MenuItemModifierPage existingItem = get(item.getId());
//				if (existingItem != null) {
//					long version = existingItem.getVersion();
//					PropertyUtils.copyProperties(existingItem, item);
//					existingItem.setVersion(version);
//					existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
//					existingItem.setUpdateSyncTime(updateSyncTime);
//					update(existingItem, session);
//				}
//				else {
//					item.setUpdateLastUpdateTime(updateLastUpdateTime);
//					item.setUpdateSyncTime(updateSyncTime);
//					save(item, session);
//				}
			}
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			throw e;
		} finally {
			closeSession(session);
		}

	}
	
	public void initializeItems(MenuItemModifierPage modifierPage) {
		Session session = null;
		try {
			session = createNewSession();
			session.refresh(modifierPage);
			Hibernate.initialize(modifierPage.getPageItems());
		} finally {
			closeSession(session);
		}
	}
}