package com.floreantpos.model.dao;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.OrderHistory;
import com.floreantpos.model.dao.BaseOrderHistoryDAO;


public class OrderHistoryDAO extends BaseOrderHistoryDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public OrderHistoryDAO () {}


	@SuppressWarnings("unchecked")
	public List<OrderHistory> findOrdersByCustomerId(String customerId) {
		if (StringUtils.isBlank(customerId)) {
			return new ArrayList<>(0);
		}
		
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(OrderHistory.class);
			criteria.add(Restrictions.eq(OrderHistory.PROP_CUSTOMER_ID, customerId));
			criteria.addOrder(Order.desc(OrderHistory.PROP_ORDER_DATE));
			criteria.setMaxResults(50);
			
			return criteria.list();
		}
	}
}