/**
 * ************************************************************************
 * * The contents of this file are subject to the MRPL 1.2
 * * (the  "License"),  being   the  Mozilla   Public  License
 * * Version 1.1  with a permitted attribution clause; you may not  use this
 * * file except in compliance with the License. You  may  obtain  a copy of
 * * the License at http://www.floreantpos.org/license.html
 * * Software distributed under the License  is  distributed  on  an "AS IS"
 * * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * * License for the specific  language  governing  rights  and  limitations
 * * under the License.
 * * The Original Code is FLOREANT POS.
 * * The Initial Developer of the Original Code is OROCUBE LLC
 * * All portions are Copyright (C) 2015 OROCUBE LLC
 * * All Rights Reserved.
 * ************************************************************************
 */
package com.floreantpos.report;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;

import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;

@SuppressWarnings("deprecation")
public class OpenTicketSummaryReport extends Report {

	public OpenTicketSummaryReport() {
		super();
	}

	@Override
	public void refresh() throws Exception {
		String userName = getUserType() == null ? POSConstants.ALL : getUserType().getName();
		OrderType orderType = this.getOrderType();
		String orderTypeId = orderType == null ? POSConstants.ALL : orderType.getId();
		String orderTypeName = orderType == null ? POSConstants.ALL : orderType.getName();
		Date startDate = this.getStartDate();
		Date endDate = this.getEndDate();
		List<Ticket> tickets = TicketDAO.getInstance().findOpenTickets(this.getTerminal(), this.getUserType(), orderTypeId, startDate, endDate);
		TicketReportModel reportModel = new TicketReportModel();
		reportModel.setItems(tickets);
		reportModel.calculateGrandTotal();
		reportModel.calculateTotalDue();

		HashMap map = new HashMap();
		ReportUtil.populateRestaurantProperties(map);
		ReportUtil.populateReportHeader(map, getTerminal(), startDate, endDate, userName);
		map.put("orderType", ReportUtil.reportLabelWithBoldTag(POSConstants.ORDER_TYPE + ":") + " " + orderTypeName); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		ReportUtil.populateReportFooter(map);
		populateReportParams(map);
		map.put("reportTitle", Messages.getString("OpenTicketSummaryReport.0")); //$NON-NLS-1$ //$NON-NLS-2$
		map.put("grandTotal", reportModel.getGrandTotalAsString()); //$NON-NLS-1$
		map.put("totalDue", reportModel.getTotalDueAsString()); //$NON-NLS-1$

		JasperReport masterReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size(ReportConstants.OPEN_TICKET_SUMMARY_REPORT)); //$NON-NLS-1$
		JasperPrint print = JasperFillManager.fillReport(masterReport, map, new JRTableModelDataSource(reportModel));
		viewer = new JRViewer(print);
	}

	private void populateReportParams(HashMap map) {
		map.put("colId", POSConstants.ID); //$NON-NLS-1$
		map.put("colCreated", POSConstants.CREATED); //$NON-NLS-1$
		map.put("colOrderT", POSConstants.ORDER_TYPE); //$NON-NLS-1$
		map.put("colOwner", Messages.getString("GiftCardSummaryReportView.3")); //$NON-NLS-1$  //$NON-NLS-2$
		map.put("colTotal", POSConstants.TOTAL); //$NON-NLS-1$
		map.put("colDue", POSConstants.DUE); //$NON-NLS-1$
		map.put("colGTotal", POSConstants.GRAND_TOTAL); //$NON-NLS-1$
	}

	@Override
	public boolean isDateRangeSupported() {
		return false;
	}

	@Override
	public boolean isTypeSupported() {
		return false;
	}

}
