package com.floreantpos.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONObject;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.constants.AppConstants;
import com.floreantpos.constants.RestConstants;
import com.floreantpos.model.Address;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Discount;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;

public class DefaultDataInserter {
	private TaxGroup taxGroupSix33;
	private TaxGroup taxGroupSix01 = new TaxGroup("taxgroup2", null, "6.01"); //$NON-NLS-1$ //$NON-NLS-2$
	private TaxGroup taxGroupnineteen32 = new TaxGroup("taxgroup3", null, "19.32"); //$NON-NLS-1$ //$NON-NLS-2$
	private ModifierGroup cheeseModifierGroup;
	private ModifierGroup bevarageModifierGroup;
	private ModifierGroup toppingsModifierGroup;
	private MenuModifier americanCheese;
	private MenuModifier gouda;
	private MenuModifier chadder;
	private MenuModifier brie;
	private MenuModifier lemon;
	private MenuModifier salt;
	private MenuModifier mashroom;
	private MenuModifier pepparoni;
	private MenuModifier sausage;
	private MenuModifier onionsModifier;
	private InventoryUnit unitPiece;
	private InventoryUnit unitKg;
	private MenuItem beefBurger;
	private MenuItem bread;
	private MenuItem meat;
	private InventoryUnit unitGram;
	private InventoryUnit unitTon;

	private Attribute smallSize;
	private Attribute mediumSize;
	private Attribute largeSize;

	Date now = StoreDAO.getServerTimestamp();

	public void insertDefaultData(int databaseVersion, boolean isCloud) {
		createStore(databaseVersion);
	}

	public void createSampleData(boolean isCloud) {
		createAttributes();
		createPizzaCrust();
		createInventoryData();
		createMenuItemData(false);
		createMenuItemSize();
		createMultipliers();
		createDiscounts();
		doCompleteStoreSetup();
	}

	//	public void createSampleOutletData(String outletId) {
	//		createSampleCurrencies(outletId);
	//		createSampleTaxes(outletId);
	//	}

	public void createSampleTestData() {
		// user
		//createSampleUsers();
		// ordertypes
		//createOrderTypes();
		// attributes
		createAttributes();
		// pizza crust
		createPizzaCrust();
		// menuitem
		createInventoryData();
		createMenuItemData(true);

		createRecipe();
		// item size
		createMenuItemSize();
		// currency
		//createSampleCurrencies();
		// tax
		//createSampleTaxes();
		// multipliers
		createMultipliers();
		// discounts
		createDiscounts();
	}

	private void doCompleteStoreSetup() {
		try {
			Store store = StoreDAO.getRestaurant();
			store.addProperty(AppConstants.SETUP_COMPLETE, "true"); //$NON-NLS-1$
			StoreDAO.getInstance().update(store);
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
	}

	private void createMenuItemSize() {
		Session session = null;
		Transaction tx = null;
		MenuItemSizeDAO menuItemSizeDAO = MenuItemSizeDAO.getInstance();
		try {
			session = menuItemSizeDAO.createNewSession();
			tx = session.beginTransaction();

			String small = Messages.getString("DatabaseUtil.21");//$NON-NLS-1$
			String medium = Messages.getString("DatabaseUtil.22");//$NON-NLS-1$
			String large = Messages.getString("DatabaseUtil.23");//$NON-NLS-1$

			MenuItemSize menuItemSize = new MenuItemSize(small.toLowerCase());
			menuItemSize.setName(small);
			menuItemSize.setSortOrder(0);
			menuItemSize.setLastUpdateTime(now);
			session.save(menuItemSize);

			menuItemSize = new MenuItemSize(medium.toLowerCase());
			menuItemSize.setName(medium);
			menuItemSize.setSortOrder(1);
			menuItemSize.setLastUpdateTime(now);
			session.save(menuItemSize);

			menuItemSize = new MenuItemSize(large.toLowerCase());
			menuItemSize.setName(large);
			menuItemSize.setSortOrder(2);
			menuItemSize.setLastUpdateTime(now);
			session.save(menuItemSize);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			menuItemSizeDAO.closeSession(session);
		}
	}

	private void createPizzaCrust() {
		Session session = null;
		Transaction tx = null;
		PizzaCrustDAO pizzaCrustDAO = PizzaCrustDAO.getInstance();
		try {
			session = pizzaCrustDAO.createNewSession();
			tx = session.beginTransaction();

			String pan = Messages.getString("DatabaseUtil.24");//$NON-NLS-1$
			String handToss = Messages.getString("DatabaseUtil.25");//$NON-NLS-1$

			PizzaCrust crust = new PizzaCrust(pan.toLowerCase());
			crust.setName(pan);
			crust.setSortOrder(0);
			crust.setLastUpdateTime(now);
			session.save(crust);

			crust = new PizzaCrust(handToss.toLowerCase());
			crust.setName(handToss);
			crust.setSortOrder(1);
			crust.setLastUpdateTime(now);
			session.save(crust);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			pizzaCrustDAO.closeSession(session);
		}
	}

	private void createSampleCurrencies(String outletId) {
		Session session = null;
		Transaction tx = null;
		CurrencyDAO currencyDAO = CurrencyDAO.getInstance();
		try {
			session = currencyDAO.createNewSession();
			tx = session.beginTransaction();

			Currency currency = new Currency("euro", outletId);
			currency.setName("EUR"); //$NON-NLS-1$
			currency.setSymbol("E"); //$NON-NLS-1$
			currency.setExchangeRate(0.8);
			currency.setLastUpdateTime(now);
			session.save(currency);

			currency = new Currency("brazil", outletId); //$NON-NLS-1$
			currency.setName("BRL"); //$NON-NLS-1$
			currency.setSymbol("B"); //$NON-NLS-1$
			currency.setExchangeRate(3.47);
			currency.setLastUpdateTime(now);
			session.save(currency);

			currency = new Currency("argentinepeso", outletId); //$NON-NLS-1$
			currency.setName("ARS"); //$NON-NLS-1$
			currency.setSymbol("P"); //$NON-NLS-1$
			currency.setExchangeRate(13.89);
			currency.setLastUpdateTime(now);
			session.save(currency);

			currency = new Currency("guarani", outletId); //$NON-NLS-1$
			currency.setName("PYG"); //$NON-NLS-1$
			currency.setSymbol("P"); //$NON-NLS-1$
			currency.setLastUpdateTime(now);
			currency.setExchangeRate(5639.78);
			session.save(currency);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			currencyDAO.closeSession(session);
		}
	}

	private void createDefaultCurrency(String outletId, JSONObject dataJsonObj) {
		Session session = null;
		Transaction tx = null;
		CurrencyDAO currencyDAO = CurrencyDAO.getInstance();
		try {
			session = currencyDAO.createNewSession();
			tx = session.beginTransaction();
			Currency currency = new Currency(dataJsonObj.getString(RestConstants.CURRENCY_CODE), outletId); //$NON-NLS-1$
			currency.setName(dataJsonObj.getString(RestConstants.CURRENCY_NAME)); //$NON-NLS-1$
			currency.setCode(dataJsonObj.getString(RestConstants.CURRENCY_CODE)); //$NON-NLS-1$
			currency.setSymbol(dataJsonObj.getString(RestConstants.CURRENCY_SYMBOL)); //$NON-NLS-1$
			currency.setExchangeRate(dataJsonObj.getDouble(RestConstants.CURRENCY_EX_RATE));
			currency.setMain(true);
			currency.setLastUpdateTime(now);
			session.save(currency);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			currencyDAO.closeSession(session);
		}
	}

	private void createDefaultTax(String outletId, String code, double taxRate) {
		Session session = null;
		Transaction tx = null;
		TaxGroupDAO taxGroupDAO = TaxGroupDAO.getInstance();
		try {
			session = taxGroupDAO.createNewSession();
			tx = session.beginTransaction();
			Tax tax = new Tax();
			tax.setId(code);
			tax.setOutletId(outletId);
			tax.setName(code); //$NON-NLS-1$
			tax.setRate(Double.valueOf(taxRate));
			tax.setLastUpdateTime(now);
			taxGroupSix33 = new TaxGroup("taxgroup1", outletId, code); //$NON-NLS-1$ //$NON-NLS-2$
			taxGroupSix33.addTotaxes(tax);
			taxGroupSix33.setLastUpdateTime(now);
			session.save(tax);
			session.save(taxGroupSix33);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			taxGroupDAO.closeSession(session);
		}
	}

	//	private void createDefaultUser() {
	//		Session session = null;
	//		Transaction tx = null;
	//		UserTypeDAO userTypeDAO = UserTypeDAO.getInstance();
	//		try {
	//			session = userTypeDAO.createNewSession();
	//			tx = session.beginTransaction();
	//
	//			UserType administrator = new UserType();
	//			administrator.setId((com.floreantpos.POSConstants.ADMINISTRATOR).toLowerCase());
	//			administrator.setName(com.floreantpos.POSConstants.ADMINISTRATOR);
	//			administrator.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
	//			administrator.setLastUpdateTime(now);
	//			session.save(administrator);
	//
	//			User administratorUser = new User();
	//			administratorUser.setId("123"); //$NON-NLS-1$
	//			administratorUser.setEncryptedPassword("1111"); //$NON-NLS-1$
	//			administratorUser.setFirstName("admin"); //$NON-NLS-1$
	//			administratorUser.setLastName("s"); //$NON-NLS-1$
	//			administratorUser.setType(administrator);
	//			administratorUser.setRoot(true);
	//			administratorUser.setActive(true);
	//			administratorUser.setLastUpdateTime(now);
	//
	//			session.save(administratorUser);
	//			tx.commit();
	//		} catch (Exception e) {
	//			if (tx != null) {
	//				tx.rollback();
	//				PosLog.error(getClass(), e);
	//			}
	//		} finally {
	//			userTypeDAO.closeSession(session);
	//		}
	//	}

	public static void createStore(int databaseVersion) {
		Session session = null;
		Transaction tx = null;
		StoreDAO storeDAO = StoreDAO.getInstance();
		Date now = StoreDAO.getServerTimestamp();

		try {
			session = storeDAO.createNewSession();
			tx = session.beginTransaction();

			Address address = new Address("store-address"); //$NON-NLS-1$
			address.setAddressLine("203 West Main Street,"); //$NON-NLS-1$
			address.setAddressLine2("South Carolina"); //$NON-NLS-1$
			address.setLastUpdateTime(now);
			session.save(address);

			Store store = new Store();
			store.setId("1"); //$NON-NLS-1$
			store.setUuid(UUID.randomUUID().toString());
			store.setName("Demo Restaurant"); //$NON-NLS-1$
			String outletName = "Main"; //$NON-NLS-1$
			store.setOutletName(outletName); //$NON-NLS-1$
			store.setDefaultOutletId(NameBaseIdGenerator.generateId(outletName));
			store.setAddressLine1("203 West Main Street,"); //$NON-NLS-1$
			store.setAddressLine2("South Carolina"); //$NON-NLS-1$
			store.setProperties(new HashMap<String, String>());
			store.setDatabaseVersion(databaseVersion);
			store.setLastUpdateTime(now);
			store.setAddress(address);

			session.saveOrUpdate(store);

			//			Outlet outlet = new Outlet(NameBaseIdGenerator.generateId(outletName));
			//			outlet.setName(outletName);
			//			outlet.setLastUpdateTime(now);

			//outlet.setAddress(address);
			//session.save(outlet);

			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(DefaultDataInserter.class, e);
			}
		} finally {
			storeDAO.closeSession(session);
		}
	}

	private void createSampleTaxes(String outletId) {
		Session session = null;
		Transaction tx = null;
		TaxGroupDAO taxGroupDAO = TaxGroupDAO.getInstance();
		try {
			session = taxGroupDAO.createNewSession();
			tx = session.beginTransaction();

			Tax five89 = new Tax("five89", "five 89", 5.89); //$NON-NLS-1$ //$NON-NLS-2$
			five89.setOutletId(outletId);
			five89.setLastUpdateTime(now);
			session.save(five89);

			Tax zero12 = new Tax("zero12", "zero 12", 0.12); //$NON-NLS-1$ //$NON-NLS-2$
			zero12.setOutletId(outletId);
			zero12.setLastUpdateTime(now);
			session.save(zero12);

			Tax fifteen45 = new Tax("fifteen45", "fifteen 45", 15.45); //$NON-NLS-1$ //$NON-NLS-2$
			fifteen45.setOutletId(outletId);
			fifteen45.setLastUpdateTime(now);
			session.save(fifteen45);

			Tax three87 = new Tax("three87", "three87", 3.87); //$NON-NLS-1$ //$NON-NLS-2$
			three87.setOutletId(outletId);
			three87.setLastUpdateTime(now);
			session.save(three87);

			// Tax Group
			taxGroupSix01.setOutletId(outletId);
			taxGroupSix01.addTotaxes(five89);
			taxGroupSix01.addTotaxes(zero12);
			taxGroupSix01.setLastUpdateTime(now);
			session.save(taxGroupSix01);

			taxGroupnineteen32.setOutletId(outletId);
			taxGroupnineteen32.addTotaxes(fifteen45);
			taxGroupnineteen32.addTotaxes(three87);
			taxGroupnineteen32.setLastUpdateTime(now);
			session.save(taxGroupnineteen32);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			taxGroupDAO.closeSession(session);
		}
	}

	private void createDiscounts() {
		Session session = null;
		Transaction tx = null;
		DiscountDAO discountDao = DiscountDAO.getInstance();
		try {
			session = discountDao.createNewSession();
			tx = session.beginTransaction();

			Discount discount1 = new Discount();
			discount1.setId("buy1get1");//$NON-NLS-1$
			discount1.setName(Messages.getString("DatabaseUtil.18", "Buy 1 and get 1 free")); //$NON-NLS-1$ //$NON-NLS-2$
			discount1.setType(1);
			discount1.setValue(100.0);
			discount1.setAutoApply(false);
			discount1.setMinimumBuy(2d);
			discount1.setQualificationType(0);
			discount1.setApplyToAll(true);
			discount1.setNeverExpire(true);
			discount1.setEnabled(true);
			discount1.setLastUpdateTime(now);

			session.save(discount1);

			Discount discount2 = new Discount();
			discount2.setId("buy2get1");//$NON-NLS-1$
			discount2.setName(Messages.getString("DatabaseUtil.19", "Buy 2 and get 1 free")); //$NON-NLS-1$ //$NON-NLS-2$
			discount2.setType(1);
			discount2.setValue(100.0);
			discount2.setAutoApply(true);
			discount2.setMinimumBuy(3d);
			discount2.setQualificationType(0);
			discount2.setApplyToAll(true);
			discount2.setNeverExpire(true);
			discount2.setEnabled(true);
			discount2.setLastUpdateTime(now);

			session.save(discount2);

			Discount discount3 = new Discount();
			discount3.setId("10%onItem");//$NON-NLS-1$
			discount3.setName(Messages.getString("DatabaseUtil.20", "10% Off on Item")); //$NON-NLS-1$ //$NON-NLS-2$
			discount3.setType(1);
			discount3.setValue(10.0);
			discount3.setAutoApply(false);
			discount3.setMinimumBuy(1d);
			discount3.setQualificationType(0);
			discount3.setApplyToAll(true);
			discount3.setNeverExpire(true);
			discount3.setEnabled(true);
			discount3.setLastUpdateTime(now);

			session.save(discount3);

			Discount discount4 = new Discount();
			discount4.setId("10%onTicket");//$NON-NLS-1$
			discount4.setName("10% on Ticket"); //$NON-NLS-1$
			discount4.setType(1);
			discount4.setValue(10.0);
			discount4.setAutoApply(false);
			discount4.setMinimumBuy(1d);
			discount4.setQualificationType(1);
			discount4.setApplyToAll(true);
			discount4.setNeverExpire(true);
			discount4.setEnabled(true);
			discount4.setLastUpdateTime(now);

			session.save(discount4);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			discountDao.closeSession(session);
		}
	}

	private void createOrderTypes(String outletId, String businessType) {
		Session session = null;
		Transaction tx = null;
		OrderTypeDAO orderTypeDAO = OrderTypeDAO.getInstance();
		try {
			session = orderTypeDAO.createNewSession();
			tx = session.beginTransaction();

			if (businessType.equalsIgnoreCase("Dine In")) { //$NON-NLS-1$
				OrderType orderType = new OrderType("dine_in", outletId); //$NON-NLS-1$
				orderType.setName(Messages.getString("DatabaseUtil.14")); //$NON-NLS-1$
				orderType.setShowTableSelection(true);
				orderType.setCloseOnPaid(true);
				orderType.setEnabled(true);
				orderType.setShouldPrintToKitchen(true);
				orderType.setShowInLoginScreen(true);
				orderType.setSortOrder(1);
				orderType.setLastUpdateTime(now);
				session.save(orderType);
			}
			else if (businessType.equalsIgnoreCase("Take out")) { //$NON-NLS-1$
				OrderType orderType = new OrderType("take_out", outletId); //$NON-NLS-1$
				orderType.setName(Messages.getString("DatabaseUtil.15")); //$NON-NLS-1$
				orderType.setShowTableSelection(false);
				orderType.setCloseOnPaid(true);
				orderType.setEnabled(true);
				orderType.setPrepaid(true);
				orderType.setShouldPrintToKitchen(true);
				orderType.setShowInLoginScreen(true);
				orderType.setSortOrder(2);
				orderType.setLastUpdateTime(now);
				session.save(orderType);
			}
			else if (businessType.equalsIgnoreCase("Retail")) { //$NON-NLS-1$
				OrderType orderType = new OrderType("retail", outletId); //$NON-NLS-1$
				orderType.setName(Messages.getString("DatabaseUtil.16")); //$NON-NLS-1$
				orderType.setShowTableSelection(false);
				orderType.setCloseOnPaid(true);
				orderType.setEnabled(true);
				orderType.setRetailOrder(true);
				orderType.setShouldPrintToKitchen(false);
				orderType.setShowInLoginScreen(true);
				orderType.setSortOrder(3);
				orderType.setLastUpdateTime(now);
				session.save(orderType);
			}
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			orderTypeDAO.closeSession(session);
		}
	}

	private void createSampleUsers(String outletId) {
		Session session = null;
		Transaction tx = null;
		UserDAO userDAO = UserDAO.getInstance();
		try {
			session = userDAO.createNewSession();
			tx = session.beginTransaction();

			UserType manager = new UserType();
			manager.setId((com.floreantpos.POSConstants.MANAGER).toLowerCase());
			manager.setName(com.floreantpos.POSConstants.MANAGER);
			manager.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
			manager.setLastUpdateTime(now);
			session.save(manager);

			UserType cashier = new UserType();
			cashier.setId((com.floreantpos.POSConstants.CASHIER).toLowerCase());
			cashier.setName(com.floreantpos.POSConstants.CASHIER);
			cashier.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET,
					UserPermission.SPLIT_TICKET, UserPermission.EDIT_OTHER_USERS_TICKETS)));
			cashier.setLastUpdateTime(now);
			session.save(cashier);

			UserType server = new UserType();
			server.setId("server"); //$NON-NLS-1$
			server.setName("SERVER"); //$NON-NLS-1$
			server.setPermissions(
					new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET, UserPermission.SPLIT_TICKET)));
			server.setLastUpdateTime(now);
			session.save(server);

			createManagerUser(manager, cashier, server);

			User cashierUser = new User();
			cashierUser.setId("125"); //$NON-NLS-1$
			cashierUser.setOutletId(outletId);
			cashierUser.setEncryptedPassword("3333"); //$NON-NLS-1$
			cashierUser.setFirstName("Cashier"); //$NON-NLS-1$
			cashierUser.setLastName("C"); //$NON-NLS-1$
			cashierUser.setType(cashier);
			cashierUser.setRoot(true);
			cashierUser.setActive(true);
			cashierUser.setLastUpdateTime(now);
			session.save(cashierUser);

			User serverUser = new User();
			serverUser.setId("126"); //$NON-NLS-1$
			serverUser.setOutletId(outletId);
			serverUser.setEncryptedPassword("4444"); //$NON-NLS-1$
			serverUser.setFirstName("John"); //$NON-NLS-1$
			serverUser.setLastName("Doe"); //$NON-NLS-1$
			serverUser.setType(server);
			serverUser.setRoot(true);
			serverUser.setActive(true);
			serverUser.setStaffBank(true);
			serverUser.setAutoStartStaffBank(true);
			serverUser.setLastUpdateTime(now);
			session.save(serverUser);

			serverUser = new User();
			serverUser.setId("127"); //$NON-NLS-1$
			serverUser.setOutletId(outletId);
			serverUser.setEncryptedPassword("6666"); //$NON-NLS-1$
			serverUser.setFirstName("Juthi"); //$NON-NLS-1$
			serverUser.setLastName("M"); //$NON-NLS-1$
			serverUser.setType(server);
			serverUser.setRoot(true);
			serverUser.setActive(true);
			serverUser.setLastUpdateTime(now);
			session.save(serverUser);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			userDAO.closeSession(session);
		}
	}

	private void createMenuItemData(boolean isTestData) {
		Session session = null;
		Transaction tx = null;
		MenuCategoryDAO menuCategoryDAO = MenuCategoryDAO.getInstance();
		try {
			session = menuCategoryDAO.createNewSession();
			tx = session.beginTransaction();

			MenuCategory fastfood = new MenuCategory();
			fastfood.setId("fastfood"); //$NON-NLS-1$
			fastfood.setName("FASTFOOD"); //$NON-NLS-1$
			fastfood.setVisible(true);
			fastfood.setSortOrder(1);
			fastfood.setLastUpdateTime(now);
			session.save(fastfood);

			MenuCategory drinks = new MenuCategory();
			drinks.setId("drinks"); //$NON-NLS-1$
			drinks.setName("DRINKS"); //$NON-NLS-1$
			drinks.setVisible(true);
			drinks.setSortOrder(2);
			drinks.setLastUpdateTime(now);
			session.save(drinks);

			MenuGroup burgerGroup = new MenuGroup();
			burgerGroup.setId("burger"); //$NON-NLS-1$
			burgerGroup.setName("BURGER"); //$NON-NLS-1$
			burgerGroup.setVisible(true);
			burgerGroup.setMenuCategoryId(fastfood.getId());
			burgerGroup.setMenuCategoryName(fastfood.getName());
			burgerGroup.setSortOrder(1);
			burgerGroup.setLastUpdateTime(now);
			session.save(burgerGroup);

			MenuGroup beverageGroup = new MenuGroup();
			beverageGroup.setId("beverage"); //$NON-NLS-1$
			beverageGroup.setName("BEVERAGE"); //$NON-NLS-1$
			beverageGroup.setVisible(true);
			beverageGroup.setMenuCategoryId(drinks.getId());
			beverageGroup.setMenuCategoryName(drinks.getName());
			beverageGroup.setSortOrder(2);
			beverageGroup.setLastUpdateTime(now);
			session.save(beverageGroup);

			MenuGroup sandwichGroup = new MenuGroup();
			sandwichGroup.setId("sandwich"); //$NON-NLS-1$
			sandwichGroup.setName("SANDWICH"); //$NON-NLS-1$
			sandwichGroup.setVisible(true);
			sandwichGroup.setMenuCategoryId(fastfood.getId());
			sandwichGroup.setMenuCategoryName(fastfood.getName());
			sandwichGroup.setSortOrder(3);
			sandwichGroup.setLastUpdateTime(now);
			session.save(sandwichGroup);

			createMenuModifiers(session);

			// BURGER
			MenuItem americanBurger = new MenuItem("americanBurger", "American Burger", 77.99); //$NON-NLS-1$ //$NON-NLS-2$
			americanBurger.setUnit(unitPiece);
			americanBurger.setCost(5.5);
			americanBurger.setVisible(true);
			americanBurger.setReorderLevel(5.0);
			americanBurger.setReplenishLevel(10.0);
			americanBurger.setMenuGroup(burgerGroup);
			americanBurger.setTaxGroup(taxGroupnineteen32);
			americanBurger.setLastUpdateTime(now);
			session.save(americanBurger);

			beefBurger = new MenuItem("beefBurger", "Beef Burger", 99.33); //$NON-NLS-1$ //$NON-NLS-2$
			beefBurger.setUnit(unitPiece);
			beefBurger.setCost(1.5);
			beefBurger.setVisible(true);
			beefBurger.setReorderLevel(5.0);
			beefBurger.setReplenishLevel(10.0);
			beefBurger.setMenuGroup(burgerGroup);
			beefBurger.setTaxGroup(taxGroupSix33);
			beefBurger.setLastUpdateTime(now);
			session.save(beefBurger);

			MenuItem customBurger = new MenuItem("customBurger", "Custom Burger", 45.66); //$NON-NLS-1$ //$NON-NLS-2$
			if (isTestData) {
				customBurger.setUnit(unitPiece);
				customBurger.setCost(5.5);
				customBurger.setReorderLevel(5.0);
				customBurger.setReplenishLevel(10.0);
				customBurger.setMenuGroup(burgerGroup);
				customBurger.setTaxGroup(taxGroupSix33);
				customBurger.setHasModifiers(true);
				customBurger.setHasMandatoryModifiers(true);
				customBurger.setLastUpdateTime(now);
				createCheeseMenuModifierSpec(customBurger);
				session.save(customBurger);
			}

			MenuItem numbBurger = new MenuItem("numbBurger", "Numb Burger", 23.32); //$NON-NLS-1$ //$NON-NLS-2$
			if (isTestData) {
				numbBurger.setUnit(unitPiece);
				numbBurger.setCost(5.5);
				numbBurger.setReorderLevel(5.0);
				numbBurger.setReplenishLevel(10.0);
				numbBurger.setMenuGroup(burgerGroup);
				numbBurger.setTaxGroup(taxGroupSix01);
				numbBurger.setHasModifiers(true);
				numbBurger.setHasMandatoryModifiers(true);
				numbBurger.setLastUpdateTime(now);
				createCheeseMenuModifierSpec(numbBurger);
				session.save(numbBurger);
			}

			MenuItem cheeseBurger = new MenuItem("cheeseBurger", "Cheese Burger", 75.89); //$NON-NLS-1$ //$NON-NLS-2$
			cheeseBurger.setUnit(unitPiece);
			cheeseBurger.setCost(5.5);
			cheeseBurger.setReorderLevel(5.0);
			cheeseBurger.setReplenishLevel(10.0);
			cheeseBurger.setMenuGroup(burgerGroup);
			cheeseBurger.setHasModifiers(true);
			cheeseBurger.setHasMandatoryModifiers(true);
			cheeseBurger.setTaxGroup(taxGroupnineteen32);
			cheeseBurger.setLastUpdateTime(now);
			createToppingsMenuModifierSpec(cheeseBurger);
			session.save(cheeseBurger);

			MenuItem chickenBurger = new MenuItem("chickenBurger", "Chicken Burger", 89.99); //$NON-NLS-1$ //$NON-NLS-2$
			chickenBurger.setUnit(unitPiece);
			chickenBurger.setCost(5.5);
			chickenBurger.setReorderLevel(5.0);
			chickenBurger.setReplenishLevel(10.0);
			chickenBurger.setMenuGroup(burgerGroup);
			chickenBurger.setTaxGroup(taxGroupSix33);
			chickenBurger.setLastUpdateTime(now);
			session.save(chickenBurger);

			MenuItem nullBurger = new MenuItem("nullBurger", "Null Burger", 66.99); //$NON-NLS-1$ //$NON-NLS-2$
			if (isTestData) {
				nullBurger.setUnit(unitPiece);
				nullBurger.setCost(5.5);
				nullBurger.setReorderLevel(5.0);
				nullBurger.setReplenishLevel(10.0);
				nullBurger.setMenuGroup(burgerGroup);
				nullBurger.setLastUpdateTime(now);
				session.save(nullBurger);
			}

			MenuItem hamBurger = new MenuItem("hamBurger", "Ham Burger", 85.35); //$NON-NLS-1$ //$NON-NLS-2$
			if (isTestData) {
				hamBurger.setUnit(unitPiece);
				hamBurger.setCost(5.5);
				hamBurger.setReorderLevel(5.0);
				hamBurger.setReplenishLevel(10.0);
				hamBurger.setMenuGroup(burgerGroup);
				hamBurger.setHasModifiers(true);
				hamBurger.setHasMandatoryModifiers(true);
				hamBurger.setLastUpdateTime(now);
				createToppingsMenuModifierSpec(hamBurger);
				session.save(hamBurger);
			}

			// RAW
			bread = new MenuItem("bread", "Bread", 10.00); //$NON-NLS-1$ //$NON-NLS-2$
			if (isTestData) {
				bread.setUnit(unitPiece);
				bread.setCost(3.0);
				bread.setReorderLevel(5.0);
				bread.setReplenishLevel(10.0);
				bread.setMenuGroup(burgerGroup);
				bread.setLastUpdateTime(now);
				session.save(bread);
			}

			if (isTestData) {
				meat = new MenuItem("meat", "Meat", 400.00); //$NON-NLS-1$ //$NON-NLS-2$
				meat.setUnit(unitKg);
				meat.setCost(250.0);
				meat.setReorderLevel(5.0);
				meat.setReplenishLevel(10.0);
				meat.setMenuGroup(burgerGroup);
				meat.setLastUpdateTime(now);
				session.save(meat);
			}

			// DRINKS
			MenuItem coke = new MenuItem("coke", "COKE", 14.99); //$NON-NLS-1$ //$NON-NLS-2$
			coke.setReorderLevel(5.0);
			coke.setReplenishLevel(10.0);
			coke.setUnit(unitPiece);
			coke.setCost(1.5);
			coke.setMenuGroup(beverageGroup);
			coke.setTaxGroup(taxGroupSix01);
			coke.setHasVariant(true);
			coke.setShouldPrintToKitchen(false);
			coke.setLastUpdateTime(now);
			session.save(coke);
			//if (!isCloud) {
			doCreateVariantForCoke(coke, session);
			//}

			MenuItem pepsi = new MenuItem("pepsi", "PEPSI", 7.77); //$NON-NLS-1$ //$NON-NLS-2$
			if (isTestData) {
				pepsi.setReorderLevel(5.0);
				pepsi.setReplenishLevel(10.0);
				pepsi.setUnit(unitPiece);
				pepsi.setCost(1.5);
				pepsi.setMenuGroup(beverageGroup);
				pepsi.setTaxGroup(taxGroupnineteen32);
				pepsi.setLastUpdateTime(now);
				pepsi.setHasVariant(true);
				pepsi.setHasModifiers(true);
				pepsi.setHasMandatoryModifiers(true);
				pepsi.setShouldPrintToKitchen(false);
				createBeverageMenuModifierSpec(pepsi);
				session.save(pepsi);
				doCreateVariantForPepsi(pepsi, session);
			}

			MenuItem fanta = new MenuItem("fanta", "FANTA", 8.91); //$NON-NLS-1$ //$NON-NLS-2$
			fanta.setMenuGroup(beverageGroup);
			fanta.setReorderLevel(5.0);
			fanta.setReplenishLevel(10.0);
			fanta.setTaxGroup(taxGroupSix01);
			fanta.setUnit(unitPiece);
			fanta.setCost(1.5);
			fanta.setShouldPrintToKitchen(false);
			fanta.setLastUpdateTime(now);
			session.save(fanta);

			MenuItem sprite = new MenuItem("sprite", "SPRITE", 11.13); //$NON-NLS-1$ //$NON-NLS-2$
			sprite.setMenuGroup(beverageGroup);
			sprite.setReorderLevel(5.0);
			sprite.setReplenishLevel(10.0);
			sprite.setTaxGroup(taxGroupSix33);
			sprite.setUnit(unitPiece);
			sprite.setCost(1.5);
			sprite.setShouldPrintToKitchen(false);
			sprite.setLastUpdateTime(now);
			session.save(sprite);

			// SANDWICH
			MenuItem chickenSandwich = new MenuItem("chickenSandwich", "CHICKEN SANDWICH", 51.32); //$NON-NLS-1$ //$NON-NLS-2$
			chickenSandwich.setTaxGroup(taxGroupnineteen32);
			chickenSandwich.setMenuGroup(sandwichGroup);
			chickenSandwich.setReorderLevel(5.0);
			chickenSandwich.setReplenishLevel(10.0);
			chickenSandwich.setVisible(true);
			chickenSandwich.setUnit(unitPiece);
			chickenSandwich.setCost(1.5);
			chickenSandwich.setLastUpdateTime(now);
			session.save(chickenSandwich);

			MenuItem beefSandwich = new MenuItem("beeefSandwich", "BEEF SANDWICH", 113.45); //$NON-NLS-1$ //$NON-NLS-2$
			beefSandwich.setTaxGroup(taxGroupSix01);
			beefSandwich.setMenuGroup(sandwichGroup);
			beefSandwich.setReorderLevel(5.0);
			beefSandwich.setVisible(true);
			beefSandwich.setReplenishLevel(10.0);
			beefSandwich.setUnit(unitPiece);
			beefSandwich.setCost(1.5);
			beefSandwich.setLastUpdateTime(now);
			session.save(beefSandwich);

			MenuItem hamSandwich = new MenuItem("hamSandwich", "HAM SANDWICH", 53.37); //$NON-NLS-1$ //$NON-NLS-2$
			hamSandwich.setMenuGroup(sandwichGroup);
			hamSandwich.setReorderLevel(5.0);
			hamSandwich.setVisible(true);
			hamSandwich.setReplenishLevel(10.0);
			hamSandwich.setTaxGroup(taxGroupSix33);
			hamSandwich.setUnit(unitPiece);
			hamSandwich.setCost(1.5);
			hamSandwich.setLastUpdateTime(now);
			session.save(hamSandwich);

			// Page creation
			MenuPage burgerPage = new MenuPage();
			burgerPage.setName("burgers"); //$NON-NLS-1$
			burgerPage.setCols(4);
			burgerPage.setRows(4);
			burgerPage.setButtonHeight(100);
			burgerPage.setButtonWidth(120);
			burgerPage.setVisible(true);
			burgerPage.setMenuGroupId(burgerGroup.getId());
			burgerPage.setLastUpdateTime(now);
			session.save(burgerPage);

			MenuPageItem menuPageItem = new MenuPageItem(0, 0, americanBurger, burgerPage);
			menuPageItem.setMenuPageId(burgerPage.getId());
			//			menuPageItem.setLastUpdateTime(now);
			session.save(menuPageItem);

			MenuPageItem menuPageItem2 = new MenuPageItem(1, 0, beefBurger, burgerPage);
			menuPageItem2.setMenuPageId(burgerPage.getId());
			session.save(menuPageItem2);

			MenuPageItem menuPageItem3 = new MenuPageItem(2, 0, chickenBurger, burgerPage);
			menuPageItem3.setMenuPageId(burgerPage.getId());
			session.save(menuPageItem3);

			MenuPageItem menuPageItem4 = new MenuPageItem(3, 0, cheeseBurger, burgerPage);
			menuPageItem4.setMenuPageId(burgerPage.getId());
			session.save(menuPageItem4);

			if (isTestData) {
				MenuPageItem menuPageItem5 = new MenuPageItem(0, 1, customBurger, burgerPage);
				menuPageItem5.setMenuPageId(burgerPage.getId());
				session.save(menuPageItem5);
			}

			if (isTestData) {
				MenuPageItem menuPageItem6 = new MenuPageItem(1, 1, hamBurger, burgerPage);
				menuPageItem6.setMenuPageId(burgerPage.getId());
				session.save(menuPageItem6);
			}

			if (isTestData) {
				MenuPageItem menuPageItem7 = new MenuPageItem(2, 1, nullBurger, burgerPage);
				menuPageItem7.setMenuPageId(burgerPage.getId());
				session.save(menuPageItem7);

				MenuPageItem menuPageItem8 = new MenuPageItem(3, 1, numbBurger, burgerPage);
				menuPageItem8.setMenuPageId(burgerPage.getId());
				session.save(menuPageItem8);
			}

			burgerPage.setLastUpdateTime(now);
			session.saveOrUpdate(burgerPage);

			MenuPage sandwichPage = new MenuPage();
			sandwichPage.setName("page 1"); //$NON-NLS-1$
			sandwichPage.setCols(4);
			sandwichPage.setRows(4);
			sandwichPage.setButtonHeight(100);
			sandwichPage.setButtonWidth(120);
			sandwichPage.setVisible(true);
			sandwichPage.setMenuGroupId(sandwichGroup.getId());
			sandwichPage.setLastUpdateTime(now);
			session.save(sandwichPage);

			MenuPageItem sandwichItem1 = new MenuPageItem(0, 0, beefSandwich, sandwichPage);
			sandwichItem1.setMenuPage(sandwichPage);
			session.save(sandwichItem1);

			MenuPageItem sandwichItem2 = new MenuPageItem(1, 0, chickenSandwich, sandwichPage);
			sandwichItem2.setMenuPage(sandwichPage);
			session.save(sandwichItem2);

			MenuPageItem sandwichItem3 = new MenuPageItem(2, 0, hamSandwich, sandwichPage);
			sandwichItem3.setMenuPage(sandwichPage);
			session.save(sandwichItem3);

			session.saveOrUpdate(sandwichPage);

			MenuPage drinksPage = new MenuPage();
			drinksPage.setName("page 1"); //$NON-NLS-1$
			drinksPage.setCols(4);
			drinksPage.setRows(4);
			drinksPage.setButtonHeight(100);
			drinksPage.setButtonWidth(120);
			drinksPage.setVisible(true);
			drinksPage.setMenuGroupId(beverageGroup.getId());
			drinksPage.setLastUpdateTime(now);
			session.save(drinksPage);

			MenuPageItem cokeItem = new MenuPageItem(1, 0, coke, drinksPage);
			cokeItem.setMenuPageId(drinksPage.getId());
			session.save(cokeItem);

			MenuPageItem fantaItem = new MenuPageItem(2, 0, fanta, drinksPage);
			fantaItem.setMenuPageId(drinksPage.getId());
			session.save(fantaItem);

			MenuPageItem spriteItem = new MenuPageItem(3, 0, sprite, drinksPage);
			spriteItem.setMenuPageId(drinksPage.getId());
			session.save(spriteItem);

			if (isTestData) {
				MenuPageItem pepsiItem = new MenuPageItem(0, 1, pepsi, drinksPage);
				pepsiItem.setMenuPageId(drinksPage.getId());
				session.save(pepsiItem);
			}

			session.saveOrUpdate(drinksPage);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			menuCategoryDAO.closeSession(session);
		}
	}

	private void createRecipe() {
		Session session = null;
		Transaction tx = null;
		RecepieDAO recepieDAO = RecepieDAO.getInstance();
		try {
			session = recepieDAO.createNewSession();
			tx = session.beginTransaction();

			Recepie recipe = new Recepie();
			recipe.setName("Beef Burger Recipe"); //$NON-NLS-1$
			recipe.setPortion(1.0);
			recipe.setYield(1.0);

			recipe.setCookingTime(60);
			//		recipe.setBatchProcess();
			//		recipe.setAdjustmentAmount(0.0);
			//		recipe.setLaborCost(0.0);

			recipe.setMenuItem(beefBurger);
			recipe.setYieldUnit(unitPiece.getCode());
			recipe.setPortionUnit(unitPiece.getUniqueCode());

			RecepieItem breadItem = new RecepieItem();
			breadItem.setInventoryItem(bread);
			breadItem.setQuantity(1.0);
			breadItem.setPercentage(100.0);
			breadItem.setUnit(unitPiece);
			breadItem.setUnitCode(unitPiece.getCode());
			recipe.addTorecepieItems(breadItem);

			RecepieItem meatItem = new RecepieItem();
			meatItem.setInventoryItem(meat);
			meatItem.setPercentage(10.0);
			meatItem.setQuantity(100.0);
			meatItem.setUnit(unitGram);
			meatItem.setUnitCode(unitGram.getCode());
			recipe.addTorecepieItems(meatItem);

			session.save(recipe);
			beefBurger.setDefaultRecipeId(recipe.getId());
			session.update(beefBurger);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			recepieDAO.closeSession(session);
		}
	}

	private void createMenuModifiers(Session session) {
		// first group modifier items
		americanCheese = new MenuModifier("americanCheese"); //$NON-NLS-1$
		americanCheese.setName("American"); //$NON-NLS-1$
		americanCheese.setPrice(2.99d);
		americanCheese.setTaxGroup(taxGroupnineteen32);
		americanCheese.setLastUpdateTime(now);
		session.save(americanCheese);

		gouda = new MenuModifier("gouda"); //$NON-NLS-1$
		gouda.setName("Gouda"); //$NON-NLS-1$
		gouda.setPrice(1d);
		gouda.setTaxGroup(taxGroupSix33);
		gouda.setLastUpdateTime(now);
		session.save(gouda);

		chadder = new MenuModifier("chadder"); //$NON-NLS-1$
		chadder.setName("Chadder"); //$NON-NLS-1$
		chadder.setPrice(1.25d);
		chadder.setTaxGroup(taxGroupSix33);
		chadder.setLastUpdateTime(now);
		session.save(chadder);

		brie = new MenuModifier("brie"); //$NON-NLS-1$
		brie.setName("Brie"); //$NON-NLS-1$
		brie.setPrice(2.00d);
		brie.setTaxGroup(taxGroupSix33);
		brie.setLastUpdateTime(now);
		session.save(brie);

		// first modifier group
		cheeseModifierGroup = new ModifierGroup("cheese"); //$NON-NLS-1$
		cheeseModifierGroup.setName("Cheese"); //$NON-NLS-1$
		cheeseModifierGroup.addTomodifiers(americanCheese);
		cheeseModifierGroup.addTomodifiers(gouda);
		cheeseModifierGroup.addTomodifiers(chadder);
		cheeseModifierGroup.addTomodifiers(brie);
		cheeseModifierGroup.setLastUpdateTime(now);
		session.save(cheeseModifierGroup);

		// second modifier group modifier items
		lemon = new MenuModifier("lemon"); //$NON-NLS-1$
		lemon.setName("Lemon"); //$NON-NLS-1$
		lemon.setPrice(0.79d);
		lemon.setTaxGroup(taxGroupSix01);
		lemon.setLastUpdateTime(now);
		session.save(lemon);

		salt = new MenuModifier("salt"); //$NON-NLS-1$
		salt.setName("Salt"); //$NON-NLS-1$
		salt.setPrice(0.27d);
		salt.setLastUpdateTime(now);
		session.save(salt);

		// third modifier group
		bevarageModifierGroup = new ModifierGroup("beverages"); //$NON-NLS-1$
		bevarageModifierGroup.setName("Beverages"); //$NON-NLS-1$
		bevarageModifierGroup.addTomodifiers(lemon);
		bevarageModifierGroup.addTomodifiers(salt);
		bevarageModifierGroup.setLastUpdateTime(now);
		session.save(bevarageModifierGroup);

		// second modifier group modifier items
		mashroom = new MenuModifier("mashroom"); //$NON-NLS-1$
		mashroom.setName("Mashroom"); //$NON-NLS-1$
		mashroom.setPrice(1d);
		mashroom.setLastUpdateTime(now);
		session.save(mashroom);

		pepparoni = new MenuModifier("pepparoni"); //$NON-NLS-1$
		pepparoni.setName("Pepparoni"); //$NON-NLS-1$
		pepparoni.setPrice(3.33d);
		pepparoni.setTaxGroup(taxGroupSix01);
		pepparoni.setLastUpdateTime(now);
		session.save(pepparoni);

		sausage = new MenuModifier("sausage"); //$NON-NLS-1$
		sausage.setName("Sausage"); //$NON-NLS-1$
		sausage.setPrice(1.25d);
		sausage.setLastUpdateTime(now);
		session.save(sausage);

		onionsModifier = new MenuModifier("onion"); //$NON-NLS-1$
		onionsModifier.setName("Onions"); //$NON-NLS-1$
		onionsModifier.setExtraPrice(2.75);
		// onionsModifier.setTaxGroup(taxGroup);
		onionsModifier.setShouldPrintToKitchen(true);
		onionsModifier.setPrice(2.0);
		onionsModifier.setLastUpdateTime(now);
		session.save(onionsModifier);

		// second modifier group
		toppingsModifierGroup = new ModifierGroup("toppings"); //$NON-NLS-1$
		toppingsModifierGroup.setName("Toppings"); //$NON-NLS-1$
		toppingsModifierGroup.addTomodifiers(mashroom);
		toppingsModifierGroup.addTomodifiers(pepparoni);
		toppingsModifierGroup.addTomodifiers(sausage);
		toppingsModifierGroup.addTomodifiers(onionsModifier);
		toppingsModifierGroup.setLastUpdateTime(now);
		session.save(toppingsModifierGroup);
	}

	private void createCheeseMenuModifierSpec(MenuItem menuItem) {
		Session session = null;
		Transaction tx = null;
		MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = MenuItemModifierPageItemDAO.getInstance();
		try {
			session = menuItemModifierPageItemDAO.createNewSession();
			tx = session.beginTransaction();

			// modifier specification
			MenuItemModifierSpec cheeseModifierGroupSpec = new MenuItemModifierSpec();
			cheeseModifierGroupSpec.setModifierGroup(cheeseModifierGroup);
			cheeseModifierGroupSpec.setName("Cheese"); //$NON-NLS-1$
			cheeseModifierGroupSpec.setMinQuantity(1);
			cheeseModifierGroupSpec.setMaxQuantity(2);
			cheeseModifierGroupSpec.setSortOrder(0);
			cheeseModifierGroupSpec.setEnable(true);
			cheeseModifierGroupSpec.setJumpGroup(true);
			cheeseModifierGroupSpec.setLastUpdateTime(now);
			session.save(cheeseModifierGroupSpec);

			MenuItemModifierPage cheeseModifierSpecPage = new MenuItemModifierPage();
			cheeseModifierSpecPage.setName("Page 1"); //$NON-NLS-1$
			cheeseModifierSpecPage.setButtonHeight(100);
			cheeseModifierSpecPage.setButtonWidth(100);
			cheeseModifierSpecPage.setRows(4);
			cheeseModifierSpecPage.setCols(4);
			cheeseModifierSpecPage.setVisible(true);
			cheeseModifierSpecPage.setSortOrder(1);
			cheeseModifierSpecPage.setFlixibleButtonSize(false);
			cheeseModifierSpecPage.setModifierSpecId(cheeseModifierGroupSpec.getId());
			cheeseModifierSpecPage.setLastUpdateTime(now);
			session.save(cheeseModifierSpecPage);

			MenuItemModifierPageItem cheesePageItem = new MenuItemModifierPageItem(0, 0, americanCheese, cheeseModifierSpecPage);
			cheesePageItem.setLastUpdateTime(now);
			session.saveOrUpdate(cheesePageItem);
			cheeseModifierSpecPage.addTopageItems(cheesePageItem);

			MenuItemModifierPageItem goudaPageItem = new MenuItemModifierPageItem(1, 0, gouda, cheeseModifierSpecPage);
			goudaPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(goudaPageItem);
			cheeseModifierSpecPage.addTopageItems(goudaPageItem);

			MenuItemModifierPageItem briePageItem = new MenuItemModifierPageItem(2, 0, brie, cheeseModifierSpecPage);
			briePageItem.setLastUpdateTime(now);
			session.saveOrUpdate(briePageItem);
			cheeseModifierSpecPage.addTopageItems(briePageItem);

			MenuItemModifierPageItem cheddarPageItem = new MenuItemModifierPageItem(3, 0, chadder, cheeseModifierSpecPage);
			cheddarPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(cheddarPageItem);
			cheeseModifierSpecPage.addTopageItems(cheddarPageItem);

			cheeseModifierGroupSpec.addTomodifierPages(cheeseModifierSpecPage);

			// modifier page

			// page item
			menuItem.addTomenuItemModiferSpecs(cheeseModifierGroupSpec);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			menuItemModifierPageItemDAO.closeSession(session);
		}
	}

	private void createBeverageMenuModifierSpec(MenuItem menuItem) {
		Session session = null;
		Transaction tx = null;
		MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = MenuItemModifierPageItemDAO.getInstance();
		try {
			session = menuItemModifierPageItemDAO.createNewSession();
			tx = session.beginTransaction();

			// modifier specification
			MenuItemModifierSpec beverageModifierGroupSpec = new MenuItemModifierSpec();
			beverageModifierGroupSpec.setModifierGroup(toppingsModifierGroup);
			beverageModifierGroupSpec.setName("Beverage"); //$NON-NLS-1$
			beverageModifierGroupSpec.setMinQuantity(1);
			beverageModifierGroupSpec.setMaxQuantity(2);
			beverageModifierGroupSpec.setSortOrder(0);
			beverageModifierGroupSpec.setEnable(true);
			beverageModifierGroupSpec.setJumpGroup(true);
			beverageModifierGroupSpec.setLastUpdateTime(now);
			session.save(beverageModifierGroupSpec);

			// modifier page
			MenuItemModifierPage beverageModifierSpecPage = new MenuItemModifierPage();
			beverageModifierSpecPage.setName("Page 1"); //$NON-NLS-1$
			beverageModifierSpecPage.setButtonHeight(100);
			beverageModifierSpecPage.setButtonWidth(100);
			beverageModifierSpecPage.setRows(4);
			beverageModifierSpecPage.setCols(4);
			beverageModifierSpecPage.setVisible(true);
			beverageModifierSpecPage.setSortOrder(1);
			beverageModifierSpecPage.setFlixibleButtonSize(false);
			beverageModifierSpecPage.setModifierSpecId(beverageModifierGroupSpec.getId());
			beverageModifierSpecPage.setLastUpdateTime(now);
			session.saveOrUpdate(beverageModifierSpecPage);

			// page item
			MenuItemModifierPageItem saltPageItem = new MenuItemModifierPageItem(0, 0, salt, beverageModifierSpecPage);
			saltPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(saltPageItem);
			beverageModifierSpecPage.addTopageItems(saltPageItem);

			MenuItemModifierPageItem lemonPageItem = new MenuItemModifierPageItem(1, 0, lemon, beverageModifierSpecPage);
			lemonPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(lemonPageItem);
			beverageModifierSpecPage.addTopageItems(lemonPageItem);

			beverageModifierGroupSpec.addTomodifierPages(beverageModifierSpecPage);
			menuItem.addTomenuItemModiferSpecs(beverageModifierGroupSpec);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			menuItemModifierPageItemDAO.closeSession(session);
		}

	}

	private void createToppingsMenuModifierSpec(MenuItem menuItem) {
		Session session = null;
		Transaction tx = null;
		MenuItemModifierSpecDAO menuItemModifierSpecDAO = MenuItemModifierSpecDAO.getInstance();
		try {
			session = menuItemModifierSpecDAO.createNewSession();
			tx = session.beginTransaction();

			// modifier specification
			MenuItemModifierSpec toppingsModifierGroupSpec = new MenuItemModifierSpec();
			toppingsModifierGroupSpec.setModifierGroup(toppingsModifierGroup);
			toppingsModifierGroupSpec.setName("toppings"); //$NON-NLS-1$
			toppingsModifierGroupSpec.setMinQuantity(1);
			toppingsModifierGroupSpec.setMaxQuantity(2);
			toppingsModifierGroupSpec.setSortOrder(0);
			toppingsModifierGroupSpec.setEnable(true);
			toppingsModifierGroupSpec.setJumpGroup(true);
			toppingsModifierGroupSpec.setLastUpdateTime(now);
			session.save(toppingsModifierGroupSpec);

			// modifier page
			MenuItemModifierPage toppingsModifierSpecPage = new MenuItemModifierPage();
			toppingsModifierSpecPage.setName("Page 1"); //$NON-NLS-1$
			toppingsModifierSpecPage.setButtonHeight(100);
			toppingsModifierSpecPage.setButtonWidth(100);
			toppingsModifierSpecPage.setRows(4);
			toppingsModifierSpecPage.setCols(4);
			toppingsModifierSpecPage.setVisible(true);
			toppingsModifierSpecPage.setSortOrder(1);
			toppingsModifierSpecPage.setFlixibleButtonSize(false);
			toppingsModifierSpecPage.setModifierSpecId(toppingsModifierGroupSpec.getId());
			toppingsModifierSpecPage.setLastUpdateTime(now);
			session.saveOrUpdate(toppingsModifierSpecPage);

			// page item
			MenuItemModifierPageItem mashroomPageItem = new MenuItemModifierPageItem(0, 0, mashroom, toppingsModifierSpecPage);
			mashroomPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(mashroomPageItem);
			toppingsModifierSpecPage.addTopageItems(mashroomPageItem);

			MenuItemModifierPageItem pepproniPageItem = new MenuItemModifierPageItem(1, 0, pepparoni, toppingsModifierSpecPage);
			pepproniPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(pepproniPageItem);
			toppingsModifierSpecPage.addTopageItems(pepproniPageItem);

			MenuItemModifierPageItem sausagePageItem = new MenuItemModifierPageItem(2, 0, sausage, toppingsModifierSpecPage);
			sausagePageItem.setLastUpdateTime(now);
			session.saveOrUpdate(sausagePageItem);
			toppingsModifierSpecPage.addTopageItems(sausagePageItem);

			MenuItemModifierPageItem onionPageItem = new MenuItemModifierPageItem(3, 0, onionsModifier, toppingsModifierSpecPage);
			onionPageItem.setLastUpdateTime(now);
			session.saveOrUpdate(onionPageItem);
			toppingsModifierSpecPage.addTopageItems(onionPageItem);

			toppingsModifierGroupSpec.addTomodifierPages(toppingsModifierSpecPage);
			menuItem.addTomenuItemModiferSpecs(toppingsModifierGroupSpec);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			menuItemModifierSpecDAO.closeSession(session);
		}
	}

	private void createMultipliers() {
		Session session = null;
		Transaction tx = null;
		MultiplierDAO multiplierDAO = MultiplierDAO.getInstance();
		try {
			session = multiplierDAO.createNewSession();
			tx = session.beginTransaction();
			Multiplier regular = new Multiplier("Regular"); //$NON-NLS-1$
			regular.setRate(100d);
			regular.setTicketPrefix("Regular"); //$NON-NLS-1$
			regular.setDefaultMultiplier(true);
			regular.setSortOrder(1);
			regular.setLastUpdateTime(now);
			session.save(regular);

			Multiplier extra = new Multiplier("extra"); //$NON-NLS-1$
			extra.setRate(200d);
			extra.setTicketPrefix("Extra"); //$NON-NLS-1$
			extra.setSortOrder(2);
			extra.setLastUpdateTime(now);
			session.save(extra);

			Multiplier half = new Multiplier("half"); //$NON-NLS-1$
			half.setRate(50d);
			half.setTicketPrefix("Half"); //$NON-NLS-1$
			half.setSortOrder(3);
			half.setLastUpdateTime(now);
			session.save(half);

			Multiplier quarter = new Multiplier("quarter"); //$NON-NLS-1$
			quarter.setRate(25d);
			quarter.setTicketPrefix("Quarter"); //$NON-NLS-1$
			quarter.setSortOrder(4);
			quarter.setLastUpdateTime(now);
			session.save(quarter);

			Multiplier tripple = new Multiplier("tripple"); //$NON-NLS-1$
			tripple.setRate(300d);
			tripple.setTicketPrefix("Tripple"); //$NON-NLS-1$
			tripple.setSortOrder(5);
			tripple.setLastUpdateTime(now);
			session.save(tripple);

			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			multiplierDAO.closeSession(session);
		}
	}

	private void createShifts(java.lang.String outletId) {
		Session session = null;
		Transaction tx = null;
		DayPartDAO dayPartDAO = DayPartDAO.getInstance();
		try {
			session = dayPartDAO.createNewSession();
			tx = session.beginTransaction();

			DayPart regularShift = new DayPart("regular", outletId); //$NON-NLS-1$
			regularShift.setName("Regular"); //$NON-NLS-1$
			java.util.Date shiftStartTime = ShiftUtil.buildShiftStartTime(10, 0, Calendar.AM, 6, 0, Calendar.PM);
			java.util.Date shiftEndTime = ShiftUtil.buildShiftEndTime(10, 0, Calendar.AM, 6, 0, Calendar.PM);
			regularShift.setStartTime(shiftStartTime);
			regularShift.setEndTime(shiftEndTime);
			long length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
			regularShift.setShiftLength(Long.valueOf(length));
			regularShift.setLastUpdateTime(now);
			session.save(regularShift);

			DayPart eveningShift = new DayPart("evening", outletId); //$NON-NLS-1$
			eveningShift.setName("Evening"); //$NON-NLS-1$
			shiftStartTime = ShiftUtil.buildShiftStartTime(6, 0, Calendar.PM, 2, 0, Calendar.AM);
			shiftEndTime = ShiftUtil.buildShiftEndTime(6, 0, Calendar.PM, 2, 0, Calendar.AM);
			eveningShift.setStartTime(shiftStartTime);
			eveningShift.setEndTime(shiftEndTime);
			length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
			eveningShift.setShiftLength(Long.valueOf(length));
			eveningShift.setLastUpdateTime(now);
			session.save(eveningShift);

			DayPart nightShift = new DayPart("night", outletId); //$NON-NLS-1$
			nightShift.setName("Night"); //$NON-NLS-1$
			shiftStartTime = ShiftUtil.buildShiftStartTime(2, 0, Calendar.AM, 10, 0, Calendar.AM);
			shiftEndTime = ShiftUtil.buildShiftEndTime(2, 0, Calendar.AM, 10, 0, Calendar.AM);
			nightShift.setStartTime(shiftStartTime);
			nightShift.setEndTime(shiftEndTime);
			length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
			nightShift.setShiftLength(Long.valueOf(length));
			nightShift.setLastUpdateTime(now);
			session.save(nightShift);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			dayPartDAO.closeSession(session);
		}
	}

	private void createAttributes() {
		Session session = null;
		Transaction tx = null;
		AttributeGroupDAO attributeGroupDAO = AttributeGroupDAO.getInstance();
		try {
			session = attributeGroupDAO.createNewSession();
			tx = session.beginTransaction();

			AttributeGroup sizeGroup = new AttributeGroup("size"); //$NON-NLS-1$
			sizeGroup.setName("Size"); //$NON-NLS-1$
			sizeGroup.setLastUpdateTime(now);
			session.save(sizeGroup);

			smallSize = new Attribute("small");//$NON-NLS-1$
			smallSize.setName("Small"); //$NON-NLS-1$
			smallSize.setSortOrder(0);
			smallSize.setGroup(sizeGroup);
			smallSize.setLastUpdateTime(now);
			session.save(smallSize);

			mediumSize = new Attribute(("medium"));//$NON-NLS-1$
			mediumSize.setName("Medium"); //$NON-NLS-1$
			mediumSize.setSortOrder(1);
			mediumSize.setGroup(sizeGroup);
			mediumSize.setLastUpdateTime(now);
			session.save(mediumSize);

			largeSize = new Attribute("large");//$NON-NLS-1$
			largeSize.setName("Large"); //$NON-NLS-1$
			largeSize.setSortOrder(2);
			largeSize.setGroup(sizeGroup);
			largeSize.setLastUpdateTime(now);
			session.save(largeSize);

			AttributeGroup crustGroup = new AttributeGroup();
			crustGroup.setName("Crust"); //$NON-NLS-1$
			crustGroup.setLastUpdateTime(now);
			session.save(crustGroup);

			Attribute pan = new Attribute("pan");//$NON-NLS-1$
			pan.setName("Pan"); //$NON-NLS-1$
			pan.setSortOrder(0);
			pan.setLastUpdateTime(now);
			pan.setGroup(crustGroup);
			session.save(pan);

			Attribute handTossed = new Attribute("hand_tossed"); //$NON-NLS-1$
			handTossed.setName("Hand tossed"); //$NON-NLS-1$
			handTossed.setSortOrder(1);
			handTossed.setLastUpdateTime(now);
			handTossed.setGroup(crustGroup);
			session.save(handTossed);

			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			attributeGroupDAO.closeSession(session);
		}
	}

	private void doCreateVariantForCoke(MenuItem item, Session session) {
		// variants
		MenuItem largeItem = new MenuItem();
		largeItem.setId("large-" + item.getId()); //$NON-NLS-1$
		largeItem.setName("Large " + item.getName()); //$NON-NLS-1$
		largeItem.setParentMenuItemId(item.getId());
		largeItem.setMenuGroupId(item.getMenuGroupId());
		largeItem.setMenuCategoryId(item.getMenuCategoryId());
		largeItem.setUnit(item.getUnit());
		largeItem.setVariant(true);
		largeItem.setPrice(4.89);
		largeItem.setShouldPrintToKitchen(false);
		largeItem.setInventoryItem(item.isInventoryItem());
		largeItem.setAttributes(Arrays.asList(largeSize));
		largeItem.setLastUpdateTime(now);
		session.save(largeItem);

		MenuItem mediumItem = new MenuItem();
		mediumItem.setId("medium-" + item.getId()); //$NON-NLS-1$
		mediumItem.setName("Medium " + item.getName()); //$NON-NLS-1$
		mediumItem.setParentMenuItemId(item.getId());
		mediumItem.setMenuGroupId(item.getMenuGroupId());
		mediumItem.setMenuCategoryId(item.getMenuCategoryId());
		mediumItem.setUnit(item.getUnit());
		mediumItem.setVariant(true);
		mediumItem.setPrice(2.97);
		mediumItem.setShouldPrintToKitchen(false);
		mediumItem.setInventoryItem(item.isInventoryItem());
		mediumItem.setAttributes(Arrays.asList(mediumSize));
		mediumItem.setLastUpdateTime(now);
		session.save(mediumItem);

		MenuItem smallItem = new MenuItem();
		smallItem.setId("small-" + item.getId()); //$NON-NLS-1$
		smallItem.setName("Small " + item.getName()); //$NON-NLS-1$
		smallItem.setParentMenuItemId(item.getId());
		smallItem.setMenuGroupId(item.getMenuGroupId());
		smallItem.setMenuCategoryId(item.getMenuCategoryId());
		smallItem.setUnit(item.getUnit());
		smallItem.setVariant(true);
		smallItem.setPrice(1.32);
		smallItem.setShouldPrintToKitchen(false);
		smallItem.setInventoryItem(item.isInventoryItem());
		smallItem.setAttributes(Arrays.asList(smallSize));
		smallItem.setLastUpdateTime(now);
		session.save(smallItem);

		//		item.setVariants(POSUtil.copySelectedValues(item.getVariants(), varients));
	}

	private void doCreateVariantForPepsi(MenuItem item, Session session) {
		// variants
		MenuItem largeItem = new MenuItem();
		largeItem.setId("large-" + item.getId()); //$NON-NLS-1$
		largeItem.setName("Large " + item.getName()); //$NON-NLS-1$
		largeItem.setParentMenuItemId(item.getId());
		largeItem.setMenuGroupId(item.getMenuGroupId());
		largeItem.setMenuCategoryId(item.getMenuCategoryId());
		largeItem.setUnit(item.getUnit());
		largeItem.setVariant(true);
		largeItem.setPrice(2.33);
		largeItem.setInventoryItem(item.isInventoryItem());
		largeItem.setAttributes(Arrays.asList(largeSize));
		largeItem.setShouldPrintToKitchen(false);
		largeItem.setLastUpdateTime(now);
		session.save(largeItem);

		MenuItem mediumItem = new MenuItem();
		mediumItem.setId("medium-" + item.getId()); //$NON-NLS-1$
		mediumItem.setName("Medium " + item.getName()); //$NON-NLS-1$
		mediumItem.setParentMenuItemId(item.getId());
		mediumItem.setMenuGroupId(item.getMenuGroupId());
		mediumItem.setMenuCategoryId(item.getMenuCategoryId());
		mediumItem.setUnit(item.getUnit());
		mediumItem.setVariant(true);
		mediumItem.setPrice(1.67);
		mediumItem.setShouldPrintToKitchen(false);
		mediumItem.setInventoryItem(item.isInventoryItem());
		mediumItem.setAttributes(Arrays.asList(mediumSize));
		mediumItem.setLastUpdateTime(now);
		session.save(mediumItem);
	}

	private void createInventoryData() {
		Session session = null;
		Transaction tx = null;
		InventoryUnitDAO inventoryUnitDAO = InventoryUnitDAO.getInstance();
		try {
			session = inventoryUnitDAO.createNewSession();
			tx = session.beginTransaction();

			InventoryUnitGroup group = new InventoryUnitGroup("measurement"); //$NON-NLS-1$
			group.setName("Measurement"); //$NON-NLS-1$
			group.setLastUpdateTime(now);
			session.save(group);

			unitPiece = new InventoryUnit("each"); //$NON-NLS-1$
			unitPiece.setBaseUnit(true);
			unitPiece.setCode("ea"); //$NON-NLS-1$
			unitPiece.setName("Each"); //$NON-NLS-1$
			unitPiece.setConversionRate(1.0);
			unitPiece.setUnitGroupId(group.getId());
			unitPiece.setLastUpdateTime(now);
			session.save(unitPiece);

			InventoryUnitGroup weight = new InventoryUnitGroup("weight"); //$NON-NLS-1$
			weight.setName("Weight"); //$NON-NLS-1$
			weight.setLastUpdateTime(now);
			session.save(weight);

			unitGram = new InventoryUnit("gram"); //$NON-NLS-1$
			unitGram.setCode("g"); //$NON-NLS-1$
			unitGram.setName("gram"); //$NON-NLS-1$
			unitGram.setConversionRate(1000.0);
			unitGram.setUnitGroupId(weight.getId());
			unitGram.setLastUpdateTime(now);
			session.save(unitGram);

			unitKg = new InventoryUnit("kilogram"); //$NON-NLS-1$
			unitKg.setBaseUnit(true);
			unitKg.setCode("kg"); //$NON-NLS-1$
			unitKg.setName("Kilo gram"); //$NON-NLS-1$
			unitKg.setConversionRate(1.0);
			unitKg.setUnitGroupId(weight.getId());
			unitKg.setLastUpdateTime(now);
			session.save(unitKg);

			unitTon = new InventoryUnit("ton"); //$NON-NLS-1$
			unitTon.setBaseUnit(true);
			unitTon.setCode("ton"); //$NON-NLS-1$
			unitTon.setName("Ton"); //$NON-NLS-1$
			unitTon.setConversionRate(1.0);
			unitTon.setUnitGroupId(weight.getId());
			unitTon.setLastUpdateTime(now);
			session.save(unitTon);

			PackagingUnit packagingUnit = new PackagingUnit("box"); //$NON-NLS-1$
			packagingUnit.setCode("box"); //$NON-NLS-1$
			packagingUnit.setName("Box"); //$NON-NLS-1$
			packagingUnit.setLastUpdateTime(now);
			session.save(packagingUnit);

			packagingUnit = new PackagingUnit("cartoon"); //$NON-NLS-1$
			packagingUnit.setCode("cartoon"); //$NON-NLS-1$
			packagingUnit.setName("Cartoon"); //$NON-NLS-1$
			packagingUnit.setLastUpdateTime(now);
			session.save(packagingUnit);

			InventoryVendor vendor = new InventoryVendor("cash"); //$NON-NLS-1$
			vendor.setName("Cash"); //$NON-NLS-1$
			vendor.setVisible(true);
			vendor.setLastUpdateTime(now);
			session.save(vendor);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			inventoryUnitDAO.closeSession(session);
		}
	}

	private void createDefaultInventoryLocation(String outletId) {
		InventoryLocation location = new InventoryLocation("store", outletId); //$NON-NLS-1$
		location.setName("Store"); //$NON-NLS-1$
		location.setDefaultInLocation(true);
		location.setDefaultOutLocation(true);
		location.setSortOrder(0);
		location.setVisible(true);
		location.setRoot(true);
		location.setLastUpdateTime(now);
		InventoryLocationDAO.getInstance().save(location);
	}

	private void createDefaultFloor(String outletId) {
		Session session = null;
		Transaction tx = null;
		ShopTableDAO shopTableDAO = ShopTableDAO.getInstance();
		try {
			session = shopTableDAO.createNewSession();
			tx = session.beginTransaction();

			ShopFloor floor = new ShopFloor("mainfloor", outletId); //$NON-NLS-1$
			floor.setName("Main Floor"); //$NON-NLS-1$

			List<ShopTable> tableList = ShopTableDAO.getInstance().findByOutletId(outletId);
			Set<ShopTable> shopTables = new HashSet<ShopTable>();

			if (tableList != null && !tableList.isEmpty()) {
				for (int i = 0; i < tableList.size(); i++) {
					ShopTable shopTable = tableList.get(i);

					shopTable.setX(getPositionX().get(i));
					shopTable.setY(getPositionY().get(i));
					shopTable.setLastUpdateTime(now);

					session.saveOrUpdate(shopTable);

					shopTables.add(shopTable);

					if (i == 13) {
						break;
					}
				}

			}
			else {
				for (int i = 0; i < getPositionX().size(); i++) {
					ShopTable shopTable = new ShopTable(floor, outletId, getPositionX().get(i), getPositionY().get(i), (i + 1));
					shopTable.setLastUpdateTime(now);
					ShopTableStatus shopTableStatus = new ShopTableStatus();
					Integer tableId = shopTable.getId();
					shopTableStatus.setId(tableId);
					shopTableStatus.setOutletId(outletId);
					shopTableStatus.setTableStatus(TableStatus.Available);
					shopTableStatus.setLastUpdateTime(now);
					session.save(shopTableStatus);
					shopTable.setShopTableStatus(shopTableStatus);
					shopTables.add(shopTable);
				}
			}

			floor.setTables(shopTables);
			floor.setLastUpdateTime(now);
			session.save(floor);

			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			shopTableDAO.closeSession(session);
		}
	}

	private List<Integer> getPositionX() {
		List<Integer> positionX = new ArrayList();
		positionX.add(19);
		positionX.add(161);
		positionX.add(309);
		positionX.add(17);
		positionX.add(162);
		positionX.add(318);
		positionX.add(18);
		positionX.add(161);
		positionX.add(330);
		positionX.add(22);
		positionX.add(169);
		positionX.add(329);
		positionX.add(487);
		positionX.add(661);

		return positionX;
	}

	private List<Integer> getPositionY() {
		List<Integer> positionY = new ArrayList();
		positionY.add(12);
		positionY.add(12);
		positionY.add(14);
		positionY.add(132);
		positionY.add(136);
		positionY.add(140);
		positionY.add(258);
		positionY.add(258);
		positionY.add(260);
		positionY.add(382);
		positionY.add(381);
		positionY.add(387);
		positionY.add(391);
		positionY.add(390);

		return positionY;
	}

	private void createManagerUser(UserType manager, UserType cashier, UserType server) {
		Session session = null;
		Transaction tx = null;
		UserDAO userDAO = UserDAO.getInstance();
		try {
			session = userDAO.createNewSession();
			tx = session.beginTransaction();

			User managerUser = new User();
			managerUser.setId("124"); //$NON-NLS-1$
			managerUser.setEncryptedPassword("2222"); //$NON-NLS-1$
			managerUser.setFirstName("Manager"); //$NON-NLS-1$
			managerUser.setLastName("M"); //$NON-NLS-1$
			managerUser.setType(manager);
			managerUser.setRoot(true);
			managerUser.setActive(true);
			managerUser.setStaffBank(true);
			managerUser.setLastUpdateTime(now);

			User cashierUser = new User();
			cashierUser.setId("981"); //$NON-NLS-1$
			cashierUser.setFirstName("Manager"); //$NON-NLS-1$
			cashierUser.setLastName("M"); //$NON-NLS-1$
			cashierUser.setType(cashier);
			cashierUser.setParentUser(managerUser);
			cashierUser.setActive(true);
			cashierUser.setStaffBank(true);
			cashierUser.setLastUpdateTime(now);

			User serverUser = new User();
			serverUser.setId("890"); //$NON-NLS-1$
			serverUser.setFirstName("Manager"); //$NON-NLS-1$
			serverUser.setLastName("M"); //$NON-NLS-1$
			serverUser.setType(server);
			serverUser.setParentUser(managerUser);
			serverUser.setActive(true);
			serverUser.setStaffBank(true);
			serverUser.setAutoStartStaffBank(true);
			serverUser.setLastUpdateTime(now);

			session.save(managerUser);
			session.save(cashierUser);
			session.save(serverUser);
			tx.commit();
		} catch (Exception e) {
			if (tx != null) {
				tx.rollback();
				PosLog.error(getClass(), e);
			}
		} finally {
			userDAO.closeSession(session);
		}
	}

	public void createDefaultClientDataForAndroid(Store store, String customerId, String adminEmail, String adminPassword, String outletId,
			JSONObject clientDataJson) throws Exception {

		Address storeAddress = store.getAddress();
		if (storeAddress == null) {
			storeAddress = new Address();
			store.setAddress(storeAddress);
		}
		storeAddress.setAddressLine(clientDataJson.getString(RestConstants.ADDRESS_LINE_1));
		storeAddress.setAddressLine2(clientDataJson.getString(RestConstants.ADDRESS_LINE_2));
		storeAddress.setStreet(clientDataJson.getString(RestConstants.ADDRESS_LINE_3));
		storeAddress.setZipCode(clientDataJson.getString(RestConstants.ZIP_CODE));
		storeAddress.setPhoneNumbers(Arrays.asList(clientDataJson.getString(RestConstants.PHONE)));
		storeAddress.setCountry(clientDataJson.getString(RestConstants.COUNTRY));
		storeAddress.setState(clientDataJson.getString(RestConstants.STATE));
		storeAddress.setCity(clientDataJson.getString(RestConstants.CITY));

		store.setAddressLine1(storeAddress.getAddressLine());
		store.setAddressLine2(storeAddress.getAddressLine2());
		store.setAddressLine3(storeAddress.getStreet());
		store.setZipCode(storeAddress.getZipCode());
		store.setTelephone(clientDataJson.getString(RestConstants.PHONE));

		UserType administrator = new UserType();
		administrator.setId((com.floreantpos.POSConstants.ADMINISTRATOR).toLowerCase());
		administrator.setName(com.floreantpos.POSConstants.ADMINISTRATOR);
		administrator.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
		administrator.setLastUpdateTime(new Date());
		UserTypeDAO.getInstance().save(administrator);

		User user = new User();
		user.setId(customerId);
		user.setOutletId(outletId);
		user.setFirstName(adminEmail);
		user.setLastName("");//$NON-NLS-1$
		user.setEmail(adminEmail);
		user.setLastUpdateTime(new Date());
		user.setEncryptedPassword("1122");//$NON-NLS-1$
		user.setUserTypeId(administrator.getId());
		user.setRoot(true);
		user.setActive(true);
		user.setCanLoginInCloud(true);
		user.setLongPassword(AESencrp.encrypt(adminPassword));
		UserDAO.getInstance().saveOrUpdate(user);

		Outlet outlet = new Outlet(outletId);
		outlet.setName("Main");//$NON-NLS-1$
		outlet.setAddress(store.getAddress());
		OutletDAO.getInstance().save(outlet);
		store.setDefaultOutletId(outlet.getId());
		store.setOutletName(outlet.getName());

		createOrderTypes(outletId, clientDataJson.getString(RestConstants.BUSINESS_TYPE));
		createShifts(outletId);
		createDefaultTax(outletId, clientDataJson.getString(RestConstants.CURRENCY_CODE), clientDataJson.getDouble(RestConstants.TAX_RATE));
		createDefaultCurrency(outletId, clientDataJson);
		createDefaultFloor(outletId);
		createDefaultInventoryLocation(outletId);
	}
}
