package com.orocube.rest.service.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.TicketItemModifierDAO;
import com.floreantpos.model.dao.TicketItemSeatDAO;

public class TicketDataServiceDao {

	private static TicketDataServiceDao instance;

	private TicketDataServiceDao() {
	}

	public static TicketDataServiceDao getInstance() {
		if (instance == null) {
			instance = new TicketDataServiceDao();
		}
		return instance;
	}

	public static TicketDataServiceDao get() {
		return getInstance();
	}

	//	private void debug(String msg) {
	//		PosLog.debug(getClass(), msg);
	//	}

	public void saveOrUpdateTicket(Ticket ticket, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
		GenericDAO genericDAO = new GenericDAO();
		Transaction tx = null;
		Session session = null;

		try {
			session = genericDAO.createNewSession();
			tx = session.beginTransaction();

			TicketDAO dao = TicketDAO.getInstance();
			//debug(ticket.getId() + " is processing...");
			Ticket existingTicket = dao.loadFullTicket(ticket.getId(), ticket.getOutletId());

			/*if (existingTicket != null && ticket.getVersion() < existingTicket.getVersion()) {
				continue;
			}*/
			if (existingTicket != null) {
				ticket.mergeTicket(existingTicket);
			}

			Gratuity gratuity = ticket.getGratuity();
			List<TicketItem> ticketItemList = ticket.getTicketItems();
			Set<PosTransaction> transactions = ticket.getTransactions();

			ticket.setUpdateLastUpdateTime(updateLastUpdateTime);
			ticket.setUpdateSyncTime(updateSyncTime);
			ticket.setCloudSynced(true);
			ticket.setTicketItems(null);
			ticket.setGratuity(null);
			ticket.setTransactions(null);

			saveOrUpdateTicket(session, ticket, existingTicket);
			saveOrUpdateTicketItems(session, ticket, existingTicket, ticketItemList);
			if (gratuity != null) {

				String ticketId = gratuity.getTicketId();
				if (ticketId == null) {
					gratuity.setTicketId(ticket.getId());
					saveOrUpdateGratuity(session, gratuity);
				}
				else if (ticketId.equalsIgnoreCase(ticket.getId())) {
					saveOrUpdateGratuity(session, gratuity);
				}
				else {
					gratuity = null;
				}
			}

			saveOrUpdatePosTransactions(session, ticket, existingTicket, transactions);

			ticket.setTicketItems(ticketItemList);
			ticket.setGratuity(gratuity);
			ticket.setTransactions(transactions);

			ticket.setShouldUpdateTableStatus(existingTicket == null);
			saveCustomerIfNotExists(session, ticket);

			Map<String, TicketItemSeat> seatMap = new HashMap<>();
			for (TicketItem ticketItem : ticket.getTicketItems()) {
				TicketItemSeat seat = ticketItem.getSeat();
				if (seat == null) {
					continue;
				}
				TicketItemSeat ticketItemSeat = seatMap.get(seat.getId());
				if (ticketItemSeat == null) {
					seatMap.put(seat.getId(), seat);
				}
				else {
					ticketItem.setSeat(ticketItemSeat);
				}
			}

			//			for (TicketItem ticketItem : ticket.getTicketItems()) {
			//				TicketItemSeat seat = ticketItem.getSeat();
			//				if (seat == null) {
			//					System.out.println("seat is null");
			//					continue;
			//				}
			//				System.out.println("treat as seat:" + ticketItem.isTreatAsSeat() + ", seat no:" + seat.getId() + ", object:" + seat);
			//			}

			//dao.saveOrUpdate(ticket, session);
			Date currentTime = new Date();
			if (updateLastUpdateTime) {
				ticket.setLastUpdateTime(currentTime);
			}
			if (updateSyncTime) {
				ticket.setLastSyncTime(currentTime);
			}
			session.saveOrUpdate(ticket);
			tx.commit();
		} catch (Exception e) {
			tx.rollback();
			PosLog.error(getClass(), e);
			throw e;
		} finally {
			genericDAO.closeSession(session);
		}
	}

	private void saveOrUpdateTicket(Session session, Ticket ticket, Ticket existingTicket) {
		if (existingTicket == null) {
			if (StringUtils.isEmpty(ticket.getShortId())) {
				ticket.setShortId(RandomStringUtils.randomNumeric(7));
			}
			if (ticket.getTokenNo() == 0) {
				ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber(SequenceNumber.TICKET_TOKEN, session));
			}
			ticket.setVersion(0);

			TicketDAO.getInstance().save(ticket, session);
		}
		else {
			ticket.setVersion(existingTicket.getVersion());
		}
	}

	private void saveOrUpdateTicketItems(Session session, Ticket ticket, Ticket existingTicket, List<TicketItem> ticketItemList) {
		List<TicketItem> existingTicketItems = null;
		if (existingTicket != null) {
			existingTicketItems = existingTicket.getTicketItems();
		}
		Map<String, TicketItem> existingTicketItemMap = new HashMap<>();
		if (existingTicketItems != null && existingTicketItems.size() > 0) {
			for (TicketItem ticketItem : existingTicketItems) {
				existingTicketItemMap.put(ticketItem.getId(), ticketItem);
			}
		}
		for (TicketItem ticketItem : ticketItemList) {
			ticketItem.setTicket(ticket);
			saveOrUpdateTicketItem(session, ticketItem, existingTicketItemMap);
		}
	}

	private void saveOrUpdatePosTransactions(Session session, Ticket ticket, Ticket existingTicket, Set<PosTransaction> transactions) {
		List<PosTransaction> existingTransactions = null;
		if (existingTicket != null) {
			existingTransactions = new ArrayList<PosTransaction>(existingTicket.getTransactions());
		}
		if (transactions != null && transactions.size() > 0) {
			for (PosTransaction transaction : transactions) {
				if (StringUtils.isBlank(transaction.getOutletId()) && ticket.getOutletId() != null) {
					transaction.setOutletId(ticket.getOutletId());
				}
				transaction.setTicket(ticket);
				if (existingTicket == null || existingTransactions == null || existingTransactions.isEmpty()) {
					transaction.setVersion(0);
					PosTransactionDAO.getInstance().save(transaction, session);
					continue;
				}
				saveOrUpdatePosTransaction(session, transaction, existingTransactions);
			}
		}
	}

	private void saveCustomerIfNotExists(Session session, Ticket ticket) {
		if (StringUtils.isEmpty(ticket.getCustomerId())) {
			return;
		}
		Customer existingCustomer = CustomerDAO.getInstance().get(ticket.getCustomerId());
		if (existingCustomer == null) {
			Customer customer = ticket.getCustomer();
			if (customer != null) {
				customer.setVersion(0);
				CustomerDAO.getInstance().save(customer, session);
			}
		}
	}

	private void saveOrUpdateTicketItem(Session session, TicketItem ticketItem, Map<String, TicketItem> existingTicketItemMap) {
		TicketItemDAO ticketItemDAO = new TicketItemDAO();

		TicketItem existingTicketItem = null;
		TicketItemModifier sizeModifier = ticketItem.getSizeModifier();
		List<TicketItemModifier> ticketItemModifierList = ticketItem.getTicketItemModifiers();
		TicketItemSeat seat = ticketItem.getSeat();

		List<TicketItem> comboTicketItems = null;
		if (ticketItem.isComboItem()) {
			comboTicketItems = ticketItem.getComboItems();
		}

		ticketItem.setTicketItemModifiers(null);
		ticketItem.setSizeModifier(null);
		ticketItem.setComboItems(null);
		ticketItem.setSeat(null);

		if (existingTicketItemMap == null || existingTicketItemMap.isEmpty()) {
			//ticketItem.getParentTicketItem();
			TicketItem existTicketItem = ticketItemDAO.get(ticketItem.getId());
			if (existTicketItem == null) {
				ticketItem.setVersion(0);
				ticketItemDAO.save(ticketItem, session);
			}
			else {
				ticketItem.setVersion(existTicketItem.getVersion());
			}
		}
		else {
			existingTicketItem = existingTicketItemMap.get(ticketItem.getId());
			if (existingTicketItem == null) {
				ticketItem.setVersion(0);
				ticketItemDAO.save(ticketItem, session);
			}
			else {
				ticketItem.setVersion(existingTicketItem.getVersion());
			}
		}

		saveOrSetVersionTicketItemSeat(seat);
		ticketItem.setSeat(seat);

		List<TicketItemModifier> existingTicketItemModifiers = null;
		if (existingTicketItem != null) {
			existingTicketItemModifiers = existingTicketItem.getTicketItemModifiers();
		}
		if (ticketItemModifierList != null && ticketItemModifierList.size() > 0) {
			for (TicketItemModifier ticketItemModifier : ticketItemModifierList) {
				ticketItemModifier.setTicketItem(ticketItem);
				if (existingTicketItem == null) {
					ticketItemModifier.setVersion(0);
					TicketItemModifierDAO.getInstance().save(ticketItemModifier, session);
					continue;
				}
				saveTicketItemModifier(session, ticketItemModifier, existingTicketItemModifiers);
			}
		}

		TicketItemModifier existingSizeModifier = null;
		if (existingTicketItem != null) {
			existingSizeModifier = existingTicketItem.getSizeModifier();
		}

		if (sizeModifier != null) {
			sizeModifier.setTicketItem(ticketItem);
			saveOrUpdateSizeModifier(session, sizeModifier, existingSizeModifier);
		}
		ticketItem.setTicketItemModifiers(ticketItemModifierList);
		ticketItem.setSizeModifier(sizeModifier);

		//Combo Item
		if (ticketItem.isComboItem()) {
			if (comboTicketItems != null && comboTicketItems.size() > 0) {
				for (TicketItem comboTicketItem : comboTicketItems) {
					comboTicketItem.setParentTicketItem(ticketItem);
					Map<String, TicketItem> exitingComboTicketItemMap = new HashMap<>();
					if (existingTicketItem != null) {
						List<TicketItem> existingComboItems = existingTicketItem.getComboItems();
						if (existingComboItems != null && existingComboItems.size() > 0) {
							for (TicketItem comboItem : existingComboItems) {
								exitingComboTicketItemMap.put(comboItem.getId(), comboItem);
							}
						}
					}
					saveOrUpdateTicketItem(session, comboTicketItem, existingTicketItem == null ? null : exitingComboTicketItemMap);
				}
			}

			ticketItem.setComboItems(comboTicketItems);
		}
	}

	private void saveOrSetVersionTicketItemSeat(TicketItemSeat seat) {
		if (seat == null) {
			return;
		}
		TicketItemSeatDAO itemSeatDAO = new TicketItemSeatDAO();
		TicketItemSeat existSeat = itemSeatDAO.get(seat.getId());
		if (existSeat == null) {
			itemSeatDAO.save(seat);
		}
		else {
			seat.setVersion(existSeat.getVersion());
		}
	}

	private void saveOrUpdateSizeModifier(Session session, TicketItemModifier ticketItemModifier, TicketItemModifier existingSizeModifier) {
		TicketItemModifierDAO instance = TicketItemModifierDAO.getInstance();

		TicketItemModifier existingTicketItemModifier = instance.get(ticketItemModifier.getId());
		if (existingTicketItemModifier == null) {
			ticketItemModifier.setVersion(0);
			instance.save(ticketItemModifier, session);
		}
		else {
			ticketItemModifier.setVersion(existingTicketItemModifier.getVersion());
		}

	}

	private void saveTicketItemModifier(Session session, TicketItemModifier ticketItemModifier, List<TicketItemModifier> existingTicketItemModifiers) {
		TicketItemModifierDAO modifierDAO = new TicketItemModifierDAO();
		if (existingTicketItemModifiers == null || existingTicketItemModifiers.isEmpty())
			return;
		TicketItemModifier existingTicketItemModifier = null;
		int idx = existingTicketItemModifiers.indexOf(ticketItemModifier);
		if (idx != -1) {
			existingTicketItemModifier = existingTicketItemModifiers.get(idx);
			if (existingTicketItemModifier == null) {
				ticketItemModifier.setVersion(0);
				modifierDAO.save(ticketItemModifier, session);
			}
			else {
				ticketItemModifier.setVersion(existingTicketItemModifier.getVersion());
			}
		}
		else {
			ticketItemModifier.setVersion(0);
			modifierDAO.save(ticketItemModifier, session);
		}
	}

	private void saveOrUpdateGratuity(Session session, Gratuity gratuity) {
		if (gratuity == null || StringUtils.isEmpty(gratuity.getId()))
			return;

		Gratuity existingItem = GratuityDAO.getInstance().get(gratuity.getId());
		if (existingItem == null) {
			gratuity.setVersion(0);
			gratuity.setUpdateLastUpdateTime(false);
			gratuity.setUpdateSyncTime(false);
			GratuityDAO.getInstance().save(gratuity, session);
		}
		else {
			gratuity.setVersion(existingItem.getVersion());
		}
	}

	private void saveOrUpdatePosTransaction(Session session, PosTransaction transaction, List<PosTransaction> existingPosTransactions) {
		PosTransactionDAO dao = new PosTransactionDAO();
		if (existingPosTransactions == null || existingPosTransactions.size() == 0)
			return;
		PosTransaction existingPosTransaction = null;
		int idx = existingPosTransactions.indexOf(transaction);
		if (idx != -1) {
			existingPosTransaction = existingPosTransactions.get(idx);
			if (existingPosTransaction == null) {
				transaction.setVersion(0);
				dao.save(transaction, session);
			}
			else {
				transaction.setVersion(existingPosTransaction.getVersion());
			}
		}
		else {
			transaction.setVersion(0);
			dao.save(transaction, session);
		}
	}

}
