package com.floreantpos.model;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseCustomPayment;

@JsonIgnoreProperties(ignoreUnknown = true, value = {})
@XmlRootElement
public class CustomPayment extends BaseCustomPayment implements TimedModel {
	private static final long serialVersionUID = 1L;

	public static final String PROP_ID = "id"; //$NON-NLS-1$
	public static final String PROP_OUTLET_ID = "outletId"; //$NON-NLS-1$

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public CustomPayment() {
	}

	/**
	 * Constructor for primary key
	 */
	public CustomPayment(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/*[CONSTRUCTOR MARKER END]*/

}