package com.floreantpos.model;

import java.util.Iterator;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.base.BaseTaxGroup;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

@JsonIgnoreProperties(ignoreUnknown = true, value = { "" })
@XmlRootElement
public class TaxGroup extends BaseTaxGroup implements TimedModel {
	private static final long serialVersionUID = 1L;
	public static final String PROP_ID = "id";
	public static final String PROP_OUTLET_ID = "outletId";
	private transient JsonObject propertiesContainer;

	private boolean updateLastUpdateTime = true;
	private boolean updateSyncTime = false;

	public boolean isUpdateSyncTime() {
		return updateSyncTime;
	}

	public void setUpdateSyncTime(boolean shouldUpdateSyncTime) {
		this.updateSyncTime = shouldUpdateSyncTime;
	}

	public boolean isUpdateLastUpdateTime() {
		return updateLastUpdateTime;
	}

	public void setUpdateLastUpdateTime(boolean shouldUpdateUpdateTime) {
		this.updateLastUpdateTime = shouldUpdateUpdateTime;
	}

	/*[CONSTRUCTOR MARKER BEGIN]*/
	public TaxGroup() {
	}

	/**
	 * Constructor for primary key
	 */
	public TaxGroup(java.lang.String id, java.lang.String outletId) {

		super(id, outletId);
	}

	/**
	 * Constructor for required fields
	 */
	public TaxGroup(java.lang.String id, java.lang.String outletId, java.lang.String name) {

		super(id, outletId, name);
	}

	/*[CONSTRUCTOR MARKER END]*/

	@Override
	public String toString() {
		String name = super.getName();
		List<Tax> taxes = getTaxes();
		if (taxes == null || taxes.isEmpty()) {
			return name;
		}
		name += " ("; //$NON-NLS-1$
		double sumOfRates = 0D;
		for (Iterator<Tax> iterator = taxes.iterator(); iterator.hasNext();) {
			Tax tax = iterator.next();
			sumOfRates += tax.getRate();
		}
		name += NumberUtil.formatAmount(sumOfRates);
		name += ")"; //$NON-NLS-1$
		return name;
	}

	public String getUniqueId() {
		return ("taxgroup_" + getName() + "_" + getId()).replaceAll("\\s+", "_"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	@Override
	public String getProperties() {
		if (propertiesContainer != null) {
			return propertiesContainer.toString();
		}

		String properties = super.getProperties();
		if (StringUtils.isEmpty(properties)) {
			return null;
		}

		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
		return properties;
	}

	@Override
	public void setProperties(String properties) {
		super.setProperties(properties);
		propertiesContainer = new Gson().fromJson(properties, JsonObject.class);
	}

	public void addProperty(String key, String value) {
		if (propertiesContainer == null) {
			propertiesContainer = new JsonObject();
		}
		propertiesContainer.addProperty(key, value);
	}

	public String getProperty(String key) {
		if (propertiesContainer == null) {
			return null;
		}
		if (propertiesContainer.has(key)) {
			JsonElement jsonElement = propertiesContainer.get(key);
			if (!jsonElement.isJsonNull()) {
				return jsonElement.getAsString();
			}
		}
		return null;
	}

	public boolean hasProperty(String key) {
		if (propertiesContainer != null) {
			return propertiesContainer.has(key);
		}
		return false;
	}

	public boolean isPropertyValueTrue(String propertyName) {
		String property = getProperty(propertyName);

		return POSUtil.getBoolean(property);
	}

	public void removeProperty(String propertyName) {
		if (propertiesContainer != null) {
			propertiesContainer.remove(propertyName);
		}
	}

	public double getTotalTaxRate() {
		double total = 0.0;
		List<Tax> taxes = getTaxes();
		if (taxes != null || !taxes.isEmpty()) {
			for (Tax tax : taxes) {
				total += tax.getRate();
			}
		}
		return total;
	}
}