package com.floreantpos.model;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang.StringUtils;

import com.floreantpos.PosLog;

public class WorkingHours {
	public static final String SUNDAY = "Sunday"; //$NON-NLS-1$
	public static final String MONDAY = "Monday"; //$NON-NLS-1$
	public static final String TUESDAY = "Tuesday"; //$NON-NLS-1$
	public static final String WEDNESDAY = "Wednesday"; //$NON-NLS-1$
	public static final String THURSDAY = "Thursday"; //$NON-NLS-1$
	public static final String FRIDAY = "Friday"; //$NON-NLS-1$
	public static final String SATURDAY = "Saturday"; //$NON-NLS-1$

	public static String[] days = new String[] { "", SUNDAY, MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY }; //$NON-NLS-1$

	public static final String OPEN = ".Open"; //$NON-NLS-1$
	public static final String START_TIME = ".StartTime"; //$NON-NLS-1$
	public static final String END_TIME = ".EndTime"; //$NON-NLS-1$

	private Calendar day;
	private Calendar openHour;
	private Calendar endHour;

	public WorkingHours(int dayOfWeek, String openTime, String endTime) {
		this.day = Calendar.getInstance();
		this.day.clear();
		this.day.set(Calendar.DAY_OF_WEEK, dayOfWeek);
		openHour = parseStringToCalendar(openTime);
		endHour = parseStringToCalendar(endTime);
	}

	public Calendar getDay() {
		return day;
	}

	public void setDay(Calendar day) {
		this.day = day;
	}

	public Calendar getOpenHour() {
		return openHour;
	}

	public void setOpenHour(Calendar openHour) {
		this.openHour = openHour;
	}

	public Calendar getEndHour() {
		return endHour;
	}

	public void setEndHour(Calendar endHour) {
		this.endHour = endHour;
	}

	private Calendar parseStringToCalendar(String timeString) {
		if (StringUtils.isEmpty(timeString)) {
			return null;
		}
		Calendar c = Calendar.getInstance();
		try {
			c.clear();
			SimpleDateFormat format = new SimpleDateFormat("hh:mm a"); //$NON-NLS-1$
			Date parseTime = format.parse(timeString);
			c.setTime(parseTime);
		} catch (Exception e) {
			PosLog.error(getClass(), e);
		}
		return c;
	}
}
