package com.floreantpos.model.dao;

import java.io.Serializable;
import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

import com.floreantpos.model.DeliveryZone;

public class DeliveryZoneDAO extends BaseDeliveryZoneDAO {

	/**
	 * Default constructor.  Can be used in place of getInstance()
	 */
	public DeliveryZoneDAO() {
	}

	@Override
	protected Serializable save(Object obj, Session s) {
		updateTime((DeliveryZone) obj);
		return super.save(obj, s);
	}

	@Override
	protected void update(Object obj, Session s) {
		updateTime((DeliveryZone) obj);
		super.update(obj, s);
	}

	@Override
	protected void saveOrUpdate(Object obj, Session s) {
		updateTime((DeliveryZone) obj);
		super.saveOrUpdate(obj, s);
	}

	@SuppressWarnings("unchecked")
	public List<DeliveryZone> findBy(String storeId, String outletId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(DeliveryZone.PROP_STORE_ID, storeId));
			criteria.add(Restrictions.eq(DeliveryZone.PROP_OUTLET_ID, outletId));
			return criteria.list();
		}
	}

	@SuppressWarnings("unchecked")
	public List<DeliveryZone> findBy(String storeId) {
		try (Session session = createNewSession()) {
			Criteria criteria = session.createCriteria(getReferenceClass());
			criteria.add(Restrictions.eq(DeliveryZone.PROP_STORE_ID, storeId));
			return criteria.list();
		}
	}

}